/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.backend.icode;

import java.io.PrintStream;
import scala.;
import scala.Array$;
import scala.Console$;
import scala.Function1;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.compat.StringBuilder;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedIntArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesUtility;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.tools.nsc.backend.icode.BasicBlocks$BasicBlock$;
import scala.tools.nsc.backend.icode.ICodes;
import scala.tools.nsc.backend.icode.Members;
import scala.tools.nsc.backend.icode.Opcodes;
import scala.tools.nsc.backend.icode.analysis.ProgramPoint;
import scala.tools.nsc.util.NoPosition$;
import scala.tools.nsc.util.Position;

public interface BasicBlocks
extends ScalaObject {

    public class BasicBlock
    implements ProgramPoint,
    ScalaObject {
        public /* synthetic */ ICodes $outer;
        private boolean touched;
        private Opcodes.Instruction[] instrs;
        private boolean closed;
        private Opcodes.Instruction _lastInstruction;
        private List instructionList;
        private Set varsInScope;
        private boolean exceptionHandlerHeader;
        private boolean loopHeader;
        private List preds;
        private boolean ignore;
        private int label;
        private Members.IMethod method;

        public BasicBlock(ICodes $outer, int theLabel, Members.IMethod method) {
            this.method = method;
            if ($outer != null) {
                this.$outer = $outer;
                this.label = theLabel;
                this.ignore = false;
                this.preds = null;
                this.loopHeader = false;
                this.exceptionHandlerHeader = false;
                this.varsInScope = new LinkedHashSet();
                this.instructionList = Nil$.MODULE$;
                this._lastInstruction = null;
                this.closed = false;
                this.touched = false;
                return;
            }
            throw new NullPointerException();
        }

        private final List subst$0(List l, Map map) {
            Nil$ nil$;
            List list = l;
            if (list != Nil$.MODULE$) {
                List list2;
                if (!(list instanceof .colon.colon)) {
                    throw new MatchError((Object)list);
                }
                .colon.colon colon2 = (.colon.colon)list;
                Opcodes.Instruction x = (Opcodes.Instruction)colon2.hd();
                List xs = colon2.tl$0();
                Option option = map.get((Object)x);
                if (!(option instanceof Some)) {
                    if (option != None$.MODULE$) {
                        throw new MatchError((Object)option);
                    }
                    Opcodes.Instruction instruction = x;
                    list2 = this.subst$0(xs, map).$colon$colon((Object)instruction);
                } else {
                    Opcodes.Instruction newInstr;
                    Some some = (Some)option;
                    Opcodes.Instruction instruction = newInstr = (Opcodes.Instruction)some.x();
                    list2 = this.subst$0(xs, map).$colon$colon((Object)instruction);
                }
                nil$ = list2;
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        }

        public /* synthetic */ ICodes scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer() {
            return this.$outer;
        }

        public String toString() {
            return "" + BoxesUtility.boxToInteger((int)this.label());
        }

        public String fullString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Block ").append(((Object)BoxesUtility.boxToInteger((int)this.label())).toString());
            buf.append("\nSuccessors: ").append((Object)this.successors());
            buf.append("\nPredecessors: ").append((Object)this.predecessors());
            return buf.toString();
        }

        public void print(PrintStream out$0) {
            out$0.println("block #" + BoxesUtility.boxToInteger((int)this.label()) + " :");
            this.toList().foreach((Function1)new BasicBlock$$anonfun$5(this, out$0));
            out$0.print("Successors: ");
            this.successors().foreach((Function1)new BasicBlock$$anonfun$6(this, out$0));
            out$0.println();
        }

        public void print() {
            this.print(System.out);
        }

        public int hashCode() {
            return this.label();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof BasicBlock)) {
                return false;
            }
            BasicBlock basicBlock = (BasicBlock)object;
            BasicBlock that = basicBlock;
            if (that.label() != this.label()) return false;
            Members.Code code = that.code();
            Members.Code code2 = this.code();
            if (code != null) {
                if (code.equals(code2)) return true;
                return false;
            } else if (code2 == null) return true;
            return false;
        }

        public List predecessors() {
            this.preds_$eq(this.code().blocks().elements().filter((Function1)new BasicBlock$$anonfun$4(this)).toList());
            return this.preds();
        }

        /*
         * Enabled aggressive block sorting
         */
        public List successors() {
            Nil$ nil$;
            Nil$ nil$2;
            block15: {
                Opcodes.Instruction instruction;
                block16: {
                    boolean bl;
                    if (this.isEmpty()) {
                        nil$2 = Nil$.MODULE$;
                        return nil$2;
                    }
                    instruction = this.lastInstruction();
                    switch (instruction.$tag()) {
                        default: {
                            bl = false;
                            break;
                        }
                        case -1887773086: {
                            if (!(instruction instanceof Opcodes.opcodes.CJUMP) || ((Opcodes.opcodes.CJUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$CJUMP$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            Opcodes.opcodes.CJUMP cJUMP = (Opcodes.opcodes.CJUMP)instruction;
                            BasicBlock success = cJUMP.successBlock();
                            BasicBlock failure = cJUMP.failureBlock();
                            BasicBlock basicBlock = success;
                            BasicBlock basicBlock2 = failure;
                            nil$ = Nil$.MODULE$.$colon$colon((Object)basicBlock2).$colon$colon((Object)basicBlock);
                            break block15;
                        }
                        case -1872135625: {
                            if (!(instruction instanceof Opcodes.opcodes.THROW) || ((Opcodes.opcodes.THROW)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$THROW$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            nil$ = Nil$.MODULE$;
                            break block15;
                        }
                        case -1584697699: {
                            if (!(instruction instanceof Opcodes.opcodes.JUMP) || ((Opcodes.opcodes.JUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$JUMP$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            nil$ = List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new BasicBlock[]{((Opcodes.opcodes.JUMP)instruction).where()}));
                            break block15;
                        }
                        case 1623032788: {
                            if (!(instruction instanceof Opcodes.opcodes.CZJUMP) || ((Opcodes.opcodes.CZJUMP)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$CZJUMP$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            Opcodes.opcodes.CZJUMP cZJUMP = (Opcodes.opcodes.CZJUMP)instruction;
                            BasicBlock success = cZJUMP.successBlock();
                            BasicBlock failure = cZJUMP.failureBlock();
                            BasicBlock basicBlock = success;
                            BasicBlock basicBlock3 = failure;
                            nil$ = Nil$.MODULE$.$colon$colon((Object)basicBlock3).$colon$colon((Object)basicBlock);
                            break block15;
                        }
                        case 2033374175: {
                            if (!(instruction instanceof Opcodes.opcodes.RETURN) || ((Opcodes.opcodes.RETURN)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$RETURN$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) {
                                bl = false;
                                break;
                            }
                            nil$ = Nil$.MODULE$;
                            break block15;
                        }
                        case 2078297571: {
                            if (instruction instanceof Opcodes.opcodes.SWITCH && ((Opcodes.opcodes.SWITCH)instruction).scala$tools$nsc$backend$icode$Opcodes$opcodes$SWITCH$$$outer() == this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().opcodes()) break block16;
                            bl = false;
                        }
                    }
                    if (bl) throw new MatchError((Object)instruction);
                    if (this.isClosed()) {
                        this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().dump();
                        this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().global().abort("The last instruction is not a control flow instruction: " + this.lastInstruction());
                        return null;
                    }
                    nil$ = Nil$.MODULE$;
                    break block15;
                }
                nil$ = ((Opcodes.opcodes.SWITCH)instruction).labels();
            }
            ObjectRef res$0 = new ObjectRef((Object)nil$);
            this.method().exh().foreach((Function1)new BasicBlock$$anonfun$3(this, res$0));
            nil$2 = (List)res$0.elem;
            return nil$2;
        }

        public boolean isClosed() {
            return this.closed();
        }

        public Opcodes.Instruction[] toInstructionArray(List l) {
            ObjectRef array$0 = new ObjectRef((Object)new Opcodes.Instruction[l.length()]);
            IntRef i$0 = new IntRef(0);
            l.foreach((Function1)new BasicBlock$$anonfun$2(this, array$0, i$0));
            return (Opcodes.Instruction[])array$0.elem;
        }

        public Opcodes.Instruction firstInstruction() {
            return !this.closed() ? (Opcodes.Instruction)this.instructionList().last() : this.instrs()[0];
        }

        public Opcodes.Instruction lastInstruction() {
            return !this.closed() ? (Opcodes.Instruction)this.instructionList().head() : this.instrs()[this.instrs().length - 1];
        }

        public void exitIgnoreMode() {
            Predef$.MODULE$.assert(this.ignore(), (Object)"Exit ignore mode when not in ignore mode.");
            this.ignore_$eq(false);
        }

        public void enterIgnoreMode() {
            this.ignore_$eq(true);
        }

        public boolean isEmpty() {
            return this.instructionList().isEmpty();
        }

        public void clear() {
            this.instructionList_$eq((List)Nil$.MODULE$);
            this.instrs_$eq(null);
            this.preds_$eq(null);
        }

        public void open() {
            Predef$.MODULE$.assert(this.closed());
            this.closed_$eq(false);
            this.ignore_$eq(false);
            this.instructionList_$eq(this.instructionList().reverse());
        }

        public void close() {
            Predef$.MODULE$.assert(this.instructionList().length() > 0, (Object)"Empty block.");
            this.closed_$eq(true);
            this.instructionList_$eq(this.instructionList().reverse());
            this.instrs_$eq(this.toInstructionArray(this.instructionList()));
        }

        public void emit(Opcodes.Instruction instr, Position pos) {
            block1: {
                if (this.closed()) {
                    this.print();
                    Console$.MODULE$.println((Object)("trying to emit: " + instr));
                }
                Predef$.MODULE$.assert(!this.closed() || this.ignore(), (Object)"BasicBlock closed");
                if (this.ignore()) break block1;
                this.touched_$eq(true);
                instr.pos_$eq(pos);
                Opcodes.Instruction instruction = instr;
                this.instructionList_$eq(this.instructionList().$colon$colon((Object)instruction));
                this._lastInstruction_$eq(instr);
            }
        }

        public void emit(Opcodes.Instruction instr) {
            if (!this.instructionList().isEmpty()) {
                this.emit(instr, ((Opcodes.Instruction)this.instructionList().head()).pos());
            } else {
                this.emit(instr, NoPosition$.MODULE$);
            }
        }

        private void substOnList(Map map$0) {
            this.instructionList_$eq(this.subst$0(this.instructionList(), map$0));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void subst(Map map) {
            if (!this.closed()) {
                this.substOnList(map);
                return;
            }
            int i = 0;
            while (i < this.instrs().length) {
                BoxedUnit boxedUnit;
                Option option = map.get((Object)this.instrs()[i]);
                if (!(option instanceof Some)) {
                    if (option != None$.MODULE$) {
                        throw new MatchError((Object)option);
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.touched_$eq(this.replaceInstruction(i, (Opcodes.Instruction)((Some)option).x()));
                    boxedUnit = BoxedUnit.UNIT;
                }
                ++i;
            }
            return;
        }

        public void removeLastInstruction() {
            if (!this.closed()) {
                this.instructionList_$eq(this.instructionList().tail());
                this.touched_$eq(true);
            } else {
                this.removeInstructionsAt((Seq)new BoxedIntArray(new int[]{this.size()}));
            }
        }

        public void removeInstructionsAt(Seq positions) {
            Predef$.MODULE$.assert(this.closed());
            List removed = positions.toList();
            Opcodes.Instruction[] newInstrs = new Opcodes.Instruction[this.instrs().length - positions.length()];
            int i = 0;
            int j = 0;
            while (true) {
                if (i >= this.instrs().length) {
                    this.instrs_$eq(newInstrs);
                    return;
                }
                if (!removed.contains((Object)BoxesUtility.boxToInteger((int)i))) {
                    newInstrs[j] = this.instrs()[i];
                    ++j;
                }
                ++i;
            }
        }

        public void insertAfter(int idx, List is) {
            Predef$.MODULE$.assert(this.closed(), (Object)"Instructions can be replaced only after the basic block is closed");
            int i = idx + 1;
            if (i < this.instrs().length) {
                Opcodes.Instruction[] newInstrs$1 = new Opcodes.Instruction[this.instrs().length + is.length()];
                Array$.MODULE$.copy((Object)this.instrs(), 0, (Object)newInstrs$1, 0, i);
                IntRef j$1 = new IntRef(i);
                is.foreach((Function1)new BasicBlock$$anonfun$1(this, newInstrs$1, j$1));
                if (i + 1 < this.instrs().length) {
                    Array$.MODULE$.copy((Object)this.instrs(), i + 1, (Object)newInstrs$1, j$1.elem, this.instrs().length - i);
                }
                this.instrs_$eq(newInstrs$1);
            }
        }

        public boolean replaceInstruction(Opcodes.Instruction iold, List is) {
            Predef$.MODULE$.assert(this.closed(), (Object)"Instructions can be replaced only after the basic block is closed");
            int i = 0;
            boolean changed = false;
            while (true) {
                if (i >= this.instrs().length || this.instrs()[i] == iold) {
                    if (i < this.instrs().length) {
                        Opcodes.Instruction[] newInstrs$0 = new Opcodes.Instruction[this.instrs().length + is.length() - 1];
                        changed = true;
                        Array$.MODULE$.copy((Object)this.instrs(), 0, (Object)newInstrs$0, 0, i);
                        IntRef j$0 = new IntRef(i);
                        is.foreach((Function1)new BasicBlock$$anonfun$0(this, newInstrs$0, j$0));
                        if (i + 1 < this.instrs().length) {
                            Array$.MODULE$.copy((Object)this.instrs(), i + 1, (Object)newInstrs$0, j$0.elem, this.instrs().length - i - 1);
                        }
                        this.instrs_$eq(newInstrs$0);
                    }
                    return changed;
                }
                ++i;
            }
        }

        public boolean replaceInstruction(Opcodes.Instruction oldInstr, Opcodes.Instruction newInstr) {
            Predef$.MODULE$.assert(this.closed(), (Object)"Instructions can be replaced only after the basic block is closed");
            boolean changed = false;
            for (int i = 0; i < this.instrs().length && !changed; ++i) {
                Opcodes.Instruction instruction = this.instrs()[i];
                Opcodes.Instruction instruction2 = oldInstr;
                if (instruction != null ? !instruction.equals(instruction2) : instruction2 != null) continue;
                newInstr.pos_$eq(oldInstr.pos());
                this.instrs()[i] = newInstr;
                changed = true;
            }
            return changed;
        }

        public boolean replaceInstruction(int pos, Opcodes.Instruction instr) {
            Predef$.MODULE$.assert(this.closed(), (Object)"Instructions can be replaced only after the basic block is closed");
            instr.pos_$eq(this.instrs()[pos].pos());
            this.instrs()[pos] = instr;
            return true;
        }

        public Opcodes.Instruction apply(int n) {
            return !this.closed() ? (Opcodes.Instruction)this.instructionList().reverse().apply(n) : this.instrs()[n];
        }

        public Option findDef(int pos) {
            Predef$.MODULE$.assert(this.closed());
            int i = pos;
            int d = 0;
            while (true) {
                if (i <= 0) {
                    return None$.MODULE$;
                }
                int prod = this.instrs()[--i].produced();
                if (prod > 0 && d == false) break;
                d += this.instrs()[i].consumed() - this.instrs()[i].produced();
            }
            return new Some((Object)BoxesUtility.boxToInteger((int)i));
        }

        public int size() {
            return !this.isClosed() ? this.instructionList().length() : this.instrs().length;
        }

        public void traverseBackwards(Function1 f) {
            int i = this.instrs().length - 1;
            while (i >= 0) {
                f.apply((Object)this.instrs()[i]);
                --i;
            }
            return;
        }

        public void traverse(Function1 f) {
            if (!this.closed()) {
                this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().dump();
                this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().global().abort("Traversing an open block!: " + BoxesUtility.boxToInteger((int)this.label()));
                return;
            }
            new BoxedObjectArray((Object[])this.instrs()).foreach(f);
        }

        public int indexOf(Opcodes.Instruction inst) {
            Predef$.MODULE$.assert(this.closed());
            int i = 0;
            while (true) {
                if (i >= this.instrs().length) {
                    return -1;
                }
                if (this.instrs()[i] == inst) break;
                ++i;
            }
            return i;
        }

        public void fromList(List is) {
            this.instrs_$eq(this.toInstructionArray(is));
            this.closed_$eq(true);
        }

        public Opcodes.Instruction[] getArray() {
            Predef$.MODULE$.assert(this.closed());
            return this.instrs();
        }

        public List toList() {
            if (this.closed() && this.touched()) {
                this.instructionList_$eq(List$.MODULE$.fromArray((BoxedArray)new BoxedObjectArray((Object[])this.instrs())));
            }
            return this.instructionList();
        }

        private void touched_$eq(boolean x$1) {
            this.touched = x$1;
        }

        private boolean touched() {
            return this.touched;
        }

        private void instrs_$eq(Opcodes.Instruction[] x$1) {
            this.instrs = x$1;
        }

        private Opcodes.Instruction[] instrs() {
            return this.instrs;
        }

        private void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        private boolean closed() {
            return this.closed;
        }

        private void _lastInstruction_$eq(Opcodes.Instruction x$1) {
            this._lastInstruction = x$1;
        }

        private Opcodes.Instruction _lastInstruction() {
            return this._lastInstruction;
        }

        private void instructionList_$eq(List x$1) {
            this.instructionList = x$1;
        }

        private List instructionList() {
            return this.instructionList;
        }

        public void varsInScope_$eq(Set x$1) {
            this.varsInScope = x$1;
        }

        public Set varsInScope() {
            return this.varsInScope;
        }

        public void exceptionHandlerHeader_$eq(boolean x$1) {
            this.exceptionHandlerHeader = x$1;
        }

        public boolean exceptionHandlerHeader() {
            return this.exceptionHandlerHeader;
        }

        public void loopHeader_$eq(boolean x$1) {
            this.loopHeader = x$1;
        }

        public boolean loopHeader() {
            return this.loopHeader;
        }

        public void preds_$eq(List x$1) {
            this.preds = x$1;
        }

        public List preds() {
            return this.preds;
        }

        public void ignore_$eq(boolean x$1) {
            this.ignore = x$1;
        }

        public boolean ignore() {
            return this.ignore;
        }

        public int label() {
            return this.label;
        }

        public Members.Code code() {
            return this.method().code();
        }

        public Members.IMethod method() {
            return this.method;
        }

        public int $tag() {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }
}

