/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import scala.Iterator;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedByteArray;
import scala.runtime.BoxesUtility;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.VirtualFile;

public final class URLZipArchive
extends AbstractFile
implements ScalaObject {
    private DirEntry root;
    private URL url;

    public URLZipArchive(URL url) {
        this.url = url;
        Predef$.MODULE$.assert(url != null);
    }

    private final InputStream getEntryInputStream$0(InputStream in) {
        ArrayBuffer buf = new ArrayBuffer();
        byte[] data = new byte[1024];
        int n = in.read(data);
        while (true) {
            if (n <= 0) {
                Object object = ScalaRunTime$.MODULE$.arrayValue(buf.toArray(), Byte.TYPE);
                return new ByteArrayInputStream((byte[])(!(object instanceof BoxedArray) ? object : ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Byte.TYPE)));
            }
            buf.$plus$plus$eq((BoxedArray)new BoxedByteArray(data), 0, n);
            n = in.read(data);
        }
    }

    private DirEntry getDir(Map dirs, String path) {
        DirEntry dirEntry;
        Option option = dirs.get((Object)path);
        if (!(option instanceof Some)) {
            if (option != None$.MODULE$) {
                throw new MatchError((Object)option);
            }
            int index = path.lastIndexOf(47, path.length() - 2);
            String name = index >= 0 ? path.substring(index + 1) : path;
            String home = index >= 0 ? path.substring(0, index + 1) : "/";
            DirEntry parent = this.getDir(dirs, home);
            DirEntry dir = new DirEntry(this, name.substring(0, name.length() - 1), path);
            parent.entries().update((Object)name, (Object)dir);
            dirs.update((Object)path, (Object)dir);
            dirEntry = dir;
        } else {
            dirEntry = (DirEntry)((Some)option).x();
        }
        return dirEntry;
    }

    private void load() {
        this.root_$eq(new DirEntry(this, "<root>", "/"));
        HashMap dirs = new HashMap();
        dirs.update((Object)"/", (Object)this.root());
        ZipInputStream zis = new ZipInputStream(this.input());
        ZipEntry entry = zis.getNextEntry();
        while (entry != null) {
            String path = entry.getName();
            Predef$.MODULE$.assert(entry.isDirectory() == path.endsWith("/"), (Object)(this.toString() + " - " + path));
            if (!entry.isDirectory()) {
                int index = path.lastIndexOf(47);
                String name = index >= 0 ? path.substring(index + 1) : path;
                String home = index >= 0 ? path.substring(0, index + 1) : "/";
                DirEntry parent = this.getDir((Map)dirs, home);
                Predef$.MODULE$.assert(!parent.entries().contains((Object)path), (Object)(this.toString() + " - " + path));
                InputStream in = this.getEntryInputStream$0(zis);
                parent.entries().update((Object)name, (Object)new FileEntry(this, name, path, entry, in));
            } else {
                DirEntry dir = this.getDir((Map)dirs, path);
                Predef$.MODULE$.assert(dir.entry() == null, (Object)(this.toString() + " - " + path));
                dir.entry_$eq(entry);
            }
            zis.closeEntry();
            entry = zis.getNextEntry();
        }
    }

    public AbstractFile lookupName(String name, boolean directory) {
        if (this.root() == null) {
            this.load();
        }
        return this.root().lookupName(name, directory);
    }

    public Iterator elements() {
        if (this.root() == null) {
            this.load();
        }
        return this.root().elements();
    }

    public InputStream input() {
        return this.url.openStream();
    }

    public long lastModified() {
        long l;
        try {
            l = this.url.openConnection().getLastModified();
        }
        catch (Throwable throwable) {
            l = 0L;
        }
        return l;
    }

    public boolean isDirectory() {
        return true;
    }

    public File file() {
        return null;
    }

    public String path() {
        return this.url.getPath();
    }

    public String name() {
        return this.url.getFile();
    }

    private void root_$eq(DirEntry x$1) {
        this.root = x$1;
    }

    private DirEntry root() {
        return this.root;
    }

    public abstract class Entry
    extends VirtualFile
    implements ScalaObject {
        public /* synthetic */ URLZipArchive $outer;

        public Entry(URLZipArchive $outer, String name, String path) {
            if ($outer != null) {
                this.$outer = $outer;
                super(name, path);
                return;
            }
            throw new NullPointerException();
        }

        public /* synthetic */ URLZipArchive scala$tools$nsc$io$URLZipArchive$Entry$$$outer() {
            return this.$outer;
        }

        public final String path() {
            return this.scala$tools$nsc$io$URLZipArchive$Entry$$$outer().toString() + "(" + super.path() + ")";
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public final class DirEntry
    extends Entry
    implements ScalaObject {
        private ZipEntry entry;
        private Map entries = new HashMap();

        public DirEntry(URLZipArchive $outer, String name, String path) {
            super($outer, name, path);
        }

        public InputStream input() {
            this.input();
            return null;
        }

        public /* synthetic */ URLZipArchive scala$tools$nsc$io$URLZipArchive$DirEntry$$$outer() {
            return this.$outer;
        }

        public AbstractFile lookupName(String name, boolean directory) {
            AbstractFile abstractFile;
            Option option = this.entries().get((Object)(!directory ? name : name + "/"));
            if (!(option instanceof Some)) {
                if (option != None$.MODULE$) {
                    throw new MatchError((Object)option);
                }
                abstractFile = null;
            } else {
                abstractFile = (AbstractFile)((Some)option).x();
            }
            return abstractFile;
        }

        public Iterator elements() {
            return this.entries().values();
        }

        public long lastModified() {
            return this.entry() != null ? this.entry().getTime() : super.lastModified();
        }

        public Nothing$ input() {
            throw new Error("cannot read directories");
        }

        public boolean isDirectory() {
            return true;
        }

        public void entry_$eq(ZipEntry x$1) {
            this.entry = x$1;
        }

        public ZipEntry entry() {
            return this.entry;
        }

        public Map entries() {
            return this.entries;
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    public final class FileEntry
    extends Entry
    implements ScalaObject {
        private InputStream in;
        private ZipEntry entry;

        public FileEntry(URLZipArchive $outer, String name, String path, ZipEntry entry, InputStream in) {
            this.entry = entry;
            this.in = in;
            super($outer, name, path);
        }

        public Option size() {
            return this.size();
        }

        public /* synthetic */ URLZipArchive scala$tools$nsc$io$URLZipArchive$FileEntry$$$outer() {
            return this.$outer;
        }

        public Some size() {
            return new Some((Object)BoxesUtility.boxToInteger((int)((int)this.entry().getSize())));
        }

        public InputStream input() {
            return this.in();
        }

        public long lastModified() {
            return this.entry().getTime();
        }

        public InputStream in() {
            return this.in;
        }

        public ZipEntry entry() {
            return this.entry;
        }
    }
}

