/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Random;
import java.util.regex.Pattern;
import scala.Function1;
import scala.Function2;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesUtility;
import scala.runtime.Nothing$;
import scala.tools.nsc.CompileClient$;
import scala.tools.nsc.CompileSocket$;
import scala.tools.nsc.Properties$;
import scala.tools.nsc.StandardCompileClient;

public class CompileSocket
implements ScalaObject {
    private int sleepTime;
    private int MaxAttempts;
    private File portsDir;
    private File tmpDir;
    private Pattern errorPattern;
    private String errorRegex;
    private String serverClass;
    private String vmCommand;

    public CompileSocket() {
        String dirname;
        File trial;
        String string = Properties$.MODULE$.scalaHome();
        this.vmCommand = string == null ? this.cmdName() : ((trial = new File(new File(dirname = string, "bin"), this.cmdName())).canRead() ? trial.getPath() : this.cmdName());
        this.serverClass = "scala.tools.nsc.CompileServer";
        this.errorRegex = ".*errors? found.*";
        this.errorPattern = Pattern.compile(this.errorRegex());
        List totry = List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new Tuple2[]{new Tuple2((Object)"scala.home", (Object)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{"var", "scala-devel"}))), new Tuple2((Object)"user.home", (Object)List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new String[]{"tmp"}))), new Tuple2((Object)"java.io.tmpdir", (Object)Nil$.MODULE$)}));
        List potentials = totry.map((Function1)new $anonfun$1(this)).filter((Function1)new $anonfun$2(this)).filter((Function1)new $anonfun$3(this)).map((Function1)new $anonfun$4(this));
        if (potentials.isEmpty()) {
            this.fatal("Could not find a directory for temporary files");
            return;
        }
        File d = (File)potentials.head();
        d.mkdirs();
        this.info("[Temp directory: " + d + "]");
        this.tmpDir = d;
        this.portsDir = new File(this.tmpDir(), this.dirName());
        this.portsDir().mkdirs();
        this.MaxAttempts = 100;
        this.sleepTime = 20;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Socket getsock$0(int attempts, String string, boolean bl) {
        Socket socket;
        int port;
        if (attempts == 0) {
            this.error("Unable to establish connection to compilation daemon");
            return null;
        }
        int n = port = bl ? this.getPort(string) : this.pollPort();
        if (port < 0) {
            return null;
        }
        String hostName = InetAddress.getLocalHost().getHostName();
        {
            Socket result = new Socket(hostName, port);
            this.info("[Connected to compilation daemon at port " + BoxesUtility.boxToInteger((int)port) + "]");
            socket = result;
        }
        return socket;
    }

    public final boolean isDirWritable$0(File f) {
        f.mkdirs();
        return f.isDirectory() && f.canWrite();
    }

    public final Option expand$0(Tuple2 trial) {
        Tuple2 tuple2 = trial;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
        String topdirProp = (String)tuple22._1();
        List extensions = (List)tuple22._2();
        String topdir = System.getProperty(topdirProp);
        if (topdir == null) {
            return None$.MODULE$;
        }
        File fulldir = (File)extensions.foldLeft((Object)new File(topdir), (Function2)new $anonfun$0(this));
        return new Some((Object)fulldir);
    }

    /*
     * WARNING - void declaration
     */
    public String getPassword(int port) {
        void var3_3;
        BufferedReader f = new BufferedReader(new FileReader(this.portFile(port)));
        String result = f.readLine();
        f.close();
        return var3_3;
    }

    public Socket getSocket(String hostName, int port) {
        try {
            return new Socket(hostName, port);
        }
        catch (Exception exception) {
            this.fatal("Unable to establish connection to server " + hostName + ":" + BoxesUtility.boxToInteger((int)port) + "; exiting");
            return null;
        }
    }

    public Socket getSocket(String serverAdr) {
        int cpos = serverAdr.indexOf(58);
        if (cpos < 0) {
            this.fatal("Malformed server address: " + serverAdr + "; exiting");
            return null;
        }
        String hostName = serverAdr.substring(0, cpos);
        try {
            int port = Predef$.MODULE$.stringWrapper(serverAdr.substring(cpos + 1)).toInt();
            return this.getSocket(hostName, port);
        }
        catch (Throwable throwable) {
            this.fatal("Malformed server address: " + serverAdr + "; exiting");
            return null;
        }
    }

    public Socket getOrCreateSocket(String vmArgs) {
        return this.getOrCreateSocket(vmArgs, true);
    }

    public Socket getOrCreateSocket(String vmArgs$0, boolean create$0) {
        int nAttempts = 49;
        return this.getsock$0(nAttempts, vmArgs$0, create$0);
    }

    public void deletePort(int port) {
        this.portFile(port).delete();
    }

    public void setPort(int port) {
        try {
            PrintWriter f = new PrintWriter(new FileOutputStream(this.portFile(port)));
            f.println(((Object)BoxesUtility.boxToInteger((int)new Random().nextInt())).toString());
            f.close();
            return;
        }
        catch (Exception exception) {
            this.fatal("Cannot create file: " + this.portFile(port).getAbsolutePath());
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public int getPort(String vmArgs) {
        void var3_3;
        int attempts = 0;
        int port = this.pollPort();
        if (port < 0) {
            this.startNewServer(vmArgs);
        }
        while (port < 0 && attempts < this.MaxAttempts()) {
            ++attempts;
            Thread.sleep(Predef$.MODULE$.int2long(this.sleepTime()));
            port = this.pollPort();
        }
        this.info("[Port number: " + BoxesUtility.boxToInteger((int)port) + "]");
        if (port < 0) {
            this.fatal("Could not connect to compilation daemon.");
            return 0;
        }
        return (int)var3_3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pollPort() {
        File[] hits$0 = this.portsDir().listFiles();
        if (hits$0.length == 0) {
            return -1;
        }
        try {
            Predef$.MODULE$.intWrapper(1).until(hits$0.length).foreach((Function1)new $anonfun$5(this, hits$0));
            int n = Predef$.MODULE$.stringWrapper(hits$0[0].getName()).toInt();
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            this.fatal(numberFormatException.toString() + "\nbad file in temp directory: " + hits$0[0].getAbsolutePath() + "\nplease remove the file and try again");
            return 0;
        }
    }

    public File portFile(int port) {
        return new File(this.portsDir(), ((Object)BoxesUtility.boxToInteger((int)port)).toString());
    }

    private void startNewServer(String vmArgs) {
        String cmd = this.serverCommand(vmArgs);
        this.info("[Executed command: " + cmd + "]");
        try {
            Runtime.getRuntime().exec(cmd);
            return;
        }
        catch (IOException iOException) {
            this.fatal("Cannot start compilation daemon.\ntried command: " + cmd);
            return;
        }
    }

    private String serverCommand(String vmArgs) {
        return this.vmCommand() + vmArgs + " " + this.serverClass();
    }

    private int sleepTime() {
        return this.sleepTime;
    }

    private int MaxAttempts() {
        return this.MaxAttempts;
    }

    public File portsDir() {
        return this.portsDir;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void info(String msg) {
        if (this.compileClient().verbose()) {
            System.out.println(msg);
        }
    }

    public Nothing$ fatal(String msg) {
        this.error(msg);
        return Predef$.MODULE$.exit(1);
    }

    public void error(String msg) {
        System.err.println(msg);
    }

    public Pattern errorPattern() {
        return this.errorPattern;
    }

    public String errorRegex() {
        return this.errorRegex;
    }

    public String serverClass() {
        return this.serverClass;
    }

    public String vmCommand() {
        return this.vmCommand;
    }

    public String cmdName() {
        return Properties$.MODULE$.cmdName();
    }

    public String dirName() {
        return "scalac-compile-server-port";
    }

    public StandardCompileClient compileClient() {
        return CompileClient$.MODULE$;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

