/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.emit;

import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.MethodBase;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.emit.Label;
import ch.epfl.lamp.compiler.msil.emit.LocalBuilder;
import ch.epfl.lamp.compiler.msil.emit.OpCode;
import ch.epfl.lamp.compiler.msil.emit.OpCodes;
import ch.epfl.lamp.compiler.msil.emit.Visitable;
import ch.epfl.lamp.compiler.msil.emit.Visitor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;

public final class ILGenerator
implements Visitable {
    private static final Type VOID;
    static final String NO_LABEL = "";
    private final ArrayList localList = new ArrayList();
    private final ArrayList labelList = new ArrayList();
    private final ArrayList opcodeList = new ArrayList();
    private final ArrayList argumentList = new ArrayList();
    private int pc = 0;
    private Label lastLabel = new Label.NormalLabel(this.pc, 0);
    private int maxstack = 0;
    private int locals = 0;
    private ExceptionStack excStack = new ExceptionStack();
    private MethodBase owner;
    Map lineNums = new HashMap();
    private static final /* synthetic */ boolean $assertionsDisabled;

    public void Emit(OpCode opCode) {
        if (opCode.$tag == 170) {
            this.emit(opCode, null, 0);
        } else {
            this.emit(opCode, null);
        }
    }

    public void Emit(OpCode opCode, char c) {
        this.emit(opCode, new Character(c));
    }

    public void Emit(OpCode opCode, ConstructorInfo constructorInfo) {
        if (!$assertionsDisabled && constructorInfo == null) {
            throw new AssertionError();
        }
        this.emit(opCode, constructorInfo, OpCode.PUSH_size[opCode.CEE_push] - constructorInfo.GetParameters().length);
    }

    public void Emit(OpCode opCode, LocalBuilder localBuilder) {
        if (!$assertionsDisabled && localBuilder == null) {
            throw new AssertionError();
        }
        this.emit(opCode, localBuilder);
    }

    public void Emit(OpCode opCode, double d) {
        this.emit(opCode, new Double(d));
    }

    public void Emit(OpCode opCode, FieldInfo fieldInfo) {
        if (!$assertionsDisabled && fieldInfo == null) {
            throw new AssertionError();
        }
        this.emit(opCode, fieldInfo);
    }

    public void Emit(OpCode opCode, short s) {
        this.emit(opCode, new Short(s));
    }

    public void Emit(OpCode opCode, int n) {
        this.emit(opCode, new Integer(n));
    }

    public void Emit(OpCode opCode, long l) {
        this.emit(opCode, new Long(l));
    }

    public void Emit(OpCode opCode, Label label) {
        if (!$assertionsDisabled && label == null) {
            throw new AssertionError();
        }
        this.emit(opCode, label);
        if (!label.isInitialized()) {
            label.setStacksize(this.lastLabel.getStacksize());
        }
    }

    public void Emit(OpCode opCode, Label[] labelArray) {
        if (!$assertionsDisabled && labelArray == null) {
            throw new AssertionError();
        }
        this.emit(opCode, labelArray, labelArray.length);
    }

    public void Emit(OpCode opCode, MethodInfo methodInfo) {
        int n;
        if (!$assertionsDisabled && methodInfo == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && methodInfo.ReturnType == null) {
            throw new AssertionError((Object)String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("No ReturnType: ".concat(String.valueOf(String.valueOf(methodInfo.DeclaringType))))).concat("::"))).concat(String.valueOf(String.valueOf(methodInfo.Name))))));
        }
        switch (opCode.$tag) {
            case 124: {
                n = OpCode.PUSH_size[opCode.CEE_push] - OpCode.POP_size[opCode.CEE_pop];
                break;
            }
            case 151: {
                n = OpCode.PUSH_size[opCode.CEE_push] - OpCode.POP_size[opCode.CEE_pop];
                break;
            }
            case 86: {
                n = OpCode.PUSH_size[opCode.CEE_push] - OpCode.POP_size[opCode.CEE_pop];
                break;
            }
            case 34: {
                n = (methodInfo.ReturnType == VOID ? 0 : 1) - methodInfo.GetParameters().length - 1;
                break;
            }
            case 35: {
                n = (methodInfo.ReturnType == VOID ? 0 : 1) - methodInfo.GetParameters().length - 1;
                break;
            }
            default: {
                n = (methodInfo.ReturnType == VOID ? 0 : 1) - methodInfo.GetParameters().length;
            }
        }
        this.emit(opCode, methodInfo, n);
    }

    public void Emit(OpCode opCode, float f2) {
        this.emit(opCode, new Float(f2));
    }

    public void Emit(OpCode opCode, String string) {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.emit(opCode, string);
    }

    public void Emit(OpCode opCode, Type type) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        this.emit(opCode, type);
    }

    public void EmitCall(OpCode opCode, MethodInfo methodInfo, Type[] typeArray) {
        if (!$assertionsDisabled && methodInfo == null) {
            throw new AssertionError();
        }
        this.emit(opCode, methodInfo, (methodInfo.ReturnType == VOID ? 0 : 1) - methodInfo.GetParameters().length);
    }

    public void EmitWriteLine(FieldInfo fieldInfo) {
        if (fieldInfo.IsStatic()) {
            this.Emit(OpCodes.Ldsfld, fieldInfo);
        } else {
            this.Emit(OpCodes.Ldfld, fieldInfo);
        }
        Type type = Type.GetType("System.Console");
        Type[] typeArray = new Type[]{fieldInfo.FieldType};
        MethodInfo methodInfo = type.GetMethod("WriteLine", typeArray);
        this.EmitCall(OpCode.Call, methodInfo, null);
    }

    public void EmitWriteLine(LocalBuilder localBuilder) {
        this.Emit(OpCodes.Ldloc, localBuilder);
        Type type = Type.GetType("System.Console");
        Type[] typeArray = new Type[]{localBuilder.LocalType};
        MethodInfo methodInfo = type.GetMethod("WriteLine", typeArray);
        this.EmitCall(OpCode.Call, methodInfo, null);
    }

    public void EmitWriteLine(String string) {
        this.Emit((OpCode)OpCode.Ldstr, string);
        Type type = Type.GetType("System.Console");
        Type[] typeArray = new Type[]{Type.GetType("System.String")};
        MethodInfo methodInfo = type.GetMethod("WriteLine", typeArray);
        this.EmitCall(OpCode.Call, methodInfo, null);
    }

    public LocalBuilder DeclareLocal(Type type) {
        LocalBuilder localBuilder = new LocalBuilder(this.locals++, type);
        this.localList.add(localBuilder);
        return localBuilder;
    }

    public Label DefineLabel() {
        return new Label.NormalLabel();
    }

    public void MarkLabel(Label label) {
        label.mergeWith(this.lastLabel);
    }

    public void BeginScope() {
        this.emitSpecialLabel(Label.NewScope);
    }

    public void EndScope() {
        this.emitSpecialLabel(Label.EndScope);
    }

    public Label BeginExceptionBlock() {
        this.emitSpecialLabel(Label.Try);
        Label.NormalLabel normalLabel = new Label.NormalLabel();
        this.excStack.push(Label.Try, normalLabel);
        return normalLabel;
    }

    public void BeginCatchBlock(Type type) {
        Object object = this.excStack.peekKind();
        switch (((Label.Kind)object).$tag) {
            case 8: {
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new RuntimeException("Catch should follow either a try or catch");
            }
        }
        object = this.excStack.popLabel();
        this.Emit(OpCodes.Leave, (Label)object);
        this.lastLabel.incStacksize();
        this.excStack.push(Label.Catch, (Label)object);
        this.emitSpecialLabel(Label.Catch, type);
    }

    public void EndExceptionBlock() {
        Label.Kind kind = this.excStack.peekKind();
        switch (kind.$tag) {
            case 8: {
                throw new RuntimeException("Try block with neither catch nor finally");
            }
            case 0: {
                this.Emit(OpCodes.Leave, this.excStack.peekLabel());
                break;
            }
            case 5: {
                this.Emit(OpCodes.Endfinally);
                break;
            }
        }
        this.MarkLabel(this.excStack.popLabel());
        this.emitSpecialLabel(Label.EndTry);
    }

    public void BeginFinallyBlock() {
        this.Emit(OpCodes.Leave, this.excStack.peekLabel());
        this.emitSpecialLabel(Label.Finally);
    }

    public void ThrowException(Type type) {
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        if (!type.isSubtypeOf(Type.GetType("System.Exception"))) {
            throw new RuntimeException(String.valueOf(String.valueOf(type)).concat(" doesn't extend System.Exception"));
        }
        ConstructorInfo constructorInfo = type.GetConstructor(Type.EmptyTypes);
        if (constructorInfo == null) {
            throw new RuntimeException(String.valueOf(String.valueOf("Type ".concat(String.valueOf(String.valueOf(type))))).concat("doesn't have a default constructor"));
        }
        this.Emit(OpCodes.Newobj, constructorInfo);
        this.Emit(OpCodes.Throw);
    }

    public void setPosition(int n) {
        if (n != 0) {
            this.lineNums.put(this.lastLabel, Integer.toString(n));
        }
    }

    public void setPosition(int n, String string) {
        if (n != 0) {
            this.lineNums.put(this.lastLabel, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(n).concat("  '"))).concat(String.valueOf(String.valueOf(string))))).concat("'"));
        }
    }

    LocalBuilder[] getLocals() {
        return this.localList.toArray(new LocalBuilder[0]);
    }

    Iterator getLabelIterator() {
        return ((AbstractList)this.labelList).iterator();
    }

    Iterator getOpcodeIterator() {
        return ((AbstractList)this.opcodeList).iterator();
    }

    Iterator getArgumentIterator() {
        return ((AbstractList)this.argumentList).iterator();
    }

    ILGenerator(MethodBase methodBase) {
        this.owner = methodBase;
    }

    int getMaxStacksize() {
        return this.maxstack;
    }

    private void emit(OpCode opCode, Object object) {
        this.emit(opCode, object, opCode.CEE_popush);
    }

    private void emit(OpCode opCode, Object object, int n) {
        this.labelList.add(this.lastLabel);
        this.opcodeList.add(opCode);
        this.argumentList.add(object);
        int n2 = this.lastLabel.getStacksize() + n;
        if (n2 > this.maxstack) {
            this.maxstack = n2;
        }
        int n3 = this.lastLabel.getAddress() + opCode.CEE_length;
        if (opCode.CEE_opcode == 69) {
            n3 += 4 * ((Label[])object).length;
        }
        this.lastLabel = new Label.NormalLabel(n3, n2);
        ++this.pc;
    }

    private void emitSpecialLabel(Label label) {
        this.emitSpecialLabel(label, null);
    }

    private void emitSpecialLabel(Label label, Type type) {
        this.labelList.add(label);
        this.opcodeList.add(null);
        this.argumentList.add(type);
    }

    public void apply(Visitor visitor) {
        visitor.caseILGenerator(this);
    }

    static {
        $assertionsDisabled = !Class.forName("ch.epfl.lamp.compiler.msil.emit.ILGenerator").desiredAssertionStatus();
        VOID = Type.GetType("System.Void");
    }

    private static final class ExceptionStack {
        private Stack labels = new Stack();
        private Stack kinds = new Stack();

        public void pop() {
            this.labels.pop();
            this.kinds.pop();
        }

        public void push(Label label, Label label2) {
            this.kinds.push(label);
            this.labels.push(label2);
        }

        public Label.Kind peekKind() {
            return ((Label)this.kinds.peek()).getKind();
        }

        public Label peekLabel() {
            return (Label)this.labels.peek();
        }

        public Label popLabel() {
            this.kinds.pop();
            return (Label)this.labels.pop();
        }
    }
}

