/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import scala.ScalaObject;

public class SocketConnection
implements ScalaObject {
    private String errorMessage;
    private BufferedReader in;
    private PrintWriter out;
    private Socket socket;
    private final int port;
    private final String hostname;

    public SocketConnection(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public void close() {
        this.in().close();
        this.out().close();
        this.socket().close();
    }

    /*
     * WARNING - void declaration
     */
    public boolean open() {
        void var1_1;
        boolean exceptionResult1 = false;
        try {
            this.socket_$eq(new Socket(this.hostname, this.port));
            this.out_$eq(new PrintWriter(this.socket().getOutputStream(), true));
            this.in_$eq(new BufferedReader(new InputStreamReader(this.socket().getInputStream())));
            exceptionResult1 = true;
        }
        catch (IOException iOException) {
            this.errorMessage_$eq("Couldn't get I/O for the connection to: " + this.hostname + ".");
            exceptionResult1 = false;
        }
        catch (UnknownHostException unknownHostException) {
            this.errorMessage_$eq("Don't know about host: " + this.hostname + ".");
            exceptionResult1 = false;
        }
        return (boolean)var1_1;
    }

    public void errorMessage_$eq(String x$1) {
        this.errorMessage = x$1;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public void in_$eq(BufferedReader x$1) {
        this.in = x$1;
    }

    public BufferedReader in() {
        return this.in;
    }

    public void out_$eq(PrintWriter x$1) {
        this.out = x$1;
    }

    public PrintWriter out() {
        return this.out;
    }

    private void socket_$eq(Socket x$1) {
        this.socket = x$1;
    }

    private Socket socket() {
        return this.socket;
    }

    public SocketConnection(int port) {
        this(InetAddress.getLocalHost().getHostName(), port);
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

