/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.backend.icode;

import java.io.PrintStream;
import scala.;
import scala.Array$;
import scala.Console$;
import scala.Function1;
import scala.Iterator;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.Some;
import scala.StringBuilder;
import scala.collection.jcl.LinkedHashSet;
import scala.collection.mutable.Map;
import scala.collection.mutable.Set;
import scala.runtime.BoxedArray;
import scala.runtime.BoxedIntArray;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.tools.nsc.backend.icode.BasicBlocks$BasicBlock$;
import scala.tools.nsc.backend.icode.ICodes;
import scala.tools.nsc.backend.icode.Members;
import scala.tools.nsc.backend.icode.Opcodes;
import scala.tools.nsc.backend.icode.analysis.ProgramPoint;
import scala.tools.nsc.util.NoPosition$;
import scala.tools.nsc.util.Position;

public interface BasicBlocks
extends ScalaObject {

    public class BasicBlock
    implements ProgramPoint,
    ScalaObject {
        public final /* synthetic */ ICodes $outer;
        private boolean touched;
        private Opcodes.Instruction[] instrs;
        private boolean closed;
        private Opcodes.Instruction _lastInstruction;
        private List instructionList;
        private Set varsInScope;
        private boolean exceptionHandlerHeader;
        private boolean loopHeader;
        private List preds;
        private boolean ignore;
        private final int label;
        private final Members.IMethod method;

        public BasicBlock(ICodes $outer, int theLabel, Members.IMethod method) {
            this.method = method;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.label = theLabel;
            this.ignore = false;
            this.preds = null;
            this.loopHeader = false;
            this.exceptionHandlerHeader = false;
            this.varsInScope = new LinkedHashSet();
            this.instructionList = Nil$.MODULE$;
            this._lastInstruction = null;
            this.closed = false;
            this.touched = false;
        }

        private final List subst$1(List l, Map map) {
            List list;
            block4: {
                Option option;
                block6: {
                    Nil$ nil$;
                    block3: {
                        Opcodes.Instruction x;
                        List xs;
                        block5: {
                            Opcodes.Instruction instruction;
                            Opcodes.Instruction newInstr;
                            List list2;
                            block2: {
                                list = l;
                                Nil$ nil$2 = Nil$.MODULE$;
                                List list3 = list;
                                if (nil$2 != null ? !nil$2.equals(list3) : list3 != null) break block2;
                                nil$ = Nil$.MODULE$;
                                break block3;
                            }
                            if (!(list instanceof .colon.colon)) break block4;
                            .colon.colon colon2 = (.colon.colon)list;
                            Opcodes.Instruction instruction2 = (Opcodes.Instruction)colon2.hd$1();
                            xs = list2 = colon2.tl$1();
                            x = instruction2;
                            option = map.get((Object)x);
                            if (!(option instanceof Some)) break block5;
                            Some some = (Some)option;
                            Opcodes.Instruction instruction3 = newInstr = (instruction = (Opcodes.Instruction)some.x());
                            nil$ = this.subst$1(xs, map).$colon$colon((Object)instruction3);
                            break block3;
                        }
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                        Opcodes.Instruction instruction = x;
                        nil$ = this.subst$1(xs, map).$colon$colon((Object)instruction);
                    }
                    return nil$;
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)list);
        }

        public /* synthetic */ ICodes scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer() {
            return this.$outer;
        }

        public String toString() {
            return new StringBuilder().append((Object)"").append((Object)BoxesRunTime.boxToInteger((int)this.label())).toString();
        }

        public String fullString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Block ").append(((Object)BoxesRunTime.boxToInteger((int)this.label())).toString());
            buf.append("\nSuccessors: ").append((Object)this.successors());
            buf.append("\nPredecessors: ").append((Object)this.predecessors());
            return buf.toString();
        }

        public void print(PrintStream out$1) {
            out$1.println(new StringBuilder().append((Object)"block #").append((Object)BoxesRunTime.boxToInteger((int)this.label())).append((Object)" :").toString());
            this.toList().foreach((Function1)new BasicBlock$$anonfun$print$1(this, out$1));
            out$1.print("Successors: ");
            this.successors().foreach((Function1)new BasicBlock$$anonfun$print$2(this, out$1));
            out$1.println();
        }

        public void print() {
            this.print(System.out);
        }

        public int hashCode() {
            return this.label();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object other) {
            Object object = other;
            if (!(object instanceof BasicBlock)) return false;
            if (((BasicBlock)object).scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer() != this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer()) return false;
            BasicBlock basicBlock = (BasicBlock)object;
            BasicBlock that = basicBlock;
            if (that.label() != this.label()) return false;
            Members.Code code = that.code();
            Members.Code code2 = this.code();
            if (code != null) {
                if (!code.equals(code2)) return false;
                return true;
            }
            if (code2 == null) return true;
            return false;
        }

        public List predecessors() {
            this.preds_$eq(((Iterator)this.code().blocks().elements()).filter((Function1)new BasicBlock$$anonfun$predecessors$1(this)).toList());
            return this.preds();
        }

        public List successors() {
            Nil$ nil$;
            if (this.isEmpty()) {
                nil$ = Nil$.MODULE$;
            } else {
                List list;
                Opcodes.Instruction instruction = this.lastInstruction();
                if (instruction instanceof Opcodes.opcodes.JUMP) {
                    list = List$.MODULE$.apply((Seq)new BoxedObjectArray((Object[])new BasicBlock[]{((Opcodes.opcodes.JUMP)instruction).whereto()}));
                } else if (instruction instanceof Opcodes.opcodes.CJUMP) {
                    BasicBlock basicBlock;
                    Opcodes.opcodes.CJUMP cJUMP = (Opcodes.opcodes.CJUMP)instruction;
                    BasicBlock basicBlock2 = cJUMP.successBlock();
                    BasicBlock failure = basicBlock = cJUMP.failureBlock();
                    BasicBlock success = basicBlock2;
                    BasicBlock basicBlock3 = failure;
                    BasicBlock basicBlock4 = success;
                    list = Nil$.MODULE$.$colon$colon((Object)basicBlock4).$colon$colon((Object)basicBlock3);
                } else if (instruction instanceof Opcodes.opcodes.CZJUMP) {
                    BasicBlock basicBlock;
                    Opcodes.opcodes.CZJUMP cZJUMP = (Opcodes.opcodes.CZJUMP)instruction;
                    BasicBlock basicBlock5 = cZJUMP.successBlock();
                    BasicBlock failure = basicBlock = cZJUMP.failureBlock();
                    BasicBlock success = basicBlock5;
                    BasicBlock basicBlock6 = failure;
                    BasicBlock basicBlock7 = success;
                    list = Nil$.MODULE$.$colon$colon((Object)basicBlock7).$colon$colon((Object)basicBlock6);
                } else if (instruction instanceof Opcodes.opcodes.SWITCH) {
                    list = ((Opcodes.opcodes.SWITCH)instruction).labels();
                } else if (instruction instanceof Opcodes.opcodes.RETURN) {
                    list = Nil$.MODULE$;
                } else if (instruction instanceof Opcodes.opcodes.THROW) {
                    list = Nil$.MODULE$;
                } else {
                    if (this.isClosed()) {
                        this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().dump();
                        this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().global().abort(new StringBuilder().append((Object)"The last instruction is not a control flow instruction: ").append((Object)this.lastInstruction()).toString());
                        return null;
                    }
                    list = Nil$.MODULE$;
                }
                ObjectRef res$1 = new ObjectRef((Object)list);
                this.method().exh().foreach((Function1)new BasicBlock$$anonfun$successors$1(this, res$1));
                nil$ = (List)res$1.elem;
            }
            return nil$;
        }

        public boolean isClosed() {
            return this.closed();
        }

        public Opcodes.Instruction[] toInstructionArray(List l) {
            ObjectRef array$1 = new ObjectRef((Object)new Opcodes.Instruction[l.length()]);
            IntRef i$1 = new IntRef(0);
            l.foreach((Function1)new BasicBlock$$anonfun$toInstructionArray$1(this, array$1, i$1));
            return (Opcodes.Instruction[])array$1.elem;
        }

        public Opcodes.Instruction firstInstruction() {
            return this.closed() ? this.instrs()[0] : (Opcodes.Instruction)this.instructionList().last();
        }

        public Opcodes.Instruction lastInstruction() {
            return this.closed() ? this.instrs()[this.instrs().length - 1] : (Opcodes.Instruction)this.instructionList().head();
        }

        public void exitIgnoreMode() {
            Predef$.MODULE$.assert(this.ignore(), (Object)"Exit ignore mode when not in ignore mode.");
            this.ignore_$eq(false);
        }

        public void enterIgnoreMode() {
            this.ignore_$eq(true);
        }

        public boolean isEmpty() {
            return this.instructionList().isEmpty();
        }

        public void clear() {
            this.instructionList_$eq((List)Nil$.MODULE$);
            this.instrs_$eq(null);
            this.preds_$eq(null);
        }

        public void open() {
            Predef$.MODULE$.assert(this.closed());
            this.closed_$eq(false);
            this.ignore_$eq(false);
            this.instructionList_$eq(this.instructionList().reverse());
        }

        public void close() {
            Predef$.MODULE$.assert(this.instructionList().length() > 0, (Object)"Empty block.");
            this.closed_$eq(true);
            this.instructionList_$eq(this.instructionList().reverse());
            this.instrs_$eq(this.toInstructionArray(this.instructionList()));
        }

        public void emit(Seq instrs) {
            instrs.foreach((Function1)new BasicBlock$$anonfun$emit$1(this));
        }

        public void emit(Opcodes.Instruction instr, Position pos) {
            if (this.closed()) {
                this.print();
                Console$.MODULE$.println((Object)new StringBuilder().append((Object)"trying to emit: ").append((Object)instr).toString());
            }
            Predef$.MODULE$.assert(!this.closed() || this.ignore(), (Object)"BasicBlock closed");
            if (!this.ignore()) {
                this.touched_$eq(true);
                instr.pos_$eq(pos);
                Opcodes.Instruction instruction = instr;
                this.instructionList_$eq(this.instructionList().$colon$colon((Object)instruction));
                this._lastInstruction_$eq(instr);
            }
        }

        public void emit(Opcodes.Instruction instr) {
            if (this.instructionList().isEmpty()) {
                this.emit(instr, NoPosition$.MODULE$);
            } else {
                this.emit(instr, ((Opcodes.Instruction)this.instructionList().head()).pos());
            }
        }

        private void substOnList(Map map$1) {
            this.instructionList_$eq(this.subst$1(this.instructionList(), map$1));
        }

        public void subst(Map map) {
            if (this.closed()) {
                for (int i = 0; i < this.instrs().length; ++i) {
                    Option option = map.get((Object)this.instrs()[i]);
                    if (option instanceof Some) {
                        this.touched_$eq(this.replaceInstruction(i, (Opcodes.Instruction)((Some)option).x()));
                        continue;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                        continue;
                    }
                    throw new MatchError((Object)option);
                }
            } else {
                this.substOnList(map);
            }
        }

        public void removeLastInstruction() {
            if (this.closed()) {
                this.removeInstructionsAt((Seq)new BoxedIntArray(new int[]{this.size()}));
            } else {
                this.instructionList_$eq(this.instructionList().tail());
                this.touched_$eq(true);
            }
        }

        public void removeInstructionsAt(Seq positions) {
            Predef$.MODULE$.assert(this.closed());
            List removed = positions.toList();
            Opcodes.Instruction[] newInstrs = new Opcodes.Instruction[this.instrs().length - positions.length()];
            int j = 0;
            for (int i = 0; i < this.instrs().length; ++i) {
                if (removed.contains((Object)BoxesRunTime.boxToInteger((int)i))) continue;
                newInstrs[j] = this.instrs()[i];
                ++j;
            }
            this.instrs_$eq(newInstrs);
        }

        public void insertAfter(int idx, List is) {
            Predef$.MODULE$.assert(this.closed(), (Object)"Instructions can be replaced only after the basic block is closed");
            int i = idx + 1;
            if (i < this.instrs().length) {
                Opcodes.Instruction[] newInstrs$2 = new Opcodes.Instruction[this.instrs().length + is.length()];
                Array$.MODULE$.copy((Object)this.instrs(), 0, (Object)newInstrs$2, 0, i);
                IntRef j$2 = new IntRef(i);
                is.foreach((Function1)new BasicBlock$$anonfun$insertAfter$1(this, newInstrs$2, j$2));
                if (i + 1 < this.instrs().length) {
                    Array$.MODULE$.copy((Object)this.instrs(), i + 1, (Object)newInstrs$2, j$2.elem, this.instrs().length - i);
                }
                this.instrs_$eq(newInstrs$2);
            }
        }

        public boolean replaceInstruction(Opcodes.Instruction iold, List is) {
            int i;
            Predef$.MODULE$.assert(this.closed(), (Object)"Instructions can be replaced only after the basic block is closed");
            boolean changed = false;
            for (i = 0; i < this.instrs().length && this.instrs()[i] != iold; ++i) {
            }
            if (i < this.instrs().length) {
                Opcodes.Instruction[] newInstrs$1 = new Opcodes.Instruction[this.instrs().length + is.length() - 1];
                changed = true;
                Array$.MODULE$.copy((Object)this.instrs(), 0, (Object)newInstrs$1, 0, i);
                IntRef j$1 = new IntRef(i);
                is.foreach((Function1)new BasicBlock$$anonfun$replaceInstruction$1(this, newInstrs$1, j$1));
                if (i + 1 < this.instrs().length) {
                    Array$.MODULE$.copy((Object)this.instrs(), i + 1, (Object)newInstrs$1, j$1.elem, this.instrs().length - i - 1);
                }
                this.instrs_$eq(newInstrs$1);
            }
            return changed;
        }

        public boolean replaceInstruction(Opcodes.Instruction oldInstr, Opcodes.Instruction newInstr) {
            Predef$.MODULE$.assert(this.closed(), (Object)"Instructions can be replaced only after the basic block is closed");
            boolean changed = false;
            for (int i = 0; i < this.instrs().length && !changed; ++i) {
                Opcodes.Instruction instruction = this.instrs()[i];
                Opcodes.Instruction instruction2 = oldInstr;
                if (instruction != null ? !instruction.equals(instruction2) : instruction2 != null) continue;
                newInstr.pos_$eq(oldInstr.pos());
                this.instrs()[i] = newInstr;
                changed = true;
            }
            return changed;
        }

        public boolean replaceInstruction(int pos, Opcodes.Instruction instr) {
            Predef$.MODULE$.assert(this.closed(), (Object)"Instructions can be replaced only after the basic block is closed");
            instr.pos_$eq(this.instrs()[pos].pos());
            this.instrs()[pos] = instr;
            return true;
        }

        public Opcodes.Instruction apply(int n) {
            return this.closed() ? this.instrs()[n] : (Opcodes.Instruction)this.instructionList().reverse().apply(n);
        }

        public Option findDef(int pos) {
            Predef$.MODULE$.assert(this.closed());
            int i = pos;
            int d = 0;
            while (i > 0) {
                int prod = this.instrs()[--i].produced();
                if (prod > 0 && d == 0) {
                    return new Some((Object)BoxesRunTime.boxToInteger((int)i));
                }
                d += this.instrs()[i].consumed() - this.instrs()[i].produced();
            }
            return None$.MODULE$;
        }

        public int size() {
            return this.isClosed() ? this.instrs().length : this.instructionList().length();
        }

        public void traverseBackwards(Function1 f2) {
            for (int i = this.instrs().length - 1; i >= 0; --i) {
                f2.apply((Object)this.instrs()[i]);
            }
        }

        public void traverse(Function1 f2) {
            if (this.closed()) {
                new BoxedObjectArray((Object[])this.instrs()).foreach(f2);
                return;
            }
            this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().dump();
            this.scala$tools$nsc$backend$icode$BasicBlocks$BasicBlock$$$outer().global().abort(new StringBuilder().append((Object)"Traversing an open block!: ").append((Object)BoxesRunTime.boxToInteger((int)this.label())).toString());
        }

        public int indexOf(Opcodes.Instruction inst) {
            Predef$.MODULE$.assert(this.closed());
            for (int i = 0; i < this.instrs().length; ++i) {
                if (this.instrs()[i] != inst) continue;
                return i;
            }
            return -1;
        }

        public void fromList(List is) {
            this.instrs_$eq(this.toInstructionArray(is));
            this.closed_$eq(true);
        }

        public Opcodes.Instruction[] getArray() {
            Predef$.MODULE$.assert(this.closed());
            return this.instrs();
        }

        public List toList() {
            if (this.closed() && this.touched()) {
                this.instructionList_$eq(List$.MODULE$.fromArray((BoxedArray)new BoxedObjectArray((Object[])this.instrs())));
            }
            return this.instructionList();
        }

        private void touched_$eq(boolean x$1) {
            this.touched = x$1;
        }

        private boolean touched() {
            return this.touched;
        }

        private void instrs_$eq(Opcodes.Instruction[] x$1) {
            this.instrs = x$1;
        }

        private Opcodes.Instruction[] instrs() {
            return this.instrs;
        }

        private void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        private boolean closed() {
            return this.closed;
        }

        private void _lastInstruction_$eq(Opcodes.Instruction x$1) {
            this._lastInstruction = x$1;
        }

        private Opcodes.Instruction _lastInstruction() {
            return this._lastInstruction;
        }

        private void instructionList_$eq(List x$1) {
            this.instructionList = x$1;
        }

        private List instructionList() {
            return this.instructionList;
        }

        public void varsInScope_$eq(Set x$1) {
            this.varsInScope = x$1;
        }

        public Set varsInScope() {
            return this.varsInScope;
        }

        public void exceptionHandlerHeader_$eq(boolean x$1) {
            this.exceptionHandlerHeader = x$1;
        }

        public boolean exceptionHandlerHeader() {
            return this.exceptionHandlerHeader;
        }

        public void loopHeader_$eq(boolean x$1) {
            this.loopHeader = x$1;
        }

        public boolean loopHeader() {
            return this.loopHeader;
        }

        public void preds_$eq(List x$1) {
            this.preds = x$1;
        }

        public List preds() {
            return this.preds;
        }

        public void ignore_$eq(boolean x$1) {
            this.ignore = x$1;
        }

        public boolean ignore() {
            return this.ignore;
        }

        public int label() {
            return this.label;
        }

        public Members.Code code() {
            return this.method().code();
        }

        public Members.IMethod method() {
            return this.method;
        }

        public int $tag() {
            return ScalaObject.class.$tag((ScalaObject)this);
        }
    }
}

