/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.emit;

import ch.epfl.lamp.compiler.msil.Assembly;
import ch.epfl.lamp.compiler.msil.AssemblyName;
import ch.epfl.lamp.compiler.msil.CallingConventions;
import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.FieldAttributes;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.ICustomAttributeProvider;
import ch.epfl.lamp.compiler.msil.MethodAttributes;
import ch.epfl.lamp.compiler.msil.MethodBase;
import ch.epfl.lamp.compiler.msil.MethodImplAttributes;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.Module;
import ch.epfl.lamp.compiler.msil.PEFile;
import ch.epfl.lamp.compiler.msil.ParameterAttributes;
import ch.epfl.lamp.compiler.msil.ParameterInfo;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.TypeAttributes;
import ch.epfl.lamp.compiler.msil.Version;
import ch.epfl.lamp.compiler.msil.emit.AssemblyBuilder;
import ch.epfl.lamp.compiler.msil.emit.ConstructorBuilder;
import ch.epfl.lamp.compiler.msil.emit.FieldBuilder;
import ch.epfl.lamp.compiler.msil.emit.ILGenerator;
import ch.epfl.lamp.compiler.msil.emit.ILPrinterVisitor$;
import ch.epfl.lamp.compiler.msil.emit.Label;
import ch.epfl.lamp.compiler.msil.emit.Label$Kind$;
import ch.epfl.lamp.compiler.msil.emit.LocalBuilder;
import ch.epfl.lamp.compiler.msil.emit.MethodBuilder;
import ch.epfl.lamp.compiler.msil.emit.ModuleBuilder;
import ch.epfl.lamp.compiler.msil.emit.OpCode;
import ch.epfl.lamp.compiler.msil.emit.OpCode$;
import ch.epfl.lamp.compiler.msil.emit.ParameterBuilder;
import ch.epfl.lamp.compiler.msil.emit.TypeBuilder;
import ch.epfl.lamp.compiler.msil.emit.Visitable;
import ch.epfl.lamp.compiler.msil.emit.Visitor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import scala.Function1;
import scala.Predef$;
import scala.ScalaObject;
import scala.StringBuilder;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public abstract class ILPrinterVisitor
implements Visitor,
ScalaObject {
    private Type currentType = null;
    private Module currentModule = null;
    private Object argument = null;
    private MethodInfo entryPoint = null;
    private int padding = 0;
    private Assembly[] as = null;
    private boolean nomembers = false;
    private boolean newline = true;
    private int lmargin = 0;
    private PrintWriter out = null;
    private final Object assemblyNameComparator = new $anon$1(this);

    public void printAttributes(ICustomAttributeProvider icap) {
        ObjectRef attrs$1 = new ObjectRef((Object)icap.GetCustomAttributes(false));
        Predef$.MODULE$.intWrapper(0).until(((Object[])attrs$1.elem).length).foreach((Function1)new $anonfun$printAttributes$1(this, attrs$1));
    }

    public void printTypeName(Type type) {
        Type type2 = type.DeclaringType;
        if (type2 == null || type2.equals(null)) {
            this.printName(type.FullName);
        } else {
            this.printTypeName(type.DeclaringType);
            this.print('/');
            this.printName(type.Name);
        }
    }

    public void printReference(Type type) {
        Assembly assembly = type.Assembly();
        Assembly assembly2 = this.currentModule().Assembly;
        if (!(assembly != null ? !assembly.equals(assembly2) : assembly2 != null)) {
            Module module = type.Module;
            Module module2 = this.currentModule();
            if (module == null ? module2 != null : !module.equals(module2)) {
                this.print("[.module ");
                this.print(type.Module.Name);
                this.print("]");
            }
        } else {
            this.print('[');
            this.print(type.Assembly().GetName().Name);
            this.print("]");
        }
        this.printTypeName(type);
    }

    public void printSignature(Type type) {
        Object sig = ILPrinterVisitor$.MODULE$.primitive().get(type);
        if (BoxesRunTime.equals(sig, null)) {
            if (type.HasElementType()) {
                this.printSignature(type.GetElementType());
                if (type.IsArray()) {
                    this.print("[]");
                } else if (type.IsPointer()) {
                    this.print('*');
                } else if (type.IsByRef()) {
                    this.print('&');
                }
            } else {
                this.print(type.IsValueType() ? "valuetype " : "class ");
                this.printReference(type);
            }
            return;
        }
        this.print(sig);
    }

    public void printSignature(MethodBase method) {
        block6: {
            Type returnType;
            block5: {
                block4: {
                    returnType = null;
                    if (!(method instanceof MethodInfo)) break block4;
                    returnType = ((MethodInfo)method).ReturnType;
                    break block5;
                }
                if (!(method instanceof ConstructorInfo)) break block6;
                returnType = ILPrinterVisitor$.MODULE$.VOID();
            }
            String s = CallingConventions.toString(Predef$.MODULE$.short2int(method.CallingConvention));
            this.print(s);
            if (s.length() > 0) {
                this.print(' ');
            }
            this.printSignature(returnType);
            this.print(' ');
            this.printReference(method.DeclaringType);
            this.print("::");
            this.printName(method.Name);
            ObjectRef params$2 = new ObjectRef((Object)method.GetParameters());
            this.print("(");
            Predef$.MODULE$.intWrapper(0).until(((ParameterInfo[])params$2.elem).length).foreach((Function1)new $anonfun$printSignature$1(this, params$2));
            this.print(")");
            return;
        }
        throw new RuntimeException();
    }

    public void printHeader(MethodBase method, Type returnType) throws IOException {
        this.print(MethodAttributes.toString(method.Attributes));
        this.print(' ');
        this.print(CallingConventions.toString(Predef$.MODULE$.short2int(method.CallingConvention)));
        this.print(' ');
        this.printSignature(returnType);
        this.print(' ');
        this.printName(method.Name);
        ParameterInfo[] params$1 = method.GetParameters();
        this.print('(');
        Predef$.MODULE$.intWrapper(0).until(params$1.length).foreach((Function1)new $anonfun$printHeader$1(this, params$1));
        this.print(") ");
        this.print(MethodImplAttributes.toString(method.GetMethodImplementationFlags()));
    }

    public void printSignature(FieldInfo field) {
        this.printSignature(field.FieldType);
        this.print(' ');
        this.printReference(field.DeclaringType);
        this.print("::");
        this.printName(field.Name);
    }

    public void printAssemblySignature(Assembly assem, boolean extern) {
        Version v;
        Version version;
        this.print(".assembly ");
        if (extern) {
            this.print("extern ");
        }
        AssemblyName an = assem.GetName();
        this.printName(an.Name);
        this.println();
        this.println("{");
        if (!extern) {
            this.printAttributes(assem);
        }
        if ((version = (v = an.Version)) != null && !version.equals(null)) {
            this.print("    .ver ");
            this.print(v.Major);
            this.print(':');
            this.print(v.Minor);
            this.print(':');
            this.print(v.Build);
            this.print(':');
            this.print(v.Revision);
            this.println();
        }
        byte[] key = an.GetPublicKeyToken();
        if (key != null) {
            this.print("    .publickeytoken = (");
            this.print(PEFile.bytes2hex(key));
            this.println(")");
        } else {
            key = an.GetPublicKey();
            if (key != null) {
                this.print("    .publickey = (");
                this.print(PEFile.bytes2hex(key));
                this.println(")");
            }
        }
        this.println("}");
    }

    public void caseLocalBuilder(LocalBuilder localBuilder) throws IOException {
        this.printSignature(localBuilder.LocalType());
        this.print(" '");
        this.print(localBuilder.name());
        this.print("'");
    }

    public void printLabel(Label label) {
        Label.Kind kind;
        Label.Kind kind2 = kind = label.getKind();
        Label.Kind kind3 = Label$Kind$.MODULE$.Normal();
        if (!(kind2 != null ? !kind2.equals(kind3) : kind3 != null)) {
            this.print(Predef$.MODULE$.any2stringadd((Object)label).$plus(": "));
        } else {
            Label.Kind kind4 = kind;
            Label.Kind kind5 = Label$Kind$.MODULE$.NewScope();
            if (!(kind4 != null ? !kind4.equals(kind5) : kind5 != null)) {
                this.print("{");
                this.indent();
            } else {
                Label.Kind kind6 = kind;
                Label.Kind kind7 = Label$Kind$.MODULE$.EndScope();
                if (!(kind6 != null ? !kind6.equals(kind7) : kind7 != null)) {
                    this.undent();
                    this.print("}");
                } else {
                    Label.Kind kind8 = kind;
                    Label.Kind kind9 = Label$Kind$.MODULE$.Try();
                    if (!(kind8 != null ? !kind8.equals(kind9) : kind9 != null)) {
                        this.print(".try {");
                        this.indent();
                    } else {
                        Label.Kind kind10 = kind;
                        Label.Kind kind11 = Label$Kind$.MODULE$.Catch();
                        if (!(kind10 != null ? !kind10.equals(kind11) : kind11 != null)) {
                            this.undent();
                            this.println("}");
                            this.print("catch ");
                            this.printReference((Type)this.argument());
                            this.print(" {");
                            this.indent();
                        } else {
                            Label.Kind kind12 = kind;
                            Label.Kind kind13 = Label$Kind$.MODULE$.Filter();
                            if (!(kind12 != null ? !kind12.equals(kind13) : kind13 != null)) {
                                this.undent();
                                this.println("}");
                                this.print("filter {");
                                this.indent();
                            } else {
                                Label.Kind kind14 = kind;
                                Label.Kind kind15 = Label$Kind$.MODULE$.EndFilter();
                                if (!(kind14 != null ? !kind14.equals(kind15) : kind15 != null)) {
                                    this.print("endfilter");
                                    this.undent();
                                    this.println("}");
                                } else {
                                    Label.Kind kind16 = kind;
                                    Label.Kind kind17 = Label$Kind$.MODULE$.Finally();
                                    if (!(kind16 != null ? !kind16.equals(kind17) : kind17 != null)) {
                                        this.undent();
                                        this.println("}");
                                        this.print("finally {");
                                        this.indent();
                                    } else {
                                        Label.Kind kind18 = kind;
                                        Label.Kind kind19 = Label$Kind$.MODULE$.EndTry();
                                        if (!(kind18 != null ? !kind18.equals(kind19) : kind19 != null)) {
                                            this.undent();
                                            this.print("}");
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void caseOpCode(OpCode opCode) throws IOException {
        block27: {
            block26: {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                String opString = opCode.toString();
                                                this.print(opString);
                                                this.pad(12 - opString.length());
                                                OpCode opCode2 = opCode;
                                                OpCode opCode3 = OpCode$.MODULE$.Ldstr();
                                                if (!(opCode2 != null ? !opCode2.equals(opCode3) : opCode3 != null)) {
                                                    this.print(ILPrinterVisitor$.MODULE$.msilString(this.argument().toString()));
                                                    return;
                                                }
                                                OpCode opCode4 = opCode;
                                                OpCode opCode5 = OpCode$.MODULE$.Switch();
                                                if (!(opCode4 != null ? !opCode4.equals(opCode5) : opCode5 != null)) {
                                                    this.print("(");
                                                    Object object = this.argument();
                                                    Label[] targets$1 = (Label[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Label.class) : object);
                                                    int m = targets$1.length;
                                                    Predef$.MODULE$.intWrapper(0).until(m).foreach((Function1)new $anonfun$caseOpCode$1(this, targets$1));
                                                    this.print(")");
                                                    return;
                                                }
                                                OpCode opCode6 = opCode;
                                                OpCode opCode7 = OpCode$.MODULE$.Call();
                                                if (!(opCode6 == null ? opCode7 != null : !opCode6.equals(opCode7))) break block18;
                                                OpCode opCode8 = opCode;
                                                OpCode opCode9 = OpCode$.MODULE$.Callvirt();
                                                if (!(opCode8 == null ? opCode9 != null : !opCode8.equals(opCode9))) break block18;
                                                OpCode opCode10 = opCode;
                                                OpCode opCode11 = OpCode$.MODULE$.Jmp();
                                                if (!(opCode10 == null ? opCode11 != null : !opCode10.equals(opCode11))) break block18;
                                                OpCode opCode12 = opCode;
                                                OpCode opCode13 = OpCode$.MODULE$.Ldftn();
                                                if (!(opCode12 == null ? opCode13 != null : !opCode12.equals(opCode13))) break block18;
                                                OpCode opCode14 = opCode;
                                                OpCode opCode15 = OpCode$.MODULE$.Ldvirtftn();
                                                if (opCode14 != null ? !opCode14.equals(opCode15) : opCode15 != null) break block19;
                                            }
                                            this.printSignature((MethodBase)this.argument());
                                            return;
                                        }
                                        OpCode opCode16 = opCode;
                                        OpCode opCode17 = OpCode$.MODULE$.Newobj();
                                        if (!(opCode16 != null ? !opCode16.equals(opCode17) : opCode17 != null)) {
                                            this.printSignature((ConstructorInfo)this.argument());
                                            return;
                                        }
                                        OpCode opCode18 = opCode;
                                        OpCode opCode19 = OpCode$.MODULE$.Ldfld();
                                        if (!(opCode18 == null ? opCode19 != null : !opCode18.equals(opCode19))) break block20;
                                        OpCode opCode20 = opCode;
                                        OpCode opCode21 = OpCode$.MODULE$.Ldflda();
                                        if (!(opCode20 == null ? opCode21 != null : !opCode20.equals(opCode21))) break block20;
                                        OpCode opCode22 = opCode;
                                        OpCode opCode23 = OpCode$.MODULE$.Ldsfld();
                                        if (!(opCode22 == null ? opCode23 != null : !opCode22.equals(opCode23))) break block20;
                                        OpCode opCode24 = opCode;
                                        OpCode opCode25 = OpCode$.MODULE$.Ldsflda();
                                        if (!(opCode24 == null ? opCode25 != null : !opCode24.equals(opCode25))) break block20;
                                        OpCode opCode26 = opCode;
                                        OpCode opCode27 = OpCode$.MODULE$.Stfld();
                                        if (!(opCode26 == null ? opCode27 != null : !opCode26.equals(opCode27))) break block20;
                                        OpCode opCode28 = opCode;
                                        OpCode opCode29 = OpCode$.MODULE$.Stsfld();
                                        if (opCode28 != null ? !opCode28.equals(opCode29) : opCode29 != null) break block21;
                                    }
                                    this.printSignature((FieldInfo)this.argument());
                                    return;
                                }
                                OpCode opCode30 = opCode;
                                OpCode opCode31 = OpCode$.MODULE$.Castclass();
                                if (!(opCode30 == null ? opCode31 != null : !opCode30.equals(opCode31))) break block22;
                                OpCode opCode32 = opCode;
                                OpCode opCode33 = OpCode$.MODULE$.Isinst();
                                if (!(opCode32 == null ? opCode33 != null : !opCode32.equals(opCode33))) break block22;
                                OpCode opCode34 = opCode;
                                OpCode opCode35 = OpCode$.MODULE$.Ldobj();
                                if (!(opCode34 == null ? opCode35 != null : !opCode34.equals(opCode35))) break block22;
                                OpCode opCode36 = opCode;
                                OpCode opCode37 = OpCode$.MODULE$.Newarr();
                                if (opCode36 != null ? !opCode36.equals(opCode37) : opCode37 != null) break block23;
                            }
                            this.printSignature((Type)this.argument());
                            return;
                        }
                        OpCode opCode38 = opCode;
                        OpCode opCode39 = OpCode$.MODULE$.Box();
                        if (!(opCode38 == null ? opCode39 != null : !opCode38.equals(opCode39))) break block24;
                        OpCode opCode40 = opCode;
                        OpCode opCode41 = OpCode$.MODULE$.Unbox();
                        if (!(opCode40 == null ? opCode41 != null : !opCode40.equals(opCode41))) break block24;
                        OpCode opCode42 = opCode;
                        OpCode opCode43 = OpCode$.MODULE$.Ldtoken();
                        if (opCode42 != null ? !opCode42.equals(opCode43) : opCode43 != null) break block25;
                    }
                    this.printReference((Type)this.argument());
                    return;
                }
                OpCode opCode44 = opCode;
                OpCode opCode45 = OpCode$.MODULE$.Ldloc();
                if (!(opCode44 == null ? opCode45 != null : !opCode44.equals(opCode45))) break block26;
                OpCode opCode46 = opCode;
                OpCode opCode47 = OpCode$.MODULE$.Ldloc_S();
                if (!(opCode46 == null ? opCode47 != null : !opCode46.equals(opCode47))) break block26;
                OpCode opCode48 = opCode;
                OpCode opCode49 = OpCode$.MODULE$.Ldloca();
                if (!(opCode48 == null ? opCode49 != null : !opCode48.equals(opCode49))) break block26;
                OpCode opCode50 = opCode;
                OpCode opCode51 = OpCode$.MODULE$.Ldloca_S();
                if (!(opCode50 == null ? opCode51 != null : !opCode50.equals(opCode51))) break block26;
                OpCode opCode52 = opCode;
                OpCode opCode53 = OpCode$.MODULE$.Stloc();
                if (!(opCode52 == null ? opCode53 != null : !opCode52.equals(opCode53))) break block26;
                OpCode opCode54 = opCode;
                OpCode opCode55 = OpCode$.MODULE$.Stloc_S();
                if (opCode54 != null ? !opCode54.equals(opCode55) : opCode55 != null) break block27;
            }
            LocalBuilder loc = (LocalBuilder)this.argument();
            this.print(loc.slot());
            this.print("\t// ");
            this.printSignature(loc.LocalType());
            this.print(" '");
            this.print(loc.name());
            this.print("'");
            return;
        }
        if (BoxesRunTime.equals((Object)this.argument(), null)) return;
        this.print(this.argument());
    }

    public void caseILGenerator(ILGenerator code) throws IOException {
        this.println(new StringBuilder().append((Object)".maxstack   ").append((Object)BoxesRunTime.boxToInteger((int)code.getMaxStacksize())).toString());
        ObjectRef locals$1 = new ObjectRef((Object)code.getLocals());
        if (((LocalBuilder[])locals$1.elem).length > 0) {
            this.println(".locals init (");
            this.indent();
            Predef$.MODULE$.intWrapper(0).until(((LocalBuilder[])locals$1.elem).length).foreach((Function1)new $anonfun$caseILGenerator$1(this, locals$1));
            this.undent();
            this.println(")");
        }
        Iterator itL = code.getLabelIterator();
        Iterator itO = code.getOpcodeIterator();
        Iterator itA = code.getArgumentIterator();
        while (itO.hasNext()) {
            OpCode o2;
            Label label = (Label)itL.next();
            String o = (String)code.lineNums().get(label);
            String string = o;
            if (string != null && !string.equals(null)) {
                this.println(new StringBuilder().append((Object)".line       ").append((Object)o).toString());
            }
            this.argument_$eq(itA.next());
            this.printLabel(label);
            OpCode opCode = o2 = (OpCode)itO.next();
            if (opCode != null && !opCode.equals(null)) {
                this.print("   ");
                this.print(o2);
            }
            this.println();
        }
    }

    public void caseParameterBuilder(ParameterBuilder param) throws IOException {
        this.print(ParameterAttributes.toString(Predef$.MODULE$.short2int(param.Attributes)));
        this.printSignature(param.ParameterType);
        this.print(' ');
        this.printName(param.Name);
    }

    public void caseMethodBuilder(MethodBuilder method) throws IOException {
        Type type;
        if (this.nomembers()) {
            return;
        }
        this.print(".method ");
        this.printHeader(method, method.ReturnType);
        if (method.IsAbstract() || (type = method.DeclaringType) != null && !type.equals(null) && method.DeclaringType.IsInterface() && !method.IsStatic()) {
            this.println(" {");
            this.indent();
            this.printAttributes(method);
            this.undent();
            this.println("}");
        } else {
            this.println();
            this.println("{");
            this.indent();
            this.printAttributes(method);
            MethodBuilder methodBuilder = method;
            MethodInfo methodInfo = this.entryPoint();
            if (!(methodBuilder != null ? !methodBuilder.equals(methodInfo) : methodInfo != null)) {
                this.println(".entrypoint");
            }
            try {
                this.print(method.GetILGenerator());
            }
            catch (RuntimeException runtimeException) {
                System.err.println(new StringBuilder().append((Object)"In method ").append((Object)method).toString());
                runtimeException.printStackTrace();
            }
            this.undent();
            this.println("}");
        }
    }

    public void caseConstructorBuilder(ConstructorBuilder constr) throws IOException {
        if (this.nomembers()) {
            return;
        }
        this.print(".method ");
        this.printHeader(constr, ILPrinterVisitor$.MODULE$.VOID());
        this.println();
        this.println("{");
        this.indent();
        this.printAttributes(constr);
        try {
            this.print(constr.GetILGenerator());
        }
        catch (RuntimeException runtimeException) {
            System.err.println(new StringBuilder().append((Object)"In method ").append((Object)constr).toString());
            runtimeException.printStackTrace();
        }
        this.undent();
        this.println("}");
    }

    public void caseFieldBuilder(FieldBuilder field) throws IOException {
        if (this.nomembers()) {
            return;
        }
        this.print(".field ");
        this.print(FieldAttributes.toString(field.Attributes));
        this.print(" ");
        this.printSignature(field.FieldType);
        this.print(" '");
        this.print(field.Name);
        this.print("'");
        if (field.IsLiteral()) {
            this.print(" = ");
            Object value = field.getValue();
            if (BoxesRunTime.equals((Object)value, null)) {
                this.print("nullref");
            } else if (value instanceof String) {
                this.print(ILPrinterVisitor$.MODULE$.msilString((String)value));
            } else if (value instanceof Boolean) {
                this.print("bool (");
                this.print(Predef$.MODULE$.boolean2Boolean(BoxesRunTime.unboxToBoolean((Object)value)) != false ? "true" : "false");
                this.print(")");
            } else if (value instanceof Byte) {
                this.print("int8 (");
                this.print(value);
                this.print(")");
            } else if (value instanceof Short) {
                this.print("int16 (");
                this.print(value);
                this.print(")");
            } else if (value instanceof Character) {
                this.print("char (");
                this.print(((Character)value).charValue());
                this.print(")");
            } else if (value instanceof Integer) {
                this.print("int32 (");
                this.print((Integer)value);
                this.print(")");
            } else if (value instanceof Long) {
                this.print("int64 (");
                this.print(Predef$.MODULE$.long2Long(BoxesRunTime.unboxToLong((Object)value)));
                this.print(")");
            } else if (value instanceof Float) {
                int bits = Float.floatToRawIntBits(Predef$.MODULE$.float2Float(BoxesRunTime.unboxToFloat((Object)value)).floatValue());
                this.print("float32 (float32 (");
                this.print(bits);
                this.print("))");
            } else if (value instanceof Double) {
                long bits = Double.doubleToRawLongBits(Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)value)));
                this.print("float64 (float64 (");
                this.print(bits);
                this.print("))");
            } else {
                throw new Error(new StringBuilder().append((Object)"ILPrinterVisitor: Illegal default value: ").append(value.getClass()).toString());
            }
        }
        this.println();
        this.printAttributes(field);
    }

    public void caseTypeBuilder(TypeBuilder type) throws IOException {
        Type type2;
        String string;
        Type type3;
        this.currentType_$eq(type);
        if (!type.Namespace.equals("") && ((type3 = type.DeclaringType) == null || type3.equals(null))) {
            this.print(".namespace '");
            this.print(type.Namespace);
            this.println("'");
            this.println("{");
            this.indent();
        }
        this.print(".class ");
        this.print(TypeAttributes.toString(type.Attributes));
        this.print(" '");
        this.print(type.Name);
        this.print("'");
        Type type4 = type.BaseType();
        if (type4 != null && !type4.equals(null)) {
            this.println();
            this.print("       extends    ");
            this.printReference(type.BaseType());
        }
        ObjectRef ifaces$1 = new ObjectRef((Object)type.getInterfaces());
        if (((Type[])ifaces$1.elem).length > 0) {
            this.println();
            this.print("       implements ");
            Predef$.MODULE$.intWrapper(0).until(((Type[])ifaces$1.elem).length).foreach((Function1)new $anonfun$caseTypeBuilder$1(this, ifaces$1));
        }
        this.println();
        this.println("{");
        this.indent();
        if (!this.nomembers() && (string = type.sourceFilename()) != null && !string.equals(null)) {
            this.println(new StringBuilder().append((Object)".line  ").append((Object)BoxesRunTime.boxToInteger((int)type.sourceLine())).append((Object)"  '").append((Object)type.sourceFilename()).append((Object)"'").toString());
        }
        if (!this.nomembers()) {
            this.printAttributes(type);
        }
        Iterator nested = type.nestedTypeBuilders().iterator();
        while (nested.hasNext()) {
            this.print((TypeBuilder)nested.next());
        }
        Iterator fields = type.fieldBuilders().iterator();
        while (fields.hasNext()) {
            this.print((FieldBuilder)fields.next());
        }
        Iterator constrs = type.constructorBuilders().iterator();
        while (constrs.hasNext()) {
            this.print((ConstructorBuilder)constrs.next());
        }
        for (MethodBuilder method : type.methodBuilders()) {
            Type type5 = method.DeclaringType;
            TypeBuilder typeBuilder = type;
            Predef$.MODULE$.assert(!(type5 != null ? !type5.equals(typeBuilder) : typeBuilder != null));
            this.print(method);
        }
        this.undent();
        this.println("}");
        if (!type.Namespace.equals("") && ((type2 = type.DeclaringType) == null || type2.equals(null))) {
            this.undent();
            this.println("}");
        }
        this.currentType_$eq(null);
    }

    public void currentType_$eq(Type x$1) {
        this.currentType = x$1;
    }

    public Type currentType() {
        return this.currentType;
    }

    public abstract void caseModuleBuilder(ModuleBuilder var1) throws IOException;

    public void currentModule_$eq(Module x$1) {
        this.currentModule = x$1;
    }

    public Module currentModule() {
        return this.currentModule;
    }

    public abstract void caseAssemblyBuilder(AssemblyBuilder var1) throws IOException;

    public void print(Visitable vAble) throws IOException {
        Visitable visitable = vAble;
        if (visitable != null && !visitable.equals(null)) {
            vAble.apply(this);
        }
    }

    public void argument_$eq(Object x$1) {
        this.argument = x$1;
    }

    public Object argument() {
        return this.argument;
    }

    public void entryPoint_$eq(MethodInfo x$1) {
        this.entryPoint = x$1;
    }

    public MethodInfo entryPoint() {
        return this.entryPoint;
    }

    public void printAssemblyBoilerplate() {
        Predef$.MODULE$.intWrapper(0).until(this.as().length).foreach((Function1)new $anonfun$printAssemblyBoilerplate$1(this));
        this.printAssemblySignature(ILPrinterVisitor$.MODULE$.currAssembly(), false);
    }

    public void printName(String name) {
        char ch = name.charAt(0);
        if (ch != '.') {
            this.print('\'');
            this.print(name);
            this.print('\'');
        } else {
            this.print(name);
        }
    }

    public void println(Object o) {
        this.print(o);
        this.println();
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(int i) {
        this.print(i);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println() {
        this.out().println();
        this.newline_$eq(true);
        this.padding_$eq(0);
    }

    public void print(long val) {
        this.align();
        this.out().print(val);
    }

    public void print(int val) {
        this.align();
        this.out().print(val);
    }

    public void print(char c) {
        this.align();
        this.out().print(c);
    }

    public void print(Object o) {
        this.align();
        this.out().print(o);
    }

    public void print(String s) {
        this.align();
        this.out().print(s);
    }

    private void printPadding() {
        if (this.padding() <= 0) {
            return;
        }
        while (this.padding() > ILPrinterVisitor$.MODULE$.SPACES_LEN()) {
            this.out().print("                                ");
            this.padding_$eq(this.padding() - ILPrinterVisitor$.MODULE$.SPACES_LEN());
        }
        this.out().print("                                ".substring(0, this.padding()));
        this.padding_$eq(0);
    }

    private void pad(int n) {
        Predef$.MODULE$.assert(n >= 0, (Object)new StringBuilder().append((Object)"negative padding: ").append((Object)BoxesRunTime.boxToInteger((int)n)).toString());
        this.padding_$eq(this.padding() + n);
    }

    private void padding_$eq(int x$1) {
        this.padding = x$1;
    }

    private int padding() {
        return this.padding;
    }

    private void undent() {
        this.lmargin_$eq(this.lmargin() - 4);
        Predef$.MODULE$.assert(this.lmargin() >= 0);
    }

    private void indent() {
        this.lmargin_$eq(this.lmargin() + 4);
    }

    private void align() {
        if (this.newline()) {
            this.padding_$eq(this.lmargin());
        }
        this.printPadding();
        this.newline_$eq(false);
    }

    public void as_$eq(Assembly[] x$1) {
        this.as = x$1;
    }

    public Assembly[] as() {
        return this.as;
    }

    public void nomembers_$eq(boolean x$1) {
        this.nomembers = x$1;
    }

    public boolean nomembers() {
        return this.nomembers;
    }

    private void newline_$eq(boolean x$1) {
        this.newline = x$1;
    }

    private boolean newline() {
        return this.newline;
    }

    private void lmargin_$eq(int x$1) {
        this.lmargin = x$1;
    }

    private int lmargin() {
        return this.lmargin;
    }

    public void out_$eq(PrintWriter x$1) {
        this.out = x$1;
    }

    public PrintWriter out() {
        return this.out;
    }

    public final Object assemblyNameComparator() {
        return this.assemblyNameComparator;
    }

    public int $tag() {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

