/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.ant;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.SortedMap;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.tools.ant.Pack200Task$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pack200Task
extends MatchingTask
implements ScalaObject {
    private String packFileSuffix = ".pack";
    private int segmentLimit = -1;
    private boolean repack = false;
    private boolean keepModificationTime = false;
    private boolean keepFileOrder = false;
    private int effort = 9;
    private Option<File> srcdir;
    private Option<File> destdir = None$.MODULE$;

    public Pack200Task() {
        this.srcdir = None$.MODULE$;
    }

    public void execute() {
        File packDir$1 = (File)this.destdir().getOrElse((Function0)new $anonfun$1(this));
        this.fileset.setDir((File)this.srcdir().getOrElse((Function0)new $anonfun$execute$1(this)));
        List<File> files2 = this.getFileList();
        if (files2.isEmpty()) {
            throw this.scala$tools$ant$Pack200Task$$error("No JAR files were selected for packing.");
        }
        Pack200.Packer packer$1 = Pack200.newPacker();
        SortedMap p = packer$1.properties();
        p.put("pack.effort", ((Object)BoxesRunTime.boxToInteger((int)this.effort())).toString());
        p.put("pack.segment.limit", ((Object)BoxesRunTime.boxToInteger((int)this.segmentLimit())).toString());
        p.put("pack.keep.file.order", this.keepFileOrder() ? "true" : "false");
        p.put("pack.modification.time", this.keepModificationTime() ? "latest" : "keep");
        files2.foreach((Function1)new $anonfun$execute$2(this, packDir$1, packer$1));
    }

    public final BufferedOutputStream scala$tools$ant$Pack200Task$$makeOutputStream(File file) {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    public final JarOutputStream scala$tools$ant$Pack200Task$$makeJarOutputStream(File file) {
        return new JarOutputStream(this.scala$tools$ant$Pack200Task$$makeOutputStream(file));
    }

    public final Nothing$ scala$tools$ant$Pack200Task$$error(String message) {
        throw new BuildException(message, this.getLocation());
    }

    private List<File> getFileList() {
        ObjectRef files$1 = new ObjectRef((Object)Nil$.MODULE$);
        FileSet fs = this.getImplicitFileSet();
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        ObjectRef dir$1 = new ObjectRef((Object)fs.getDir(this.getProject()));
        Predef$.MODULE$.refArrayOps((Object[])ds.getIncludedFiles()).withFilter((Function1)new $anonfun$getFileList$1(this)).foreach((Function1)new $anonfun$getFileList$2(this, files$1, dir$1));
        return ((List)files$1.elem).reverse();
    }

    public void setSuffix(String s) {
        this.packFileSuffix_$eq(s);
    }

    public void setDestdir(File file) {
        File file2 = file;
        if (file2 != null && !((Object)file2).equals(null) && file.exists() && file.isDirectory()) {
            this.destdir_$eq((Option<File>)new Some((Object)file));
            return;
        }
        throw this.scala$tools$ant$Pack200Task$$error(new StringBuilder().append((Object)"The destination directory is invalid: ").append((Object)file.getAbsolutePath()).toString());
    }

    public void setSegmentLimit(int size) {
        this.segmentLimit_$eq(size);
    }

    public void setRepack(boolean r) {
        this.repack_$eq(r);
    }

    public void setKeepModificationTime(boolean x2) {
        this.keepModificationTime_$eq(x2);
    }

    public void setKeepFileOrder(boolean x2) {
        this.keepFileOrder_$eq(x2);
    }

    public void setEffort(int x2) {
        if (this.effort() < 10 && this.effort() > -1) {
            this.effort_$eq(x2);
            return;
        }
        throw this.scala$tools$ant$Pack200Task$$error("The effort level must be a value from 0 to 9");
    }

    public void setDir(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            this.srcdir_$eq((Option<File>)new Some((Object)dir));
            return;
        }
        throw this.scala$tools$ant$Pack200Task$$error("Please specify a valid directory with Jar files for packing.");
    }

    public void packFileSuffix_$eq(String string) {
        this.packFileSuffix = string;
    }

    public String packFileSuffix() {
        return this.packFileSuffix;
    }

    public void segmentLimit_$eq(int n) {
        this.segmentLimit = n;
    }

    public int segmentLimit() {
        return this.segmentLimit;
    }

    public void repack_$eq(boolean bl) {
        this.repack = bl;
    }

    public boolean repack() {
        return this.repack;
    }

    public void keepModificationTime_$eq(boolean bl) {
        this.keepModificationTime = bl;
    }

    public boolean keepModificationTime() {
        return this.keepModificationTime;
    }

    public void keepFileOrder_$eq(boolean bl) {
        this.keepFileOrder = bl;
    }

    public boolean keepFileOrder() {
        return this.keepFileOrder;
    }

    public void effort_$eq(int n) {
        this.effort = n;
    }

    public int effort() {
        return this.effort;
    }

    public void srcdir_$eq(Option<File> option) {
        this.srcdir = option;
    }

    public Option<File> srcdir() {
        return this.srcdir;
    }

    public void destdir_$eq(Option<File> option) {
        this.destdir = option;
    }

    public Option<File> destdir() {
        return this.destdir;
    }
}

