/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.fjbg;

import ch.epfl.lamp.fjbg.FJBGContext;
import ch.epfl.lamp.fjbg.JAttribute;
import ch.epfl.lamp.fjbg.JClass;
import ch.epfl.lamp.fjbg.JCode;
import ch.epfl.lamp.fjbg.JMethod;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;

public class JCodeAttribute
extends JAttribute {
    protected final JCode code;

    public JCodeAttribute(FJBGContext context, JClass clazz, JMethod owner) {
        super(context, clazz);
        this.code = owner.getCode();
        assert (clazz == owner.getOwner());
    }

    public JCodeAttribute(FJBGContext context, JClass clazz, Object owner, String name2, int size2, DataInputStream stream) throws IOException {
        super(context, clazz);
        stream.readShort();
        stream.readShort();
        this.code = context.JCode(clazz, (JMethod)owner, stream);
        int handlersCount = stream.readShort();
        for (int i = 0; i < handlersCount; ++i) {
            JCode jCode = this.code;
            jCode.getClass();
            this.code.addExceptionHandler(jCode.new JCode.ExceptionHandler(stream));
        }
        List attributes = JAttribute.readFrom(context, clazz, owner, stream);
        Iterator attrIt = attributes.iterator();
        while (attrIt.hasNext()) {
            this.code.addAttribute((JAttribute)attrIt.next());
        }
        assert (name2.equals(this.getName()));
    }

    public String getName() {
        return "Code";
    }

    protected int getSize() {
        int handlersNum = this.code.getExceptionHandlers().size();
        int attrsSize = 0;
        for (JAttribute attr : this.code.getAttributes()) {
            attrsSize += attr.getSize() + 6;
        }
        return 8 + this.code.getSize() + 2 + 8 * handlersNum + 2 + attrsSize;
    }

    protected void writeContentsTo(DataOutputStream stream) throws IOException {
        List handlers = this.code.getExceptionHandlers();
        stream.writeShort(this.code.getMaxStackSize());
        stream.writeShort(this.code.getOwner().getMaxLocals());
        this.code.writeTo(stream);
        stream.writeShort(handlers.size());
        Iterator handlerIt = handlers.iterator();
        while (handlerIt.hasNext()) {
            ((JCode.ExceptionHandler)handlerIt.next()).writeTo(stream);
        }
        JAttribute.writeTo(this.code.getAttributes(), stream);
    }
}

