/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.CharsetDecoder;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.PlainFile;
import scala.tools.nsc.io.SourceReader$;
import scala.tools.nsc.io.ZipArchive;
import scala.tools.nsc.reporters.Reporter;
import scala.tools.nsc.util.NoPosition$;

@ScalaSignature(bytes="\u0006\u0001\u0005eb\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0006\u0003\u0019M{WO]2f%\u0016\fG-\u001a:\u000b\u0005\r!\u0011AA5p\u0015\t)a!A\u0002og\u000eT!a\u0002\u0005\u0002\u000bQ|w\u000e\\:\u000b\u0003%\tQa]2bY\u0006\u001c\u0001aE\u0002\u0001\u0019Q\u0001\"!\u0004\n\u000e\u00039Q!a\u0004\t\u0002\t1\fgn\u001a\u0006\u0002#\u0005!!.\u0019<b\u0013\t\u0019bB\u0001\u0004PE*,7\r\u001e\t\u0003+Yi\u0011\u0001C\u0005\u0003/!\u00111bU2bY\u0006|%M[3di\"A\u0011\u0004\u0001B\u0001B\u0003%!$A\u0004eK\u000e|G-\u001a:\u0011\u0005m\u0001S\"\u0001\u000f\u000b\u0005uq\u0012aB2iCJ\u001cX\r\u001e\u0006\u0003?A\t1A\\5p\u0013\t\tCD\u0001\bDQ\u0006\u00148/\u001a;EK\u000e|G-\u001a:\t\u0011\r\u0002!\u0011!Q\u0001\n\u0011\n\u0001B]3q_J$XM\u001d\t\u0003K!j\u0011A\n\u0006\u0003O\u0011\t\u0011B]3q_J$XM]:\n\u0005%2#\u0001\u0003*fa>\u0014H/\u001a:\t\u000b-\u0002A\u0011\u0001\u0017\u0002\rqJg.\u001b;?)\ris\u0006\r\t\u0003]\u0001i\u0011A\u0001\u0005\u00063)\u0002\rA\u0007\u0005\u0006G)\u0002\r\u0001\n\u0005\be\u0001\u0011\r\u0011\"\u00034\u0003\u0015\u0011\u0017\u0010^3t+\u0005!\u0004CA\u001b7\u001b\u0005q\u0012BA\u001c\u001f\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u0007s\u0001\u0001\u000b\u0011\u0002\u001b\u0002\r\tLH/Z:!\u0011\u001dY\u0004\u00011A\u0005\nq\nQa\u00195beN,\u0012!\u0010\t\u0003kyJ!a\u0010\u0010\u0003\u0015\rC\u0017M\u001d\"vM\u001a,'\u000fC\u0004B\u0001\u0001\u0007I\u0011\u0002\"\u0002\u0013\rD\u0017M]:`I\u0015\fHCA\"G!\t)B)\u0003\u0002F\u0011\t!QK\\5u\u0011\u001d9\u0005)!AA\u0002u\n1\u0001\u001f\u00132\u0011\u0019I\u0005\u0001)Q\u0005{\u000511\r[1sg\u0002BQa\u0013\u0001\u0005\n1\u000b1C]3q_J$XI\\2pI&tw-\u0012:s_J$\"aQ'\t\u000b9S\u0005\u0019A(\u0002\u0011\u0019LG.\u001a8b[\u0016\u0004\"\u0001U*\u000f\u0005U\t\u0016B\u0001*\t\u0003\u0019\u0001&/\u001a3fM&\u0011A+\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005IC\u0001\"B,\u0001\t\u0003A\u0016\u0001\u0002:fC\u0012$\"!W0\u0011\u0007UQF,\u0003\u0002\\\u0011\t)\u0011I\u001d:bsB\u0011Q#X\u0005\u0003=\"\u0011Aa\u00115be\")aJ\u0016a\u0001\u001f\")q\u000b\u0001C\u0001CR\u0011\u0011L\u0019\u0005\u0006G\u0002\u0004\r\u0001Z\u0001\u0005M&dW\r\u0005\u0002fO6\taM\u0003\u0002\u0004!%\u0011\u0001N\u001a\u0002\u0005\r&dW\rC\u0003X\u0001\u0011\u0005!\u000e\u0006\u0002ZW\")1-\u001ba\u0001YB\u0011a&\\\u0005\u0003]\n\u0011A\"\u00112tiJ\f7\r\u001e$jY\u0016DQa\u0016\u0001\u0005\u0012A$\"!W9\t\u000bI|\u0007\u0019A:\u0002\u000b%t\u0007/\u001e;\u0011\u0005Q<X\"A;\u000b\u0005Yt\u0012\u0001C2iC:tW\r\\:\n\u0005a,(a\u0005*fC\u0012\f'\r\\3CsR,7\t[1o]\u0016d\u0007\"B,\u0001\t#QHCA-|\u0011\u0015\u0011\u0014\u00101\u00015\u0011\u0015i\b\u0001\"\u0003\u007f\u0003%!XM]7j]\u0006$X\r\u0006\u0002Z\u007f\")1\b a\u0001{\u001d9\u00111\u0001\u0002\t\u0006\u0005\u0015\u0011\u0001D*pkJ\u001cWMU3bI\u0016\u0014\bc\u0001\u0018\u0002\b\u0019I\u0011A\u0001C\u0001\u0002#\u0015\u0011\u0011B\n\u0005\u0003\u000faA\u0003C\u0004,\u0003\u000f!\t!!\u0004\u0015\u0005\u0005\u0015\u0001\u0002CA\t\u0003\u000f!\t!a\u0005\u0002\r\u0011,7m\u001c3f)%i\u0014QCA\f\u00033\tY\u0002\u0003\u0004\u001a\u0003\u001f\u0001\rA\u0007\u0005\u0007e\u0005=\u0001\u0019\u0001\u001b\t\rm\ny\u00011\u0001>\u0011!\ti\"a\u0004A\u0002\u0005}\u0011AC3oI>3\u0017J\u001c9viB\u0019Q#!\t\n\u0007\u0005\r\u0002BA\u0004C_>dW-\u00198\t\u0011\u0005\u001d\u0012q\u0001C\u0001\u0003S\tQA\u001a7vg\"$R!PA\u0016\u0003[Aa!GA\u0013\u0001\u0004Q\u0002BB\u001e\u0002&\u0001\u0007Q\b\u0003\u0005\u00022\u0005\u001dA\u0011BA\u001a\u0003AIgn\u0019:fCN,7)\u00199bG&$\u0018\u0010F\u0002>\u0003kAq!a\u000e\u00020\u0001\u0007Q(\u0001\u0004ck\u001a4WM\u001d")
public class SourceReader
implements ScalaObject {
    private final CharsetDecoder decoder;
    private final Reporter reporter;
    private final ByteBuffer bytes;
    private CharBuffer chars;

    public static final CharBuffer flush(CharsetDecoder charsetDecoder, CharBuffer charBuffer) {
        return SourceReader$.MODULE$.flush(charsetDecoder, charBuffer);
    }

    public static final CharBuffer decode(CharsetDecoder charsetDecoder, ByteBuffer byteBuffer, CharBuffer charBuffer, boolean bl) {
        return SourceReader$.MODULE$.decode(charsetDecoder, byteBuffer, charBuffer, bl);
    }

    private ByteBuffer bytes() {
        return this.bytes;
    }

    private CharBuffer chars() {
        return this.chars;
    }

    private void chars_$eq(CharBuffer charBuffer) {
        this.chars = charBuffer;
    }

    private void reportEncodingError(String filename) {
        this.reporter.error(NoPosition$.MODULE$, new StringBuilder().append((Object)"IO error while decoding ").append((Object)filename).append((Object)" with ").append((Object)this.decoder.charset()).append((Object)"\n").append((Object)"Please try specifying another one using the -encoding option").toString());
    }

    public char[] read(String filename) {
        return this.read(new File(filename));
    }

    public char[] read(File file) {
        char[] exceptionResult1;
        FileChannel c = new FileInputStream(file).getChannel();
        try {
            exceptionResult1 = this.read(c);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.reportEncodingError(file.toString());
            exceptionResult1 = new char[]{};
            return exceptionResult1;
        }
        return exceptionResult1;
        finally {
            c.close();
        }
    }

    public char[] read(AbstractFile file) {
        char[] cArray;
        if (file instanceof PlainFile) {
            cArray = this.read(((PlainFile)file).file());
        } else if (file instanceof ZipArchive.FileEntry) {
            ZipArchive.FileEntry temp3 = (ZipArchive.FileEntry)file;
            ReadableByteChannel c = Channels.newChannel(temp3.archive().getInputStream(temp3.entry));
            cArray = this.read(c);
        } else {
            char[] exceptionResult2;
            ByteBuffer b = ByteBuffer.wrap(file.toByteArray());
            try {
                exceptionResult2 = this.read(b);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.reportEncodingError(file.toString());
                exceptionResult2 = new char[]{};
            }
            cArray = exceptionResult2;
        }
        return cArray;
    }

    public char[] read(ReadableByteChannel input) {
        CharsetDecoder decoder = this.decoder.reset();
        ByteBuffer bytes2 = this.bytes();
        bytes2.clear();
        CharBuffer chars = this.chars();
        chars.clear();
        boolean endOfInput = false;
        while (!endOfInput) {
            endOfInput = input.read(bytes2) < 0;
            bytes2.flip();
            chars = SourceReader$.MODULE$.decode(decoder, bytes2, chars, endOfInput);
        }
        return this.terminate(SourceReader$.MODULE$.flush(decoder, chars));
    }

    public char[] read(ByteBuffer bytes2) {
        CharsetDecoder decoder = this.decoder.reset();
        CharBuffer chars = this.chars();
        chars.clear();
        return this.terminate(SourceReader$.MODULE$.flush(decoder, SourceReader$.MODULE$.decode(decoder, bytes2, chars, true)));
    }

    /*
     * WARNING - void declaration
     */
    private char[] terminate(CharBuffer chars) {
        void var2_2;
        char[] result2 = new char[chars.length()];
        chars.get(result2);
        this.chars_$eq(chars);
        return var2_2;
    }

    public SourceReader(CharsetDecoder decoder, Reporter reporter) {
        this.decoder = decoder;
        this.reporter = reporter;
        this.bytes = ByteBuffer.allocate(16384);
        this.chars = CharBuffer.allocate(16384);
    }
}

