/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil;

import ch.epfl.lamp.compiler.msil.Version;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class AssemblyName {
    public String Name;
    public Version Version;
    private byte[] publicKeyToken;
    private byte[] publicKey;
    private static final MessageDigest sha;

    public byte[] GetPublicKeyToken() {
        return this.publicKeyToken == null ? null : (byte[])this.publicKeyToken.clone();
    }

    public void SetPublicKeyToken(byte[] key) {
        this.publicKeyToken = key.length == 0 ? null : (byte[])key.clone();
    }

    public byte[] GetPublicKey() {
        return this.publicKey == null ? null : (byte[])this.publicKey.clone();
    }

    public void SetPublicKey(byte[] key) {
        if (key.length > 0) {
            this.publicKey = (byte[])key.clone();
            byte[] hash = sha.digest(key);
            byte[] keyToken = new byte[8];
            for (int i = 0; i < keyToken.length; ++i) {
                keyToken[i] = hash[hash.length - 1 - i];
            }
            this.publicKeyToken = keyToken;
        }
    }

    public String toString() {
        return this.Name + ", Version=" + this.Version;
    }

    static {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        sha = md;
    }
}

