/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.lamp.compiler.msil.emit;

import ch.epfl.lamp.compiler.msil.ConstructorInfo;
import ch.epfl.lamp.compiler.msil.FieldInfo;
import ch.epfl.lamp.compiler.msil.MethodBase;
import ch.epfl.lamp.compiler.msil.MethodInfo;
import ch.epfl.lamp.compiler.msil.Type;
import ch.epfl.lamp.compiler.msil.emit.ILGenerator$;
import ch.epfl.lamp.compiler.msil.emit.Label;
import ch.epfl.lamp.compiler.msil.emit.Label$;
import ch.epfl.lamp.compiler.msil.emit.Label$Kind$;
import ch.epfl.lamp.compiler.msil.emit.LocalBuilder;
import ch.epfl.lamp.compiler.msil.emit.OpCode;
import ch.epfl.lamp.compiler.msil.emit.OpCode$;
import ch.epfl.lamp.compiler.msil.emit.OpCodes$;
import ch.epfl.lamp.compiler.msil.emit.Visitable;
import ch.epfl.lamp.compiler.msil.emit.Visitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import scala.Function0;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedArray;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ILGenerator
implements Visitable,
ScalaObject {
    private final Map<Label, String> lineNums;
    private MethodBase owner;
    private ExceptionStack excStack;
    private int locals = 0;
    private int maxstack = 0;
    private Label lastLabel;
    private int pc = 0;
    private final ArrayList<Object> argumentList;
    private final ArrayList<OpCode> opcodeList;
    private final ArrayList<Label> labelList;
    private final ArrayList<LocalBuilder> localList = new ArrayList();

    public ILGenerator(MethodBase _owner) {
        this.labelList = new ArrayList();
        this.opcodeList = new ArrayList();
        this.argumentList = new ArrayList();
        this.lastLabel = new Label.NormalLabel(this.pc(), 0);
        this.excStack = new ExceptionStack();
        this.owner = _owner;
        this.lineNums = new HashMap<Label, String>();
    }

    @Override
    public void apply(Visitor v) throws IOException {
        v.caseILGenerator(this);
    }

    private void emitSpecialLabel(Label l, Type catchType) {
        this.labelList().add(l);
        this.opcodeList().add(null);
        this.argumentList().add(catchType);
    }

    private void emitSpecialLabel(Label l) {
        this.emitSpecialLabel(l, null);
    }

    private void emit(OpCode opcode, Object arg, int overridePOPUSH) {
        this.labelList().add(this.lastLabel());
        this.opcodeList().add(opcode);
        this.argumentList().add(arg);
        int stackSize = this.lastLabel().getStacksize() + overridePOPUSH;
        if (stackSize < 0) {
            throw new RuntimeException();
        }
        if (stackSize > this.maxstack()) {
            this.maxstack_$eq(stackSize);
        }
        int address = this.lastLabel().getAddress() + opcode.CEE_length();
        if (opcode.CEE_opcode() == OpCode$.MODULE$.CEE_SWITCH()) {
            address += 4 * ((Label[])(arg instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)arg, Label.class) : arg)).length;
        }
        this.lastLabel_$eq(new Label.NormalLabel(address, stackSize));
        this.pc_$eq(this.pc() + 1);
    }

    private void emit(OpCode opcode, Object arg) {
        this.emit(opcode, arg, Predef$.MODULE$.byte2int(opcode.CEE_popush()));
    }

    public int getMaxStacksize() {
        return this.maxstack();
    }

    public Map<Label, String> lineNums() {
        return this.lineNums;
    }

    public void owner_$eq(MethodBase methodBase) {
        this.owner = methodBase;
    }

    public MethodBase owner() {
        return this.owner;
    }

    private void excStack_$eq(ExceptionStack exceptionStack) {
        this.excStack = exceptionStack;
    }

    private ExceptionStack excStack() {
        return this.excStack;
    }

    private void locals_$eq(int n) {
        this.locals = n;
    }

    private int locals() {
        return this.locals;
    }

    private void maxstack_$eq(int n) {
        this.maxstack = n;
    }

    private int maxstack() {
        return this.maxstack;
    }

    private void lastLabel_$eq(Label label) {
        this.lastLabel = label;
    }

    private Label lastLabel() {
        return this.lastLabel;
    }

    private void pc_$eq(int n) {
        this.pc = n;
    }

    private int pc() {
        return this.pc;
    }

    private final ArrayList<Object> argumentList() {
        return this.argumentList;
    }

    private final ArrayList<OpCode> opcodeList() {
        return this.opcodeList;
    }

    private final ArrayList<Label> labelList() {
        return this.labelList;
    }

    private final ArrayList<LocalBuilder> localList() {
        return this.localList;
    }

    public Iterator<Object> getArgumentIterator() {
        return this.argumentList().iterator();
    }

    public Iterator<OpCode> getOpcodeIterator() {
        return this.opcodeList().iterator();
    }

    public Iterator<Label> getLabelIterator() {
        return this.labelList().iterator();
    }

    public LocalBuilder[] getLocals() {
        return (LocalBuilder[])this.localList().toArray((Object[])new LocalBuilder[0]);
    }

    public void setPosition(int line, String filename) {
        if (line != 0) {
            this.lineNums().put(this.lastLabel(), new StringBuilder().append(line).append((Object)"  '").append((Object)filename).append((Object)"'").toString());
        }
    }

    public void setPosition(int line) {
        if (line != 0) {
            this.lineNums().put(this.lastLabel(), Integer.toString(line));
        }
    }

    public void ThrowException(Type exceptionType) {
        Type type = exceptionType;
        Predef$.MODULE$.assert(type != null && !type.equals(null));
        if (exceptionType.isSubtypeOf(Type.GetType("System.Exception"))) {
            ConstructorInfo ctor;
            Predef$.MODULE$.any2stringadd((Object)exceptionType).$plus(" doesn't extend System.Exception");
            ConstructorInfo constructorInfo = ctor = exceptionType.GetConstructor(Type.EmptyTypes);
            if (constructorInfo == null || constructorInfo.equals(null)) {
                throw new RuntimeException(new StringBuilder().append((Object)"Type ").append((Object)exceptionType).append((Object)"doesn't have a default constructor").toString());
            }
            this.Emit(OpCodes$.MODULE$.Newobj(), ctor);
            this.Emit(OpCodes$.MODULE$.Throw());
            return;
        }
        throw new RuntimeException();
    }

    public void BeginFinallyBlock() {
        this.Emit(OpCodes$.MODULE$.Leave(), this.excStack().peekLabel());
        this.emitSpecialLabel(Label$.MODULE$.Finally());
    }

    public void EndExceptionBlock() {
        Label.Kind kind;
        Label.Kind kind2 = kind = this.excStack().peekKind();
        Label.Kind kind3 = Label$Kind$.MODULE$.Try();
        if (!(kind2 != null ? !kind2.equals(kind3) : kind3 != null)) {
            throw new RuntimeException("Try block with neither catch nor finally");
        }
        Label.Kind kind4 = kind;
        Label.Kind kind5 = Label$Kind$.MODULE$.Catch();
        if (!(kind4 != null ? !kind4.equals(kind5) : kind5 != null)) {
            this.Emit(OpCodes$.MODULE$.Leave(), this.excStack().peekLabel());
        } else {
            Label.Kind kind6 = kind;
            Label.Kind kind7 = Label$Kind$.MODULE$.Finally();
            if (!(kind6 != null ? !kind6.equals(kind7) : kind7 != null)) {
                this.Emit(OpCodes$.MODULE$.Endfinally());
            }
        }
        this.MarkLabel(this.excStack().popLabel());
        this.emitSpecialLabel(Label$.MODULE$.EndTry());
    }

    public void BeginCatchBlock(Type exceptionType) {
        block3: {
            block2: {
                Label.Kind kind;
                Label.Kind kind2 = kind = this.excStack().peekKind();
                Label.Kind kind3 = Label$Kind$.MODULE$.Try();
                if (!(kind2 == null ? kind3 != null : !kind2.equals(kind3))) break block2;
                Label.Kind kind4 = kind;
                Label.Kind kind5 = Label$Kind$.MODULE$.Catch();
                if (kind4 != null ? !kind4.equals(kind5) : kind5 != null) break block3;
            }
            Label endExc = this.excStack().popLabel();
            this.Emit(OpCodes$.MODULE$.Leave(), endExc);
            this.lastLabel().incStacksize();
            this.excStack().push(Label$.MODULE$.Catch(), endExc);
            this.emitSpecialLabel(Label$.MODULE$.Catch(), exceptionType);
            return;
        }
        throw new RuntimeException("Catch should follow either a try or catch");
    }

    public void BeginExceptionBlock() {
        this.emitSpecialLabel(Label$.MODULE$.Try());
        Label.NormalLabel endExc = new Label.NormalLabel();
        this.excStack().push(Label$.MODULE$.Try(), endExc);
    }

    public void EndScope() {
        this.emitSpecialLabel(Label$.MODULE$.EndScope());
    }

    public void BeginScope() {
        this.emitSpecialLabel(Label$.MODULE$.NewScope());
    }

    public void MarkLabel(Label label) {
        label.mergeWith(this.lastLabel());
    }

    public Label DefineLabel() {
        return new Label.NormalLabel();
    }

    public LocalBuilder DeclareLocal(Type localType) {
        LocalBuilder l = new LocalBuilder(this.locals(), localType);
        this.locals_$eq(this.locals() + 1);
        this.localList().add(l);
        return l;
    }

    public void EmitWriteLine(String arg) {
        this.Emit(OpCode$.MODULE$.Ldstr(), arg);
        Type t = Type.GetType("System.Console");
        Type[] argsType = new Type[]{Type.GetType("System.String")};
        MethodInfo m = t.GetMethod("WriteLine", argsType);
        this.EmitCall(OpCode$.MODULE$.Call(), m, null);
    }

    public void EmitWriteLine(LocalBuilder arg) {
        this.Emit(OpCodes$.MODULE$.Ldloc(), arg);
        Type t = Type.GetType("System.Console");
        Type[] argsType = new Type[]{arg.LocalType()};
        MethodInfo m = t.GetMethod("WriteLine", argsType);
        this.EmitCall(OpCode$.MODULE$.Call(), m, null);
    }

    public void EmitWriteLine(FieldInfo arg) {
        if (arg.IsStatic()) {
            this.Emit(OpCodes$.MODULE$.Ldsfld(), arg);
        } else {
            this.Emit(OpCodes$.MODULE$.Ldfld(), arg);
        }
        Type t = Type.GetType("System.Console");
        Type[] argsType = new Type[]{arg.FieldType};
        MethodInfo m = t.GetMethod("WriteLine", argsType);
        this.EmitCall(OpCode$.MODULE$.Call(), m, null);
    }

    public void EmitCall(OpCode opcode, MethodInfo arg, Type[] optionalParameterTypes) {
        MethodInfo methodInfo = arg;
        Predef$.MODULE$.assert(methodInfo != null && !methodInfo.equals(null));
        Type type = arg.ReturnType;
        Type type2 = ILGenerator$.MODULE$.VOID();
        this.emit(opcode, arg, (!(type != null ? !type.equals(type2) : type2 != null) ? 0 : 1) - arg.GetParameters().length);
    }

    public void Emit(OpCode opcode, Type arg) {
        Type type = arg;
        Predef$.MODULE$.assert(type != null && !type.equals(null));
        this.emit(opcode, arg);
    }

    public void Emit(OpCode opcode, String arg) {
        String string = arg;
        Predef$.MODULE$.assert(string != null && !string.equals(null));
        this.emit(opcode, arg);
    }

    public void Emit(OpCode opcode, float arg) {
        this.emit(opcode, new Float(arg));
    }

    /*
     * Unable to fully structure code
     */
    public void Emit(OpCode opcode, MethodInfo arg$1) {
        block4: {
            block3: {
                block2: {
                    var3_3 = arg$1;
                    Predef$.MODULE$.assert(var3_3 != null && var3_3.equals(null) == false);
                    var4_4 = arg$1.ReturnType;
                    Predef$.MODULE$.assert(var4_4 != null && var4_4.equals(null) == false, (Function0)new $anonfun$Emit$1(this, arg$1));
                    v0 = opcode;
                    var6_5 = OpCode$.MODULE$.Ldftn();
                    if (!(v0 == null ? var6_5 != null : v0.equals(var6_5) == false)) break block2;
                    v1 = opcode;
                    var7_6 = OpCode$.MODULE$.Ldvirtftn();
                    if (!(v1 == null ? var7_6 != null : v1.equals(var7_6) == false)) break block2;
                    v2 = opcode;
                    var8_7 = OpCode$.MODULE$.Jmp();
                    if (v2 != null ? v2.equals(var8_7) == false : var8_7 != null) break block3;
                }
                v3 = OpCode$.MODULE$.PUSH_size()[Predef$.MODULE$.byte2int(opcode.CEE_push())] - OpCode$.MODULE$.POP_size()[Predef$.MODULE$.byte2int(opcode.CEE_pop())];
                break block4;
            }
            v4 = opcode;
            var9_8 = OpCode$.MODULE$.Calli();
            if (!(v4 == null ? var9_8 != null : v4.equals(var9_8) == false)) ** GOTO lbl-1000
            v5 = opcode;
            var10_9 = OpCode$.MODULE$.Callvirt();
            if (!(v5 != null ? v5.equals(var10_9) == false : var10_9 != null)) lbl-1000:
            // 2 sources

            {
                v6 = arg$1.ReturnType;
                var11_10 = ILGenerator$.MODULE$.VOID();
                v3 = (!(v6 != null ? v6.equals(var11_10) == false : var11_10 != null) ? 0 : 1) - arg$1.GetParameters().length - 1;
            } else {
                v7 = arg$1.ReturnType;
                var12_11 = ILGenerator$.MODULE$.VOID();
                v3 = (!(v7 != null ? v7.equals(var12_11) == false : var12_11 != null) ? 0 : 1) - arg$1.GetParameters().length;
            }
        }
        popush = v3;
        this.emit(opcode, arg$1, popush);
    }

    public void Emit(OpCode opcode, Label[] arg) {
        Predef$.MODULE$.assert(arg != null);
        this.emit(opcode, arg, arg.length);
    }

    public void Emit(OpCode opcode, Label label) {
        Label label2 = label;
        Predef$.MODULE$.assert(label2 != null && !label2.equals(null));
        this.emit(opcode, label);
        if (!label.isInitialized()) {
            label.setStacksize(this.lastLabel().getStacksize());
        }
    }

    public void Emit(OpCode opcode, long arg) {
        this.emit(opcode, new Long(arg));
    }

    public void Emit(OpCode opcode, int arg) {
        this.emit(opcode, new Integer(arg));
    }

    public void Emit(OpCode opcode, short arg) {
        this.emit(opcode, new Short(arg));
    }

    public void Emit(OpCode opcode, FieldInfo arg) {
        FieldInfo fieldInfo = arg;
        Predef$.MODULE$.assert(fieldInfo != null && !fieldInfo.equals(null));
        this.emit(opcode, arg);
    }

    public void Emit(OpCode opcode, double arg) {
        this.emit(opcode, new Double(arg));
    }

    public void Emit(OpCode opcode, LocalBuilder arg) {
        LocalBuilder localBuilder = arg;
        Predef$.MODULE$.assert(localBuilder != null && !localBuilder.equals(null));
        this.emit(opcode, arg);
    }

    public void Emit(OpCode opcode, ConstructorInfo arg) {
        ConstructorInfo constructorInfo = arg;
        Predef$.MODULE$.assert(constructorInfo != null && !constructorInfo.equals(null));
        this.emit(opcode, arg, OpCode$.MODULE$.PUSH_size()[Predef$.MODULE$.byte2int(opcode.CEE_push())] - arg.GetParameters().length);
    }

    public void Emit(OpCode opcode, char arg) {
        this.emit(opcode, new Character(arg));
    }

    public void Emit(OpCode opcode) {
        OpCode opCode = opcode;
        OpCode opCode2 = OpCode$.MODULE$.Ret();
        if (!(opCode != null ? !opCode.equals(opCode2) : opCode2 != null)) {
            this.emit(opcode, null, 0);
        } else {
            this.emit(opcode, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ExceptionStack
    implements ScalaObject {
        private final Stack<Label> kinds;
        private final Stack<Label> labels = new Stack();

        public ExceptionStack() {
            this.kinds = new Stack();
        }

        public Label popLabel() {
            this.kinds().pop();
            return this.labels().pop();
        }

        public Label peekLabel() {
            return this.labels().peek();
        }

        public Label.Kind peekKind() {
            return this.kinds().peek().getKind();
        }

        public void push(Label kind, Label label) {
            this.kinds().push(kind);
            this.labels().push(label);
        }

        public void pop() {
            this.labels().pop();
            this.kinds().pop();
        }

        public void ExceptionStack() {
        }

        private Stack<Label> kinds() {
            return this.kinds;
        }

        private Stack<Label> labels() {
            return this.labels;
        }
    }
}

