/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.nsc.io;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.tools.nsc.io.AbstractFile;
import scala.tools.nsc.io.PlainFile;
import scala.tools.nsc.io.VirtualFile;
import scala.tools.nsc.io.ZipArchive$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ZipArchive
extends PlainFile
implements ScalaObject {
    private DirEntry root;
    private final ZipFile archive;

    public static final AbstractFile fromURL(URL uRL) {
        return ZipArchive$.MODULE$.fromURL(uRL);
    }

    public static final AbstractFile fromArchive(ZipFile zipFile) {
        return ZipArchive$.MODULE$.fromArchive(zipFile);
    }

    public static final AbstractFile fromFile(File file) {
        return ZipArchive$.MODULE$.fromFile(file);
    }

    public static final AbstractFile fromPath(String string) {
        return ZipArchive$.MODULE$.fromPath(string);
    }

    public ZipArchive(File file, ZipFile archive) {
        this.archive = archive;
        super(file);
        Predef$.MODULE$.assert(archive != null);
    }

    private DirEntry getDir(Map<String, DirEntry> dirs, String path) {
        Option temp1;
        block4: {
            DirEntry dirEntry;
            block3: {
                block2: {
                    DirEntry temp3;
                    temp1 = dirs.get((Object)path);
                    if (!(temp1 instanceof Some)) break block2;
                    Some temp2 = (Some)temp1;
                    dirEntry = temp3 = (DirEntry)temp2.x();
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option option = temp1;
                if ((none$ != null ? !none$.equals(option) : option != null) || !(temp1 instanceof None$)) break block4;
                int index = path.lastIndexOf(47, path.length() - 2);
                String name = index < 0 ? path : path.substring(index + 1);
                String home = index < 0 ? "/" : path.substring(0, index + 1);
                DirEntry parent = this.getDir(dirs, home);
                DirEntry dir = new DirEntry(this, parent, name.substring(0, name.length() - 1), path);
                parent.entries().update((Object)name, (Object)dir);
                dirs.update((Object)path, (Object)dir);
                dirEntry = dir;
            }
            return dirEntry;
        }
        throw new MatchError(temp1.toString());
    }

    private void load() {
        this.root_$eq(new DirEntry(this, this, "<root>", "/"));
        HashMap dirs = new HashMap();
        dirs.update((Object)"/", (Object)this.root());
        Enumeration<? extends ZipEntry> entries = this.archive().entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            String path$1 = entry.getName();
            Predef$.MODULE$.assert(entry.isDirectory() == path$1.endsWith("/"), (Function0)new $anonfun$load$1(this, path$1));
            if (entry.isDirectory()) {
                DirEntry dir = this.getDir((Map<String, DirEntry>)dirs, path$1);
                if (dir.entry() != null) continue;
                dir.entry_$eq(entry);
                continue;
            }
            int index = path$1.lastIndexOf(47);
            String name = index < 0 ? path$1 : path$1.substring(index + 1);
            String home = index < 0 ? "/" : path$1.substring(0, index + 1);
            DirEntry parent = this.getDir((Map<String, DirEntry>)dirs, home);
            parent.entries().update((Object)name, (Object)new FileEntry(this, parent, name, path$1, entry));
        }
    }

    @Override
    public AbstractFile lookupNameUnchecked(String name, boolean directory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public AbstractFile lookupName(String name, boolean directory) {
        if (this.root() == null) {
            this.load();
        }
        return this.root().lookupName(name, directory);
    }

    @Override
    public Iterator<AbstractFile> iterator() {
        if (this.root() == null) {
            this.load();
        }
        return this.root().iterator();
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    private void root_$eq(DirEntry dirEntry) {
        this.root = dirEntry;
    }

    private DirEntry root() {
        return this.root;
    }

    public ZipFile archive() {
        return this.archive;
    }

    public abstract class Entry
    extends VirtualFile
    implements ScalaObject {
        public final /* synthetic */ ZipArchive $outer;
        private final AbstractFile container;

        public Entry(ZipArchive $outer, AbstractFile container, String name, String path) {
            this.container = container;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(name, path);
        }

        public /* synthetic */ ZipArchive scala$tools$nsc$io$ZipArchive$Entry$$$outer() {
            return this.$outer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object that) {
            if (!super.equals(that)) return false;
            Object temp5 = that;
            if (!(temp5 instanceof Entry)) return false;
            if (((Entry)temp5).scala$tools$nsc$io$ZipArchive$Entry$$$outer() != this.scala$tools$nsc$io$ZipArchive$Entry$$$outer()) return false;
            Entry temp6 = (Entry)temp5;
            AbstractFile abstractFile = this.container();
            AbstractFile abstractFile2 = temp6.container();
            if (abstractFile != null) {
                if (!abstractFile.equals(abstractFile2)) return false;
                return true;
            }
            if (abstractFile2 == null) return true;
            return false;
        }

        public int hashCode() {
            return super.hashCode() + this.container().hashCode();
        }

        public String pathInArchive() {
            return super.path();
        }

        public final ZipFile getArchive() {
            return this.scala$tools$nsc$io$ZipArchive$Entry$$$outer().archive();
        }

        public final String path() {
            return new StringBuilder().append((Object)this.scala$tools$nsc$io$ZipArchive$Entry$$$outer().toString()).append((Object)"(").append((Object)this.pathInArchive()).append((Object)")").toString();
        }

        public AbstractFile container() {
            return this.container;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class DirEntry
    extends Entry
    implements ScalaObject {
        private ZipEntry entry;
        private final Map<String, Entry> entries = new HashMap();

        public DirEntry(ZipArchive $outer, AbstractFile container, String name, String path) {
            super($outer, container, name, path);
        }

        @Override
        public AbstractFile lookupName(String name, boolean directory) {
            Option temp7;
            block4: {
                Entry entry;
                block3: {
                    block2: {
                        Entry temp9;
                        temp7 = this.entries().get((Object)(directory ? new StringBuilder().append((Object)name).append((Object)"/").toString() : name));
                        if (!(temp7 instanceof Some)) break block2;
                        Some temp8 = (Some)temp7;
                        entry = temp9 = (Entry)temp8.x();
                        break block3;
                    }
                    None$ none$ = None$.MODULE$;
                    Option option = temp7;
                    if ((none$ != null ? !none$.equals(option) : option != null) || !(temp7 instanceof None$)) break block4;
                    entry = null;
                }
                return entry;
            }
            throw new MatchError(temp7.toString());
        }

        @Override
        public Iterator<AbstractFile> iterator() {
            return this.entries().valuesIterator();
        }

        @Override
        public long lastModified() {
            return this.entry() != null ? this.entry().getTime() : super.lastModified();
        }

        public Nothing$ input() {
            throw new Error("cannot read directories");
        }

        @Override
        public boolean isDirectory() {
            return true;
        }

        public void entry_$eq(ZipEntry zipEntry) {
            this.entry = zipEntry;
        }

        public ZipEntry entry() {
            return this.entry;
        }

        public Map<String, Entry> entries() {
            return this.entries;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class FileEntry
    extends Entry
    implements ScalaObject {
        private final ZipEntry entry;

        public FileEntry(ZipArchive $outer, AbstractFile container, String name, String path, ZipEntry entry) {
            this.entry = entry;
            super($outer, container, name, path);
        }

        public /* synthetic */ ZipArchive scala$tools$nsc$io$ZipArchive$FileEntry$$$outer() {
            return this.$outer;
        }

        public Some<Integer> sizeOption() {
            return new Some((Object)BoxesRunTime.boxToInteger((int)((int)this.entry().getSize())));
        }

        @Override
        public InputStream input() {
            return this.archive().getInputStream(this.entry());
        }

        @Override
        public long lastModified() {
            return this.entry().getTime();
        }

        public ZipFile archive() {
            return this.scala$tools$nsc$io$ZipArchive$FileEntry$$$outer().archive();
        }

        public ZipEntry entry() {
            return this.entry;
        }
    }
}

