/*
 * Decompiled with CFR 0.152.
 */
package scala.tools.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import scala.ScalaObject;
import scala.collection.mutable.StringBuilder;

public class SocketConnection
implements ScalaObject {
    private String errorMessage;
    private BufferedReader in;
    private PrintWriter out;
    private Socket socket;
    private final int port;
    private final String hostname;

    public SocketConnection(String hostname, int port) {
        this.hostname = hostname;
        this.port = port;
    }

    public void close() {
        this.in().close();
        this.out().close();
        this.socket().close();
    }

    /*
     * WARNING - void declaration
     */
    public boolean open() {
        void var1_1;
        boolean exceptionResult1 = false;
        try {
            this.socket_$eq(new Socket(this.hostname, this.port));
            this.out_$eq(new PrintWriter(this.socket().getOutputStream(), true));
            this.in_$eq(new BufferedReader(new InputStreamReader(this.socket().getInputStream())));
            exceptionResult1 = true;
        }
        catch (IOException iOException) {
            this.errorMessage_$eq(new StringBuilder().append((Object)"Couldn't get I/O for the connection to: ").append((Object)this.hostname).append((Object)".").toString());
            exceptionResult1 = false;
        }
        catch (UnknownHostException unknownHostException) {
            this.errorMessage_$eq(new StringBuilder().append((Object)"Don't know about host: ").append((Object)this.hostname).append((Object)".").toString());
            exceptionResult1 = false;
        }
        return (boolean)var1_1;
    }

    public void errorMessage_$eq(String string) {
        this.errorMessage = string;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public void in_$eq(BufferedReader bufferedReader) {
        this.in = bufferedReader;
    }

    public BufferedReader in() {
        return this.in;
    }

    public void out_$eq(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public PrintWriter out() {
        return this.out;
    }

    private void socket_$eq(Socket socket) {
        this.socket = socket;
    }

    private Socket socket() {
        return this.socket;
    }

    public SocketConnection(int port) {
        this(InetAddress.getLocalHost().getHostName(), port);
    }
}

