/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent;

import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u000f\t91+\u001f8d-\u0006\u0014(BA\u0002\u0005\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0002\u000b\u0005)1oY1mC\u000e\u0001QC\u0001\u0005\u0019'\t\u0001\u0011\u0002\u0005\u0002\u000b\u001f5\t1B\u0003\u0002\r\u001b\u0005!A.\u00198h\u0015\u0005q\u0011\u0001\u00026bm\u0006L!\u0001E\u0006\u0003\r=\u0013'.Z2u\u0011\u0015\u0011\u0002\u0001\"\u0001\u0014\u0003\u0019a\u0014N\\5u}Q\tA\u0003E\u0002\u0016\u0001Yi\u0011A\u0001\t\u0003/aa\u0001\u0001B\u0003\u001a\u0001\t\u0007!DA\u0001B#\tYr\u0004\u0005\u0002\u001d;5\tA!\u0003\u0002\u001f\t\t9aj\u001c;iS:<\u0007C\u0001\u000f!\u0013\t\tCAA\u0002B]fDqa\t\u0001A\u0002\u0013%A%A\u0005jg\u0012+g-\u001b8fIV\tQ\u0005\u0005\u0002\u001dM%\u0011q\u0005\u0002\u0002\b\u0005>|G.Z1o\u0011\u001dI\u0003\u00011A\u0005\n)\nQ\"[:EK\u001aLg.\u001a3`I\u0015\fHCA\u0016/!\taB&\u0003\u0002.\t\t!QK\\5u\u0011\u001dy\u0003&!AA\u0002\u0015\n1\u0001\u001f\u00132\u0011\u0019\t\u0004\u0001)Q\u0005K\u0005Q\u0011n\u001d#fM&tW\r\u001a\u0011\t\u000fM\u0002\u0001\u0019!C\u0005i\u0005)a/\u00197vKV\tQ\u0007E\u0002\u001dmYI!a\u000e\u0003\u0003\r=\u0003H/[8o\u0011\u001dI\u0004\u00011A\u0005\ni\n\u0011B^1mk\u0016|F%Z9\u0015\u0005-Z\u0004bB\u00189\u0003\u0003\u0005\r!\u000e\u0005\u0007{\u0001\u0001\u000b\u0015B\u001b\u0002\rY\fG.^3!\u0011\u0015y\u0004\u0001\"\u0001A\u0003\r9W\r^\u000b\u0002-!)!\t\u0001C\u0005\u0007\u0006!r/Y5u\u001b\u0016\f7/\u001e:j]\u001e,E.\u00199tK\u0012$\"\u0001R$\u0011\u0005q)\u0015B\u0001$\u0005\u0005\u0011auN\\4\t\u000b!\u000b\u0005\u0019\u0001#\u0002\u000fQLW.Z8vi\")q\b\u0001C\u0001\u0015R\u0011Qg\u0013\u0005\u0006\u0011&\u0003\r\u0001\u0012\u0005\u0006\u001b\u0002!\tAT\u0001\u0005i\u0006\\W\rF\u0001\u0017\u0011\u0015i\u0005\u0001\"\u0001Q)\t1\u0012\u000bC\u0003I\u001f\u0002\u0007A\tC\u0003T\u0001\u0011\u0005A+A\u0002tKR$\"aK+\t\u000bY\u0013\u0006\u0019\u0001\f\u0002\u0003aDCA\u0015-\\;B\u0011A$W\u0005\u00035\u0012\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005a\u0016\u0001O+tK\u0002\u0002\u0007/\u001e;aA%t7\u000f^3bI2\u0002\u0013m\u001d\u0011ag\u0016$\b\rI5tAA|G/\u001a8uS>t\u0017\r\u001c7zA\u0015\u0014(o\u001c:.aJ|g.Z\u0011\u0002=\u00061!GL\u00191]ABQ\u0001\u0019\u0001\u0005\u0002\u0005\f1\u0001];u)\tY#\rC\u0003W?\u0002\u0007a\u0003C\u0003e\u0001\u0011\u0005A%A\u0003jgN+G\u000fC\u0003g\u0001\u0011\u0005q-A\u0003v]N,G\u000fF\u0001,Q\u0011)\u0007,[/\"\u0003)\f1(V:fA\u0001$\u0018m[3aA%t7\u000f^3bI2\u0002\u0013m\u001d\u0011ak:\u001cX\r\u001e1!SN\u0004\u0003o\u001c;f]RLwN\\1mYf\u0004SM\u001d:pe6\u0002(o\u001c8f\u0011\u0015a\u0007\u0001\"\u0003n\u0003\u0019\u0019X\r\u001e,bYR\u00111F\u001c\u0005\u0006-.\u0004\rA\u0006\u0005\u0006a\u0002!IaZ\u0001\tk:\u001cX\r\u001e,bY\u0002")
public class SyncVar<A> {
    private boolean isDefined = false;
    private Option<A> value = None$.MODULE$;

    private boolean isDefined() {
        return this.isDefined;
    }

    private void isDefined_$eq(boolean bl) {
        this.isDefined = bl;
    }

    private Option<A> value() {
        return this.value;
    }

    private void value_$eq(Option<A> option) {
        this.value = option;
    }

    public synchronized A get() {
        while (!this.isDefined()) {
            this.wait();
        }
        return this.value().get();
    }

    private long waitMeasuringElapsed(long timeout) {
        long l;
        if (timeout <= 0L) {
            l = 0L;
        } else {
            long start = System.currentTimeMillis();
            this.wait(timeout);
            long elapsed = System.currentTimeMillis() - start;
            l = elapsed < 0L ? 0L : elapsed;
        }
        return l;
    }

    public synchronized Option<A> get(long timeout) {
        long elapsed;
        for (long rest = timeout; !this.isDefined() && rest > 0L; rest -= elapsed) {
            elapsed = this.waitMeasuringElapsed(rest);
        }
        return this.value();
    }

    public synchronized A take() {
        try {
            return this.get();
        }
        finally {
            this.unsetVal();
        }
    }

    public synchronized A take(long timeout) {
        try {
            return this.get(timeout).get();
        }
        finally {
            this.unsetVal();
        }
    }

    public void set(A x) {
        this.setVal(x);
    }

    public synchronized void put(A x) {
        while (this.isDefined()) {
            this.wait();
        }
        this.setVal(x);
    }

    public synchronized boolean isSet() {
        return this.isDefined();
    }

    public synchronized void unset() {
        this.isDefined_$eq(false);
        this.value_$eq(None$.MODULE$);
        this.notifyAll();
    }

    private synchronized void setVal(A x) {
        this.isDefined_$eq(true);
        this.value_$eq(new Some<A>(x));
        this.notifyAll();
    }

    private synchronized void unsetVal() {
        this.isDefined_$eq(false);
        this.value_$eq(None$.MODULE$);
        this.notifyAll();
    }
}

