/*
 * Decompiled with CFR 0.152.
 */
package scala.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.io.BufferedSource;
import scala.io.Codec;
import scala.io.Codec$;
import scala.io.Source;
import scala.runtime.BoxedUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Source$ {
    public static final Source$ MODULE$;
    private final int DefaultBufSize;

    static {
        new Source$();
    }

    public int DefaultBufSize() {
        return this.DefaultBufSize;
    }

    public BufferedSource stdin() {
        return this.fromInputStream(System.in, Codec$.MODULE$.fallbackSystemCodec());
    }

    public Source fromIterable(Iterable<Object> iterable$1) {
        return new Source(iterable$1){
            private final Iterator<Object> iter;

            public Iterator<Object> iter() {
                return this.iter;
            }
            {
                this.iter = iterable$1.iterator();
            }
        }.withReset((Function0<Source>)((Object)new Serializable(iterable$1){
            public static final long serialVersionUID = 0L;
            private final Iterable iterable$1;

            public final Source apply() {
                return Source$.MODULE$.fromIterable(this.iterable$1);
            }
            {
                this.iterable$1 = iterable$1;
            }
        }));
    }

    public Source fromChar(char c) {
        return this.fromIterable(Predef$.MODULE$.wrapCharArray(Array$.MODULE$.apply(c, (Seq<Object>)Predef$.MODULE$.wrapCharArray(new char[0]))));
    }

    public Source fromChars(char[] chars) {
        return this.fromIterable(Predef$.MODULE$.wrapCharArray(chars));
    }

    public Source fromString(String s) {
        return this.fromIterable(Predef$.MODULE$.wrapString(s));
    }

    public BufferedSource fromFile(String name, Codec codec) {
        return this.fromFile(new File(name), codec);
    }

    public BufferedSource fromFile(String name, String enc) {
        return this.fromFile(name, Codec$.MODULE$.apply(enc));
    }

    public BufferedSource fromFile(URI uri, Codec codec) {
        return this.fromFile(new File(uri), codec);
    }

    public BufferedSource fromFile(URI uri, String enc) {
        return this.fromFile(uri, Codec$.MODULE$.apply(enc));
    }

    public BufferedSource fromFile(File file, Codec codec) {
        return this.fromFile(file, this.DefaultBufSize(), codec);
    }

    public BufferedSource fromFile(File file, String enc) {
        return this.fromFile(file, Codec$.MODULE$.apply(enc));
    }

    public BufferedSource fromFile(File file, String enc, int bufferSize) {
        return this.fromFile(file, bufferSize, Codec$.MODULE$.apply(enc));
    }

    public BufferedSource fromFile(File file$1, int bufferSize$1, Codec codec$2) {
        FileInputStream inputStream$1 = new FileInputStream(file$1);
        return (BufferedSource)this.createBufferedSource(inputStream$1, bufferSize$1, (Function0<Source>)((Object)new Serializable(file$1, bufferSize$1, codec$2){
            public static final long serialVersionUID = 0L;
            private final File file$1;
            private final int bufferSize$1;
            private final Codec codec$2;

            public final BufferedSource apply() {
                return Source$.MODULE$.fromFile(this.file$1, this.bufferSize$1, this.codec$2);
            }
            {
                this.file$1 = file$1;
                this.bufferSize$1 = bufferSize$1;
                this.codec$2 = codec$2;
            }
        }), (Function0<BoxedUnit>)((Object)new Serializable(inputStream$1){
            public static final long serialVersionUID = 0L;
            private final FileInputStream inputStream$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.inputStream$1.close();
            }
            {
                this.inputStream$1 = inputStream$1;
            }
        }), codec$2).withDescription(new StringBuilder().append((Object)"file:").append((Object)file$1.getAbsolutePath()).toString());
    }

    public Source fromBytes(byte[] bytes, Codec codec) {
        return this.fromString(new String(bytes, codec.name()));
    }

    public Source fromBytes(byte[] bytes, String enc) {
        return this.fromBytes(bytes, Codec$.MODULE$.apply(enc));
    }

    public Source fromRawBytes(byte[] bytes) {
        return this.fromString(new String(bytes, Codec$.MODULE$.ISO8859().name()));
    }

    public BufferedSource fromURI(URI uri, Codec codec) {
        return this.fromFile(new File(uri), codec);
    }

    public BufferedSource fromURL(String s, String enc) {
        return this.fromURL(s, Codec$.MODULE$.apply(enc));
    }

    public BufferedSource fromURL(String s, Codec codec) {
        return this.fromURL(new URL(s), codec);
    }

    public BufferedSource fromURL(URL url, String enc) {
        return this.fromURL(url, Codec$.MODULE$.apply(enc));
    }

    public BufferedSource fromURL(URL url, Codec codec) {
        return this.fromInputStream(url.openStream(), codec);
    }

    public BufferedSource createBufferedSource(InputStream inputStream$2, int bufferSize$2, Function0<Source> reset$1, Function0<BoxedUnit> close$1, Codec codec$3) {
        Serializable resetFn = reset$1 == null ? new Serializable(inputStream$2, bufferSize$2, (Function0)((Object)reset$1), close$1, codec$3){
            public static final long serialVersionUID = 0L;
            private final InputStream inputStream$2;
            private final int bufferSize$2;
            private final Function0 reset$1;
            private final Function0 close$1;
            private final Codec codec$3;

            public final BufferedSource apply() {
                return Source$.MODULE$.createBufferedSource(this.inputStream$2, this.bufferSize$2, this.reset$1, this.close$1, this.codec$3);
            }
            {
                this.inputStream$2 = inputStream$2;
                this.bufferSize$2 = bufferSize$2;
                this.reset$1 = reset$1;
                this.close$1 = close$1;
                this.codec$3 = codec$3;
            }
        } : reset$1;
        return (BufferedSource)new BufferedSource(inputStream$2, bufferSize$2, codec$3).withReset((Function0<Source>)((Object)resetFn)).withClose(close$1);
    }

    public int createBufferedSource$default$2() {
        return this.DefaultBufSize();
    }

    public Function0 createBufferedSource$default$3() {
        return null;
    }

    public Function0 createBufferedSource$default$4() {
        return null;
    }

    public BufferedSource fromInputStream(InputStream is, String enc) {
        return this.fromInputStream(is, Codec$.MODULE$.apply(enc));
    }

    public BufferedSource fromInputStream(InputStream is$1, Codec codec$1) {
        InputStream x$1 = is$1;
        Serializable x$2 = new Serializable(is$1, codec$1){
            public static final long serialVersionUID = 0L;
            private final InputStream is$1;
            private final Codec codec$1;

            public final BufferedSource apply() {
                return Source$.MODULE$.fromInputStream(this.is$1, this.codec$1);
            }
            {
                this.is$1 = is$1;
                this.codec$1 = codec$1;
            }
        };
        Serializable x$3 = new Serializable(is$1){
            public static final long serialVersionUID = 0L;
            private final InputStream is$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.is$1.close();
            }
            {
                this.is$1 = is$1;
            }
        };
        int x$4 = this.createBufferedSource$default$2();
        Codec x$5 = codec$1;
        return this.createBufferedSource(x$1, x$4, (Function0<Source>)((Object)x$2), (Function0<BoxedUnit>)((Object)x$3), x$5);
    }

    private Source$() {
        MODULE$ = this;
        this.DefaultBufSize = 2048;
    }
}

