/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.impl;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.forkjoin.ForkJoinPool;
import scala.concurrent.forkjoin.ForkJoinTask;
import scala.concurrent.forkjoin.ForkJoinWorkerThread;
import scala.concurrent.impl.ExecutionContextImpl;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichDouble$;
import scala.util.control.NonFatal$;

public final class ExecutionContextImpl$ {
    public static final ExecutionContextImpl$ MODULE$;

    static {
        new ExecutionContextImpl$();
    }

    /*
     * WARNING - void declaration
     */
    public ExecutorService createDefaultExecutorService(Function1<Throwable, BoxedUnit> reporter) {
        ForkJoinPool forkJoinPool;
        int numThreads = this.getInt$1("scala.concurrent.context.numThreads", "x1");
        int maxNoOfThreads = this.getInt$1("scala.concurrent.context.maxThreads", "x1");
        int desiredParallelism = this.range$1(this.getInt$1("scala.concurrent.context.minThreads", "1"), numThreads, maxNoOfThreads);
        int maxExtraThreads = this.getInt$1("scala.concurrent.context.maxExtraThreads", "256");
        Thread.UncaughtExceptionHandler uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(reporter){
            private final Function1 reporter$3;

            public void uncaughtException(Thread thread, Throwable cause) {
                this.reporter$3.apply(cause);
            }
            {
                this.reporter$3 = reporter$3;
            }
        };
        ExecutionContextImpl.DefaultThreadFactory threadFactory = new ExecutionContextImpl.DefaultThreadFactory(true, maxNoOfThreads + maxExtraThreads, "scala-execution-context-global", uncaughtExceptionHandler);
        try {
            forkJoinPool = new ForkJoinPool(desiredParallelism, uncaughtExceptionHandler, threadFactory){

                public void execute(Runnable runnable) {
                    ForkJoinWorkerThread forkJoinWorkerThread;
                    ForkJoinTask<V> forkJoinTask;
                    ForkJoinTask<V> forkJoinTask2 = runnable instanceof ForkJoinTask ? (forkJoinTask = (ForkJoinTask<V>)((Object)runnable)) : new ExecutionContextImpl.AdaptedForkJoinTask(runnable);
                    Thread thread = Thread.currentThread();
                    if (thread instanceof ForkJoinWorkerThread && (forkJoinWorkerThread = (ForkJoinWorkerThread)thread).getPool() == this) {
                        forkJoinTask2.fork();
                    } else {
                        super.execute(forkJoinTask2);
                    }
                }
            };
        }
        catch (Throwable throwable) {
            void var10_10;
            Option<Throwable> option = NonFatal$.MODULE$.unapply(throwable);
            if (option.isEmpty()) {
                throw throwable;
            }
            System.err.println("Failed to create ForkJoinPool for the default ExecutionContext, falling back to ThreadPoolExecutor");
            option.get().printStackTrace(System.err);
            ThreadPoolExecutor exec2 = new ThreadPoolExecutor(desiredParallelism, desiredParallelism, 5L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(), threadFactory);
            exec2.allowCoreThreadTimeOut(true);
            forkJoinPool = var10_10;
        }
        return forkJoinPool;
    }

    public ExecutionContextImpl fromExecutor(Executor e, Function1<Throwable, BoxedUnit> reporter) {
        Option<Executor> option = Option$.MODULE$.apply(e);
        return new ExecutionContextImpl(option.isEmpty() ? MODULE$.createDefaultExecutorService(reporter) : option.get(), reporter);
    }

    public Function1<Throwable, BoxedUnit> fromExecutor$default$2() {
        return ExecutionContext$.MODULE$.defaultReporter();
    }

    public ExecutionContextImpl fromExecutorService(ExecutorService es, Function1<Throwable, BoxedUnit> reporter) {
        return new ExecutionContextExecutorService(es, reporter){

            private final ExecutorService asExecutorService() {
                return (ExecutorService)this.executor();
            }

            public void execute(Runnable command) {
                this.executor().execute(command);
            }

            public void shutdown() {
                this.asExecutorService().shutdown();
            }

            public List<Runnable> shutdownNow() {
                return this.asExecutorService().shutdownNow();
            }

            public boolean isShutdown() {
                return this.asExecutorService().isShutdown();
            }

            public boolean isTerminated() {
                return this.asExecutorService().isTerminated();
            }

            public boolean awaitTermination(long l, TimeUnit timeUnit) {
                return this.asExecutorService().awaitTermination(l, timeUnit);
            }

            public <T> Future<T> submit(Callable<T> callable) {
                return this.asExecutorService().submit(callable);
            }

            public <T> Future<T> submit(Runnable runnable, T t) {
                return this.asExecutorService().submit(runnable, t);
            }

            public Future<?> submit(Runnable runnable) {
                return this.asExecutorService().submit(runnable);
            }

            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) {
                return this.asExecutorService().invokeAll(callables);
            }

            public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) {
                return this.asExecutorService().invokeAll(callables, l, timeUnit);
            }

            public <T> T invokeAny(Collection<? extends Callable<T>> callables) {
                return this.asExecutorService().invokeAny(callables);
            }

            public <T> T invokeAny(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) {
                return this.asExecutorService().invokeAny(callables, l, timeUnit);
            }
            {
                Option<ExecutorService> option = Option$.MODULE$.apply(es$1);
                super(option.isEmpty() ? ExecutionContextImpl$.MODULE$.createDefaultExecutorService(reporter$2) : option.get(), reporter$2);
            }
        };
    }

    public Function1<Throwable, BoxedUnit> fromExecutorService$default$2() {
        return ExecutionContext$.MODULE$.defaultReporter();
    }

    private final int getInt$1(String name, String string2) {
        int n;
        String string3;
        String string4;
        try {
            string4 = System.getProperty(name, string2);
        }
        catch (SecurityException securityException) {
            string4 = string3 = string2;
        }
        if (string3.charAt(0) == 'x') {
            String string5 = string3.substring(1);
            Predef$ predef$ = Predef$.MODULE$;
            double d = (double)Runtime.getRuntime().availableProcessors() * new StringOps(string5).toDouble();
            Predef$ predef$2 = Predef$.MODULE$;
            n = (int)RichDouble$.MODULE$.ceil$extension(d);
        } else {
            Predef$ predef$ = Predef$.MODULE$;
            n = new StringOps(string3).toInt();
        }
        return n;
    }

    private final int range$1(int floor, int desired, int ceiling) {
        return package$.MODULE$.min(package$.MODULE$.max(floor, desired), ceiling);
    }

    private ExecutionContextImpl$() {
        MODULE$ = this;
    }
}

