/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Numeric$BigDecimalAsIfIntegral$;
import scala.math.Numeric$BigIntIsIntegral$;
import scala.math.Numeric$ByteIsIntegral$;
import scala.math.Numeric$CharIsIntegral$;
import scala.math.Numeric$DoubleAsIfIntegral$;
import scala.math.Numeric$FloatAsIfIntegral$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Numeric$ShortIsIntegral$;
import scala.math.Ordering;
import scala.math.Ordering$BigDecimal$;
import scala.math.Ordering$BigInt$;
import scala.math.Ordering$Byte$;
import scala.math.Ordering$Char$;
import scala.math.Ordering$Double$;
import scala.math.Ordering$Float$;
import scala.math.Ordering$Int$;
import scala.math.Ordering$Long$;
import scala.math.Ordering$Short$;
import scala.runtime.BoxesRunTime;

public final class NumericRange$
implements Serializable {
    public static final NumericRange$ MODULE$;
    private final Map<Numeric<?>, Ordering<?>> defaultOrdering;

    static {
        new NumericRange$();
    }

    public <T> int count(T start, T end, T step, boolean isInclusive, Integral<T> num) {
        Object object;
        int endside;
        int stepint;
        int endint;
        Object zero = num.zero();
        boolean upward = num.lt(start, end);
        boolean posStep = num.gt(step, zero);
        if (BoxesRunTime.equals(step, zero)) {
            throw new IllegalArgumentException("step cannot be 0.");
        }
        if (BoxesRunTime.equals(start, end)) {
            if (isInclusive) {
                return 1;
            }
            return 0;
        }
        if (upward != posStep) {
            return 0;
        }
        int startint = num.toInt(start);
        if (BoxesRunTime.equals(start, num.fromInt(startint)) && BoxesRunTime.equals(end, num.fromInt(endint = num.toInt(end))) && BoxesRunTime.equals(step, num.fromInt(stepint = num.toInt(step)))) {
            if (isInclusive) {
                return Range$.MODULE$.inclusive(startint, endint, stepint).length();
            }
            return Range$.MODULE$.apply(startint, endint, stepint).length();
        }
        Object one = num.one();
        Object limit = num.fromInt(Integer.MAX_VALUE);
        int startside = num.signum(start);
        if (startside * (endside = num.signum(end)) >= 0) {
            T diff = num.minus(end, start);
            Object quotient = this.check$1(num.quot(diff, step), num, limit);
            Object remainder = num.minus(diff, num.times(quotient, step));
            object = !isInclusive && BoxesRunTime.equals(zero, remainder) ? quotient : this.check$1(num.plus(quotient, one), num, limit);
        } else {
            Object object2;
            Object negone = num.fromInt(-1);
            Object startlim = posStep ? negone : one;
            Object startdiff = num.minus(startlim, start);
            Object startq = this.check$1(num.quot(startdiff, step), num, limit);
            Object waypointA = BoxesRunTime.equals(startq, zero) ? start : num.plus(start, num.times(startq, step));
            T waypointB = num.plus(waypointA, step);
            if (num.lt(waypointB, end) != upward) {
                object2 = isInclusive && BoxesRunTime.equals(waypointB, end) ? num.plus(startq, num.fromInt(2)) : num.plus(startq, one);
            } else {
                T enddiff = num.minus(end, waypointB);
                Object endq = this.check$1(num.quot(enddiff, step), num, limit);
                T last = BoxesRunTime.equals(endq, zero) ? waypointB : num.plus(waypointB, num.times(endq, step));
                object2 = num.plus(startq, num.plus(endq, !isInclusive && BoxesRunTime.equals(last, end) ? one : num.fromInt(2)));
            }
            object = this.check$1(object2, num, limit);
        }
        return num.toInt(object);
    }

    public <T> NumericRange.Exclusive<T> apply(T start, T end, T step, Integral<T> num) {
        return new NumericRange.Exclusive<T>(start, end, step, num);
    }

    public <T> NumericRange.Inclusive<T> inclusive(T start, T end, T step, Integral<T> num) {
        return new NumericRange.Inclusive<T>(start, end, step, num);
    }

    public Map<Numeric<?>, Ordering<?>> defaultOrdering() {
        return this.defaultOrdering;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private final Object check$1(Object t, Integral num$1, Object limit$1) {
        if (num$1.gt(t, limit$1)) {
            throw new IllegalArgumentException("More than Int.MaxValue elements.");
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    private NumericRange$() {
        Tuple2<Numeric$BigDecimalAsIfIntegral$, Ordering$BigDecimal$> tuple2;
        Tuple2<Numeric$DoubleAsIfIntegral$, Ordering$Double$> tuple22;
        Tuple2<Numeric$FloatAsIfIntegral$, Ordering$Float$> tuple23;
        Tuple2<Numeric$LongIsIntegral$, Ordering$Long$> tuple24;
        Tuple2<Numeric$CharIsIntegral$, Ordering$Char$> tuple25;
        Tuple2<Numeric$ByteIsIntegral$, Ordering$Byte$> tuple26;
        Tuple2<Numeric$ShortIsIntegral$, Ordering$Short$> tuple27;
        Tuple2<Numeric$IntIsIntegral$, Ordering$Int$> tuple28;
        void $minus$greater$extension_y;
        Tuple2<void, Ordering$BigInt$> tuple29;
        MODULE$ = this;
        Tuple2[] tuple2Array = new Tuple2[9];
        Predef$ArrowAssoc$ predef$ArrowAssoc$ = Predef$ArrowAssoc$.MODULE$;
        Ordering$BigInt$ ordering$BigInt$ = Ordering$BigInt$.MODULE$;
        Numeric$BigIntIsIntegral$ numeric$BigIntIsIntegral$ = Predef$.MODULE$.ArrowAssoc(Numeric$BigIntIsIntegral$.MODULE$);
        if (predef$ArrowAssoc$ == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$2 = predef$ArrowAssoc$;
        tuple2Array[0] = tuple29 = new Tuple2<void, Ordering$BigInt$>($minus$greater$extension_y, ordering$BigInt$);
        Predef$ArrowAssoc$ predef$ArrowAssoc$3 = Predef$ArrowAssoc$.MODULE$;
        Ordering$Int$ ordering$Int$ = Ordering$Int$.MODULE$;
        Numeric$IntIsIntegral$ numeric$IntIsIntegral$ = Predef$.MODULE$.ArrowAssoc(Numeric$IntIsIntegral$.MODULE$);
        if (predef$ArrowAssoc$3 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$4 = predef$ArrowAssoc$3;
        tuple2Array[1] = tuple28 = new Tuple2<Numeric$IntIsIntegral$, Ordering$Int$>(numeric$IntIsIntegral$, ordering$Int$);
        Predef$ArrowAssoc$ predef$ArrowAssoc$5 = Predef$ArrowAssoc$.MODULE$;
        Ordering$Short$ ordering$Short$ = Ordering$Short$.MODULE$;
        Numeric$ShortIsIntegral$ numeric$ShortIsIntegral$ = Predef$.MODULE$.ArrowAssoc(Numeric$ShortIsIntegral$.MODULE$);
        if (predef$ArrowAssoc$5 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$6 = predef$ArrowAssoc$5;
        tuple2Array[2] = tuple27 = new Tuple2<Numeric$ShortIsIntegral$, Ordering$Short$>(numeric$ShortIsIntegral$, ordering$Short$);
        Predef$ArrowAssoc$ predef$ArrowAssoc$7 = Predef$ArrowAssoc$.MODULE$;
        Ordering$Byte$ ordering$Byte$ = Ordering$Byte$.MODULE$;
        Numeric$ByteIsIntegral$ numeric$ByteIsIntegral$ = Predef$.MODULE$.ArrowAssoc(Numeric$ByteIsIntegral$.MODULE$);
        if (predef$ArrowAssoc$7 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$8 = predef$ArrowAssoc$7;
        tuple2Array[3] = tuple26 = new Tuple2<Numeric$ByteIsIntegral$, Ordering$Byte$>(numeric$ByteIsIntegral$, ordering$Byte$);
        Predef$ArrowAssoc$ predef$ArrowAssoc$9 = Predef$ArrowAssoc$.MODULE$;
        Ordering$Char$ ordering$Char$ = Ordering$Char$.MODULE$;
        Numeric$CharIsIntegral$ numeric$CharIsIntegral$ = Predef$.MODULE$.ArrowAssoc(Numeric$CharIsIntegral$.MODULE$);
        if (predef$ArrowAssoc$9 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$10 = predef$ArrowAssoc$9;
        tuple2Array[4] = tuple25 = new Tuple2<Numeric$CharIsIntegral$, Ordering$Char$>(numeric$CharIsIntegral$, ordering$Char$);
        Predef$ArrowAssoc$ predef$ArrowAssoc$11 = Predef$ArrowAssoc$.MODULE$;
        Ordering$Long$ ordering$Long$ = Ordering$Long$.MODULE$;
        Numeric$LongIsIntegral$ numeric$LongIsIntegral$ = Predef$.MODULE$.ArrowAssoc(Numeric$LongIsIntegral$.MODULE$);
        if (predef$ArrowAssoc$11 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$12 = predef$ArrowAssoc$11;
        tuple2Array[5] = tuple24 = new Tuple2<Numeric$LongIsIntegral$, Ordering$Long$>(numeric$LongIsIntegral$, ordering$Long$);
        Predef$ArrowAssoc$ predef$ArrowAssoc$13 = Predef$ArrowAssoc$.MODULE$;
        Ordering$Float$ ordering$Float$ = Ordering$Float$.MODULE$;
        Numeric$FloatAsIfIntegral$ numeric$FloatAsIfIntegral$ = Predef$.MODULE$.ArrowAssoc(Numeric$FloatAsIfIntegral$.MODULE$);
        if (predef$ArrowAssoc$13 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$14 = predef$ArrowAssoc$13;
        tuple2Array[6] = tuple23 = new Tuple2<Numeric$FloatAsIfIntegral$, Ordering$Float$>(numeric$FloatAsIfIntegral$, ordering$Float$);
        Predef$ArrowAssoc$ predef$ArrowAssoc$15 = Predef$ArrowAssoc$.MODULE$;
        Ordering$Double$ ordering$Double$ = Ordering$Double$.MODULE$;
        Numeric$DoubleAsIfIntegral$ numeric$DoubleAsIfIntegral$ = Predef$.MODULE$.ArrowAssoc(Numeric$DoubleAsIfIntegral$.MODULE$);
        if (predef$ArrowAssoc$15 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$16 = predef$ArrowAssoc$15;
        tuple2Array[7] = tuple22 = new Tuple2<Numeric$DoubleAsIfIntegral$, Ordering$Double$>(numeric$DoubleAsIfIntegral$, ordering$Double$);
        Predef$ArrowAssoc$ predef$ArrowAssoc$17 = Predef$ArrowAssoc$.MODULE$;
        Ordering$BigDecimal$ ordering$BigDecimal$ = Ordering$BigDecimal$.MODULE$;
        Numeric$BigDecimalAsIfIntegral$ numeric$BigDecimalAsIfIntegral$ = Predef$.MODULE$.ArrowAssoc(Numeric$BigDecimalAsIfIntegral$.MODULE$);
        if (predef$ArrowAssoc$17 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$18 = predef$ArrowAssoc$17;
        tuple2Array[8] = tuple2 = new Tuple2<Numeric$BigDecimalAsIfIntegral$, Ordering$BigDecimal$>(numeric$BigDecimalAsIfIntegral$, ordering$BigDecimal$);
        this.defaultOrdering = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }
}

