/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Map;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.FlatHashTable;
import scala.collection.mutable.FlatHashTable$;
import scala.collection.mutable.FlatHashTable$HashUtils$class;
import scala.collection.mutable.HashTable$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction1$mcVI$sp;

public abstract class FlatHashTable$class {
    private static /* synthetic */ Map $deserializeLambdaCache$;

    private static final boolean tableDebug(FlatHashTable $this) {
        return false;
    }

    public static int capacity(FlatHashTable $this, int expectedSize) {
        if (expectedSize == 0) {
            return 1;
        }
        return HashTable$.MODULE$.powerOfTwo(expectedSize);
    }

    public static int initialSize(FlatHashTable $this) {
        return 32;
    }

    private static int initialCapacity(FlatHashTable $this) {
        return $this.capacity($this.initialSize());
    }

    public static int randomSeed(FlatHashTable $this) {
        return FlatHashTable$.MODULE$.seedGenerator().get().nextInt();
    }

    public static int tableSizeSeed(FlatHashTable $this) {
        return Integer.bitCount($this.table().length - 1);
    }

    public static void init(FlatHashTable $this, ObjectInputStream in, Function1 f) {
        in.defaultReadObject();
        $this._loadFactor_$eq(in.readInt());
        Predef$.MODULE$.assert($this._loadFactor() > 0);
        int size = in.readInt();
        $this.tableSize_$eq(0);
        Predef$.MODULE$.assert(size >= 0);
        $this.table_$eq(new Object[$this.capacity(FlatHashTable$.MODULE$.sizeForThreshold(size, $this._loadFactor()))]);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), $this.table().length));
        $this.seedvalue_$eq(in.readInt());
        boolean smDefined = in.readBoolean();
        if (smDefined) {
            $this.sizeMapInit($this.table().length);
        } else {
            $this.sizemap_$eq(null);
        }
        for (int index = 0; index < size; ++index) {
            Object elem = FlatHashTable$HashUtils$class.entryToElem($this, in.readObject());
            f.apply(elem);
            $this.addElem(elem);
        }
    }

    public static void serializeTo(FlatHashTable $this, ObjectOutputStream out) {
        out.defaultWriteObject();
        out.writeInt($this._loadFactor());
        out.writeInt($this.tableSize());
        out.writeInt($this.seedvalue());
        out.writeBoolean($this.isSizeMapDefined());
        $this.iterator().foreach((JFunction1 & java.io.Serializable & Serializable)x$12 -> {
            out.writeObject(x$12);
            return BoxedUnit.UNIT;
        });
    }

    public static Option findEntry(FlatHashTable $this, Object elem) {
        Object object = FlatHashTable$class.findElemImpl($this, elem);
        Option option = object == null ? None$.MODULE$ : new Some<Object>(FlatHashTable$HashUtils$class.entryToElem($this, object));
        return option;
    }

    public static boolean containsElem(FlatHashTable $this, Object elem) {
        return FlatHashTable$class.findElemImpl($this, elem) != null;
    }

    private static Object findElemImpl(FlatHashTable $this, Object elem) {
        Object searchEntry = FlatHashTable$HashUtils$class.elemToEntry($this, elem);
        int h = FlatHashTable$class.index($this, searchEntry.hashCode());
        Object curEntry = $this.table()[h];
        while (curEntry != null && !BoxesRunTime.equals(curEntry, searchEntry)) {
            h = (h + 1) % $this.table().length;
            curEntry = $this.table()[h];
        }
        return curEntry;
    }

    public static boolean addElem(FlatHashTable $this, Object elem) {
        return $this.addEntry(FlatHashTable$HashUtils$class.elemToEntry($this, elem));
    }

    public static boolean addEntry(FlatHashTable $this, Object newEntry) {
        int h = FlatHashTable$class.index($this, newEntry.hashCode());
        Object curEntry = $this.table()[h];
        while (curEntry != null) {
            if (BoxesRunTime.equals(curEntry, newEntry)) {
                return false;
            }
            h = (h + 1) % $this.table().length;
            curEntry = $this.table()[h];
        }
        $this.table()[h] = newEntry;
        $this.tableSize_$eq($this.tableSize() + 1);
        $this.nnSizeMapAdd(h);
        if ($this.tableSize() >= $this.threshold()) {
            FlatHashTable$class.growTable($this);
        }
        return true;
    }

    public static boolean removeElem(FlatHashTable $this, Object elem) {
        if (FlatHashTable$class.tableDebug($this)) {
            FlatHashTable$class.checkConsistent($this);
        }
        Object removalEntry = FlatHashTable$HashUtils$class.elemToEntry($this, elem);
        int h = FlatHashTable$class.index($this, removalEntry.hashCode());
        Object curEntry = $this.table()[h];
        while (curEntry != null) {
            if (BoxesRunTime.equals(curEntry, removalEntry)) {
                int h0 = h;
                int h1 = (h0 + 1) % $this.table().length;
                while ($this.table()[h1] != null) {
                    int h2 = FlatHashTable$class.index($this, $this.table()[h1].hashCode());
                    if (h2 != h1 && FlatHashTable$class.precedes$1($this, h2, h0)) {
                        $this.table()[h0] = $this.table()[h1];
                        h0 = h1;
                    }
                    h1 = (h1 + 1) % $this.table().length;
                }
                $this.table()[h0] = null;
                $this.tableSize_$eq($this.tableSize() - 1);
                $this.nnSizeMapRemove(h0);
                if (FlatHashTable$class.tableDebug($this)) {
                    FlatHashTable$class.checkConsistent($this);
                }
                return true;
            }
            h = (h + 1) % $this.table().length;
            curEntry = $this.table()[h];
        }
        return false;
    }

    public static Iterator iterator(FlatHashTable $this) {
        return new AbstractIterator<A>($this){
            private int i;
            private final /* synthetic */ FlatHashTable $outer;

            private int i() {
                return this.i;
            }

            private void i_$eq(int x$1) {
                this.i = x$1;
            }

            public boolean hasNext() {
                while (this.i() < this.$outer.table().length && this.$outer.table()[this.i()] == null) {
                    this.i_$eq(this.i() + 1);
                }
                return this.i() < this.$outer.table().length;
            }

            public A next() {
                if (this.hasNext()) {
                    this.i_$eq(this.i() + 1);
                    return (A)FlatHashTable$HashUtils$class.entryToElem(this.$outer, this.$outer.table()[this.i() - 1]);
                }
                return (A)Iterator$.MODULE$.empty().next();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.i = 0;
            }
        };
    }

    private static void growTable(FlatHashTable $this) {
        Object[] oldtable = $this.table();
        $this.table_$eq(new Object[$this.table().length * 2]);
        $this.tableSize_$eq(0);
        $this.nnSizeMapReset($this.table().length);
        $this.seedvalue_$eq($this.tableSizeSeed());
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), $this.table().length));
        for (int i = 0; i < oldtable.length; ++i) {
            Object entry = oldtable[i];
            java.io.Serializable serializable = entry != null ? BoxesRunTime.boxToBoolean($this.addEntry(entry)) : BoxedUnit.UNIT;
        }
        if (FlatHashTable$class.tableDebug($this)) {
            FlatHashTable$class.checkConsistent($this);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void checkConsistent(FlatHashTable $this) {
        void intWrapper_x;
        Predef$ predef$ = Predef$.MODULE$;
        boolean bl = false;
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        void var3_3 = intWrapper_x;
        Range range = RichInt$.MODULE$.until$extension0((int)var3_3, $this.table().length);
        FlatHashTable flatHashTable = $this;
        Function1 function1 = (JFunction1$mcVI$sp & java.io.Serializable & Serializable)i -> {
            if (flatHashTable.table()[i] != null && !flatHashTable.containsElem(FlatHashTable$HashUtils$class.entryToElem(flatHashTable, flatHashTable.table()[i]))) {
                void assert_assertion;
                Predef$ predef$ = Predef$.MODULE$;
                int n = i;
                FlatHashTable flatHashTable = flatHashTable;
                Function0 function0 = (JFunction0 & java.io.Serializable & Serializable)() -> new StringBuilder().append(n).append((Object)" ").append(flatHashTable.table()[n]).append((Object)" ").append((Object)new ArrayOps.ofRef<Object>(Predef$.MODULE$._refArrayOps(flatHashTable.table())).mkString()).toString();
                boolean bl = false;
                if (predef$ == null) {
                    throw null;
                }
                Predef$ predef$2 = predef$;
                if (assert_assertion == false) {
                    throw new AssertionError((Object)new StringBuilder().append((Object)"assertion failed: ").append((Object)FlatHashTable$class.scala$collection$mutable$FlatHashTable$class$$$anonfun$3(flatHashTable, n)).toString());
                }
            }
        };
        if (range == null) {
            throw null;
        }
        Range foreach$mVc$sp_this = range;
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                int n = foreach$mVc$sp_i;
                FlatHashTable$class.scala$collection$mutable$FlatHashTable$class$$$anonfun$2(flatHashTable, n);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.lastElement()) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    public static void nnSizeMapAdd(FlatHashTable $this, int h) {
        if ($this.sizemap() != null) {
            int p = h >> FlatHashTable$HashUtils$class.sizeMapBucketBitSize($this);
            int[] nArray = $this.sizemap();
            nArray[p] = nArray[p] + 1;
        }
    }

    public static void nnSizeMapRemove(FlatHashTable $this, int h) {
        if ($this.sizemap() != null) {
            int[] nArray = $this.sizemap();
            int n = h >> FlatHashTable$HashUtils$class.sizeMapBucketBitSize($this);
            nArray[n] = nArray[n] - 1;
        }
    }

    public static void nnSizeMapReset(FlatHashTable $this, int tableLength) {
        if ($this.sizemap() != null) {
            int nsize = $this.calcSizeMapSize(tableLength);
            if ($this.sizemap().length != nsize) {
                $this.sizemap_$eq(new int[nsize]);
                return;
            }
            Arrays.fill($this.sizemap(), 0);
        }
    }

    public static final int totalSizeMapBuckets(FlatHashTable $this) {
        return ($this.table().length - 1) / FlatHashTable$HashUtils$class.sizeMapBucketSize($this) + 1;
    }

    public static int calcSizeMapSize(FlatHashTable $this, int tableLength) {
        return (tableLength >> FlatHashTable$HashUtils$class.sizeMapBucketBitSize($this)) + 1;
    }

    public static void sizeMapInit(FlatHashTable $this, int tableLength) {
        $this.sizemap_$eq(new int[$this.calcSizeMapSize(tableLength)]);
    }

    /*
     * WARNING - void declaration
     */
    public static void sizeMapInitAndRebuild(FlatHashTable $this) {
        void intWrapper_x;
        $this.sizeMapInit($this.table().length);
        int totalbuckets = FlatHashTable$class.totalSizeMapBuckets($this);
        int tableidx = 0;
        Object[] tbl = $this.table();
        Predef$ predef$ = Predef$.MODULE$;
        int n = FlatHashTable$HashUtils$class.sizeMapBucketSize($this);
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        void var9_7 = intWrapper_x;
        int tableuntil = RichInt$.MODULE$.min$extension((int)var9_7, tbl.length);
        for (int bucketidx = 0; bucketidx < totalbuckets; ++bucketidx) {
            int currbucketsz = 0;
            while (tableidx < tableuntil) {
                if (tbl[tableidx] != null) {
                    ++currbucketsz;
                }
                ++tableidx;
            }
            $this.sizemap()[bucketidx] = currbucketsz;
            tableuntil += FlatHashTable$HashUtils$class.sizeMapBucketSize($this);
        }
    }

    public static void printSizeMap(FlatHashTable $this) {
        Predef$.MODULE$.println(new ArrayOps.ofInt(Predef$.MODULE$._intArrayOps($this.sizemap())).mkString("szmap: [", ", ", "]"));
    }

    public static void printContents(FlatHashTable $this) {
        Predef$.MODULE$.println(new ArrayOps.ofRef<Object>(Predef$.MODULE$._refArrayOps($this.table())).mkString("[", ", ", "]"));
    }

    public static void sizeMapDisable(FlatHashTable $this) {
        $this.sizemap_$eq(null);
    }

    public static boolean isSizeMapDefined(FlatHashTable $this) {
        return $this.sizemap() != null;
    }

    public static boolean alwaysInitSizeMap(FlatHashTable $this) {
        return false;
    }

    public static final int index(FlatHashTable $this, int hcode) {
        int improved = FlatHashTable$HashUtils$class.improve($this, hcode, $this.seedvalue());
        int ones = $this.table().length - 1;
        return improved >>> 32 - Integer.bitCount(ones) & ones;
    }

    public static void clearTable(FlatHashTable $this) {
        for (int i = $this.table().length - 1; i >= 0; --i) {
            $this.table()[i] = null;
        }
        $this.tableSize_$eq(0);
        $this.nnSizeMapReset($this.table().length);
    }

    public static FlatHashTable.Contents hashTableContents(FlatHashTable $this) {
        return new FlatHashTable.Contents($this._loadFactor(), $this.table(), $this.tableSize(), $this.threshold(), $this.seedvalue(), $this.sizemap());
    }

    public static void initWithContents(FlatHashTable $this, FlatHashTable.Contents c) {
        if (c != null) {
            $this._loadFactor_$eq(c.loadFactor());
            $this.table_$eq(c.table());
            $this.tableSize_$eq(c.tableSize());
            $this.threshold_$eq(c.threshold());
            $this.seedvalue_$eq(c.seedvalue());
            $this.sizemap_$eq(c.sizemap());
        }
        if ($this.alwaysInitSizeMap()) {
            if ($this.sizemap() == null) {
                $this.sizeMapInitAndRebuild();
            }
        }
    }

    private static final boolean precedes$1(FlatHashTable $this, int i, int j) {
        int d = $this.table().length >> 1;
        if (i <= j) {
            return j - i < d;
        }
        return i - j > d;
    }

    public static void $init$(FlatHashTable $this) {
        $this._loadFactor_$eq(FlatHashTable$.MODULE$.defaultLoadFactor());
        $this.table_$eq(new Object[FlatHashTable$class.initialCapacity($this)]);
        $this.tableSize_$eq(0);
        $this.threshold_$eq(FlatHashTable$.MODULE$.newThreshold($this._loadFactor(), FlatHashTable$class.initialCapacity($this)));
        $this.sizemap_$eq(null);
        $this.seedvalue_$eq($this.tableSizeSeed());
    }
}

