/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.TraversableLike$class;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichChar$;
import scala.runtime.java8.JFunction1;

public final class Duration$
implements Serializable {
    public static final Duration$ MODULE$;
    private final double maxPreciseDouble;
    private final List<Tuple2<TimeUnit, String>> timeUnitLabels;
    private final Map<TimeUnit, String> timeUnitName;
    private final Map<String, TimeUnit> timeUnit;
    private final long \u00b5s_per_ns;
    private final long ms_per_ns;
    private final long s_per_ns;
    private final long min_per_ns;
    private final long h_per_ns;
    private final long d_per_ns;
    private final FiniteDuration Zero;
    private final Duration.Infinite Undefined;
    private final Duration.Infinite Inf;
    private final Duration.Infinite MinusInf;
    private static /* synthetic */ java.util.Map $deserializeLambdaCache$;

    static {
        new Duration$();
    }

    public Duration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, (TimeUnit)((Object)this.timeUnit().apply(unit)));
    }

    /*
     * WARNING - void declaration
     */
    public Duration apply(String s) {
        Duration duration;
        void filterNot_filterNot_p;
        void filterNot_p;
        void augmentString_x;
        Predef$ predef$ = Predef$.MODULE$;
        String string = s;
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        void var17_4 = augmentString_x;
        Function1 function1 = (JFunction1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean(Duration$.scala$concurrent$duration$Duration$$$anonfun$1(BoxesRunTime.unboxToChar(x$1)));
        StringOps filterNot_this = new StringOps((String)var17_4);
        void var33_7 = filterNot_p;
        StringOps filterNot_filterNot_$this = filterNot_this;
        Object Repr = filterNot_filterNot_$this.filterImpl(filterNot_filterNot_p, true);
        Object Repr2 = Repr;
        String s1 = (String)Repr2;
        String string2 = s1;
        boolean bl = "Inf".equals(string2) ? true : ("PlusInf".equals(string2) ? true : "+Inf".equals(string2));
        if (bl) {
            duration = this.Inf();
        } else {
            boolean bl2 = "MinusInf".equals(string2) ? true : "-Inf".equals(string2);
            if (bl2) {
                duration = this.MinusInf();
            } else {
                void augmentString_x2;
                Predef$ predef$3;
                TimeUnit unit;
                void augmentString_x3;
                void takeWhile_takeWhile_p;
                Object Repr3;
                void takeWhile_p;
                void augmentString_x4;
                void augmentString_x5;
                Predef$ predef$4 = Predef$.MODULE$;
                Predef$ predef$5 = Predef$.MODULE$;
                Predef$ predef$6 = Predef$.MODULE$;
                String string3 = s1;
                if (predef$6 == null) {
                    throw null;
                }
                Predef$ predef$7 = predef$6;
                void var20_18 = augmentString_x5;
                String string4 = (String)new StringOps((String)var20_18).reverse();
                if (predef$5 == null) {
                    throw null;
                }
                Predef$ predef$8 = predef$5;
                void var23_21 = augmentString_x4;
                Function1 function12 = (JFunction1 & java.io.Serializable & Serializable)x$2 -> BoxesRunTime.boxToBoolean(Duration$.scala$concurrent$duration$Duration$$$anonfun$2(BoxesRunTime.unboxToChar(x$2)));
                StringOps takeWhile_this = new StringOps((String)var23_21);
                void var39_24 = takeWhile_p;
                StringOps takeWhile_takeWhile_$this = takeWhile_this;
                Object Repr4 = Repr3 = takeWhile_takeWhile_$this.take(takeWhile_takeWhile_$this.prefixLength(takeWhile_takeWhile_p));
                String string5 = (String)Repr4;
                if (predef$4 == null) {
                    throw null;
                }
                Predef$ predef$9 = predef$4;
                void var26_30 = augmentString_x3;
                String unitName = (String)new StringOps((String)var26_30).reverse();
                Option option = this.timeUnit().get(unitName);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    unit = (TimeUnit)((Object)some.x());
                    predef$3 = Predef$.MODULE$;
                    String string6 = s1;
                    if (predef$3 == null) {
                        throw null;
                    }
                } else {
                    throw new NumberFormatException(new StringBuilder().append((Object)"format error ").append((Object)s).toString());
                }
                Predef$ predef$10 = predef$3;
                void var29_37 = augmentString_x2;
                String valueStr = (String)new StringOps((String)var29_37).dropRight(unitName.length());
                double valueD = Double.parseDouble(valueStr);
                FiniteDuration finiteDuration = valueD >= -9.007199254740992E15 && valueD <= 9.007199254740992E15 ? this.apply(valueD, unit) : this.apply(Long.parseLong(valueStr), unit);
                duration = finiteDuration;
            }
        }
        return duration;
    }

    private List<String> words(String s) {
        return new ArrayOps.ofRef<Object>(Predef$.MODULE$._refArrayOps((Object[])s.trim().split("\\s+"))).toList();
    }

    private List<String> expandLabels(String labels) {
        List<String> list = this.words(labels);
        if (!(list instanceof $colon$colon)) {
            throw new MatchError(list);
        }
        $colon$colon $colon$colon = ($colon$colon)list;
        String hd = (String)$colon$colon.head();
        List rest = $colon$colon.tl$access$1();
        Tuple2 tuple2 = new Tuple2(hd, rest);
        Tuple2 tuple22 = tuple2;
        String hd2 = tuple22._1();
        List rest2 = tuple22._2();
        String string = hd2;
        return rest2.flatMap((JFunction1 & java.io.Serializable & Serializable)s -> List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{s, new StringBuilder().append(s).append((Object)"s").toString()})), List$.MODULE$.canBuildFrom()).$colon$colon(string);
    }

    public Map<TimeUnit, String> timeUnitName() {
        return this.timeUnitName;
    }

    public Map<String, TimeUnit> timeUnit() {
        return this.timeUnit;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(String s) {
        Option option;
        Option option2 = this.liftedTree1$1(s);
        Duration$ duration$ = this;
        Function1 function1 = (JFunction1 & java.io.Serializable & Serializable)d -> this.unapply((Duration)d);
        if (option2 == null) {
            throw null;
        }
        Option flatMap_this = option2;
        if (flatMap_this.isEmpty()) {
            option = None$.MODULE$;
        } else {
            Object a = flatMap_this.get();
            option = duration$.scala$concurrent$duration$Duration$$$anonfun$7((Duration)a);
        }
        None$ none$ = option;
        return none$;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        if (d.isFinite()) {
            return new Some<Tuple2<Object, TimeUnit>>(new Tuple2<Long, TimeUnit>(BoxesRunTime.boxToLong(d.length()), d.unit()));
        }
        return None$.MODULE$;
    }

    public Duration fromNanos(double nanos) {
        if (Predef$.MODULE$.double2Double(nanos).isInfinite()) {
            if (nanos > 0.0) {
                return this.Inf();
            }
            return this.MinusInf();
        }
        if (Predef$.MODULE$.double2Double(nanos).isNaN()) {
            return this.Undefined();
        }
        if (nanos > (double)Long.MAX_VALUE || nanos < (double)Long.MIN_VALUE) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"trying to construct too large duration with ").append(BoxesRunTime.boxToDouble(nanos)).append((Object)"ns").toString());
        }
        return this.fromNanos((long)(nanos + 0.5));
    }

    public FiniteDuration fromNanos(long nanos) {
        if (nanos % 86400000000000L == 0L) {
            return this.apply(nanos / 86400000000000L, TimeUnit.DAYS);
        }
        if (nanos % 3600000000000L == 0L) {
            return this.apply(nanos / 3600000000000L, TimeUnit.HOURS);
        }
        if (nanos % 60000000000L == 0L) {
            return this.apply(nanos / 60000000000L, TimeUnit.MINUTES);
        }
        if (nanos % 1000000000L == 0L) {
            return this.apply(nanos / 1000000000L, TimeUnit.SECONDS);
        }
        if (nanos % 1000000L == 0L) {
            return this.apply(nanos / 1000000L, TimeUnit.MILLISECONDS);
        }
        if (nanos % 1000L == 0L) {
            return this.apply(nanos / 1000L, TimeUnit.MICROSECONDS);
        }
        return this.apply(nanos, TimeUnit.NANOSECONDS);
    }

    public FiniteDuration Zero() {
        return this.Zero;
    }

    public Duration.Infinite Undefined() {
        return this.Undefined;
    }

    public Duration.Infinite Inf() {
        return this.Inf;
    }

    public Duration.Infinite MinusInf() {
        return this.MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public Duration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration create(String s) {
        return this.apply(s);
    }

    private Object readResolve() {
        return MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean scala$concurrent$duration$Duration$$$anonfun$1(char x$1) {
        void charWrapper_c;
        Predef$ predef$ = Predef$.MODULE$;
        char c = x$1;
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        void var3_3 = charWrapper_c;
        return RichChar$.MODULE$.isWhitespace$extension((char)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean scala$concurrent$duration$Duration$$$anonfun$2(char x$2) {
        void charWrapper_c;
        Predef$ predef$ = Predef$.MODULE$;
        char c = x$2;
        if (predef$ == null) {
            throw null;
        }
        Predef$ predef$2 = predef$;
        void var3_3 = charWrapper_c;
        return RichChar$.MODULE$.isLetter$extension((char)var3_3);
    }

    private final Option liftedTree1$1(String s$1) {
        try {
            return new Some<Duration>(this.apply(s$1));
        }
        catch (RuntimeException runtimeException) {
            return None$.MODULE$;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Duration$() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        Tuple2<void, void> tuple2;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        Tuple2<void, void> tuple22;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        Tuple2<void, void> tuple23;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        Tuple2<void, void> tuple24;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        Tuple2<void, void> tuple25;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        Tuple2<void, void> tuple26;
        void $minus$greater$extension_y7;
        void $minus$greater$extension_$this7;
        Tuple2<void, void> tuple27;
        MODULE$ = this;
        Tuple2[] tuple2Array = new Tuple2[7];
        Predef$ArrowAssoc$ predef$ArrowAssoc$ = Predef$ArrowAssoc$.MODULE$;
        String string = "d day";
        TimeUnit timeUnit = Predef$.MODULE$.ArrowAssoc(TimeUnit.DAYS);
        if (predef$ArrowAssoc$ == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$2 = predef$ArrowAssoc$;
        tuple2Array[0] = tuple27 = new Tuple2<void, void>($minus$greater$extension_$this7, $minus$greater$extension_y7);
        Predef$ArrowAssoc$ predef$ArrowAssoc$3 = Predef$ArrowAssoc$.MODULE$;
        String string2 = "h hour";
        TimeUnit timeUnit2 = Predef$.MODULE$.ArrowAssoc(TimeUnit.HOURS);
        if (predef$ArrowAssoc$3 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$4 = predef$ArrowAssoc$3;
        tuple2Array[1] = tuple26 = new Tuple2<void, void>($minus$greater$extension_$this6, $minus$greater$extension_y6);
        Predef$ArrowAssoc$ predef$ArrowAssoc$5 = Predef$ArrowAssoc$.MODULE$;
        String string3 = "min minute";
        TimeUnit timeUnit3 = Predef$.MODULE$.ArrowAssoc(TimeUnit.MINUTES);
        if (predef$ArrowAssoc$5 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$6 = predef$ArrowAssoc$5;
        tuple2Array[2] = tuple25 = new Tuple2<void, void>($minus$greater$extension_$this5, $minus$greater$extension_y5);
        Predef$ArrowAssoc$ predef$ArrowAssoc$7 = Predef$ArrowAssoc$.MODULE$;
        String string4 = "s sec second";
        TimeUnit timeUnit4 = Predef$.MODULE$.ArrowAssoc(TimeUnit.SECONDS);
        if (predef$ArrowAssoc$7 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$8 = predef$ArrowAssoc$7;
        tuple2Array[3] = tuple24 = new Tuple2<void, void>($minus$greater$extension_$this4, $minus$greater$extension_y4);
        Predef$ArrowAssoc$ predef$ArrowAssoc$9 = Predef$ArrowAssoc$.MODULE$;
        String string5 = "ms milli millisecond";
        TimeUnit timeUnit5 = Predef$.MODULE$.ArrowAssoc(TimeUnit.MILLISECONDS);
        if (predef$ArrowAssoc$9 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$10 = predef$ArrowAssoc$9;
        tuple2Array[4] = tuple23 = new Tuple2<void, void>($minus$greater$extension_$this3, $minus$greater$extension_y3);
        Predef$ArrowAssoc$ predef$ArrowAssoc$11 = Predef$ArrowAssoc$.MODULE$;
        String string6 = "\u00b5s micro microsecond";
        TimeUnit timeUnit6 = Predef$.MODULE$.ArrowAssoc(TimeUnit.MICROSECONDS);
        if (predef$ArrowAssoc$11 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$12 = predef$ArrowAssoc$11;
        tuple2Array[5] = tuple22 = new Tuple2<void, void>($minus$greater$extension_$this2, $minus$greater$extension_y2);
        Predef$ArrowAssoc$ predef$ArrowAssoc$13 = Predef$ArrowAssoc$.MODULE$;
        String string7 = "ns nano nanosecond";
        TimeUnit timeUnit7 = Predef$.MODULE$.ArrowAssoc(TimeUnit.NANOSECONDS);
        if (predef$ArrowAssoc$13 == null) {
            throw null;
        }
        Predef$ArrowAssoc$ predef$ArrowAssoc$14 = predef$ArrowAssoc$13;
        tuple2Array[6] = tuple2 = new Tuple2<void, void>($minus$greater$extension_$this, $minus$greater$extension_y);
        this.timeUnitLabels = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
        this.timeUnitName = this.timeUnitLabels.toMap(Predef$.MODULE$.$conforms()).mapValues((JFunction1 & java.io.Serializable & Serializable)s -> this.words((String)s).last()).toMap(Predef$.MODULE$.$conforms());
        this.timeUnit = ((TraversableOnce)this.timeUnitLabels.flatMap((JFunction1 & java.io.Serializable & Serializable)x0$1 -> {
            $colon$colon<Nothing$> $colon$colon;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                void map_bf;
                TimeUnit unit = (TimeUnit)((Object)((Object)tuple2._1()));
                String names = (String)tuple2._2();
                List<String> list = this.expandLabels(names);
                TimeUnit timeUnit = unit;
                CanBuildFrom canBuildFrom = List$.MODULE$.canBuildFrom();
                Function1 function1 = (JFunction1 & java.io.Serializable & Serializable)x$5 -> {
                    void $minus$greater$extension_y;
                    void $minus$greater$extension_$this;
                    Predef$ArrowAssoc$ predef$ArrowAssoc$ = Predef$ArrowAssoc$.MODULE$;
                    TimeUnit timeUnit = timeUnit;
                    String string = Predef$.MODULE$.ArrowAssoc(x$5);
                    if (predef$ArrowAssoc$ == null) {
                        throw null;
                    }
                    Predef$ArrowAssoc$ predef$ArrowAssoc$2 = predef$ArrowAssoc$;
                    Tuple2<void, void> tuple2 = new Tuple2<void, void>($minus$greater$extension_$this, $minus$greater$extension_y);
                    return tuple2;
                };
                if (list == null) {
                    throw null;
                }
                List<String> map_this = list;
                if (map_bf == List$.MODULE$.ReusableCBF()) {
                    if (map_this == Nil$.MODULE$) {
                        $colon$colon = Nil$.MODULE$;
                    } else {
                        $colon$colon<Nothing$> map_h;
                        String string = map_this.head();
                        $colon$colon<Nothing$> map_t = map_h = new $colon$colon<Nothing$>((Nothing$)((Object)Duration$.scala$concurrent$duration$Duration$$$anonfun$6(timeUnit, string)), Nil$.MODULE$);
                        for (List map_rest = (List)map_this.tail(); map_rest != Nil$.MODULE$; map_rest = (List)map_rest.tail()) {
                            string = map_rest.head();
                            $colon$colon<Nothing$> map_nx = new $colon$colon<Nothing$>((Nothing$)((Object)Duration$.scala$concurrent$duration$Duration$$$anonfun$6(timeUnit, string)), Nil$.MODULE$);
                            map_t.tl_$eq(map_nx);
                            map_t = map_nx;
                        }
                        $colon$colon = map_h;
                    }
                } else {
                    void map_f;
                    $colon$colon = TraversableLike$class.map(map_this, (Function1)map_f, (CanBuildFrom)map_bf);
                }
            } else {
                throw new MatchError(tuple2);
            }
            $colon$colon<Nothing$> $colon$colon2 = $colon$colon;
            List list = $colon$colon2;
            return list;
        }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.Zero = new FiniteDuration(0L, TimeUnit.DAYS);
        this.Undefined = new Duration.Infinite(){

            public String toString() {
                return "Duration.Undefined";
            }

            public boolean equals(Object other) {
                return false;
            }

            public Duration $plus(Duration other) {
                return this;
            }

            public Duration $minus(Duration other) {
                return this;
            }

            public Duration $times(double factor) {
                return this;
            }

            public Duration $div(double factor) {
                return this;
            }

            public double $div(Duration other) {
                return Double.NaN;
            }

            public int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return 1;
            }

            public Duration unary_$minus() {
                return this;
            }

            public double toUnit(TimeUnit unit) {
                return Double.NaN;
            }

            private Object readResolve() {
                return Duration$.MODULE$.Undefined();
            }
        };
        this.Inf = new Duration.Infinite(){

            public String toString() {
                return "Duration.Inf";
            }

            public int compare(Duration other) {
                Duration duration = other;
                int n = duration == Duration$.MODULE$.Undefined() ? -1 : (duration == this ? 0 : 1);
                return n;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.MinusInf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.POSITIVE_INFINITY;
            }

            private Object readResolve() {
                return Duration$.MODULE$.Inf();
            }
        };
        this.MinusInf = new Duration.Infinite(){

            public String toString() {
                return "Duration.MinusInf";
            }

            public int compare(Duration other) {
                if (other == this) {
                    return 0;
                }
                return -1;
            }

            public Duration unary_$minus() {
                return Duration$.MODULE$.Inf();
            }

            public double toUnit(TimeUnit unit) {
                return Double.NEGATIVE_INFINITY;
            }

            private Object readResolve() {
                return Duration$.MODULE$.MinusInf();
            }
        };
    }
}

