/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Hashing$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.BitmapIndexedMapNode;
import scala.collection.immutable.ChampBaseIterator;
import scala.collection.immutable.HashCollisionMapNode;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.HashMap$;
import scala.collection.immutable.MapNode;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ReusableBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001df!\u0002\u000f\u001e\u0005u\u0019\u0003\"B#\u0001\t\u00031\u0005\"\u0002%\u0001\t\u0013I\u0005\"C'\u0001\u0001\u0004\u0005\r\u0011\"\u0003O\u0011%y\u0005\u00011AA\u0002\u0013%\u0001\u000bC\u0005W\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\")q\u000b\u0001C\u00051\"9A\f\u0001a\u0001\n\u0013i\u0006bB1\u0001\u0001\u0004%IA\u0019\u0005\u0007I\u0002\u0001\u000b\u0015\u00020\t\r\u0015\u0004A\u0011A\u000fg\u0011\u0015\u0001\b\u0001\"\u0003r\u0011\u0015q\b\u0001\"\u0003\u0000\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!!\n\u0001\t\u0013\t9\u0003C\u0004\u00024\u0001!I!!\u000e\t\u0011\u0005%\u0003\u0001\"\u0001\u001e\u0003\u0017Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002b\u0001!I!a\u0018\t\u000f\u0005\r\u0004\u0001\"\u0011\u0002f!9\u0011q\r\u0001\u0005B\u0005%\u0004bBA4\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003O\u0002A\u0011AA;\u0011\u001d\t9\u0007\u0001C\u0001\u0003{Bq!!#\u0001\t\u0003\nY\tC\u0004\u0002 \u0002!\t%a\u0018\t\u0011\u0005\u0005\u0006\u0001\"\u0001 \u0003GCq!!*\u0001\t\u0003\n\u0019K\u0001\bICNDW*\u00199Ck&dG-\u001a:\u000b\u0005yy\u0012!C5n[V$\u0018M\u00197f\u0015\t\u0001\u0013%\u0001\u0006d_2dWm\u0019;j_:T\u0011AI\u0001\u0006g\u000e\fG.Y\u000b\u0004IQz4c\u0001\u0001&SA\u0011aeJ\u0007\u0002C%\u0011\u0001&\t\u0002\u0007\u0003:L(+\u001a4\u0011\t)js&Q\u0007\u0002W)\u0011AfH\u0001\b[V$\u0018M\u00197f\u0013\tq3FA\bSKV\u001c\u0018M\u00197f\u0005VLG\u000eZ3s!\u00111\u0003G\r \n\u0005E\n#A\u0002+va2,'\u0007\u0005\u00024i1\u0001A!B\u001b\u0001\u0005\u00049$!A&\u0004\u0001E\u0011\u0001h\u000f\t\u0003MeJ!AO\u0011\u0003\u000f9{G\u000f[5oOB\u0011a\u0005P\u0005\u0003{\u0005\u00121!\u00118z!\t\u0019t\bB\u0003A\u0001\t\u0007qGA\u0001W!\u0011\u00115I\r \u000e\u0003uI!\u0001R\u000f\u0003\u000f!\u000b7\u000f['ba\u00061A(\u001b8jiz\"\u0012a\u0012\t\u0005\u0005\u0002\u0011d(\u0001\toK^,U\u000e\u001d;z%>|GOT8eKV\t!\n\u0005\u0003C\u0017Jr\u0014B\u0001'\u001e\u0005Q\u0011\u0015\u000e^7ba&sG-\u001a=fI6\u000b\u0007OT8eK\u00069\u0011\r\\5bg\u0016$W#A!\u0002\u0017\u0005d\u0017.Y:fI~#S-\u001d\u000b\u0003#R\u0003\"A\n*\n\u0005M\u000b#\u0001B+oSRDq!\u0016\u0003\u0002\u0002\u0003\u0007\u0011)A\u0002yIE\n\u0001\"\u00197jCN,G\rI\u0001\nSN\fE.[1tK\u0012,\u0012!\u0017\t\u0003MiK!aW\u0011\u0003\u000f\t{w\u000e\\3b]\u0006A!o\\8u\u001d>$W-F\u0001_!\u0011\u0011uL\r \n\u0005\u0001l\"aB'ba:{G-Z\u0001\re>|GOT8eK~#S-\u001d\u000b\u0003#\u000eDq!\u0016\u0005\u0002\u0002\u0003\u0007a,A\u0005s_>$hj\u001c3fA\u0005Iq-\u001a;Pe\u0016c7/Z\u000b\u0003O&$2\u0001\u001b7o!\t\u0019\u0014\u000eB\u0003k\u0015\t\u00071N\u0001\u0002WaE\u0011ah\u000f\u0005\u0006[*\u0001\rAM\u0001\u0004W\u0016L\b\"B8\u000b\u0001\u0004A\u0017!\u0002<bYV,\u0017!D5og\u0016\u0014H/\u00127f[\u0016tG\u000f\u0006\u0003sqjd\bc\u0001\u0014tk&\u0011A/\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003MYL!a^\u0011\u0003\u0007%sG\u000fC\u0003z\u0017\u0001\u0007!/\u0001\u0002bg\")1p\u0003a\u0001k\u0006\u0011\u0011\u000e\u001f\u0005\u0006{.\u0001\r!^\u0001\u0005K2,W.A\u0006j]N,'\u000f\u001e,bYV,W\u0003BA\u0001\u00033!R\"UA\u0002\u0003\u000f\tY!!\u0004\u0002\u0012\u0005U\u0001BBA\u0003\u0019\u0001\u0007!*\u0001\u0002c[\"1\u0011\u0011\u0002\u0007A\u0002U\faAY5ua>\u001c\b\"B7\r\u0001\u0004\u0011\u0004BBA\b\u0019\u0001\u0007Q/\u0001\u0007pe&<\u0017N\\1m\u0011\u0006\u001c\b\u000e\u0003\u0004\u0002\u00141\u0001\r!^\u0001\bW\u0016L\b*Y:i\u0011\u0019yG\u00021\u0001\u0002\u0018A\u00191'!\u0007\u0005\r\u0005mAB1\u0001l\u0005\t1\u0016'A\u0007sK6|g/Z#mK6,g\u000e\u001e\u000b\u0006e\u0006\u0005\u00121\u0005\u0005\u0006s6\u0001\rA\u001d\u0005\u0006w6\u0001\r!^\u0001\u0018[&<'/\u0019;f\rJ|W.\u00138mS:,Gk\u001c(pI\u0016$\u0012\"UA\u0015\u0003W\ti#a\f\t\r\u0005\u0015a\u00021\u0001K\u0011\u0019\t\u0019B\u0004a\u0001k\"1\u0011\u0011\u0002\bA\u0002UDa!!\r\u000f\u0001\u0004q\u0016\u0001\u00028pI\u0016\f\u0001b]3u-\u0006dW/Z\u000b\u0005\u0003o\t9\u0005F\u0005R\u0003s\tY$!\u0010\u0002B!1\u0011QA\bA\u0002)Ca!!\u0003\u0010\u0001\u0004)\bBBA \u001f\u0001\u0007!'\u0001\u0004oK^\\U-\u001f\u0005\b\u0003\u0007z\u0001\u0019AA#\u0003!qWm\u001e,bYV,\u0007cA\u001a\u0002H\u00111\u00111D\bC\u0002-\fa!\u001e9eCR,G#D)\u0002N\u0005E\u00131KA+\u0003/\nI\u0006\u0003\u0004\u0002PA\u0001\rAX\u0001\b[\u0006\u0004hj\u001c3f\u0011\u0015i\u0007\u00031\u00013\u0011\u0015y\u0007\u00031\u0001?\u0011\u0019\ty\u0001\u0005a\u0001k\"1\u00111\u0003\tA\u0002UDa!a\u0017\u0011\u0001\u0004)\u0018!B:iS\u001a$\u0018aD3ogV\u0014X-\u00168bY&\f7/\u001a3\u0015\u0003E\u000b\u0011bY8qs\u0016cW-\\:\u0002\rI,7/\u001e7u)\u0005\t\u0015AB1eI>sW\r\u0006\u0003\u0002l\u00055T\"\u0001\u0001\t\u000bu$\u0002\u0019A\u0018\u0015\r\u0005-\u0014\u0011OA:\u0011\u0015iW\u00031\u00013\u0011\u0015yW\u00031\u0001?)!\tY'a\u001e\u0002z\u0005m\u0004\"B7\u0017\u0001\u0004\u0011\u0004\"B8\u0017\u0001\u0004q\u0004BBA\b-\u0001\u0007Q\u000f\u0006\u0006\u0002l\u0005}\u0014\u0011QAB\u0003\u000bCQ!\\\fA\u0002IBQa\\\fA\u0002yBa!a\u0004\u0018\u0001\u0004)\bBBAD/\u0001\u0007Q/\u0001\u0003iCND\u0017AB1eI\u0006cG\u000e\u0006\u0003\u0002l\u00055\u0005bBAH1\u0001\u0007\u0011\u0011S\u0001\u0003qN\u0004R!a%\u0002\u001a>r1AJAK\u0013\r\t9*I\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tY*!(\u0003\u0019%#XM]1cY\u0016|enY3\u000b\u0007\u0005]\u0015%A\u0003dY\u0016\f'/\u0001\u0003tSj,W#A;\u0002\u0013-twn\u001e8TSj,\u0007")
public final class HashMapBuilder<K, V>
implements ReusableBuilder<Tuple2<K, V>, HashMap<K, V>> {
    private HashMap<K, V> aliased;
    private MapNode<K, V> scala$collection$immutable$HashMapBuilder$$rootNode = this.newEmptyRootNode();

    private BitmapIndexedMapNode<K, V> newEmptyRootNode() {
        return new BitmapIndexedMapNode(0, 0, (Object[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Any()), (int[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Int()), 0, 0);
    }

    private HashMap<K, V> aliased() {
        return this.aliased;
    }

    private void aliased_$eq(HashMap<K, V> x$1) {
        this.aliased = x$1;
    }

    private boolean isAliased() {
        return this.aliased() != null;
    }

    public MapNode<K, V> scala$collection$immutable$HashMapBuilder$$rootNode() {
        return this.scala$collection$immutable$HashMapBuilder$$rootNode;
    }

    private void scala$collection$immutable$HashMapBuilder$$rootNode_$eq(MapNode<K, V> x$1) {
        this.scala$collection$immutable$HashMapBuilder$$rootNode = x$1;
    }

    public <V0> V0 getOrElse(K key, V0 value) {
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode().size() == 0) {
            return value;
        }
        int originalHash = Statics.anyHash(key);
        return (V0)this.scala$collection$immutable$HashMapBuilder$$rootNode().getOrElse(key, originalHash, Hashing$.MODULE$.improve(originalHash), 0, (Function0<Object> & Serializable)() -> value);
    }

    private int[] insertElement(int[] as, int ix, int elem) {
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length + 1];
        System.arraycopy(as, 0, result, 0, ix);
        result[ix] = elem;
        System.arraycopy(as, ix, result, ix + 1, as.length - ix);
        return result;
    }

    private <V1> void insertValue(BitmapIndexedMapNode<K, V> bm, int bitpos, K key, int originalHash, int keyHash, V1 value) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 2 * dataIx;
        Object[] src = bm.content();
        Object[] dst = new Object[src.length + 2];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        dst[idx + 1] = value;
        System.arraycopy(src, idx, dst, idx + 2, src.length - idx);
        int[] dstHashes = this.insertElement(bm.originalHashes(), dataIx, originalHash);
        bm.dataMap_$eq(bm.dataMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() + 1);
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + keyHash);
    }

    /*
     * WARNING - void declaration
     */
    private int[] removeElement(int[] as, int ix) {
        void var3_3;
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length - 1];
        System.arraycopy(as, 0, result, 0, ix);
        System.arraycopy(as, ix + 1, result, ix, as.length - ix - 1);
        return var3_3;
    }

    private void migrateFromInlineToNode(BitmapIndexedMapNode<K, V> bm, int keyHash, int bitpos, MapNode<K, V> node) {
        int dataIx = bm.dataIndex(bitpos);
        int idxOld = 2 * dataIx;
        int idxNew = bm.content().length - 2 - bm.nodeIndex(bitpos);
        Object[] src = bm.content();
        Object[] dst = new Object[src.length - 2 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 2, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 2, dst, idxNew + 1, src.length - idxNew - 2);
        int[] dstHashes = this.removeElement(bm.originalHashes(), dataIx);
        bm.dataMap_$eq(bm.dataMap() ^ bitpos);
        bm.nodeMap_$eq(bm.nodeMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() - 1 + node.size());
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + (node.cachedJavaKeySetHashCode() - keyHash));
    }

    private <V1> void setValue(BitmapIndexedMapNode<K, V> bm, int bitpos, K newKey, V1 newValue) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 2 * dataIx;
        bm.content()[idx + 1] = newValue;
    }

    /*
     * WARNING - void declaration
     */
    public void update(MapNode<K, V> mapNode, K key, V value, int originalHash, int keyHash, int shift) {
        if (mapNode instanceof BitmapIndexedMapNode) {
            BitmapIndexedMapNode bitmapIndexedMapNode = (BitmapIndexedMapNode)mapNode;
            int n = keyHash >>> shift & 0x1F;
            int n2 = 1 << n;
            if ((bitmapIndexedMapNode.dataMap() & n2) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedMapNode.dataMap(), n, n2);
                Object object = bitmapIndexedMapNode.content()[2 * index];
                int n3 = bitmapIndexedMapNode.originalHashes()[index];
                if (n3 == originalHash && BoxesRunTime.equals(object, key)) {
                    this.setValue(bitmapIndexedMapNode, n2, key, value);
                    return;
                }
                Object object2 = bitmapIndexedMapNode.content()[2 * index + 1];
                int key0Hash = Hashing$.MODULE$.improve(n3);
                MapNode<Object, Object> subNodeNew = bitmapIndexedMapNode.mergeTwoKeyValPairs(object, object2, n3, key0Hash, key, value, originalHash, keyHash, shift + 5);
                this.migrateFromInlineToNode(bitmapIndexedMapNode, key0Hash, n2, subNodeNew);
                return;
            }
            if ((bitmapIndexedMapNode.nodeMap() & n2) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedMapNode.nodeMap(), n, n2);
                Node subNode = bitmapIndexedMapNode.getNode(index);
                int beforeSize = ((MapNode)subNode).size();
                int beforeHash = subNode.cachedJavaKeySetHashCode();
                this.update((MapNode<K, V>)subNode, key, value, originalHash, keyHash, shift + 5);
                bitmapIndexedMapNode.size_$eq(bitmapIndexedMapNode.size() + (((MapNode)subNode).size() - beforeSize));
                bitmapIndexedMapNode.cachedJavaKeySetHashCode_$eq(bitmapIndexedMapNode.cachedJavaKeySetHashCode() + (subNode.cachedJavaKeySetHashCode() - beforeHash));
                return;
            }
            this.insertValue(bitmapIndexedMapNode, n2, key, originalHash, keyHash, value);
            return;
        }
        if (mapNode instanceof HashCollisionMapNode) {
            void updated_elem;
            HashCollisionMapNode hashCollisionMapNode = (HashCollisionMapNode)mapNode;
            int index = hashCollisionMapNode.indexOf(key);
            if (index < 0) {
                hashCollisionMapNode.content_$eq(hashCollisionMapNode.content().appended(new Tuple2<K, V>(key, value)));
                return;
            }
            Vector vector = hashCollisionMapNode.content();
            Tuple2<K, V> tuple2 = new Tuple2<K, V>(key, value);
            if (vector == null) {
                throw null;
            }
            tuple2 = null;
            hashCollisionMapNode.content_$eq(vector.updateAt(index, updated_elem));
            return;
        }
        throw new MatchError(mapNode);
    }

    private void ensureUnaliased() {
        if (this.isAliased()) {
            this.copyElems();
        }
        this.aliased_$eq(null);
    }

    private void copyElems() {
        this.scala$collection$immutable$HashMapBuilder$$rootNode_$eq(this.scala$collection$immutable$HashMapBuilder$$rootNode().copy());
    }

    @Override
    public HashMap<K, V> result() {
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode().size() == 0) {
            return HashMap$.MODULE$.empty();
        }
        if (this.aliased() != null) {
            return this.aliased();
        }
        this.aliased_$eq(new HashMap<K, V>(this.scala$collection$immutable$HashMapBuilder$$rootNode()));
        Statics.releaseFence();
        return this.aliased();
    }

    public HashMapBuilder<K, V> addOne(Tuple2<K, V> elem) {
        this.ensureUnaliased();
        int h = Statics.anyHash(elem._1());
        int im = Hashing$.MODULE$.improve(h);
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), elem._1(), elem._2(), h, im, 0);
        return this;
    }

    public HashMapBuilder<K, V> addOne(K key, V value) {
        this.ensureUnaliased();
        int originalHash = Statics.anyHash(key);
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), key, value, originalHash, Hashing$.MODULE$.improve(originalHash), 0);
        return this;
    }

    public HashMapBuilder<K, V> addOne(K key, V value, int originalHash) {
        this.ensureUnaliased();
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), key, value, originalHash, Hashing$.MODULE$.improve(originalHash), 0);
        return this;
    }

    public HashMapBuilder<K, V> addOne(K key, V value, int originalHash, int hash) {
        this.ensureUnaliased();
        this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), key, value, originalHash, hash, 0);
        return this;
    }

    public HashMapBuilder<K, V> addAll(IterableOnce<Tuple2<K, V>> xs) {
        this.ensureUnaliased();
        if (xs instanceof HashMap) {
            HashMap hashMap = (HashMap)xs;
            new ChampBaseIterator<MapNode<K, V>>(this, hashMap){
                {
                    while (this.hasNext()) {
                        int originalHash = ((Node)this.currentValueNode()).getHash(this.currentValueCursor());
                        $outer.update($outer.scala$collection$immutable$HashMapBuilder$$rootNode(), ((MapNode)this.currentValueNode()).getKey(this.currentValueCursor()), ((MapNode)this.currentValueNode()).getValue(this.currentValueCursor()), originalHash, Hashing$.MODULE$.improve(originalHash), 0);
                        this.currentValueCursor_$eq(this.currentValueCursor() + 1);
                    }
                }
            };
        } else if (xs instanceof scala.collection.mutable.HashMap) {
            scala.collection.mutable.HashMap hashMap = (scala.collection.mutable.HashMap)xs;
            Iterator iter = hashMap.nodeIterator();
            while (iter.hasNext()) {
                HashMap.Node next = iter.next();
                int originalHash = hashMap.unimproveHash(next.hash());
                int hash = Hashing$.MODULE$.improve(originalHash);
                this.update(this.scala$collection$immutable$HashMapBuilder$$rootNode(), next.key(), next.value(), originalHash, hash, 0);
            }
        } else {
            Iterator<Tuple2<K, V>> it = xs.iterator();
            while (it.hasNext()) {
                this.addOne(it.next());
            }
        }
        return this;
    }

    @Override
    public void clear() {
        this.aliased_$eq(null);
        if (this.scala$collection$immutable$HashMapBuilder$$rootNode().size() > 0) {
            this.scala$collection$immutable$HashMapBuilder$$rootNode_$eq(this.newEmptyRootNode());
        }
    }

    public int size() {
        return this.scala$collection$immutable$HashMapBuilder$$rootNode().size();
    }

    @Override
    public int knownSize() {
        return this.scala$collection$immutable$HashMapBuilder$$rootNode().size();
    }
}

