/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.collection.Hashing$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.BitmapIndexedSetNode;
import scala.collection.immutable.ChampBaseIterator;
import scala.collection.immutable.HashCollisionSetNode;
import scala.collection.immutable.HashSet;
import scala.collection.immutable.HashSet$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Node;
import scala.collection.immutable.Node$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetNode;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc!B\f\u0019\u0005iq\u0002\"\u0002\u001e\u0001\t\u0003Y\u0004\"B\u001f\u0001\t\u0013q\u0004\"\u0003\"\u0001\u0001\u0004\u0005\r\u0011\"\u0003D\u0011%!\u0005\u00011AA\u0002\u0013%Q\tC\u0005L\u0001\u0001\u0007\t\u0011)Q\u0005m!)A\n\u0001C\u0005\u001b\"9\u0011\u000b\u0001a\u0001\n\u0013\u0011\u0006b\u0002,\u0001\u0001\u0004%Ia\u0016\u0005\u00073\u0002\u0001\u000b\u0015B*\t\u000bi\u0003A\u0011B.\t\u000b!\u0004A\u0011B5\t\u000ba\u0004A\u0011B=\t\u000bq\u0004A\u0011B?\t\u000f\u0005%\u0001\u0001\"\u0003\u0002\f!9\u0011q\u0003\u0001\u0005\u0002\u0005e\u0001bBA\u0016\u0001\u0011%\u0011Q\u0006\u0005\b\u0003_\u0001A\u0011BA\u0017\u0011\u001d\t\t\u0004\u0001C!\u0003gAq!!\u000e\u0001\t\u0003\n9\u0004C\u0004\u0002>\u0001!\t%a\u0010\t\u000f\u00055\u0003\u0001\"\u0011\u0002.!A\u0011q\n\u0001\u0005\u0002i\t\tF\u0001\bICND7+\u001a;Ck&dG-\u001a:\u000b\u0005eQ\u0012!C5n[V$\u0018M\u00197f\u0015\tYB$\u0001\u0006d_2dWm\u0019;j_:T\u0011!H\u0001\u0006g\u000e\fG.Y\u000b\u0003?1\u001a2\u0001\u0001\u0011%!\t\t#%D\u0001\u001d\u0013\t\u0019CD\u0001\u0004B]f\u0014VM\u001a\t\u0005K!Rc'D\u0001'\u0015\t9#$A\u0004nkR\f'\r\\3\n\u0005%2#a\u0002\"vS2$WM\u001d\t\u0003W1b\u0001\u0001B\u0003.\u0001\t\u0007qFA\u0001B\u0007\u0001\t\"\u0001M\u001a\u0011\u0005\u0005\n\u0014B\u0001\u001a\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\t\u001b\n\u0005Ub\"aA!osB\u0019q\u0007\u000f\u0016\u000e\u0003aI!!\u000f\r\u0003\u000f!\u000b7\u000f[*fi\u00061A(\u001b8jiz\"\u0012\u0001\u0010\t\u0004o\u0001Q\u0013\u0001\u00058fo\u0016k\u0007\u000f^=S_>$hj\u001c3f+\u0005y\u0004cA\u001cAU%\u0011\u0011\t\u0007\u0002\u0015\u0005&$X.\u00199J]\u0012,\u00070\u001a3TKRtu\u000eZ3\u0002\u000f\u0005d\u0017.Y:fIV\ta'A\u0006bY&\f7/\u001a3`I\u0015\fHC\u0001$J!\t\ts)\u0003\u0002I9\t!QK\\5u\u0011\u001dQE!!AA\u0002Y\n1\u0001\u001f\u00132\u0003!\tG.[1tK\u0012\u0004\u0013!C5t\u00032L\u0017m]3e+\u0005q\u0005CA\u0011P\u0013\t\u0001FDA\u0004C_>dW-\u00198\u0002\u0011I|w\u000e\u001e(pI\u0016,\u0012a\u0015\t\u0004oQS\u0013BA+\u0019\u0005\u001d\u0019V\r\u001e(pI\u0016\fAB]8pi:{G-Z0%KF$\"A\u0012-\t\u000f)C\u0011\u0011!a\u0001'\u0006I!o\\8u\u001d>$W\rI\u0001\u000eS:\u001cXM\u001d;FY\u0016lWM\u001c;\u0015\tq\u0013GM\u001a\t\u0004Cu{\u0016B\u00010\u001d\u0005\u0015\t%O]1z!\t\t\u0003-\u0003\u0002b9\t\u0019\u0011J\u001c;\t\u000b\rT\u0001\u0019\u0001/\u0002\u0005\u0005\u001c\b\"B3\u000b\u0001\u0004y\u0016AA5y\u0011\u00159'\u00021\u0001`\u0003\u0011)G.Z7\u0002\u0017%t7/\u001a:u-\u0006dW/Z\u000b\u0003UV$bAR6n_F\u001c\b\"\u00027\f\u0001\u0004y\u0014A\u00012n\u0011\u0015q7\u00021\u0001`\u0003\u0019\u0011\u0017\u000e\u001e9pg\")\u0001o\u0003a\u0001U\u0005\u00191.Z=\t\u000bI\\\u0001\u0019A0\u0002\u0019=\u0014\u0018nZ5oC2D\u0015m\u001d5\t\u000bQ\\\u0001\u0019A0\u0002\u000f-,\u0017\u0010S1tQ\u0012)ao\u0003b\u0001o\n\u0011\u0011)M\t\u0003UM\nQB]3n_Z,W\t\\3nK:$Hc\u0001/{w\")1\r\u0004a\u00019\")Q\r\u0004a\u0001?\u00069R.[4sCR,gI]8n\u0013:d\u0017N\\3U_:{G-\u001a\u000b\b\rz|\u00181AA\u0003\u0011\u0015aW\u00021\u0001@\u0011\u0019\t\t!\u0004a\u0001?\u0006YQ\r\\3nK:$\b*Y:i\u0011\u0015qW\u00021\u0001`\u0011\u0019\t9!\u0004a\u0001'\u0006!an\u001c3f\u0003!\u0019X\r\u001e,bYV,W\u0003BA\u0007\u0003+!rARA\b\u0003#\t\u0019\u0002C\u0003m\u001d\u0001\u0007q\bC\u0003o\u001d\u0001\u0007q\fC\u0003h\u001d\u0001\u0007!\u0006B\u0003w\u001d\t\u0007q/\u0001\u0004va\u0012\fG/\u001a\u000b\f\r\u0006m\u0011qDA\u0012\u0003K\t9\u0003\u0003\u0004\u0002\u001e=\u0001\raU\u0001\bg\u0016$hj\u001c3f\u0011\u0019\t\tc\u0004a\u0001U\u00059Q\r\\3nK:$\b\"\u0002:\u0010\u0001\u0004y\u0006BBA\u0001\u001f\u0001\u0007q\f\u0003\u0004\u0002*=\u0001\raX\u0001\u0006g\"Lg\r^\u0001\u0010K:\u001cXO]3V]\u0006d\u0017.Y:fIR\ta)A\u0005d_BLX\t\\3ng\u00061!/Z:vYR$\u0012AN\u0001\u0007C\u0012$wJ\\3\u0015\t\u0005e\u00121H\u0007\u0002\u0001!)qm\u0005a\u0001U\u00051\u0011\r\u001a3BY2$B!!\u000f\u0002B!9\u00111\t\u000bA\u0002\u0005\u0015\u0013A\u0001=t!\u0015\t9%!\u0013+\u001b\u0005Q\u0012bAA&5\ta\u0011\n^3sC\ndWm\u00148dK\u0006)1\r\\3be\u0006!1/\u001b>f+\u0005y\u0006")
public final class HashSetBuilder<A>
implements Builder<A, HashSet<A>> {
    private HashSet<A> aliased;
    private SetNode<A> scala$collection$immutable$HashSetBuilder$$rootNode = this.newEmptyRootNode();

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public final int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<HashSet<A>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public final Growable<A> $plus$eq(A elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable<A> $plus$eq(A elem1, A elem2, Seq<A> elems) {
        return Growable.$plus$eq$(this, elem1, elem2, elems);
    }

    @Override
    public final Growable<A> $plus$plus$eq(IterableOnce<A> xs) {
        return Growable.$plus$plus$eq$(this, xs);
    }

    private BitmapIndexedSetNode<A> newEmptyRootNode() {
        return new BitmapIndexedSetNode(0, 0, (Object[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Any()), (int[])Array$.MODULE$.apply(Nil$.MODULE$, ClassTag$.MODULE$.Int()), 0, 0);
    }

    private HashSet<A> aliased() {
        return this.aliased;
    }

    private void aliased_$eq(HashSet<A> x$1) {
        this.aliased = x$1;
    }

    private boolean isAliased() {
        return this.aliased() != null;
    }

    public SetNode<A> scala$collection$immutable$HashSetBuilder$$rootNode() {
        return this.scala$collection$immutable$HashSetBuilder$$rootNode;
    }

    private void scala$collection$immutable$HashSetBuilder$$rootNode_$eq(SetNode<A> x$1) {
        this.scala$collection$immutable$HashSetBuilder$$rootNode = x$1;
    }

    private int[] insertElement(int[] as, int ix, int elem) {
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length + 1];
        System.arraycopy(as, 0, result, 0, ix);
        result[ix] = elem;
        System.arraycopy(as, ix, result, ix + 1, as.length - ix);
        return result;
    }

    private <A1> void insertValue(BitmapIndexedSetNode<A> bm, int bitpos, A key, int originalHash, int keyHash) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 1 * dataIx;
        Object[] src = bm.content();
        Object[] dst = new Object[src.length + 1];
        System.arraycopy(src, 0, dst, 0, idx);
        dst[idx] = key;
        System.arraycopy(src, idx, dst, idx + 1, src.length - idx);
        int[] dstHashes = this.insertElement(bm.originalHashes(), dataIx, originalHash);
        bm.dataMap_$eq(bm.dataMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() + 1);
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() + keyHash);
    }

    /*
     * WARNING - void declaration
     */
    private int[] removeElement(int[] as, int ix) {
        void var3_3;
        if (ix < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (ix > as.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int[] result = new int[as.length - 1];
        System.arraycopy(as, 0, result, 0, ix);
        System.arraycopy(as, ix + 1, result, ix, as.length - ix - 1);
        return var3_3;
    }

    private void migrateFromInlineToNode(BitmapIndexedSetNode<A> bm, int elementHash, int bitpos, SetNode<A> node) {
        int dataIx = bm.dataIndex(bitpos);
        int idxOld = 1 * dataIx;
        int idxNew = bm.content().length - 1 - bm.nodeIndex(bitpos);
        Object[] src = bm.content();
        Object[] dst = new Object[src.length - 1 + 1];
        System.arraycopy(src, 0, dst, 0, idxOld);
        System.arraycopy(src, idxOld + 1, dst, idxOld, idxNew - idxOld);
        dst[idxNew] = node;
        System.arraycopy(src, idxNew + 1, dst, idxNew + 1, src.length - idxNew - 1);
        int[] dstHashes = this.removeElement(bm.originalHashes(), dataIx);
        bm.dataMap_$eq(bm.dataMap() ^ bitpos);
        bm.nodeMap_$eq(bm.nodeMap() | bitpos);
        bm.content_$eq(dst);
        bm.originalHashes_$eq(dstHashes);
        bm.size_$eq(bm.size() - 1 + node.size());
        bm.cachedJavaKeySetHashCode_$eq(bm.cachedJavaKeySetHashCode() - elementHash + node.cachedJavaKeySetHashCode());
    }

    private <A1> void setValue(BitmapIndexedSetNode<A> bm, int bitpos, A elem) {
        int dataIx = bm.dataIndex(bitpos);
        int idx = 1 * dataIx;
        bm.content()[idx] = elem;
    }

    public void update(SetNode<A> setNode, A element, int originalHash, int elementHash, int shift) {
        if (setNode instanceof BitmapIndexedSetNode) {
            BitmapIndexedSetNode bitmapIndexedSetNode = (BitmapIndexedSetNode)setNode;
            int n = elementHash >>> shift & 0x1F;
            int n2 = 1 << n;
            if ((bitmapIndexedSetNode.dataMap() & n2) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedSetNode.dataMap(), n, n2);
                Object object = bitmapIndexedSetNode.content()[1 * index];
                int n3 = bitmapIndexedSetNode.originalHashes()[index];
                if (n3 == originalHash && BoxesRunTime.equals(object, element)) {
                    this.setValue(bitmapIndexedSetNode, n2, object);
                    return;
                }
                int element0Hash = Hashing$.MODULE$.improve(n3);
                SetNode<Object> subNodeNew = bitmapIndexedSetNode.mergeTwoKeyValPairs(object, n3, element0Hash, element, originalHash, elementHash, shift + 5);
                this.migrateFromInlineToNode(bitmapIndexedSetNode, element0Hash, n2, subNodeNew);
                return;
            }
            if ((bitmapIndexedSetNode.nodeMap() & n2) != 0) {
                int index = Node$.MODULE$.indexFrom(bitmapIndexedSetNode.nodeMap(), n, n2);
                Node subNode = bitmapIndexedSetNode.getNode(index);
                int beforeSize = ((SetNode)subNode).size();
                int beforeHashCode = subNode.cachedJavaKeySetHashCode();
                this.update((SetNode<A>)subNode, element, originalHash, elementHash, shift + 5);
                bitmapIndexedSetNode.size_$eq(bitmapIndexedSetNode.size() + (((SetNode)subNode).size() - beforeSize));
                bitmapIndexedSetNode.cachedJavaKeySetHashCode_$eq(bitmapIndexedSetNode.cachedJavaKeySetHashCode() + (subNode.cachedJavaKeySetHashCode() - beforeHashCode));
                return;
            }
            this.insertValue(bitmapIndexedSetNode, n2, element, originalHash, elementHash);
            return;
        }
        if (setNode instanceof HashCollisionSetNode) {
            HashCollisionSetNode hashCollisionSetNode = (HashCollisionSetNode)setNode;
            Vector<Object> vector = hashCollisionSetNode.content();
            if (vector == null) {
                throw null;
            }
            int n = SeqOps.indexOf$(vector, element);
            if (n < 0) {
                hashCollisionSetNode.content_$eq((Vector<Object>)hashCollisionSetNode.content().appended(element));
                return;
            }
            Vector<Object> vector2 = hashCollisionSetNode.content();
            if (vector2 == null) {
                throw null;
            }
            hashCollisionSetNode.content_$eq(vector2.updateAt(n, element));
            return;
        }
        throw new MatchError(setNode);
    }

    private void ensureUnaliased() {
        if (this.isAliased()) {
            this.copyElems();
        }
        this.aliased_$eq(null);
    }

    private void copyElems() {
        this.scala$collection$immutable$HashSetBuilder$$rootNode_$eq(this.scala$collection$immutable$HashSetBuilder$$rootNode().copy());
    }

    @Override
    public HashSet<A> result() {
        if (this.scala$collection$immutable$HashSetBuilder$$rootNode().size() == 0) {
            return HashSet$.MODULE$.empty();
        }
        if (this.aliased() != null) {
            return this.aliased();
        }
        this.aliased_$eq(new HashSet<A>(this.scala$collection$immutable$HashSetBuilder$$rootNode()));
        Statics.releaseFence();
        return this.aliased();
    }

    @Override
    public HashSetBuilder<A> addOne(A elem) {
        this.ensureUnaliased();
        int h = Statics.anyHash(elem);
        int im = Hashing$.MODULE$.improve(h);
        this.update(this.scala$collection$immutable$HashSetBuilder$$rootNode(), elem, h, im, 0);
        return this;
    }

    @Override
    public HashSetBuilder<A> addAll(IterableOnce<A> xs) {
        this.ensureUnaliased();
        if (xs instanceof HashSet) {
            HashSet hashSet = (HashSet)xs;
            new ChampBaseIterator<SetNode<A>>(this, hashSet){
                {
                    while (this.hasNext()) {
                        int originalHash = ((Node)this.currentValueNode()).getHash(this.currentValueCursor());
                        $outer.update($outer.scala$collection$immutable$HashSetBuilder$$rootNode(), ((SetNode)this.currentValueNode()).getPayload(this.currentValueCursor()), originalHash, Hashing$.MODULE$.improve(originalHash), 0);
                        this.currentValueCursor_$eq(this.currentValueCursor() + 1);
                    }
                }
            };
        } else {
            Iterator<A> it = xs.iterator();
            while (it.hasNext()) {
                this.addOne((Object)it.next());
            }
        }
        return this;
    }

    @Override
    public void clear() {
        this.aliased_$eq(null);
        if (this.scala$collection$immutable$HashSetBuilder$$rootNode().size() > 0) {
            this.scala$collection$immutable$HashSetBuilder$$rootNode_$eq(this.newEmptyRootNode());
        }
    }

    public int size() {
        return this.scala$collection$immutable$HashSetBuilder$$rootNode().size();
    }
}

