/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterator;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Searching;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.IndexedSeqOps;
import scala.collection.immutable.NumericRange$;
import scala.collection.mutable.Builder;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Numeric$BigDecimalAsIfIntegral$;
import scala.math.Numeric$BigIntIsIntegral$;
import scala.math.Numeric$ByteIsIntegral$;
import scala.math.Numeric$CharIsIntegral$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Numeric$ShortIsIntegral$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\r%f\u0001B&M!MC\u0001b\u001c\u0001\u0003\u0006\u0004%\t\u0001\u001d\u0005\tc\u0002\u0011\t\u0011)A\u00053\"A!\u000f\u0001BC\u0002\u0013\u0005\u0001\u000f\u0003\u0005t\u0001\t\u0005\t\u0015!\u0003Z\u0011!!\bA!b\u0001\n\u0003\u0001\b\u0002C;\u0001\u0005\u0003\u0005\u000b\u0011B-\t\u0011Y\u0004!Q1A\u0005\u0002]D\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001\u001f\u0005\ty\u0002\u0011\t\u0011)A\u0006{\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0001bBA\u0013\u0001\u0011\u0005\u0013q\u0005\u0005\u000b\u0003c\u0001\u0001R1A\u0005B\u0005M\u0002BBA\u001e\u0001\u0011\u0005s\u000f\u0003\u0004\u0002>\u0001!\t\u0005\u001d\u0005\b\u0003\u007f\u0001A\u0011IA!\u0011\u0019\t\u0019\u0005\u0001C!a\"9\u0011Q\t\u0001\u0005B\u0005\u0005\u0003bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003\u001f\u0002A\u0011AA)\u0011\u001d\tI\u0006\u0001C\u0001\u00037Bq!a*\u0001\t\u0003\nI\u000bC\u0004\u0002V\u0002!I!a6\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\"9\u0011Q\u001d\u0001\u0005\n\u0005\u001d\bbBB\u0013\u0001\u0011\u00053q\u0005\u0005\b\u0007W\u0001A\u0011IB\u0017\u0011\u001d\u0019\t\u0004\u0001C!\u0007gAqa!\u0010\u0001\t\u0003\n\t\u0005C\u0004\u0004@\u0001!\te!\u0011\t\u000f\rU\u0003\u0001\"\u0011\u0004X!911\r\u0001\u0005\u0002\r\u0015\u0004bBB6\u0001\u0011\u00053Q\u000e\u0005\b\u0007s\u0002A\u0011IB>\u0011)\u0019Y\t\u0001EC\u0002\u0013\u0005\u00131\u0007\u0005\b\u0007\u001b\u0003AQKA\u001a\u0011\u001d\u0019y\t\u0001C!\u0007#Cqaa&\u0001\t\u0003\u001aI\n\u0003\u0005\u0004\u0014\u0001\u0001K\u0011KBP\u0011!\u0019\t\u000b\u0001Q\u0005R\r\rvaBAw\u0019\"\u0005\u0011q\u001e\u0004\u0007\u00172C\t!!=\t\u000f\u0005M\u0011\u0006\"\u0001\u0003\n!9!1B\u0015\u0005\u0002\t5aA\u0002B\u0012S\u0001\u0011)\u0003\u0003\u0006pY\t\u0005\t\u0015!\u0003\u0003,\u0005A!B\u001d\u0017\u0003\u0002\u0003\u0006IAa\u000b\u0004\u0011)!HF!A!\u0002\u0013\u0011Y#\u0002\u0005\ny2\u0012\t\u0011)A\u0006\u0005_Aq!a\u0005-\t\u0003\u0011\t\u0004C\u0004\u0002P1\"\tE!\u0011\t\u000f\t%C\u0006\"\u0001\u0003L\u00191!qJ\u0015\u0001\u0005#B!b\u001c\u001b\u0003\u0002\u0003\u0006IAa\u0016\u0002\u0011)\u0011HG!A!\u0002\u0013\u00119f\u0001\u0005\u000biR\u0012\t\u0011)A\u0005\u0005/*\u0001\"\u0003?5\u0005\u0003\u0005\u000b1\u0002B.\u0011\u001d\t\u0019\u0002\u000eC\u0001\u0005;Bq!a\u00145\t\u0003\u0012Y\u0007C\u0004\u0003tQ\"\tA!\u001e\t\u000f\u0005e\u0013\u0006\"\u0001\u0003\b\"9!1O\u0015\u0005\u0002\tu\u0005B\u0003BZS\t\u0007I\u0011\u0001(\u00036\"A!\u0011[\u0015!\u0002\u0013\u00119L\u0002\u0004\u0003b&2!1\u001d\u0005\u000b\u0005k\u0004%\u0011!Q\u0001\n\t]\b\"\u0003?A\u0005\u0003\u0005\u000b\u0011\u0002B}\u0011\u001d\t\u0019\u0002\u0011C\u0001\u0005wDqaa\u0001AA\u0003&\u0001\u0010\u0003\u0005\u0004\u0006\u0001\u0003\u000b\u0015\u0002Bw\u0011!\u00199\u0001\u0011Q\u0001\n\t5\bbBB\u0005\u0001\u0012\u0005\u00131\u0007\u0005\u0007\u0007\u0017\u0001E\u0011A<\t\u000f\r5\u0001\t\"\u0001\u0004\u0010!I11C\u0015\u0002\u0002\u0013%1Q\u0003\u0002\r\u001dVlWM]5d%\u0006tw-\u001a\u0006\u0003\u001b:\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005=\u0003\u0016AC2pY2,7\r^5p]*\t\u0011+A\u0003tG\u0006d\u0017m\u0001\u0001\u0016\u0005Q[6#\u0002\u0001VK\"d\u0007c\u0001,X36\tA*\u0003\u0002Y\u0019\nY\u0011IY:ue\u0006\u001cGoU3r!\tQ6\f\u0004\u0001\u0005\u000bq\u0003!\u0019A/\u0003\u0003Q\u000b\"A\u00182\u0011\u0005}\u0003W\"\u0001)\n\u0005\u0005\u0004&a\u0002(pi\"Lgn\u001a\t\u0003?\u000eL!\u0001\u001a)\u0003\u0007\u0005s\u0017\u0010E\u0002WMfK!a\u001a'\u0003\u0015%sG-\u001a=fIN+\u0017\u000fE\u0003WSf[W-\u0003\u0002k\u0019\ni\u0011J\u001c3fq\u0016$7+Z9PaN\u0004\"A\u00164\u0011\u000bYk\u0017l[3\n\u00059d%!F*ue&\u001cGo\u00149uS6L'0\u001a3TKF|\u0005o]\u0001\u0006gR\f'\u000f^\u000b\u00023\u000611\u000f^1si\u0002\n1!\u001a8e\u0003\u0011)g\u000e\u001a\u0011\u0002\tM$X\r]\u0001\u0006gR,\u0007\u000fI\u0001\fSNLen\u00197vg&4X-F\u0001y!\ty\u00160\u0003\u0002{!\n9!i\\8mK\u0006t\u0017\u0001D5t\u0013:\u001cG.^:jm\u0016\u0004\u0013a\u00018v[B!a0!\u0004Z\u001d\ry\u0018\u0011\u0002\b\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001*\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0016bAA\u0006!\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\b\u0003#\u0011\u0001\"\u00138uK\u001e\u0014\u0018\r\u001c\u0006\u0004\u0003\u0017\u0001\u0016A\u0002\u001fj]&$h\b\u0006\u0006\u0002\u0018\u0005u\u0011qDA\u0011\u0003G!B!!\u0007\u0002\u001cA\u0019a\u000bA-\t\u000bqT\u00019A?\t\u000b=T\u0001\u0019A-\t\u000bIT\u0001\u0019A-\t\u000bQT\u0001\u0019A-\t\u000bYT\u0001\u0019\u0001=\u0002\u0011%$XM]1u_J,\"!!\u000b\u0011\u000b\u0005-\u0012QF-\u000e\u00039K1!a\fO\u0005!IE/\u001a:bi>\u0014\u0018A\u00027f]\u001e$\b.\u0006\u0002\u00026A\u0019q,a\u000e\n\u0007\u0005e\u0002KA\u0002J]R\fq![:F[B$\u00180\u0001\u0003mCN$\u0018\u0001B5oSR,\"!!\u0007\u0002\t!,\u0017\rZ\u0001\u0005i\u0006LG.\u0001\u0002csR!\u0011\u0011DA&\u0011\u0019\tiE\u0005a\u00013\u00069a.Z<Ti\u0016\u0004\u0018\u0001B2paf$\u0002\"!\u0007\u0002T\u0005U\u0013q\u000b\u0005\u0006_N\u0001\r!\u0017\u0005\u0006eN\u0001\r!\u0017\u0005\u0006iN\u0001\r!W\u0001\u0006CB\u0004H.\u001f\u000b\u00043\u0006u\u0003bBA0)\u0001\u0007\u0011QG\u0001\u0004S\u0012D\b&\u0002\u000b\u0002d\u0005=\u0004#B0\u0002f\u0005%\u0014bAA4!\n1A\u000f\u001b:poN\u00042A`A6\u0013\u0011\ti'!\u0005\u00033%sG-\u001a=PkR|eMQ8v]\u0012\u001cX\t_2faRLwN\\\u0019\b=\u0005E\u0014\u0011QAS!\u0011\t\u0019(a\u001f\u000f\t\u0005U\u0014q\u000f\t\u0004\u0003\u0003\u0001\u0016bAA=!\u00061\u0001K]3eK\u001aLA!! \u0002\u0000\t11\u000b\u001e:j]\u001eT1!!\u001fQc%\u0019\u00131QAE\u00037\u000bY)\u0006\u0003\u0002\u0006\u0006\u001dUCAA9\t\u0019a&K1\u0001\u0002\u0012&!\u00111RAG\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011q\u0012)\u0002\rQD'o\\<t#\rq\u00161\u0013\t\u0005\u0003+\u000b9JD\u0002`\u0003\u0013IA!!'\u0002\u0012\tIA\u000b\u001b:po\u0006\u0014G.Z\u0019\nG\u0005u\u0015qTAQ\u0003\u001fs1aXAP\u0013\r\ty\tU\u0019\u0006E}\u0003\u00161\u0015\u0002\u0006g\u000e\fG.Y\u0019\u0004M\u0005%\u0014a\u00024pe\u0016\f7\r[\u000b\u0005\u0003W\u000by\f\u0006\u0003\u0002.\u0006M\u0006cA0\u00020&\u0019\u0011\u0011\u0017)\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003k+\u0002\u0019AA\\\u0003\u00051\u0007CB0\u0002:f\u000bi,C\u0002\u0002<B\u0013\u0011BR;oGRLwN\\\u0019\u0011\u0007i\u000by\f\u0002\u0006\u0002BV\u0001\u000b\u0011!AC\u0002u\u0013\u0011!\u0016\u0015\u0007\u0003\u007f\u000b)-a3\u0011\u0007}\u000b9-C\u0002\u0002JB\u00131b\u001d9fG&\fG.\u001b>fIFJ1%!4\u0002P\u0006M\u0017\u0011\u001b\b\u0004?\u0006=\u0017bAAi!\u0006!QK\\5uc\u0015!s0a\u0002R\u0003II7oV5uQ&t'i\\;oI\u0006\u0014\u0018.Z:\u0015\u0007a\fI\u000e\u0003\u0004\u0002\\Z\u0001\r!W\u0001\u0005K2,W.\u0001\bm_\u000e\fG/[8o\u0003\u001a$XM\u001d(\u0015\u0007e\u000b\t\u000fC\u0004\u0002d^\u0001\r!!\u000e\u0002\u00039\fQB\\3x\u000b6\u0004H/\u001f*b]\u001e,G\u0003BAu\u0007G\u0001B!a;53:\u0011a\u000bK\u0001\r\u001dVlWM]5d%\u0006tw-\u001a\t\u0003-&\u001aR!KAz\u0003s\u00042aXA{\u0013\r\t9\u0010\u0015\u0002\u0007\u0003:L(+\u001a4\u0011\t\u0005m(QA\u0007\u0003\u0003{TA!a@\u0003\u0002\u0005\u0011\u0011n\u001c\u0006\u0003\u0005\u0007\tAA[1wC&!!qAA\u007f\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\ty/A\u0003d_VtG/\u0006\u0003\u0003\u0010\teAC\u0003B\t\u00057\u0011iBa\b\u0003\"Q!\u0011Q\u0007B\n\u0011\u0019a8\u0006q\u0001\u0003\u0016A)a0!\u0004\u0003\u0018A\u0019!L!\u0007\u0005\u000bq[#\u0019A/\t\r=\\\u0003\u0019\u0001B\f\u0011\u0019\u00118\u00061\u0001\u0003\u0018!1Ao\u000ba\u0001\u0005/AQA^\u0016A\u0002a\u0014\u0011\"\u00138dYV\u001c\u0018N^3\u0016\t\t\u001d\"QF\n\u0004Y\t%\u0002\u0003\u0002,\u0001\u0005W\u00012A\u0017B\u0017\t\u0015aFF1\u0001^!\u0015q\u0018Q\u0002B\u0016)!\u0011\u0019Da\u000f\u0003>\t}B\u0003\u0002B\u001b\u0005s\u0001RAa\u000e-\u0005Wi\u0011!\u000b\u0005\u0007yF\u0002\u001dAa\f\t\r=\f\u0004\u0019\u0001B\u0016\u0011\u0019\u0011\u0018\u00071\u0001\u0003,!1A/\ra\u0001\u0005W!\u0002B!\u000e\u0003D\t\u0015#q\t\u0005\u0007_J\u0002\rAa\u000b\t\rI\u0014\u0004\u0019\u0001B\u0016\u0011\u0019!(\u00071\u0001\u0003,\u0005IQ\r_2mkNLg/Z\u000b\u0003\u0005\u001b\u0002RAa\u000e5\u0005W\u0011\u0011\"\u0012=dYV\u001c\u0018N^3\u0016\t\tM#\u0011L\n\u0004i\tU\u0003\u0003\u0002,\u0001\u0005/\u00022A\u0017B-\t\u0015aFG1\u0001^!\u0015q\u0018Q\u0002B,)!\u0011yF!\u001a\u0003h\t%D\u0003\u0002B1\u0005G\u0002RAa\u000e5\u0005/Ba\u0001`\u001dA\u0004\tm\u0003BB8:\u0001\u0004\u00119\u0006\u0003\u0004ss\u0001\u0007!q\u000b\u0005\u0007if\u0002\rAa\u0016\u0015\u0011\t\u0005$Q\u000eB8\u0005cBaa\u001c\u001eA\u0002\t]\u0003B\u0002:;\u0001\u0004\u00119\u0006\u0003\u0004uu\u0001\u0007!qK\u0001\nS:\u001cG.^:jm\u0016,\"Aa\u001e\u0011\u000b\t]BFa\u0016)\u000fQ\u0012YH!!\u0003\u0004B\u0019qL! \n\u0007\t}\u0004K\u0001\tTKJL\u0017\r\u001c,feNLwN\\+J\t\u0006)a/\u00197vKz\t1\u0001K\u0004-\u0005w\u0012\tIa!\u0016\t\t%%\u0011\u0013\u000b\t\u0005\u0017\u00139J!'\u0003\u001cR!!Q\u0012BJ!\u0015\u00119\u0004\u000eBH!\rQ&\u0011\u0013\u0003\u00069r\u0012\r!\u0018\u0005\u0007yr\u0002\u001dA!&\u0011\u000by\fiAa$\t\r=d\u0004\u0019\u0001BH\u0011\u0019\u0011H\b1\u0001\u0003\u0010\"1A\u000f\u0010a\u0001\u0005\u001f+BAa(\u0003(RA!\u0011\u0015BW\u0005_\u0013\t\f\u0006\u0003\u0003$\n%\u0006#\u0002B\u001cY\t\u0015\u0006c\u0001.\u0003(\u0012)A,\u0010b\u0001;\"1A0\u0010a\u0002\u0005W\u0003RA`A\u0007\u0005KCaa\\\u001fA\u0002\t\u0015\u0006B\u0002:>\u0001\u0004\u0011)\u000b\u0003\u0004u{\u0001\u0007!QU\u0001\u0010I\u00164\u0017-\u001e7u\u001fJ$WM]5oOV\u0011!q\u0017\t\b-\ne&Q\u0018Bj\u0013\r\u0011Y\f\u0014\u0002\u0004\u001b\u0006\u0004\b\u0007\u0002B`\u0005\u001b\u0004bA!1\u0003H\n-WB\u0001Bb\u0015\r\u0011)\rU\u0001\u0005[\u0006$\b.\u0003\u0003\u0003J\n\r'a\u0002(v[\u0016\u0014\u0018n\u0019\t\u00045\n5GA\u0003Bh\u007f\u0005\u0005\t\u0011!B\u0001;\n\u0019q\fJ\u0019\u0002!\u0011,g-Y;mi>\u0013H-\u001a:j]\u001e\u0004\u0003\u0007\u0002Bk\u0005;\u0004bA!1\u0003X\nm\u0017\u0002\u0002Bm\u0005\u0007\u0014\u0001b\u0014:eKJLgn\u001a\t\u00045\nuGA\u0003Bp\u007f\u0005\u0005\t\u0011!B\u0001;\n\u0019q\f\n\u001a\u0003)9+X.\u001a:jGJ\u000bgnZ3Ji\u0016\u0014\u0018\r^8s+\u0011\u0011)Oa<\u0014\u000b\u0001\u00139O!=\u0011\r\u0005-\"\u0011\u001eBw\u0013\r\u0011YO\u0014\u0002\u0011\u0003\n\u001cHO]1di&#XM]1u_J\u00042A\u0017Bx\t\u0015a\u0006I1\u0001^!\rq(1_\u0005\u0005\u0005\u000f\t\t\"\u0001\u0003tK24\u0007\u0003\u0002,\u0001\u0005[\u0004RA`A\u0007\u0005[$bA!@\u0003\u0000\u000e\u0005\u0001#\u0002B\u001c\u0001\n5\bb\u0002B{\u0007\u0002\u0007!q\u001f\u0005\u0007y\u000e\u0003\rA!?\u0002\u0011}C\u0017m\u001d(fqR\fQa\u00188fqR\f1\u0002\\1ti\u0016cW-\\3oi\u0006I1N\\8x]NK'0Z\u0001\bQ\u0006\u001ch*\u001a=u\u0003\u0011qW\r\u001f;\u0015\u0005\t5\bf\u0002!\u0003|\t\u0005%1Q\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0007/\u0001Ba!\u0007\u0004 5\u001111\u0004\u0006\u0005\u0007;\u0011\t!\u0001\u0003mC:<\u0017\u0002BB\u0011\u00077\u0011aa\u00142kK\u000e$\bB\u0002BA1\u0001\u0007\u0011,\u0001\u0003uC.,G\u0003BA\r\u0007SAq!a9\u001a\u0001\u0004\t)$\u0001\u0003ee>\u0004H\u0003BA\r\u0007_Aq!a9\u001b\u0001\u0004\t)$A\u0004ta2LG/\u0011;\u0015\t\rU21\b\t\b?\u000e]\u0012\u0011DA\r\u0013\r\u0019I\u0004\u0015\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005\r8\u00041\u0001\u00026\u00059!/\u001a<feN,\u0017aA7j]V!11IB()\rI6Q\t\u0005\b\u0007\u000fj\u00029AB%\u0003\ry'\u000f\u001a\t\u0006}\u000e-3QJ\u0005\u0005\u00053\f\t\u0002E\u0002[\u0007\u001f\"qa!\u0015\u001e\u0005\u0004\u0019\u0019F\u0001\u0002UcE\u0011\u0011LY\u0001\u0004[\u0006DX\u0003BB-\u0007C\"2!WB.\u0011\u001d\u00199E\ba\u0002\u0007;\u0002RA`B&\u0007?\u00022AWB1\t\u001d\u0019\tF\bb\u0001\u0007'\nQbY8oi\u0006Lgn\u001d+za\u0016$Gc\u0001=\u0004h!11\u0011N\u0010A\u0002e\u000b\u0011\u0001_\u0001\tG>tG/Y5ogV!1qNB;)\rA8\u0011\u000f\u0005\b\u0007S\u0002\u0003\u0019AB:!\rQ6Q\u000f\u0003\b\u0007o\u0002#\u0019AB*\u0005\t\t\u0015'A\u0002tk6,Ba! \u0004\u0002R!1qPBC!\rQ6\u0011\u0011\u0003\b\u0007\u0007\u000b#\u0019AB*\u0005\u0005\u0011\u0005B\u0002?\"\u0001\b\u00199\tE\u0003\u007f\u0007\u0013\u001by(\u0003\u0003\u0003J\u0006E\u0011\u0001\u00035bg\"\u001cu\u000eZ3\u0002/\u0005\u0004\b\u000f\\=Qe\u00164WM\u001d:fI6\u000b\u0007\u0010T3oORD\u0017AB3rk\u0006d7\u000fF\u0002y\u0007'Caa!&%\u0001\u0004\u0011\u0017!B8uQ\u0016\u0014\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\rm\u0005\u0003BB\r\u0007;KA!! \u0004\u001cQ\u0011\u00111_\u0001\nG2\f7o\u001d(b[\u0016,\"aa'*\u0007\u0001!D\u0006K\u0004\u0001\u0005w\u0012\tIa!")
public class NumericRange<T>
extends AbstractSeq<T>
implements scala.collection.immutable.IndexedSeq<T>,
scala.collection.immutable.StrictOptimizedSeqOps<T, scala.collection.immutable.IndexedSeq, scala.collection.immutable.IndexedSeq<T>> {
    private static final long serialVersionUID = 3L;
    private int length;
    private int hashCode;
    private final T start;
    private final T end;
    private final T step;
    private final boolean isInclusive;
    public final Integral<T> scala$collection$immutable$NumericRange$$num;
    private volatile byte bitmap$0;

    public static <T> Inclusive<T> inclusive(T t, T t2, T t3, Integral<T> integral) {
        return new Inclusive<T>(t, t2, t3, integral);
    }

    @Override
    public Object distinctBy(Function1 f) {
        return scala.collection.immutable.StrictOptimizedSeqOps.distinctBy$(this, f);
    }

    @Override
    public Object updated(int index, Object elem) {
        return scala.collection.immutable.StrictOptimizedSeqOps.updated$(this, index, elem);
    }

    @Override
    public Object patch(int from, IterableOnce other, int replaced) {
        return scala.collection.immutable.StrictOptimizedSeqOps.patch$(this, from, other, replaced);
    }

    @Override
    public Object prepended(Object elem) {
        return StrictOptimizedSeqOps.prepended$(this, elem);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object appendedAll(IterableOnce suffix) {
        return StrictOptimizedSeqOps.appendedAll$(this, suffix);
    }

    @Override
    public Object prependedAll(IterableOnce prefix) {
        return StrictOptimizedSeqOps.prependedAll$(this, prefix);
    }

    @Override
    public Object padTo(int len, Object elem) {
        return StrictOptimizedSeqOps.padTo$(this, len, elem);
    }

    @Override
    public Tuple2<scala.collection.immutable.IndexedSeq<T>, scala.collection.immutable.IndexedSeq<T>> partition(Function1<T, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<scala.collection.immutable.IndexedSeq<T>, scala.collection.immutable.IndexedSeq<T>> span(Function1<T, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>> unzip(Function1<T, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>, scala.collection.immutable.IndexedSeq<A3>> unzip3(Function1<T, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<T, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<T, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public Object concat(IterableOnce suffix) {
        return StrictOptimizedIterableOps.concat$(this, suffix);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<T, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<T, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<T, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>> partitionWith(Function1<T, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionWith$(this, f);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
        return Seq.canEqual$(this, that);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce that) {
        return SeqOps.sameElements$(this, that);
    }

    @Override
    public final scala.collection.immutable.IndexedSeq<T> toIndexedSeq() {
        return scala.collection.immutable.IndexedSeq.toIndexedSeq$(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return scala.collection.immutable.IndexedSeq.canEqual$(this, that);
    }

    @Override
    public <B> boolean sameElements(IterableOnce<B> o) {
        return scala.collection.immutable.IndexedSeq.sameElements$(this, o);
    }

    @Override
    public SeqFactory<?> iterableFactory() {
        return scala.collection.immutable.IndexedSeq.iterableFactory$(this);
    }

    @Override
    public /* synthetic */ Object scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
        return scala.collection.IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public Object slice(int from, int until) {
        return IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public String stringPrefix() {
        return IndexedSeq.stringPrefix$(this);
    }

    @Override
    public Iterator<T> reverseIterator() {
        return scala.collection.IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public IndexedSeqView<T> view() {
        return scala.collection.IndexedSeqOps.view$(this);
    }

    @Override
    public Iterable<T> reversed() {
        return scala.collection.IndexedSeqOps.reversed$(this);
    }

    @Override
    public Object takeRight(int n) {
        return scala.collection.IndexedSeqOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return scala.collection.IndexedSeqOps.dropRight$(this, n);
    }

    @Override
    public final int lengthCompare(int len) {
        return scala.collection.IndexedSeqOps.lengthCompare$(this, len);
    }

    @Override
    public final int knownSize() {
        return scala.collection.IndexedSeqOps.knownSize$(this);
    }

    @Override
    public final int sizeCompare(Iterable<?> that) {
        return scala.collection.IndexedSeqOps.sizeCompare$(this, that);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
        return scala.collection.IndexedSeqOps.search$(this, elem, ord);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
        return scala.collection.IndexedSeqOps.search$(this, elem, from, to, ord);
    }

    public T start() {
        return this.start;
    }

    public T end() {
        return this.end;
    }

    public T step() {
        return this.step;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    @Override
    public Iterator<T> iterator() {
        return new NumericRangeIterator<T>(this, this.scala$collection$immutable$NumericRange$$num);
    }

    private int length$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.length = NumericRange$.MODULE$.count(this.start(), this.end(), this.step(), this.isInclusive(), this.scala$collection$immutable$NumericRange$$num);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.length;
    }

    @Override
    public int length() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.length$lzycompute();
        }
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public T last() {
        if (this.length() == 0) {
            throw new NoSuchElementException("head of empty list");
        }
        return this.locationAfterN(this.length() - 1);
    }

    @Override
    public NumericRange<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty list");
        }
        return new NumericRange<T>(this.start(), this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.end()).$minus(this.step()), this.step(), this.isInclusive(), this.scala$collection$immutable$NumericRange$$num);
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty list");
        }
        return this.start();
    }

    @Override
    public NumericRange<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty list");
        }
        if (this.isInclusive()) {
            return new Inclusive(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.scala$collection$immutable$NumericRange$$num);
        }
        return new Exclusive(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.scala$collection$immutable$NumericRange$$num);
    }

    public NumericRange<T> by(T newStep) {
        return this.copy(this.start(), this.end(), newStep);
    }

    public NumericRange<T> copy(T start, T end, T step) {
        return new NumericRange<T>(start, end, step, this.isInclusive(), this.scala$collection$immutable$NumericRange$$num);
    }

    @Override
    public T apply(int idx) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(this.length() - 1).append(")").toString());
        }
        return this.locationAfterN(idx);
    }

    @Override
    public <U> void foreach(Function1<T, U> f) {
        T current = this.start();
        for (int count = 0; count < this.length(); ++count) {
            f.apply(current);
            current = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(current).$plus(this.step());
        }
    }

    private boolean isWithinBoundaries(T elem) {
        return !this.isEmpty() && (this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.step()).$greater(this.scala$collection$immutable$NumericRange$$num.zero()) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.start()).$less$eq(elem) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(elem).$less$eq(this.last()) || this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.step()).$less(this.scala$collection$immutable$NumericRange$$num.zero()) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.last()).$less$eq(elem) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(elem).$less$eq(this.start()));
    }

    private T locationAfterN(int n) {
        return this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).$times(this.scala$collection$immutable$NumericRange$$num.fromInt(n)));
    }

    private Exclusive<T> newEmptyRange(T value) {
        Integral<T> apply_num = this.scala$collection$immutable$NumericRange$$num;
        T apply_step = this.step();
        return new Exclusive<T>(value, value, apply_step, apply_num);
    }

    @Override
    public NumericRange<T> take(int n) {
        if (n <= 0 || this.length() == 0) {
            return this.newEmptyRange(this.start());
        }
        if (n >= this.length()) {
            return this;
        }
        return new Inclusive<T>(this.start(), this.locationAfterN(n - 1), this.step(), this.scala$collection$immutable$NumericRange$$num);
    }

    @Override
    public NumericRange<T> drop(int n) {
        if (n <= 0 || this.length() == 0) {
            return this;
        }
        if (n >= this.length()) {
            return this.newEmptyRange(this.end());
        }
        return this.copy(this.locationAfterN(n), this.end(), this.step());
    }

    @Override
    public Tuple2<NumericRange<T>, NumericRange<T>> splitAt(int n) {
        return new Tuple2<Object, Object>(this.take(n), this.drop(n));
    }

    @Override
    public NumericRange<T> reverse() {
        if (this.isEmpty()) {
            return this;
        }
        return new Inclusive<T>(this.last(), this.start(), this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).unary_$minus(), this.scala$collection$immutable$NumericRange$$num);
    }

    @Override
    public <T1> T min(Ordering<T1> ord) {
        block6: {
            block5: {
                Ordering ordering;
                if (ord == this.scala$collection$immutable$NumericRange$$num) break block5;
                Option option = NumericRange$.MODULE$.defaultOrdering().get(this.scala$collection$immutable$NumericRange$$num);
                if (option == null) {
                    throw null;
                }
                Option exists_this = option;
                boolean bl = !exists_this.isEmpty() && NumericRange.$anonfun$min$1(ord, ordering = (Ordering)exists_this.get());
                Object var2_2 = null;
                if (!bl) break block6;
            }
            if (this.scala$collection$immutable$NumericRange$$num.signum(this.step()) > 0) {
                return this.head();
            }
            return this.last();
        }
        return (T)IterableOnceOps.min$(this, ord);
    }

    @Override
    public <T1> T max(Ordering<T1> ord) {
        block6: {
            block5: {
                Ordering ordering;
                if (ord == this.scala$collection$immutable$NumericRange$$num) break block5;
                Option option = NumericRange$.MODULE$.defaultOrdering().get(this.scala$collection$immutable$NumericRange$$num);
                if (option == null) {
                    throw null;
                }
                Option exists_this = option;
                boolean bl = !exists_this.isEmpty() && NumericRange.$anonfun$max$1(ord, ordering = (Ordering)exists_this.get());
                Object var2_2 = null;
                if (!bl) break block6;
            }
            if (this.scala$collection$immutable$NumericRange$$num.signum(this.step()) > 0) {
                return this.last();
            }
            return this.head();
        }
        return (T)IterableOnceOps.max$(this, ord);
    }

    public boolean containsTyped(T x) {
        return this.isWithinBoundaries(x) && BoxesRunTime.equals(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(x).$minus(this.start())).$percent(this.step()), this.scala$collection$immutable$NumericRange$$num.zero());
    }

    @Override
    public <A1> boolean contains(A1 x) {
        try {
            return this.containsTyped(x);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public <B> B sum(Numeric<B> num) {
        if (this.isEmpty()) {
            return num.zero();
        }
        if (SeqOps.size$(this) == 1) {
            return (B)this.head();
        }
        if (num == Numeric$IntIsIntegral$.MODULE$ || num == Numeric$ShortIsIntegral$.MODULE$ || num == Numeric$ByteIsIntegral$.MODULE$ || num == Numeric$CharIsIntegral$.MODULE$) {
            long exact = (long)SeqOps.size$(this) * (num.toLong(this.head()) + (long)num.toInt(this.last())) / 2L;
            return num.fromInt((int)exact);
        }
        if (num == Numeric$LongIsIntegral$.MODULE$) {
            long l;
            long a = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.head()).toLong();
            long b = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.last()).toLong();
            if ((SeqOps.size$(this) & 1) == 0) {
                l = (long)(SeqOps.size$(this) / 2) * (a + b);
            } else {
                long ha = a / 2L;
                long hb = b / 2L;
                l = (long)SeqOps.size$(this) * (ha + hb + (a - 2L * ha + (b - 2L * hb)) / 2L);
            }
            return (B)Long.valueOf(l);
        }
        if (num == Numeric$BigIntIsIntegral$.MODULE$ || num == Numeric$BigDecimalAsIfIntegral$.MODULE$) {
            Integral numAsIntegral = (Integral)num;
            return (B)numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(num.fromInt(SeqOps.size$(this))).$times(numAsIntegral.mkNumericOps(this.head()).$plus(this.last()))).$div(num.fromInt(2));
        }
        if (this.isEmpty()) {
            return num.zero();
        }
        B acc = num.zero();
        T i = this.head();
        for (int idx = 0; idx < this.length(); ++idx) {
            acc = num.plus(acc, i);
            i = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(i).$plus(this.step());
        }
        return acc;
    }

    private int hashCode$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hashCode = Seq.hashCode$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hashCode;
    }

    @Override
    public int hashCode() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.hashCode$lzycompute();
        }
        return this.hashCode;
    }

    @Override
    public final int applyPreferredMaxLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean equals(Object other) {
        NumericRange numericRange;
        boolean bl = other instanceof NumericRange ? (numericRange = (NumericRange)other).canEqual(this) && this.length() == numericRange.length() && (this.length() == 0 || BoxesRunTime.equals(this.start(), numericRange.start()) && BoxesRunTime.equals(this.last(), numericRange.last())) : Seq.equals$(this, other);
        return bl;
    }

    @Override
    public String toString() {
        String empty = this.isEmpty() ? "empty " : "";
        String preposition = this.isInclusive() ? "to" : "until";
        String stepped = BoxesRunTime.equals(this.step(), 1) ? "" : new StringBuilder(4).append(" by ").append(this.step()).toString();
        return new StringBuilder(15).append(empty).append("NumericRange ").append(this.start()).append(" ").append(preposition).append(" ").append(this.end()).append(stepped).toString();
    }

    @Override
    public Object writeReplace() {
        return this;
    }

    @Override
    public String className() {
        return "NumericRange";
    }

    public void foreach$mVc$sp(Function1<T, BoxedUnit> f) {
        T current = this.start();
        for (int count = 0; count < this.length(); ++count) {
            f.apply(current);
            current = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(current).$plus(this.step());
        }
    }

    public static final /* synthetic */ boolean $anonfun$min$1(Ordering ord$1, Ordering x$1) {
        return ord$1 == x$1;
    }

    public static final /* synthetic */ boolean $anonfun$max$1(Ordering ord$2, Ordering x$2) {
        return ord$2 == x$2;
    }

    public NumericRange(T start, T end, T step, boolean isInclusive, Integral<T> num) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.isInclusive = isInclusive;
        this.scala$collection$immutable$NumericRange$$num = num;
    }

    public static final /* synthetic */ Object $anonfun$min$1$adapted(Ordering ord$1, Ordering x$1) {
        return BoxesRunTime.boxToBoolean(NumericRange.$anonfun$min$1(ord$1, x$1));
    }

    public static final /* synthetic */ Object $anonfun$max$1$adapted(Ordering ord$2, Ordering x$2) {
        return BoxesRunTime.boxToBoolean(NumericRange.$anonfun$max$1(ord$2, x$2));
    }

    public static class Exclusive<T>
    extends NumericRange<T> {
        private static final long serialVersionUID = 3L;
        private final Integral<T> num;

        @Override
        public Exclusive<T> copy(T start, T end, T step) {
            Integral<T> apply_num = this.num;
            return new Exclusive<T>(start, end, step, apply_num);
        }

        /*
         * WARNING - void declaration
         */
        public Inclusive<T> inclusive() {
            void inclusive_num;
            void inclusive_step;
            Integral<T> integral = this.num;
            Object t = super.step();
            Object inclusive_end = super.end();
            Object inclusive_start = super.start();
            return new Inclusive<void>((void)inclusive_start, (void)inclusive_end, inclusive_step, (Integral<void>)inclusive_num);
        }

        public Exclusive(T start, T end, T step, Integral<T> num) {
            this.num = num;
            super(start, end, step, false, num);
        }
    }

    public static class Inclusive<T>
    extends NumericRange<T> {
        private static final long serialVersionUID = 3L;
        private final Integral<T> num;

        @Override
        public Inclusive<T> copy(T start, T end, T step) {
            Integral<T> inclusive_num = this.num;
            return new Inclusive<T>(start, end, step, inclusive_num);
        }

        /*
         * WARNING - void declaration
         */
        public Exclusive<T> exclusive() {
            void apply_num;
            void apply_step;
            Integral<T> integral = this.num;
            Object t = super.step();
            Object apply_end = super.end();
            Object apply_start = super.start();
            return new Exclusive<void>((void)apply_start, (void)apply_end, apply_step, (Integral<void>)apply_num);
        }

        public Inclusive(T start, T end, T step, Integral<T> num) {
            this.num = num;
            super(start, end, step, true, num);
        }
    }

    public static final class NumericRangeIterator<T>
    extends AbstractIterator<T>
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private final NumericRange<T> self;
        private final Integral<T> num;
        private boolean _hasNext;
        private T _next;
        private final T lastElement;

        @Override
        public int knownSize() {
            if (this._hasNext) {
                return this.num.toInt(this.num.mkNumericOps(this.num.mkNumericOps(this.lastElement).$minus(this._next)).$div(this.self.step())) + 1;
            }
            return 0;
        }

        @Override
        public boolean hasNext() {
            return this._hasNext;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            void var1_1;
            T value;
            if (!this._hasNext) {
                Iterator$.scala$collection$Iterator$$_empty.next();
            }
            this._hasNext = !BoxesRunTime.equals(value = this._next, this.lastElement);
            this._next = this.num.plus(value, this.self.step());
            return var1_1;
        }

        public NumericRangeIterator(NumericRange<T> self, Integral<T> num) {
            this.self = self;
            this.num = num;
            this._hasNext = !self.isEmpty();
            this._next = self.start();
            this.lastElement = this._hasNext ? self.last() : self.start();
        }
    }
}

