/*
 * Decompiled with CFR 0.152.
 */
package scala.jdk;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import scala.MatchError;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;

public final class DurationConverters$ {
    public static final DurationConverters$ MODULE$ = new DurationConverters$();

    public FiniteDuration toScala(Duration duration) {
        FiniteDuration finiteDuration;
        long originalSeconds = duration.getSeconds();
        int originalNanos = duration.getNano();
        if (originalNanos == 0) {
            if (originalSeconds == 0L) {
                return Duration$.MODULE$.Zero();
            }
            TimeUnit apply_unit = TimeUnit.SECONDS;
            return new FiniteDuration(originalSeconds, apply_unit);
        }
        if (originalSeconds == 0L) {
            long l = originalNanos;
            TimeUnit apply_unit = TimeUnit.NANOSECONDS;
            return new FiniteDuration(l, apply_unit);
        }
        try {
            long secondsAsNanos = Math.multiplyExact(originalSeconds, 1000000000L);
            long totalNanos = secondsAsNanos + (long)originalNanos;
            if (!(totalNanos < 0L && secondsAsNanos < 0L || totalNanos > 0L && secondsAsNanos > 0L)) {
                throw new ArithmeticException();
            }
            TimeUnit apply_unit = TimeUnit.NANOSECONDS;
            finiteDuration = new FiniteDuration(totalNanos, apply_unit);
            Object var11_9 = null;
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException(new StringBuilder(54).append("Java duration ").append(duration).append(" cannot be expressed as a Scala duration").toString());
        }
        return finiteDuration;
    }

    public Duration toJava(FiniteDuration duration) {
        Duration duration2;
        if (duration.length() == 0L) {
            return Duration.ZERO;
        }
        TimeUnit timeUnit = duration.unit();
        if (((Object)((Object)TimeUnit.NANOSECONDS)).equals((Object)timeUnit)) {
            duration2 = Duration.ofNanos(duration.length());
        } else if (((Object)((Object)TimeUnit.MICROSECONDS)).equals((Object)timeUnit)) {
            duration2 = Duration.of(duration.length(), ChronoUnit.MICROS);
        } else if (((Object)((Object)TimeUnit.MILLISECONDS)).equals((Object)timeUnit)) {
            duration2 = Duration.ofMillis(duration.length());
        } else if (((Object)((Object)TimeUnit.SECONDS)).equals((Object)timeUnit)) {
            duration2 = Duration.ofSeconds(duration.length());
        } else if (((Object)((Object)TimeUnit.MINUTES)).equals((Object)timeUnit)) {
            duration2 = Duration.ofMinutes(duration.length());
        } else if (((Object)((Object)TimeUnit.HOURS)).equals((Object)timeUnit)) {
            duration2 = Duration.ofHours(duration.length());
        } else if (((Object)((Object)TimeUnit.DAYS)).equals((Object)timeUnit)) {
            duration2 = Duration.ofDays(duration.length());
        } else {
            throw new MatchError((Object)timeUnit);
        }
        return duration2;
    }

    private DurationConverters$() {
    }
}

