/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterator;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Searching;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StepperShape$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.convert.impl.AnyNumericRangeStepper;
import scala.collection.convert.impl.IndexedStepperBase;
import scala.collection.convert.impl.IntNumericRangeStepper;
import scala.collection.convert.impl.LongNumericRangeStepper;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.IndexedSeqOps;
import scala.collection.immutable.NumericRange$;
import scala.collection.mutable.Builder;
import scala.math.Integral;
import scala.math.Numeric;
import scala.math.Numeric$BigDecimalAsIfIntegral$;
import scala.math.Numeric$BigIntIsIntegral$;
import scala.math.Numeric$ByteIsIntegral$;
import scala.math.Numeric$CharIsIntegral$;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Numeric$LongIsIntegral$;
import scala.math.Numeric$ShortIsIntegral$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0011ma\u0001\u0002'N!QC!\"!\u0001\u0001\u0005\u000b\u0007I\u0011AA\u0002\u0011%\t)\u0001\u0001B\u0001B\u0003%!\f\u0003\u0006\u0002\b\u0001\u0011)\u0019!C\u0001\u0003\u0007A\u0011\"!\u0003\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0015\u0005-\u0001A!b\u0001\n\u0003\t\u0019\u0001C\u0005\u0002\u000e\u0001\u0011\t\u0011)A\u00055\"Q\u0011q\u0002\u0001\u0003\u0006\u0004%\t!!\u0005\t\u0015\u0005e\u0001A!A!\u0002\u0013\t\u0019\u0002\u0003\u0006\u0002\u001c\u0001\u0011\t\u0011)A\u0006\u0003;Aq!a\t\u0001\t\u0003\t)\u0003C\u0004\u00026\u0001!\t%a\u000e\t\u000f\u0005}\u0002\u0001\"\u0011\u0002B!Q\u0011Q\u0011\u0001\t\u0006\u0004%\t%a\"\t\u000f\u0005=\u0005\u0001\"\u0011\u0002\u0012!9\u0011\u0011\u0013\u0001\u0005B\u0005\r\u0001bBAJ\u0001\u0011\u0005\u0013Q\u0013\u0005\b\u0003/\u0003A\u0011IA\u0002\u0011\u001d\tI\n\u0001C!\u0003+Cq!a'\u0001\t\u0003\ti\nC\u0004\u0002$\u0002!\t!!*\t\u000f\u00055\u0006\u0001\"\u0001\u00020\"9\u00111 \u0001\u0005B\u0005u\bb\u0002B\u001f\u0001\u0011%!q\b\u0005\b\u0005\u000b\u0002A\u0011\u0002B$\u0011\u001d\u0011i\u0005\u0001C\u0005\u0005\u001fBqa!(\u0001\t\u0003\u001ay\nC\u0004\u0004$\u0002!\te!*\t\u000f\r%\u0006\u0001\"\u0011\u0004,\"91Q\u0017\u0001\u0005B\u0005U\u0005bBB\\\u0001\u0011\u00053\u0011\u0018\u0005\b\u0007\u0017\u0004A\u0011IBg\u0011\u001d\u0019I\u000e\u0001C\u0001\u00077Dqa!9\u0001\t\u0003\u001a\u0019\u000fC\u0004\u0004p\u0002!\te!=\t\u0015\r}\b\u0001#b\u0001\n\u0003\n9\tC\u0004\u0005\u0002\u0001!)&a\"\t\u000f\u0011\r\u0001\u0001\"\u0011\u0005\u0006!9A1\u0002\u0001\u0005B\u00115\u0001\u0002\u0003C\b\u0001\u0001&\t\u0006\"\u0005\b\u000f\tUS\n#\u0001\u0003X\u00191A*\u0014E\u0001\u00053Bq!a\t*\t\u0003\u0011y\u0007C\u0004\u0003r%\"IAa\u001d\t\u000f\t\u001d\u0015\u0006\"\u0001\u0003\n\u001a1!qT\u0015\u0001\u0005CC1\"!\u0001.\u0005\u0003\u0005\u000b\u0011\u0002BT\u0003!Y\u0011qA\u0017\u0003\u0002\u0003\u0006IAa*\u0004\u0011-\tY!\fB\u0001B\u0003%!qU\u0003\t\u0015\u0005mQF!A!\u0002\u0017\u0011Y\u000bC\u0004\u0002$5\"\tA!,\t\u000f\u0005\rV\u0006\"\u0011\u0003>\"9!QY\u0017\u0005\u0002\t\u001dgA\u0002BfS\u0001\u0011i\rC\u0006\u0002\u0002U\u0012\t\u0011)A\u0005\u0005'\f\u0001bCA\u0004k\t\u0005\t\u0015!\u0003\u0003T\u000eA1\"a\u00036\u0005\u0003\u0005\u000b\u0011\u0002Bj\u000b!Q\u00111D\u001b\u0003\u0002\u0003\u0006YAa6\t\u000f\u0005\rR\u0007\"\u0001\u0003Z\"9\u00111U\u001b\u0005B\t\u001d\bb\u0002Bxk\u0011\u0005!\u0011\u001f\u0005\b\u0003[KC\u0011AB\u0002\u0011\u001d\u0011y/\u000bC\u0001\u00073A!ba\f*\u0005\u0004%\taTB\u0019\u0011!\u0019i%\u000bQ\u0001\n\rMbABB/S\u0019\u0019y\u0006\u0003\u0006\u0004n\u0005\u0013\t\u0011)A\u0005\u0007_B!\"a\u0007B\u0005\u0003\u0005\u000b\u0011BB9\u0011\u001d\t\u0019#\u0011C\u0001\u0007gB\u0001ba\u001fBA\u0003&\u00111\u0003\u0005\t\u0007{\n\u0005\u0015)\u0003\u0004j!A1qP!!\u0002\u0013\u0019I\u0007C\u0004\u0004\u0002\u0006#\t%a\"\t\u000f\r\r\u0015\t\"\u0001\u0002\u0012!91QQ!\u0005\u0002\r\u001d\u0005\"CBFS\u0005\u0005I\u0011BBG\u00051qU/\\3sS\u000e\u0014\u0016M\\4f\u0015\tqu*A\u0005j[6,H/\u00192mK*\u0011\u0001+U\u0001\u000bG>dG.Z2uS>t'\"\u0001*\u0002\u000bM\u001c\u0017\r\\1\u0004\u0001U\u0011Q\u000bX\n\b\u0001Y3\u0017.\u001c9u!\r9\u0006LW\u0007\u0002\u001b&\u0011\u0011,\u0014\u0002\f\u0003\n\u001cHO]1diN+\u0017\u000f\u0005\u0002\\92\u0001A!B/\u0001\u0005\u0004q&!\u0001+\u0012\u0005}\u001b\u0007C\u00011b\u001b\u0005\t\u0016B\u00012R\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001\u00193\n\u0005\u0015\f&aA!osB\u0019qk\u001a.\n\u0005!l%AC%oI\u0016DX\rZ*fcB)qK\u001b.mM&\u00111.\u0014\u0002\u000e\u0013:$W\r_3e'\u0016\fx\n]:\u0011\u0005];\u0007#B,o524\u0017BA8N\u0005U\u0019FO]5di>\u0003H/[7ju\u0016$7+Z9PaN\u0004B!\u001d:[Y6\tq*\u0003\u0002t\u001f\n9\u0012\n^3sC\ndWMR1di>\u0014\u0018\u0010R3gCVdGo\u001d\t\u0003kvt!A^>\u000f\u0005]TX\"\u0001=\u000b\u0005e\u001c\u0016A\u0002\u001fs_>$h(C\u0001S\u0013\ta\u0018+A\u0004qC\u000e\\\u0017mZ3\n\u0005y|(\u0001D*fe&\fG.\u001b>bE2,'B\u0001?R\u0003\u0015\u0019H/\u0019:u+\u0005Q\u0016AB:uCJ$\b%A\u0002f]\u0012\fA!\u001a8eA\u0005!1\u000f^3q\u0003\u0015\u0019H/\u001a9!\u0003-I7/\u00138dYV\u001c\u0018N^3\u0016\u0005\u0005M\u0001c\u00011\u0002\u0016%\u0019\u0011qC)\u0003\u000f\t{w\u000e\\3b]\u0006a\u0011n]%oG2,8/\u001b<fA\u0005\u0019a.^7\u0011\tU\fyBW\u0005\u0004\u0003Cy(\u0001C%oi\u0016<'/\u00197\u0002\rqJg.\u001b;?))\t9#!\f\u00020\u0005E\u00121\u0007\u000b\u0005\u0003S\tY\u0003E\u0002X\u0001iCq!a\u0007\u000b\u0001\b\ti\u0002\u0003\u0004\u0002\u0002)\u0001\rA\u0017\u0005\u0007\u0003\u000fQ\u0001\u0019\u0001.\t\r\u0005-!\u00021\u0001[\u0011\u001d\tyA\u0003a\u0001\u0003'\t\u0001\"\u001b;fe\u0006$xN]\u000b\u0003\u0003s\u0001B!]A\u001e5&\u0019\u0011QH(\u0003\u0011%#XM]1u_J\fqa\u001d;faB,'/\u0006\u0004\u0002D\u0005}\u0014Q\n\u000b\u0005\u0003\u000b\n\u0019H\u0005\u0004\u0002H\u0005-\u0013\u0011\r\u0004\u0007\u0003\u0013\u0002\u0001!!\u0012\u0003\u0019q\u0012XMZ5oK6,g\u000e\u001e \u0011\u0007m\u000bi\u0005B\u0004\u0002P1\u0011\r!!\u0015\u0003\u0003M\u000b2aXA*a\u0011\t)&!\u0018\u0011\u000bE\f9&a\u0017\n\u0007\u0005esJA\u0004Ti\u0016\u0004\b/\u001a:\u0011\u0007m\u000bi\u0006B\u0006\u0002`\u00055\u0013\u0011!A\u0001\u0006\u0003q&aA0%cA!\u00111MA7\u001d\u0011\t)'!\u001b\u000f\u0007Y\f9'\u0003\u0002Q#&\u0019\u00111N(\u0002\u000fM#X\r\u001d9fe&!\u0011qNA9\u00059)eMZ5dS\u0016tGo\u00159mSRT1!a\u001bP\u0011\u001d\t)\b\u0004a\u0002\u0003o\nQa\u001d5ba\u0016\u0004r!]A=\u0003{\nY%C\u0002\u0002|=\u0013Ab\u0015;faB,'o\u00155ba\u0016\u00042aWA@\t\u001d\t\t\t\u0004b\u0001\u0003\u0007\u0013\u0011AQ\t\u00035\u000e\fa\u0001\\3oORDWCAAE!\r\u0001\u00171R\u0005\u0004\u0003\u001b\u000b&aA%oi\u00069\u0011n]#naRL\u0018\u0001\u00027bgR\fA!\u001b8jiV\u0011\u0011\u0011F\u0001\u0005Q\u0016\fG-\u0001\u0003uC&d\u0017A\u00012z)\u0011\tI#a(\t\r\u0005\u00056\u00031\u0001[\u0003\u001dqWm^*uKB\fAaY8qsRA\u0011\u0011FAT\u0003S\u000bY\u000b\u0003\u0004\u0002\u0002Q\u0001\rA\u0017\u0005\u0007\u0003\u000f!\u0002\u0019\u0001.\t\r\u0005-A\u00031\u0001[\u0003\u0015\t\u0007\u000f\u001d7z)\rQ\u0016\u0011\u0017\u0005\b\u0003g+\u0002\u0019AAE\u0003\rIG\r\u001f\u0015\u0006+\u0005]\u00161\u0019\t\u0006A\u0006e\u0016QX\u0005\u0004\u0003w\u000b&A\u0002;ie><8\u000fE\u0002v\u0003\u007fK1!!1\u0000\u0005eIe\u000eZ3y\u001fV$xJ\u001a\"pk:$7/\u0012=dKB$\u0018n\u001c82\u000fy\t)-!6\u0002zB!\u0011qYAh\u001d\u0011\tI-a3\u0011\u0005]\f\u0016bAAg#\u00061\u0001K]3eK\u001aLA!!5\u0002T\n11\u000b\u001e:j]\u001eT1!!4Rc%\u0019\u0013q[Ao\u0003_\fy.\u0006\u0003\u0002Z\u0006mWCAAc\t\u0019i6K1\u0001\u0002f&!\u0011q\\Aq\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u00111])\u0002\rQD'o\\<t#\ry\u0016q\u001d\t\u0005\u0003S\fYO\u0004\u0002aw&\u0019\u0011Q^@\u0003\u0013QC'o\\<bE2,\u0017'C\u0012\u0002r\u0006M\u0018Q_Ar\u001d\r\u0001\u00171_\u0005\u0004\u0003G\f\u0016'\u0002\u0012a#\u0006](!B:dC2\f\u0017g\u0001\u0014\u0002>\u00069am\u001c:fC\u000eDW\u0003BA\u0000\u0005'!BA!\u0001\u0003\bA\u0019\u0001Ma\u0001\n\u0007\t\u0015\u0011K\u0001\u0003V]&$\bb\u0002B\u0005-\u0001\u0007!1B\u0001\u0002MB1\u0001M!\u0004[\u0005#I1Aa\u0004R\u0005%1UO\\2uS>t\u0017\u0007E\u0002\\\u0005'!!B!\u0006\u0017A\u0003\u0005\tQ1\u0001_\u0005\u0005)\u0006F\u0002B\n\u00053\u0011y\u0002E\u0002a\u00057I1A!\bR\u0005-\u0019\b/Z2jC2L'0\u001a32\u0013\r\u0012\tC!\u000e\u0003:\t]\u0002C\u0002B\u0012\u0005S\u0011yCD\u0002a\u0005KI1Aa\nR\u00035\u0019\u0006/Z2jC2L'0\u00192mK&!!1\u0006B\u0017\u0005\u00159%o\\;q\u0015\r\u00119#\u0015\t\u0006A\nE\"\u0011A\u0005\u0004\u0005g\t&A\u0002+va2,\u0017'\u0003\u0003\u00038\t5\u0012\u0001B+oSR\f\u0014b\tB\u0012\u0005K\u0011YDa\n2\t\u00112(PU\u0001\u0013SN<\u0016\u000e\u001e5j]\n{WO\u001c3be&,7\u000f\u0006\u0003\u0002\u0014\t\u0005\u0003B\u0002B\"/\u0001\u0007!,\u0001\u0003fY\u0016l\u0017A\u00047pG\u0006$\u0018n\u001c8BMR,'O\u0014\u000b\u00045\n%\u0003b\u0002B&1\u0001\u0007\u0011\u0011R\u0001\u0002]\u0006ia.Z<F[B$\u0018PU1oO\u0016$BA!\u0015\u0004\u001cB!!1K\u001b[\u001d\t9\u0006&\u0001\u0007Ok6,'/[2SC:<W\r\u0005\u0002XSM)\u0011Fa\u0017\u0003bA\u0019\u0001M!\u0018\n\u0007\t}\u0013K\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0005G\u0012i'\u0004\u0002\u0003f)!!q\rB5\u0003\tIwN\u0003\u0002\u0003l\u0005!!.\u0019<b\u0013\rq(Q\r\u000b\u0003\u0005/\n\u0001DY5h\t\u0016\u001c\u0017.\\1m\u0007\",7m[+oI\u0016\u0014h\r\\8x+\u0011\u0011)Ha \u0015\u0011\t]$\u0011\u0011BB\u0005\u000b#BA!\u0001\u0003z!9\u00111D\u0016A\u0004\tm\u0004#B;\u0002 \tu\u0004cA.\u0003\u0000\u0011)Ql\u000bb\u0001=\"9\u0011\u0011A\u0016A\u0002\tu\u0004bBA\u0004W\u0001\u0007!Q\u0010\u0005\b\u0003\u0017Y\u0003\u0019\u0001B?\u0003\u0015\u0019w.\u001e8u+\u0011\u0011YI!&\u0015\u0015\t5%q\u0013BM\u00057\u0013i\n\u0006\u0003\u0002\n\n=\u0005bBA\u000eY\u0001\u000f!\u0011\u0013\t\u0006k\u0006}!1\u0013\t\u00047\nUE!B/-\u0005\u0004q\u0006bBA\u0001Y\u0001\u0007!1\u0013\u0005\b\u0003\u000fa\u0003\u0019\u0001BJ\u0011\u001d\tY\u0001\fa\u0001\u0005'Cq!a\u0004-\u0001\u0004\t\u0019BA\u0005J]\u000edWo]5wKV!!1\u0015BU'\ri#Q\u0015\t\u0005/\u0002\u00119\u000bE\u0002\\\u0005S#Q!X\u0017C\u0002y\u0003R!^A\u0010\u0005O#\u0002Ba,\u00038\ne&1\u0018\u000b\u0005\u0005c\u0013)\fE\u0003\u000346\u00129+D\u0001*\u0011\u001d\tYB\ra\u0002\u0005WCq!!\u00013\u0001\u0004\u00119\u000bC\u0004\u0002\bI\u0002\rAa*\t\u000f\u0005-!\u00071\u0001\u0003(RA!\u0011\u0017B`\u0005\u0003\u0014\u0019\rC\u0004\u0002\u0002M\u0002\rAa*\t\u000f\u0005\u001d1\u00071\u0001\u0003(\"9\u00111B\u001aA\u0002\t\u001d\u0016!C3yG2,8/\u001b<f+\t\u0011I\rE\u0003\u00034V\u00129KA\u0005Fq\u000edWo]5wKV!!q\u001aBk'\r)$\u0011\u001b\t\u0005/\u0002\u0011\u0019\u000eE\u0002\\\u0005+$Q!X\u001bC\u0002y\u0003R!^A\u0010\u0005'$\u0002Ba7\u0003b\n\r(Q\u001d\u000b\u0005\u0005;\u0014y\u000eE\u0003\u00034V\u0012\u0019\u000eC\u0004\u0002\u001ci\u0002\u001dAa6\t\u000f\u0005\u0005!\b1\u0001\u0003T\"9\u0011q\u0001\u001eA\u0002\tM\u0007bBA\u0006u\u0001\u0007!1\u001b\u000b\t\u0005;\u0014IOa;\u0003n\"9\u0011\u0011A\u001eA\u0002\tM\u0007bBA\u0004w\u0001\u0007!1\u001b\u0005\b\u0003\u0017Y\u0004\u0019\u0001Bj\u0003%Ign\u00197vg&4X-\u0006\u0002\u0003tB)!1W\u0017\u0003T\":QGa>\u0003~\n}\bc\u00011\u0003z&\u0019!1`)\u0003!M+'/[1m-\u0016\u00148/[8o+&#\u0015!\u0002<bYV,g$A\u0002)\u000f5\u00129P!@\u0003\u0000V!1QAB\u0007)!\u00199aa\u0005\u0004\u0016\r]A\u0003BB\u0005\u0007\u001f\u0001RAa-6\u0007\u0017\u00012aWB\u0007\t\u0015iVH1\u0001_\u0011\u001d\tY\"\u0010a\u0002\u0007#\u0001R!^A\u0010\u0007\u0017Aq!!\u0001>\u0001\u0004\u0019Y\u0001C\u0004\u0002\bu\u0002\raa\u0003\t\u000f\u0005-Q\b1\u0001\u0004\fU!11DB\u0012)!\u0019ib!\u000b\u0004,\r5B\u0003BB\u0010\u0007K\u0001RAa-.\u0007C\u00012aWB\u0012\t\u0015ifH1\u0001_\u0011\u001d\tYB\u0010a\u0002\u0007O\u0001R!^A\u0010\u0007CAq!!\u0001?\u0001\u0004\u0019\t\u0003C\u0004\u0002\by\u0002\ra!\t\t\u000f\u0005-a\b1\u0001\u0004\"\u0005yA-\u001a4bk2$xJ\u001d3fe&tw-\u0006\u0002\u00044A9qk!\u000e\u0004:\r=\u0013bAB\u001c\u001b\n\u0019Q*\u001991\t\rm2\u0011\n\t\u0007\u0007{\u0019\u0019ea\u0012\u000e\u0005\r}\"bAB!#\u0006!Q.\u0019;i\u0013\u0011\u0019)ea\u0010\u0003\u000f9+X.\u001a:jGB\u00191l!\u0013\u0005\u0015\r-\u0003)!A\u0001\u0002\u000b\u0005aLA\u0002`II\n\u0001\u0003Z3gCVdGo\u0014:eKJLgn\u001a\u00111\t\rE3\u0011\f\t\u0007\u0007{\u0019\u0019fa\u0016\n\t\rU3q\b\u0002\t\u001fJ$WM]5oOB\u00191l!\u0017\u0005\u0015\rm\u0003)!A\u0001\u0002\u000b\u0005aLA\u0002`IM\u0012ACT;nKJL7MU1oO\u0016LE/\u001a:bi>\u0014X\u0003BB1\u0007W\u001aB!QB2iB)\u0011o!\u001a\u0004j%\u00191qM(\u0003!\u0005\u00137\u000f\u001e:bGRLE/\u001a:bi>\u0014\bcA.\u0004l\u0011)Q,\u0011b\u0001=\u0006!1/\u001a7g!\u00119\u0006a!\u001b\u0011\u000bU\fyb!\u001b\u0015\r\rU4qOB=!\u0015\u0011\u0019,QB5\u0011\u001d\u0019i\u0007\u0012a\u0001\u0007_Bq!a\u0007E\u0001\u0004\u0019\t(\u0001\u0005`Q\u0006\u001ch*\u001a=u\u0003\u0015yf.\u001a=u\u0003-a\u0017m\u001d;FY\u0016lWM\u001c;\u0002\u0013-twn\u001e8TSj,\u0017a\u00025bg:+\u0007\u0010^\u0001\u0005]\u0016DH\u000f\u0006\u0002\u0004j!:\u0011Ia>\u0003~\n}\u0018\u0001D<sSR,'+\u001a9mC\u000e,GCABH!\u0011\u0019\tja&\u000e\u0005\rM%\u0002BBK\u0005S\nA\u0001\\1oO&!1\u0011TBJ\u0005\u0019y%M[3di\"1!Q`\rA\u0002i\u000bA\u0001^1lKR!\u0011\u0011FBQ\u0011\u001d\u0011YE\u0007a\u0001\u0003\u0013\u000bA\u0001\u001a:paR!\u0011\u0011FBT\u0011\u001d\u0011Ye\u0007a\u0001\u0003\u0013\u000bqa\u001d9mSR\fE\u000f\u0006\u0003\u0004.\u000eM\u0006c\u00021\u00040\u0006%\u0012\u0011F\u0005\u0004\u0007c\u000b&A\u0002+va2,'\u0007C\u0004\u0003Lq\u0001\r!!#\u0002\u000fI,g/\u001a:tK\u0006\u0019Q.\u001b8\u0016\t\rm6q\u0019\u000b\u00045\u000eu\u0006bBB`=\u0001\u000f1\u0011Y\u0001\u0004_J$\u0007#B;\u0004D\u000e\u0015\u0017bAB+\u007fB\u00191la2\u0005\u000f\r%gD1\u0001\u0002\u0004\n\u0011A+M\u0001\u0004[\u0006DX\u0003BBh\u0007/$2AWBi\u0011\u001d\u0019yl\ba\u0002\u0007'\u0004R!^Bb\u0007+\u00042aWBl\t\u001d\u0019Im\bb\u0001\u0003\u0007\u000bQbY8oi\u0006Lgn\u001d+za\u0016$G\u0003BA\n\u0007;Daaa8!\u0001\u0004Q\u0016!\u0001=\u0002\u0011\r|g\u000e^1j]N,Ba!:\u0004lR!\u00111CBt\u0011\u001d\u0019y.\ta\u0001\u0007S\u00042aWBv\t\u001d\u0019i/\tb\u0001\u0003\u0007\u0013!!Q\u0019\u0002\u0007M,X.\u0006\u0003\u0004t\u000e]H\u0003BB{\u0007s\u00042aWB|\t\u001d\t\tI\tb\u0001\u0003\u0007Cq!a\u0007#\u0001\b\u0019Y\u0010E\u0003v\u0007{\u001c)0C\u0002\u0004F}\f\u0001\u0002[1tQ\u000e{G-Z\u0001\u0018CB\u0004H.\u001f)sK\u001a,'O]3e\u001b\u0006DH*\u001a8hi\"\fa!Z9vC2\u001cH\u0003BA\n\t\u000fAa\u0001\"\u0003&\u0001\u0004\u0019\u0017!B8uQ\u0016\u0014\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u0015\u0017!C2mCN\u001ch*Y7f+\t!\u0019\u0002\u0005\u0003\u0004\u0012\u0012U\u0011\u0002BAi\u0007'K3\u0001A\u001b.Q\u001d\u0001!q\u001fB\u007f\u0005\u007f\u0004")
public class NumericRange<T>
extends AbstractSeq<T>
implements scala.collection.immutable.IndexedSeq<T>,
scala.collection.immutable.StrictOptimizedSeqOps<T, scala.collection.immutable.IndexedSeq, scala.collection.immutable.IndexedSeq<T>>,
Serializable {
    private static final long serialVersionUID = 3L;
    private int length;
    private int hashCode;
    private final T start;
    private final T end;
    private final T step;
    private final boolean isInclusive;
    public final Integral<T> scala$collection$immutable$NumericRange$$num;
    private volatile byte bitmap$0;

    public static <T> Inclusive<T> inclusive(T t, T t2, T t3, Integral<T> integral) {
        return new Inclusive<T>(t, t2, t3, integral);
    }

    @Override
    public Object distinctBy(Function1 f) {
        return scala.collection.immutable.StrictOptimizedSeqOps.distinctBy$(this, f);
    }

    @Override
    public Object updated(int index, Object elem) {
        return scala.collection.immutable.StrictOptimizedSeqOps.updated$(this, index, elem);
    }

    @Override
    public Object patch(int from, IterableOnce other, int replaced) {
        return scala.collection.immutable.StrictOptimizedSeqOps.patch$(this, from, other, replaced);
    }

    @Override
    public Object prepended(Object elem) {
        return StrictOptimizedSeqOps.prepended$(this, elem);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object appendedAll(IterableOnce suffix) {
        return StrictOptimizedSeqOps.appendedAll$(this, suffix);
    }

    @Override
    public Object prependedAll(IterableOnce prefix) {
        return StrictOptimizedSeqOps.prependedAll$(this, prefix);
    }

    @Override
    public Object padTo(int len, Object elem) {
        return StrictOptimizedSeqOps.padTo$(this, len, elem);
    }

    @Override
    public Object diff(Seq that) {
        return StrictOptimizedSeqOps.diff$(this, that);
    }

    @Override
    public Object intersect(Seq that) {
        return StrictOptimizedSeqOps.intersect$(this, that);
    }

    @Override
    public Tuple2<scala.collection.immutable.IndexedSeq<T>, scala.collection.immutable.IndexedSeq<T>> partition(Function1<T, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<scala.collection.immutable.IndexedSeq<T>, scala.collection.immutable.IndexedSeq<T>> span(Function1<T, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>> unzip(Function1<T, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>, scala.collection.immutable.IndexedSeq<A3>> unzip3(Function1<T, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<T, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<T, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<T, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<T, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<T, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.IndexedSeq<A1>, scala.collection.immutable.IndexedSeq<A2>> partitionMap(Function1<T, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$canEqual(Object that) {
        return Seq.canEqual$(this, that);
    }

    @Override
    public /* synthetic */ boolean scala$collection$immutable$IndexedSeq$$super$sameElements(IterableOnce that) {
        return SeqOps.sameElements$(this, that);
    }

    @Override
    public final scala.collection.immutable.IndexedSeq<T> toIndexedSeq() {
        return scala.collection.immutable.IndexedSeq.toIndexedSeq$(this);
    }

    @Override
    public boolean canEqual(Object that) {
        return scala.collection.immutable.IndexedSeq.canEqual$(this, that);
    }

    @Override
    public <B> boolean sameElements(IterableOnce<B> o) {
        return scala.collection.immutable.IndexedSeq.sameElements$(this, o);
    }

    @Override
    public SeqFactory<scala.collection.immutable.IndexedSeq> iterableFactory() {
        return scala.collection.immutable.IndexedSeq.iterableFactory$(this);
    }

    @Override
    public /* synthetic */ Object scala$collection$immutable$IndexedSeqOps$$super$slice(int from, int until) {
        return scala.collection.IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public Object slice(int from, int until) {
        return IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public String stringPrefix() {
        return IndexedSeq.stringPrefix$(this);
    }

    @Override
    public Iterator<T> reverseIterator() {
        return scala.collection.IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public IndexedSeqView<T> view() {
        return scala.collection.IndexedSeqOps.view$(this);
    }

    @Override
    public IndexedSeqView<T> view(int from, int until) {
        return scala.collection.IndexedSeqOps.view$(this, from, until);
    }

    @Override
    public Iterable<T> reversed() {
        return scala.collection.IndexedSeqOps.reversed$(this);
    }

    @Override
    public final int lengthCompare(int len) {
        return scala.collection.IndexedSeqOps.lengthCompare$((scala.collection.IndexedSeqOps)this, len);
    }

    @Override
    public int knownSize() {
        return scala.collection.IndexedSeqOps.knownSize$(this);
    }

    @Override
    public final int lengthCompare(Iterable<?> that) {
        return scala.collection.IndexedSeqOps.lengthCompare$((scala.collection.IndexedSeqOps)this, that);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
        return scala.collection.IndexedSeqOps.search$(this, elem, ord);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
        return scala.collection.IndexedSeqOps.search$(this, elem, from, to, ord);
    }

    public T start() {
        return this.start;
    }

    public T end() {
        return this.end;
    }

    public T step() {
        return this.step;
    }

    public boolean isInclusive() {
        return this.isInclusive;
    }

    @Override
    public Iterator<T> iterator() {
        return new NumericRangeIterator<T>(this, this.scala$collection$immutable$NumericRange$$num);
    }

    @Override
    public <B, S extends Stepper<?>> S stepper(StepperShape<B, S> shape) {
        int n = shape.shape();
        IndexedStepperBase indexedStepperBase = StepperShape$.MODULE$.IntShape() == n ? new IntNumericRangeStepper(this, 0, this.length()) : (StepperShape$.MODULE$.LongShape() == n ? new LongNumericRangeStepper(this, 0, this.length()) : shape.parUnbox(new AnyNumericRangeStepper(this, 0, this.length())));
        return (S)indexedStepperBase;
    }

    private int length$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.length = NumericRange$.MODULE$.count(this.start(), this.end(), this.step(), this.isInclusive(), this.scala$collection$immutable$NumericRange$$num);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.length;
    }

    @Override
    public int length() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.length$lzycompute();
        }
        return this.length;
    }

    @Override
    public boolean isEmpty() {
        return this.length() == 0;
    }

    @Override
    public T last() {
        if (this.length() == 0) {
            throw new NoSuchElementException("head of empty list");
        }
        return this.locationAfterN(this.length() - 1);
    }

    @Override
    public NumericRange<T> init() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("init of empty list");
        }
        return new NumericRange<T>(this.start(), this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.end()).$minus(this.step()), this.step(), this.isInclusive(), this.scala$collection$immutable$NumericRange$$num);
    }

    @Override
    public T head() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("head of empty list");
        }
        return this.start();
    }

    @Override
    public NumericRange<T> tail() {
        if (this.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty list");
        }
        if (this.isInclusive()) {
            return new Inclusive(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.scala$collection$immutable$NumericRange$$num);
        }
        return new Exclusive(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.step()), this.end(), this.step(), this.scala$collection$immutable$NumericRange$$num);
    }

    public NumericRange<T> by(T newStep) {
        return this.copy(this.start(), this.end(), newStep);
    }

    public NumericRange<T> copy(T start, T end, T step) {
        return new NumericRange<T>(start, end, step, this.isInclusive(), this.scala$collection$immutable$NumericRange$$num);
    }

    @Override
    public T apply(int idx) throws IndexOutOfBoundsException {
        if (idx < 0 || idx >= this.length()) {
            throw new IndexOutOfBoundsException(new StringBuilder(31).append(idx).append(" is out of bounds (min 0, max ").append(this.length() - 1).append(")").toString());
        }
        return this.locationAfterN(idx);
    }

    @Override
    public <U> void foreach(Function1<T, U> f) {
        T current = this.start();
        for (int count = 0; count < this.length(); ++count) {
            f.apply(current);
            current = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(current).$plus(this.step());
        }
    }

    private boolean isWithinBoundaries(T elem) {
        return !this.isEmpty() && (this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.step()).$greater(this.scala$collection$immutable$NumericRange$$num.zero()) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.start()).$less$eq(elem) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(elem).$less$eq(this.last()) || this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.step()).$less(this.scala$collection$immutable$NumericRange$$num.zero()) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.last()).$less$eq(elem) && this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(elem).$less$eq(this.start()));
    }

    private T locationAfterN(int n) {
        return this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.start()).$plus(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).$times(this.scala$collection$immutable$NumericRange$$num.fromInt(n)));
    }

    private Exclusive<T> newEmptyRange(T value) {
        Integral<T> apply_num = this.scala$collection$immutable$NumericRange$$num;
        T apply_step = this.step();
        return new Exclusive<T>(value, value, apply_step, apply_num);
    }

    @Override
    public NumericRange<T> take(int n) {
        if (n <= 0 || this.length() == 0) {
            return this.newEmptyRange(this.start());
        }
        if (n >= this.length()) {
            return this;
        }
        return new Inclusive<T>(this.start(), this.locationAfterN(n - 1), this.step(), this.scala$collection$immutable$NumericRange$$num);
    }

    @Override
    public NumericRange<T> drop(int n) {
        if (n <= 0 || this.length() == 0) {
            return this;
        }
        if (n >= this.length()) {
            return this.newEmptyRange(this.end());
        }
        return this.copy(this.locationAfterN(n), this.end(), this.step());
    }

    @Override
    public Tuple2<NumericRange<T>, NumericRange<T>> splitAt(int n) {
        return new Tuple2<Object, Object>(this.take(n), this.drop(n));
    }

    @Override
    public NumericRange<T> reverse() {
        if (this.isEmpty()) {
            return this;
        }
        return new Inclusive<T>(this.last(), this.start(), this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.step()).unary_$minus(), this.scala$collection$immutable$NumericRange$$num);
    }

    @Override
    public <T1> T min(Ordering<T1> ord) {
        block6: {
            block5: {
                Ordering ordering;
                if (ord == this.scala$collection$immutable$NumericRange$$num) break block5;
                Option option = NumericRange$.MODULE$.defaultOrdering().get(this.scala$collection$immutable$NumericRange$$num);
                if (option == null) {
                    throw null;
                }
                Option exists_this = option;
                boolean bl = !exists_this.isEmpty() && NumericRange.$anonfun$min$1(ord, ordering = (Ordering)exists_this.get());
                Object var2_2 = null;
                if (!bl) break block6;
            }
            if (this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.scala$collection$immutable$NumericRange$$num.sign(this.step())).$greater(this.scala$collection$immutable$NumericRange$$num.zero())) {
                return this.head();
            }
            return this.last();
        }
        return (T)IterableOnceOps.min$(this, ord);
    }

    @Override
    public <T1> T max(Ordering<T1> ord) {
        block6: {
            block5: {
                Ordering ordering;
                if (ord == this.scala$collection$immutable$NumericRange$$num) break block5;
                Option option = NumericRange$.MODULE$.defaultOrdering().get(this.scala$collection$immutable$NumericRange$$num);
                if (option == null) {
                    throw null;
                }
                Option exists_this = option;
                boolean bl = !exists_this.isEmpty() && NumericRange.$anonfun$max$1(ord, ordering = (Ordering)exists_this.get());
                Object var2_2 = null;
                if (!bl) break block6;
            }
            if (this.scala$collection$immutable$NumericRange$$num.mkOrderingOps(this.scala$collection$immutable$NumericRange$$num.sign(this.step())).$greater(this.scala$collection$immutable$NumericRange$$num.zero())) {
                return this.last();
            }
            return this.head();
        }
        return (T)IterableOnceOps.max$(this, ord);
    }

    public boolean containsTyped(T x) {
        return this.isWithinBoundaries(x) && BoxesRunTime.equals(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.scala$collection$immutable$NumericRange$$num.mkNumericOps(x).$minus(this.start())).$percent(this.step()), this.scala$collection$immutable$NumericRange$$num.zero());
    }

    @Override
    public <A1> boolean contains(A1 x) {
        try {
            return this.containsTyped(x);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    @Override
    public <B> B sum(Numeric<B> num) {
        if (this.isEmpty()) {
            return num.zero();
        }
        if (SeqOps.size$(this) == 1) {
            return (B)this.head();
        }
        if (num == Numeric$IntIsIntegral$.MODULE$ || num == Numeric$ShortIsIntegral$.MODULE$ || num == Numeric$ByteIsIntegral$.MODULE$ || num == Numeric$CharIsIntegral$.MODULE$) {
            long exact = (long)SeqOps.size$(this) * (num.toLong(this.head()) + (long)num.toInt(this.last())) / 2L;
            return num.fromInt((int)exact);
        }
        if (num == Numeric$LongIsIntegral$.MODULE$) {
            long l;
            long a = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.head()).toLong();
            long b = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(this.last()).toLong();
            if ((SeqOps.size$(this) & 1) == 0) {
                l = (long)(SeqOps.size$(this) / 2) * (a + b);
            } else {
                long ha = a / 2L;
                long hb = b / 2L;
                l = (long)SeqOps.size$(this) * (ha + hb + (a - 2L * ha + (b - 2L * hb)) / 2L);
            }
            return (B)Long.valueOf(l);
        }
        if (num == Numeric$BigIntIsIntegral$.MODULE$ || num == Numeric$BigDecimalAsIfIntegral$.MODULE$) {
            Integral numAsIntegral = (Integral)num;
            return (B)numAsIntegral.mkNumericOps(numAsIntegral.mkNumericOps(num.fromInt(SeqOps.size$(this))).$times(numAsIntegral.mkNumericOps(this.head()).$plus(this.last()))).$div(num.fromInt(2));
        }
        if (this.isEmpty()) {
            return num.zero();
        }
        B acc = num.zero();
        T i = this.head();
        for (int idx = 0; idx < this.length(); ++idx) {
            acc = num.plus(acc, i);
            i = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(i).$plus(this.step());
        }
        return acc;
    }

    private int hashCode$lzycompute() {
        synchronized (this) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.hashCode = Seq.hashCode$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hashCode;
    }

    @Override
    public int hashCode() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.hashCode$lzycompute();
        }
        return this.hashCode;
    }

    @Override
    public final int applyPreferredMaxLength() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean equals(Object other) {
        NumericRange numericRange;
        boolean bl = other instanceof NumericRange ? (numericRange = (NumericRange)other).canEqual(this) && this.length() == numericRange.length() && (this.length() == 0 || BoxesRunTime.equals(this.start(), numericRange.start()) && BoxesRunTime.equals(this.last(), numericRange.last())) : Seq.equals$(this, other);
        return bl;
    }

    @Override
    public String toString() {
        String empty = this.isEmpty() ? "empty " : "";
        String preposition = this.isInclusive() ? "to" : "until";
        String stepped = BoxesRunTime.equals(this.step(), 1) ? "" : new StringBuilder(4).append(" by ").append(this.step()).toString();
        return new StringBuilder(15).append(empty).append("NumericRange ").append(this.start()).append(" ").append(preposition).append(" ").append(this.end()).append(stepped).toString();
    }

    @Override
    public String className() {
        return "NumericRange";
    }

    public void foreach$mVc$sp(Function1<T, BoxedUnit> f) {
        T current = this.start();
        for (int count = 0; count < this.length(); ++count) {
            f.apply(current);
            current = this.scala$collection$immutable$NumericRange$$num.mkNumericOps(current).$plus(this.step());
        }
    }

    public static final /* synthetic */ boolean $anonfun$min$1(Ordering ord$1, Ordering x$1) {
        return ord$1 == x$1;
    }

    public static final /* synthetic */ boolean $anonfun$max$1(Ordering ord$2, Ordering x$2) {
        return ord$2 == x$2;
    }

    public NumericRange(T start, T end, T step, boolean isInclusive, Integral<T> num) {
        this.start = start;
        this.end = end;
        this.step = step;
        this.isInclusive = isInclusive;
        this.scala$collection$immutable$NumericRange$$num = num;
    }

    public static final /* synthetic */ Object $anonfun$min$1$adapted(Ordering ord$1, Ordering x$1) {
        return BoxesRunTime.boxToBoolean(NumericRange.$anonfun$min$1(ord$1, x$1));
    }

    public static final /* synthetic */ Object $anonfun$max$1$adapted(Ordering ord$2, Ordering x$2) {
        return BoxesRunTime.boxToBoolean(NumericRange.$anonfun$max$1(ord$2, x$2));
    }

    public static class Exclusive<T>
    extends NumericRange<T> {
        private static final long serialVersionUID = 3L;
        private final Integral<T> num;

        @Override
        public Exclusive<T> copy(T start, T end, T step) {
            Integral<T> apply_num = this.num;
            return new Exclusive<T>(start, end, step, apply_num);
        }

        /*
         * WARNING - void declaration
         */
        public Inclusive<T> inclusive() {
            void inclusive_num;
            void inclusive_step;
            Integral<T> integral = this.num;
            Object t = super.step();
            Object inclusive_end = super.end();
            Object inclusive_start = super.start();
            return new Inclusive<void>((void)inclusive_start, (void)inclusive_end, inclusive_step, (Integral<void>)inclusive_num);
        }

        public Exclusive(T start, T end, T step, Integral<T> num) {
            this.num = num;
            super(start, end, step, false, num);
        }
    }

    public static class Inclusive<T>
    extends NumericRange<T> {
        private static final long serialVersionUID = 3L;
        private final Integral<T> num;

        @Override
        public Inclusive<T> copy(T start, T end, T step) {
            Integral<T> inclusive_num = this.num;
            return new Inclusive<T>(start, end, step, inclusive_num);
        }

        /*
         * WARNING - void declaration
         */
        public Exclusive<T> exclusive() {
            void apply_num;
            void apply_step;
            Integral<T> integral = this.num;
            Object t = super.step();
            Object apply_end = super.end();
            Object apply_start = super.start();
            return new Exclusive<void>((void)apply_start, (void)apply_end, apply_step, (Integral<void>)apply_num);
        }

        public Inclusive(T start, T end, T step, Integral<T> num) {
            this.num = num;
            super(start, end, step, true, num);
        }
    }

    public static final class NumericRangeIterator<T>
    extends AbstractIterator<T>
    implements Serializable {
        private static final long serialVersionUID = 3L;
        private final NumericRange<T> self;
        private final Integral<T> num;
        private boolean _hasNext;
        private T _next;
        private final T lastElement;

        @Override
        public int knownSize() {
            if (this._hasNext) {
                return this.num.toInt(this.num.mkNumericOps(this.num.mkNumericOps(this.lastElement).$minus(this._next)).$div(this.self.step())) + 1;
            }
            return 0;
        }

        @Override
        public boolean hasNext() {
            return this._hasNext;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            void var1_1;
            T value;
            if (!this._hasNext) {
                Iterator$.scala$collection$Iterator$$_empty.next();
            }
            this._hasNext = !BoxesRunTime.equals(value = this._next, this.lastElement);
            this._next = this.num.plus(value, this.self.step());
            return var1_1;
        }

        public NumericRangeIterator(NumericRange<T> self, Integral<T> num) {
            this.self = self;
            this.num = num;
            this._hasNext = !self.isEmpty();
            this._next = self.start();
            this.lastElement = this._hasNext ? self.last() : self.start();
        }
    }
}

