/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import scala.Iterator;
import scala.collection.mutable.HashEntry;
import scala.collection.mutable.HashTable;
import scala.collection.mutable.HashTable$;
import scala.runtime.BoxedAnyArray;
import scala.runtime.BoxedArray;
import scala.runtime.Comparator;

public abstract class HashTable$class {
    public static void $init$(HashTable hashTable) {
        hashTable.initialThreshold_$eq(HashTable$class.newThreshold(hashTable, hashTable.initialSize()));
        hashTable.table_$eq(hashTable.initialSize() != 0 ? new BoxedAnyArray(hashTable.initialSize()) : null);
        hashTable.tableSize_$eq(0);
        hashTable.threshold_$eq(hashTable.initialThreshold());
    }

    public static final int index(HashTable hashTable, int n) {
        return hashTable.improve(n) & hashTable.table().length() - 1;
    }

    public static final int improve(HashTable hashTable, int n) {
        int n2 = n + ~(n << 9);
        n2 ^= n2 >>> 14;
        n2 += n2 << 4;
        return n2 ^ n2 >>> 10;
    }

    public static int elemHashCode(HashTable hashTable, Object object) {
        return object.hashCode();
    }

    public static boolean elemEquals(HashTable hashTable, Object object, Object object2) {
        return Comparator.equals(object, object2);
    }

    private static void resize(HashTable hashTable, int n) {
        BoxedArray boxedArray = hashTable.table();
        hashTable.table_$eq(new BoxedAnyArray(n));
        int n2 = boxedArray.length() - 1;
        while (true) {
            HashEntry hashEntry;
            if (n2 < 0) {
                hashTable.threshold_$eq(HashTable$class.newThreshold(hashTable, n));
                return;
            }
            HashEntry hashEntry2 = (HashEntry)boxedArray.apply(n2);
            while ((hashEntry = hashEntry2) != null && !hashEntry.equals(null)) {
                int n3 = hashTable.index(hashTable.elemHashCode(hashEntry2.key()));
                HashEntry hashEntry3 = (HashEntry)hashEntry2.next();
                hashEntry2.next_$eq(hashTable.table().apply(n3));
                hashTable.table().update(n3, hashEntry2);
                hashEntry2 = hashEntry3;
            }
            --n2;
        }
    }

    private static int newThreshold(HashTable hashTable, int n) {
        return (int)((float)n * hashTable.loadFactor());
    }

    public static void clear(HashTable hashTable) {
        int n = hashTable.table().length() - 1;
        while (true) {
            if (n < 0) {
                hashTable.tableSize_$eq(0);
                return;
            }
            hashTable.table().update(n, null);
            --n;
        }
    }

    public static Iterator entries(HashTable hashTable) {
        return new HashTable$.anon.0(hashTable);
    }

    public static void removeEntry(HashTable hashTable, Object object) {
        block1: {
            HashEntry hashEntry;
            int n;
            block2: {
                n = hashTable.index(hashTable.elemHashCode(object));
                hashEntry = (HashEntry)hashTable.table().apply(n);
                HashEntry hashEntry2 = hashEntry;
                if (hashEntry2 == null || hashEntry2.equals(null)) break block1;
                if (hashTable.elemEquals(hashEntry.key(), object)) break block2;
                HashEntry hashEntry3 = (HashEntry)hashEntry.next();
                while ((hashEntry2 = hashEntry3) != null && !hashEntry2.equals(null) && !hashTable.elemEquals(hashEntry3.key(), object)) {
                    hashEntry = hashEntry3;
                    hashEntry3 = (HashEntry)hashEntry3.next();
                }
                hashEntry2 = hashEntry3;
                if (hashEntry2 == null || hashEntry2.equals(null)) break block1;
                hashEntry.next_$eq(hashEntry3.next());
                hashTable.tableSize_$eq(hashTable.tableSize() - 1);
                break block1;
            }
            hashTable.table().update(n, hashEntry.next());
            hashTable.tableSize_$eq(hashTable.tableSize() - 1);
        }
    }

    public static void addEntry(HashTable hashTable, HashEntry hashEntry) {
        int n = hashTable.index(hashTable.elemHashCode(hashEntry.key()));
        hashEntry.next_$eq(hashTable.table().apply(n));
        hashTable.table().update(n, hashEntry);
        hashTable.tableSize_$eq(hashTable.tableSize() + 1);
        if (hashTable.tableSize() > hashTable.threshold()) {
            HashTable$class.resize(hashTable, 2 * hashTable.table().length());
        }
    }

    public static HashEntry findEntry(HashTable hashTable, Object object) {
        HashEntry hashEntry;
        int n = hashTable.index(hashTable.elemHashCode(object));
        HashEntry hashEntry2 = (HashEntry)hashTable.table().apply(n);
        while ((hashEntry = hashEntry2) != null && !hashEntry.equals(null) && !hashTable.elemEquals(hashEntry2.key(), object)) {
            hashEntry2 = (HashEntry)hashEntry2.next();
        }
        return hashEntry2;
    }

    public static int size(HashTable hashTable) {
        return hashTable.tableSize();
    }

    public static int initialSize(HashTable hashTable) {
        return 16;
    }

    public static float loadFactor(HashTable hashTable) {
        return 0.75f;
    }
}

