/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Some;
import scala.Symbol;
import scala.actors.Actor;
import scala.actors.Actor$;
import scala.actors.remote.FreshNameCreator$;
import scala.actors.remote.NamedSend;
import scala.actors.remote.NetKernel$;
import scala.actors.remote.Node;
import scala.actors.remote.Service;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedUnit;

public class NetKernel
implements ScalaObject {
    private HashMap names;
    private HashMap actors;
    private Service service;

    public NetKernel(Service service) {
        this.service = service;
        this.actors = new HashMap();
        this.names = new HashMap();
    }

    public void register(Symbol name, Actor a) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            this.actors().$plus$eq(name).$minus$greater(a);
            this.names().$plus$eq(a).$minus$greater(name);
            return;
        }
    }

    private HashMap names() {
        return this.names;
    }

    private HashMap actors() {
        return this.actors;
    }

    public void processMsg(Node senderNode$0, Object msg) {
        NetKernel netKernel = this;
        synchronized (netKernel) {
            Object object = msg;
            if (!(object instanceof NamedSend)) {
                throw new MatchError(object);
            }
            NamedSend namedSend = (NamedSend)object;
            Symbol symbol = namedSend.senderName();
            Symbol symbol2 = namedSend.receiver();
            byte[] byArray = namedSend.data();
            Symbol senderName$0 = symbol;
            Symbol receiver$0 = symbol2;
            byte[] data = byArray;
            Option option = this.actors().get(receiver$0);
            if (!(option instanceof Some)) {
                if (option != None$.MODULE$) {
                    throw new MatchError(option);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Some some = (Some)option;
                Actor a$0 = (Actor)some.x();
                Object msg$0 = this.service.serializer().deserialize(data);
                $anon$0 senderProxy = new $anon$0(this, senderNode$0, senderName$0, receiver$0, a$0, msg$0);
                ((Actor)senderProxy).start();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
    }

    public void send(Node node, Symbol name, Object msg) {
        Symbol symbol;
        Option option = this.names().get(Actor$.MODULE$.self());
        if (option != None$.MODULE$) {
            if (!(option instanceof Some)) {
                throw new MatchError(option);
            }
            symbol = (Symbol)((Some)option).x();
        } else {
            Symbol freshName = FreshNameCreator$.MODULE$.newName("remotesender");
            this.register(freshName, Actor$.MODULE$.self());
            symbol = freshName;
        }
        Symbol senderName = symbol;
        this.namedSend(node, senderName, name, msg);
    }

    public void namedSend(Node node, Symbol senderName, Symbol receiver, Object msg) {
        byte[] bytes = this.service.serializer().serialize(msg);
        this.sendToNode(node, new NamedSend(senderName, receiver, bytes));
    }

    public void sendToNode(Node node, Object msg) {
        byte[] bytes = this.service.serializer().serialize(msg);
        this.service.send(node, bytes);
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

