/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import scala.Iterator;
import scala.Predef$;
import scala.Seq;
import scala.runtime.BoxesUtility;
import scala.xml.parsing.TokenTests;
import scala.xml.parsing.TokenTests$;

public abstract class TokenTests$class {
    public static void $init$(TokenTests $this) {
    }

    public static boolean checkPubID(TokenTests $this, String s) {
        boolean bl;
        if (s.length() > 0) {
            Iterator y = Predef$.MODULE$.stringWrapper(s).elements();
            char c = ' ';
            while (y.hasNext() && $this.isPubIDChar(c)) {
                c = BoxesUtility.unboxToChar(y.next());
            }
            bl = !y.hasNext();
        } else {
            bl = true;
        }
        return bl;
    }

    public static boolean checkSysID(TokenTests $this, String s) {
        return s.indexOf(34) == -1 || s.indexOf(39) == -1;
    }

    public static boolean isValidIANAEncoding(TokenTests $this, Seq ianaEncoding) {
        Iterator it = ianaEncoding.elements();
        if (it.hasNext()) {
            char c = BoxesUtility.unboxToChar(it.next());
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                while (it.hasNext()) {
                    c = BoxesUtility.unboxToChar(it.next());
                    if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isPubIDChar(TokenTests $this, char ch) {
        char c = ch;
        boolean bl = c == ' ' || c == '\r' || c == '\n' ? true : ('0' <= ch && ch <= '9' || 'a' <= ch && ch <= 'z' || 'A' <= ch && ch <= 'Z' ? true : c == '-' || c == '\'' || c == '(' || c == ')' || c == '+' || c == ',' || c == '.' || c == '/' || c == ':' || c == '=' || c == '?' || c == ';' || c == '!' || c == '*' || c == '#' || c == '@' || c == '$' || c == '_' || c == '%');
        return bl;
    }

    public static boolean isName(TokenTests $this, String s) {
        boolean bl;
        if (s.length() > 0) {
            Iterator y = Predef$.MODULE$.stringWrapper(s).elements();
            if ($this.isNameStart(BoxesUtility.unboxToChar(y.next()))) {
                while (y.hasNext() && $this.isNameChar(BoxesUtility.unboxToChar(y.next()))) {
                }
                bl = !y.hasNext();
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static boolean isNameStart(TokenTests $this, char ch) {
        byte by = (byte)Character.getType(ch);
        return by == 2 ? true : (by == 1 ? true : (by == 5 ? true : (by == 3 ? true : (by == 10 ? true : ch == '_'))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isNameChar(TokenTests $this, char ch) {
        char c;
        if ($this.isNameStart(ch)) return true;
        char c2 = c = ch;
        switch (c2) {
            default: {
                byte by = (byte)Character.getType(ch);
                if (by == 8) {
                    return true;
                }
                if (by == 7) {
                    return true;
                }
                if (by == 6) {
                    return true;
                }
                if (by == 4) {
                    return true;
                }
                if (by != 9) return false;
                return true;
            }
            case '-': {
                return true;
            }
            case '.': {
                return true;
            }
            case ':': {
                return true;
            }
        }
    }

    public static final boolean isSpace(TokenTests $this, Seq cs) {
        Iterator it = cs.elements();
        return it.hasNext() && it.forall(new TokenTests$.anonfun.0($this));
    }

    public static final boolean isSpace(TokenTests $this, char ch) {
        boolean bl;
        char c;
        char c2 = c = ch;
        switch (c2) {
            default: {
                bl = false;
                break;
            }
            case '\t': {
                bl = true;
                break;
            }
            case '\n': {
                bl = true;
                break;
            }
            case '\r': {
                bl = true;
                break;
            }
            case ' ': {
                bl = true;
            }
        }
        return bl;
    }
}

