/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.include.sax;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.runtime.BoxesRunTime;
import scala.xml.Utility$;
import scala.xml.include.sax.XIncludeFilter;

public class XIncluder
implements ContentHandler,
LexicalHandler,
ScalaObject {
    private XIncludeFilter filter;
    private Stack entities;
    private boolean inDTD;
    private OutputStreamWriter out;
    private String encoding;

    public XIncluder(OutputStream outs, String encoding) {
        this.encoding = encoding;
        this.out = new OutputStreamWriter(outs, encoding);
        this.inDTD = false;
        this.entities = new Stack();
        this.filter = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void comment(char[] ch, int start, int length2) {
        if (this.inDTD() || this.filter().insideIncludeElement()) return;
        try {
            this.out().write("<!--");
            this.out().write(ch, start, length2);
            this.out().write("-->");
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void setFilter(XIncludeFilter filter2) {
        this.filter_$eq(filter2);
    }

    private /* synthetic */ void filter_$eq(XIncludeFilter x$1) {
        this.filter = x$1;
    }

    private /* synthetic */ XIncludeFilter filter() {
        return this.filter;
    }

    public void endCDATA() {
    }

    public void startCDATA() {
    }

    public void endEntity(String name) {
        this.entities().pop();
    }

    public void startEntity(String name) {
        this.entities().push(name);
    }

    public void endDTD() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startDTD(String name, String publicID, String systemID) {
        this.inDTD_$eq(true);
        if (this.entities().size() != 0) return;
        String id = "";
        String string2 = publicID;
        if (string2 == null || string2.equals(null)) {
            string2 = systemID;
            if (string2 != null && !string2.equals(null)) {
                id = " SYSTEM \"" + systemID + BoxesRunTime.boxToCharacter('\"');
            }
        } else {
            id = " PUBLIC \"" + publicID + "\" \"" + systemID + BoxesRunTime.boxToCharacter('\"');
        }
        try {
            this.out().write("<!DOCTYPE " + name + id + ">\r\n");
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Error while writing DOCTYPE", iOException);
        }
    }

    private /* synthetic */ Stack entities() {
        return this.entities;
    }

    private /* synthetic */ void inDTD_$eq(boolean x$1) {
        this.inDTD = x$1;
    }

    private /* synthetic */ boolean inDTD() {
        return this.inDTD;
    }

    public void skippedEntity(String name) {
        try {
            this.out().write("&" + name + ";");
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void processingInstruction(String target, String data2) {
        try {
            this.out().write("<?" + target + " " + data2 + "?>");
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length2) {
        this.characters(ch, start, length2);
    }

    public void characters(char[] ch, int start, int length2) {
        try {
            for (int i = 0; i < length2; ++i) {
                char c = ch[start + i];
                if (c == '&') {
                    this.out().write("&amp;");
                    continue;
                }
                if (c == '<') {
                    this.out().write("&lt;");
                    continue;
                }
                if (c == '>') {
                    this.out().write("&gt;");
                    continue;
                }
                this.out().write(Predef$.MODULE$.char2int(c));
            }
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void endElement(String namespaceURI, String localName, String qualifiedName) {
        try {
            this.out().write("</" + qualifiedName + ">");
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes atts) {
        try {
            this.out().write("<" + qualifiedName);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.out().write(" ");
                this.out().write(atts.getQName(i));
                this.out().write("='");
                String value2 = atts.getValue(i);
                this.out().write(Utility$.MODULE$.escape(value2));
                this.out().write("'");
            }
            this.out().write(">");
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public void startPrefixMapping(String prefix, String uri) {
    }

    public void endDocument() {
        try {
            this.out().flush();
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Flush failed", iOException);
        }
    }

    public void startDocument() {
        try {
            this.out().write("<?xml version='1.0' encoding='" + this.encoding + "'?>\r\n");
            return;
        }
        catch (IOException iOException) {
            throw new SAXException("Write failed", iOException);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public /* synthetic */ void out_$eq(OutputStreamWriter x$1) {
        this.out = x$1;
    }

    public /* synthetic */ OutputStreamWriter out() {
        return this.out;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

