/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.persistent;

import java.io.File;
import java.io.FileOutputStream;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import scala.Iterator;
import scala.Iterator$;
import scala.Predef$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.io.Source;
import scala.io.Source$;
import scala.runtime.BoxesRunTime;
import scala.util.logging.Logged;
import scala.util.logging.Logged$class;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.TopScope$;
import scala.xml.XML$;
import scala.xml.parsing.ConstructingParser$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class CachedFileStorage
extends Thread
implements Logged,
ScalaObject {
    private int interval;
    private boolean dirty;
    private File theFile;
    private File file2;
    private File file1;

    public CachedFileStorage(File file1) {
        this.file1 = file1;
        Logged$class.$init$(this);
        this.file2 = new File(file1.getParent(), file1.getName() + "$");
        this.theFile = null;
        this.dirty = false;
        this.interval = 1000;
    }

    private final /* synthetic */ boolean gd1$1() {
        return this.file1().lastModified() < this.file2().lastModified();
    }

    public void flush() {
        this.dirty_$eq(true);
        this.save();
    }

    public void run() {
        this.log("[run]\nstarting storage thread, checking every " + BoxesRunTime.boxToInteger(this.interval()) + " ms");
        while (true) {
            Thread.sleep(Predef$.MODULE$.int2long(this.interval()));
            this.save();
        }
    }

    private void save() {
        if (this.dirty()) {
            this.log("[save]\ndeleting " + this.theFile());
            this.theFile().delete();
            this.log("creating new " + this.theFile());
            this.theFile().createNewFile();
            FileOutputStream fos = new FileOutputStream(this.theFile());
            FileChannel c = fos.getChannel();
            TopScope$ topScope$ = Predef$.MODULE$.$scope();
            NodeBuffer $buf = new NodeBuffer();
            $buf.$amp$plus(this.nodes().toList());
            Elem storageNode = new Elem(null, "nodes", Null$.MODULE$, topScope$, $buf);
            Writer w = Channels.newWriter((WritableByteChannel)c, "utf-8");
            XML$.MODULE$.write(w, storageNode, "utf-8", true, null);
            this.log("writing to " + this.theFile());
            w.close();
            c.close();
            fos.close();
            this.dirty_$eq(false);
            this.switch();
            this.log("[save done]");
        }
    }

    private Iterator load() {
        this.log("[load]\nloading " + this.theFile());
        Source src = Source$.MODULE$.fromFile(this.theFile());
        this.log("parsing " + this.theFile());
        Node res = ConstructingParser$.MODULE$.fromSource(src, false).document().docElem().apply(0);
        this.switch();
        this.log("[load done]");
        return res.child().elements();
    }

    public abstract void $minus$eq(Node var1);

    public abstract void $plus$eq(Node var1);

    public abstract Iterator nodes();

    /*
     * Enabled aggressive block sorting
     */
    public Iterator initialNodes() {
        Iterator iterator;
        boolean tp1 = this.file1().exists();
        boolean tp2 = this.file2().exists();
        if (!tp1) {
            if (!tp2) {
                this.theFile_$eq(this.file1());
                iterator = (Iterator)Iterator$.MODULE$.empty();
                return iterator;
            }
        } else if (tp1) {
            if (tp2 && this.gd1$1()) {
                this.theFile_$eq(this.file2());
                iterator = this.load();
                return iterator;
            }
            this.theFile_$eq(this.file1());
            iterator = this.load();
            return iterator;
        }
        this.theFile_$eq(this.file2());
        iterator = this.load();
        return iterator;
    }

    public /* synthetic */ int interval() {
        return this.interval;
    }

    public /* synthetic */ void dirty_$eq(boolean x$1) {
        this.dirty = x$1;
    }

    public /* synthetic */ boolean dirty() {
        return this.dirty;
    }

    private void switch() {
        File file = this.theFile();
        File file2 = this.file1();
        this.theFile_$eq(!(file != null ? !((Object)file).equals(file2) : file2 != null) ? this.file2() : this.file1());
    }

    private /* synthetic */ void theFile_$eq(File x$1) {
        this.theFile = x$1;
    }

    private /* synthetic */ File theFile() {
        return this.theFile;
    }

    private /* synthetic */ File file2() {
        return this.file2;
    }

    private /* synthetic */ File file1() {
        return this.file1;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }

    public void log(String x$1) {
        Logged$class.log(this, x$1);
    }
}

