/*
 * Decompiled with CFR 0.152.
 */
package scala.xml;

import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import org.xml.sax.InputSource;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.Utility$;
import scala.xml.dtd.DocType;
import scala.xml.parsing.NoBindingFactoryAdapter;

public final class XML$
implements ScalaObject {
    public static final XML$ MODULE$;
    private final String encoding;
    private final String lang;
    private final String space;
    private final String preserve;
    private final String namespace;
    private final String xmlns;
    private final String xml;

    static {
        new XML$();
    }

    public XML$() {
        this.xml = "xml";
        this.xmlns = "xmlns";
        this.namespace = "http://www.w3.org/XML/1998/namespace";
        this.preserve = "preserve";
        this.space = "space";
        this.lang = "lang";
        this.encoding = "ISO-8859-1";
        MODULE$ = this;
    }

    public final void write(Writer w, Node node, String enc, boolean xmlDecl, DocType doctype) {
        if (xmlDecl) {
            w.write("<?xml version='1.0' encoding='" + enc + "'?>\n");
        }
        if (doctype != null) {
            w.write(doctype.toString() + "\n");
        }
        w.write(Utility$.MODULE$.toXML(node));
    }

    public final void saveFull(String filename, Node node, String enc, boolean xmlDecl, DocType doctype) {
        FileOutputStream fos = null;
        Writer w = null;
        try {
            fos = new FileOutputStream(filename);
            w = Channels.newWriter((WritableByteChannel)fos.getChannel(), enc);
            this.write(w, node, enc, xmlDecl, doctype);
            w.close();
            fos.close();
            return;
        }
        catch (Throwable throwable) {
            w.close();
            fos.close();
            throw throwable;
        }
    }

    public final void saveFull(String filename, Node node, boolean xmlDecl, DocType doctype) {
        this.saveFull(filename, node, this.encoding(), xmlDecl, doctype);
    }

    public final void save(String filename, Node node, String enc) {
        this.saveFull(filename, node, enc, false, null);
    }

    public final void save(String filename, Node node) {
        this.save(filename, node, this.encoding());
    }

    public final Elem loadString(String string2) {
        return this.load(new StringReader(string2));
    }

    public final Elem load(InputSource source) {
        return new NoBindingFactoryAdapter().loadXML(source);
    }

    public final Elem load(String sysID) {
        return new NoBindingFactoryAdapter().loadXML(new InputSource(sysID));
    }

    public final Elem load(Reader reader) {
        return new NoBindingFactoryAdapter().loadXML(new InputSource(reader));
    }

    public final Elem load(InputStream is) {
        return new NoBindingFactoryAdapter().loadXML(new InputSource(is));
    }

    public final Elem loadFile(String fileName) {
        return new NoBindingFactoryAdapter().loadXML(new InputSource(new FileInputStream(fileName)));
    }

    public final Elem loadFile(FileDescriptor fileDesc) {
        return new NoBindingFactoryAdapter().loadXML(new InputSource(new FileInputStream(fileDesc)));
    }

    public final Elem loadFile(File file) {
        return new NoBindingFactoryAdapter().loadXML(new InputSource(new FileInputStream(file)));
    }

    public String encoding() {
        return this.encoding;
    }

    public String lang() {
        return this.lang;
    }

    public String space() {
        return this.space;
    }

    public String preserve() {
        return this.preserve;
    }

    public String namespace() {
        return this.namespace;
    }

    public String xmlns() {
        return this.xmlns;
    }

    public String xml() {
        return this.xml;
    }

    public int $tag() {
        return ScalaObject$class.$tag(this);
    }
}

