/*
 * Decompiled with CFR 0.152.
 */
package scala.util.parsing.input;

import scala.ScalaObject;
import scala.util.parsing.input.OffsetPosition;
import scala.util.parsing.input.Position;
import scala.util.parsing.input.Reader;

public class CharSequenceReader
extends Reader
implements ScalaObject {
    private final int offset;
    private final CharSequence source;

    public CharSequenceReader(CharSequence source, int offset) {
        this.source = source;
        this.offset = offset;
    }

    public CharSequenceReader drop(int n) {
        return new CharSequenceReader(this.source(), this.offset() + n);
    }

    public boolean atEnd() {
        return this.offset() >= this.source().length();
    }

    public Position pos() {
        return new OffsetPosition(this.source(), this.offset());
    }

    public CharSequenceReader rest() {
        return this.offset() < this.source().length() ? new CharSequenceReader(this.source(), this.offset() + 1) : this;
    }

    public char first() {
        return this.offset() < this.source().length() ? this.source().charAt(this.offset()) : (char)'\u001a';
    }

    public CharSequenceReader(CharSequence source) {
        this(source, 0);
    }

    public int offset() {
        return this.offset;
    }

    public CharSequence source() {
        return this.source;
    }
}

