/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import scala.List;
import scala.List$;
import scala.MatchError;
import scala.Nil$;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$Pair$;
import scala.ScalaObject;
import scala.ScalaObject$class;
import scala.Some;
import scala.StringBuilder;
import scala.actors.Debug$;
import scala.actors.remote.JavaSerializer;
import scala.actors.remote.NetKernel;
import scala.actors.remote.Node;
import scala.actors.remote.Service;
import scala.actors.remote.Service$class;
import scala.actors.remote.TcpService$;
import scala.actors.remote.TcpServiceWorker;
import scala.collection.mutable.HashMap;
import scala.runtime.BoxedObjectArray;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpService
extends Thread
implements Service,
ScalaObject {
    private final NetKernel kernel;
    private final HashMap<Node, TcpServiceWorker> connections;
    private boolean shouldTerminate;
    private final HashMap<Node, List<byte[]>> pendingSends;
    private final Node internalNode;
    private final JavaSerializer serializer;
    private final int port;

    public TcpService(int port, ClassLoader cl) {
        this.port = port;
        Service$class.$init$(this);
        this.serializer = new JavaSerializer(this, cl);
        this.internalNode = new Node(InetAddress.getLocalHost().getHostAddress(), port);
        this.pendingSends = new HashMap();
        this.shouldTerminate = false;
        this.connections = new HashMap();
    }

    private final void liftedTree1$1(Node node, byte[] byArray) {
        block5: {
            try {
                TcpServiceWorker newWorker$1 = this.connect(node);
                newWorker$1.transmit(byArray);
                Option option = this.pendingSends().get(node);
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (!(none$ == null ? option2 != null : !none$.equals(option2))) break block5;
                if (option instanceof Some) {
                    ((List)((Some)option).x()).foreach(new $anonfun$liftedTree1$1$1(this, newWorker$1));
                    this.pendingSends().$minus$eq(node);
                    break block5;
                }
                throw new MatchError(option);
            }
            catch (SecurityException securityException) {
            }
            catch (IOException iOException) {
                this.bufferMsg$1(iOException, node, byArray);
            }
            catch (UnknownHostException unknownHostException) {
                this.bufferMsg$1(unknownHostException, node, byArray);
            }
        }
    }

    private final void bufferMsg$1(Throwable t, Node node, byte[] byArray) {
        Option option;
        block4: {
            block5: {
                block3: {
                    block2: {
                        option = this.pendingSends().get(node);
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                        this.pendingSends().$plus$eq(Predef$Pair$.MODULE$.apply(node, List$.MODULE$.apply(new BoxedObjectArray((Object[])new byte[][]{byArray}))));
                        break block3;
                    }
                    if (!(option instanceof Some)) break block4;
                    Some some = (Some)option;
                    List list2 = (List)some.x();
                    List msgs = list2;
                    if (!this.gd1$1(msgs)) break block5;
                    byte[] byArray2 = byArray;
                    this.pendingSends().$plus$eq(Predef$Pair$.MODULE$.apply(node, list2.$colon$colon(byArray2)));
                }
                return;
            }
            throw new MatchError(option);
        }
        throw new MatchError(option);
    }

    private final /* synthetic */ boolean gd1$1(List x$1) {
        return x$1.length() < TcpService$.MODULE$.BufSize();
    }

    public void nodeDown(Node mnode) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.connections().$minus$eq(mnode);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isReachable(Node node) {
        boolean bl;
        if (this.isConnected(node)) {
            bl = true;
        } else {
            void var2_2;
            boolean exceptionResult2 = false;
            try {
                this.connect(node);
                return true;
            }
            catch (SecurityException securityException) {
                exceptionResult2 = false;
            }
            catch (IOException iOException) {
                exceptionResult2 = false;
            }
            catch (UnknownHostException unknownHostException) {
                exceptionResult2 = false;
            }
            bl = var2_2;
        }
        return bl;
    }

    public void disconnectNode(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Option option;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        option = this.connections().get(n);
                        None$ none$ = None$.MODULE$;
                        Option option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!(option instanceof Some)) break block7;
                    this.connections().$minus$eq(n);
                    ((TcpServiceWorker)((Some)option).x()).halt();
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public TcpServiceWorker connect(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Socket sock = new Socket(n.address(), n.port());
            TcpServiceWorker worker = new TcpServiceWorker(this, sock);
            worker.sendNode(n);
            worker.start();
            this.addConnection(n, worker);
            return worker;
        }
    }

    public boolean isConnected(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            return BoxesRunTime.unboxToBoolean(BoxesRunTime.boxToBoolean(!this.connections().get(n).isEmpty()));
        }
    }

    public Option<TcpServiceWorker> getConnection(Node n) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            return this.connections().get(n);
        }
    }

    public void addConnection(Node node, TcpServiceWorker worker) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            this.connections().$plus$eq(Predef$Pair$.MODULE$.apply(node, worker));
            return;
        }
    }

    private HashMap<Node, TcpServiceWorker> connections() {
        return this.connections;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        socket = new ServerSocket(this.port);
        while (!this.shouldTerminate()) {
            Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": waiting for new connection..."));
            nextClient = socket.accept();
            if (this.shouldTerminate()) {
                nextClient.close();
                continue;
            }
            worker = new TcpServiceWorker(this, nextClient);
            Debug$.MODULE$.info(new StringBuilder().append((Object)"Started new ").append(worker).toString());
            worker.readNode();
            worker.start();
        }
        ** GOTO lbl39
        {
            catch (Exception var1_9) {
                Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": caught ")).append(var1_9).toString());
                Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
                workers$1 = new ObjectRef(Nil$.MODULE$);
                this.connections().values().foreach(new $anonfun$run$1(this, workers$1));
                ((List)workers$1.elem).foreach(new $anonfun$run$2(this));
                return;
            }
            catch (SecurityException var2_10) {
                Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": caught ")).append(var2_10).toString());
                Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
                workers$1 = new ObjectRef(Nil$.MODULE$);
                this.connections().values().foreach(new $anonfun$run$1(this, workers$1));
                ((List)workers$1.elem).foreach(new $anonfun$run$2(this));
                return;
                catch (IOException var3_11) {
                    try {
                        Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": caught ")).append(var3_11).toString());
                        Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
                        workers$1 = new ObjectRef(Nil$.MODULE$);
                        this.connections().values().foreach(new $anonfun$run$1(this, workers$1));
                        ((List)workers$1.elem).foreach(new $anonfun$run$2(this));
                        return;
                    }
                    catch (Throwable var4_12) {
                        Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
                        workers$1 = new ObjectRef(Nil$.MODULE$);
                        this.connections().values().foreach(new $anonfun$run$1(this, workers$1));
                        ((List)workers$1.elem).foreach(new $anonfun$run$2(this));
                        throw var4_12;
                        break;
                    }
lbl39:
                    // 1 sources

                    Debug$.MODULE$.info(Predef$.MODULE$.any2stringadd(this).$plus(": shutting down..."));
                    workers$1 = new ObjectRef(Nil$.MODULE$);
                    this.connections().values().foreach(new $anonfun$run$1(this, workers$1));
                    ((List)workers$1.elem).foreach(new $anonfun$run$2(this));
                    return;
                }
            }
        }
    }

    private void shouldTerminate_$eq(boolean x$1) {
        this.shouldTerminate = x$1;
    }

    private boolean shouldTerminate() {
        return this.shouldTerminate;
    }

    @Override
    public void terminate() {
        this.shouldTerminate_$eq(true);
        try {
            new Socket(this.internalNode().address(), this.internalNode().port());
        }
        catch (ConnectException connectException) {
            Debug$.MODULE$.info(new StringBuilder().append((Object)Predef$.MODULE$.any2stringadd(this).$plus(": caught ")).append(connectException).toString());
        }
    }

    @Override
    public void send(Node node$1, byte[] data$1) {
        TcpService tcpService = this;
        synchronized (tcpService) {
            Option<TcpServiceWorker> option;
            block7: {
                block6: {
                    BoxedUnit boxedUnit;
                    block5: {
                        option = this.getConnection(node$1);
                        None$ none$ = None$.MODULE$;
                        Option<TcpServiceWorker> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block5;
                        this.liftedTree1$1(node$1, data$1);
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!(option instanceof Some)) break block7;
                    ((TcpServiceWorker)((Some)option).x()).transmit(data$1);
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    private HashMap<Node, List<byte[]>> pendingSends() {
        return this.pendingSends;
    }

    @Override
    public Node node() {
        return this.internalNode();
    }

    private Node internalNode() {
        return this.internalNode;
    }

    @Override
    public JavaSerializer serializer() {
        return this.serializer;
    }

    @Override
    public int $tag() throws RemoteException {
        return ScalaObject$class.$tag(this);
    }

    @Override
    public void kernel_$eq(NetKernel x$1) {
        this.kernel = x$1;
    }

    @Override
    public NetKernel kernel() {
        return this.kernel;
    }
}

