/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.remote;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import scala.MatchError;
import scala.ScalaObject;
import scala.actors.Debug$;
import scala.actors.remote.Node;
import scala.actors.remote.TcpService;
import scala.collection.mutable.StringBuilder;
import scala.runtime.StringAdd;

public class TcpServiceWorker
extends Thread
implements ScalaObject {
    private boolean running;
    private Node connectedNode;
    private final DataOutputStream dataout;
    private final DataInputStream datain;
    private final Socket so;
    private final TcpService parent;

    public TcpServiceWorker(TcpService parent, Socket so) {
        this.parent = parent;
        this.so = so;
        this.datain = new DataInputStream(so.getInputStream());
        this.dataout = new DataOutputStream(so.getOutputStream());
        this.running = true;
    }

    public void run() {
        try {
            while (this.running()) {
                Object msg = this.parent.serializer().readObject(this.datain());
                this.parent.kernel().processMsg(this.connectedNode(), msg);
            }
        }
        catch (Exception exception) {
            Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": caught ")).append(exception).toString());
            this.parent.nodeDown(this.connectedNode());
        }
        catch (IOException iOException) {
            Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": caught ")).append(iOException).toString());
            this.parent.nodeDown(this.connectedNode());
        }
        Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": service terminated at ")).append(this.parent.node()).toString());
    }

    public void halt() {
        synchronized (this) {
            this.so.close();
            this.running_$eq(false);
            return;
        }
    }

    public void running_$eq(boolean bl) {
        this.running = bl;
    }

    public boolean running() {
        return this.running;
    }

    public void transmit(byte[] data2) {
        synchronized (this) {
            Debug$.MODULE$.info(new StringAdd(this).$plus(": transmitting data..."));
            this.dataout().writeInt(data2.length);
            this.dataout().write(data2);
            this.dataout().flush();
            return;
        }
    }

    public void readNode() {
        Object node = this.parent.serializer().readObject(this.datain());
        if (node instanceof Node) {
            Node temp25 = (Node)node;
            if (true) {
                this.connectedNode_$eq(temp25);
                this.parent.addConnection(temp25, this);
                return;
            }
            throw new MatchError(node.toString());
        }
        throw new MatchError(node.toString());
    }

    public void sendNode(Node n) {
        this.connectedNode_$eq(n);
        this.parent.serializer().writeObject(this.dataout(), this.parent.node());
    }

    public void connectedNode_$eq(Node node) {
        this.connectedNode = node;
    }

    public Node connectedNode() {
        return this.connectedNode;
    }

    public DataOutputStream dataout() {
        return this.dataout;
    }

    public DataInputStream datain() {
        return this.datain;
    }
}

