/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.scheduler;

import java.security.AccessControlException;
import scala.None$;
import scala.Option;
import scala.ScalaObject;
import scala.Some;
import scala.actors.Debug$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.StringAdd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThreadPoolConfig$
implements ScalaObject {
    public static final ThreadPoolConfig$ MODULE$;
    private final int maxPoolSize;
    private final int corePoolSize;
    private final int minNumThreads;
    private final Runtime rt;

    static {
        new ThreadPoolConfig$();
    }

    private ThreadPoolConfig$() {
        int n;
        int byCores;
        Some temp2;
        int temp3;
        MODULE$ = this;
        this.rt = Runtime.getRuntime();
        this.minNumThreads = 4;
        Option<Integer> temp1 = this.getIntegerProp("actors.corePoolSize");
        this.corePoolSize = temp1 instanceof Some && this.gd1$1(temp3 = BoxesRunTime.unboxToInt((temp2 = (Some)temp1).x())) ? temp3 : ((byCores = this.rt().availableProcessors() * 2) > this.minNumThreads() ? byCores : this.minNumThreads());
        Option<Integer> temp4 = this.getIntegerProp("actors.maxPoolSize");
        if (temp4 instanceof Some) {
            int temp6;
            Some temp5 = (Some)temp4;
            n = temp6 = BoxesRunTime.unboxToInt(temp5.x());
        } else {
            n = 256;
        }
        int preMaxSize = n;
        this.maxPoolSize = preMaxSize >= this.corePoolSize() ? preMaxSize : this.corePoolSize();
    }

    private final /* synthetic */ boolean gd1$1(int n) {
        return n > 0;
    }

    public boolean useForkJoin() {
        boolean exceptionResult2;
        try {
            boolean bl;
            String fjProp = System.getProperty("actors.enableForkJoin");
            if (fjProp == null || fjProp.equals(null)) {
                String javaVersion = System.getProperty("java.version");
                String jvmVendor = System.getProperty("java.vm.vendor");
                Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": java.version = ")).append((Object)javaVersion).toString());
                Debug$.MODULE$.info(new StringBuilder().append((Object)new StringAdd(this).$plus(": java.vm.vendor = ")).append((Object)jvmVendor).toString());
                bl = (javaVersion.indexOf("1.6") != -1 || javaVersion.indexOf("1.7") != -1) && jvmVendor.indexOf("Sun") != -1;
            } else {
                bl = fjProp.equals("true");
            }
            exceptionResult2 = bl;
        }
        catch (SecurityException securityException) {
            exceptionResult2 = false;
        }
        return exceptionResult2;
    }

    public int maxPoolSize() {
        return this.maxPoolSize;
    }

    public int corePoolSize() {
        return this.corePoolSize;
    }

    private Option<Integer> getIntegerProp(String propName) {
        Option exceptionResult1;
        try {
            String prop = System.getProperty(propName);
            int n = Integer.parseInt(prop);
            exceptionResult1 = new Some<Integer>(BoxesRunTime.boxToInteger(n));
        }
        catch (NumberFormatException numberFormatException) {
            exceptionResult1 = None$.MODULE$;
        }
        catch (AccessControlException accessControlException) {
            exceptionResult1 = None$.MODULE$;
        }
        return exceptionResult1;
    }

    private int minNumThreads() {
        return this.minNumThreads;
    }

    private Runtime rt() {
        return this.rt;
    }
}

