/*
 * Decompiled with CFR 0.152.
 */
package scala;

import java.io.Serializable;
import java.math.BigInteger;
import scala.BigInt$;
import scala.GenericRange;
import scala.Range$BigInt$;
import scala.ScalaObject;
import scala.Tuple2;
import scala.util.Random;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigInt
extends Number
implements ScalaObject,
Serializable {
    private final BigInteger bigInteger;

    public static final BigInt long2bigInt(long l) {
        return BigInt$.MODULE$.long2bigInt(l);
    }

    public static final BigInt int2bigInt(int n) {
        return BigInt$.MODULE$.int2bigInt(n);
    }

    public static final BigInt probablePrime(int n, Random random) {
        return BigInt$.MODULE$.probablePrime(n, random);
    }

    public static final BigInt apply(String string2, int n) {
        return BigInt$.MODULE$.apply(string2, n);
    }

    public static final BigInt apply(String string2) {
        return BigInt$.MODULE$.apply(string2);
    }

    public static final BigInt apply(int n, Random random) {
        return BigInt$.MODULE$.apply(n, random);
    }

    public static final BigInt apply(int n, int n2, Random random) {
        return BigInt$.MODULE$.apply(n, n2, random);
    }

    public static final BigInt apply(int n, byte[] byArray) {
        return BigInt$.MODULE$.apply(n, byArray);
    }

    public static final BigInt apply(byte[] byArray) {
        return BigInt$.MODULE$.apply(byArray);
    }

    public static final BigInt apply(long l) {
        return BigInt$.MODULE$.apply(l);
    }

    public static final BigInt apply(int n) {
        return BigInt$.MODULE$.apply(n);
    }

    public BigInt(BigInteger bigInteger) {
        this.bigInteger = bigInteger;
    }

    public /* synthetic */ BigInt until$default$2() {
        return BigInt$.MODULE$.apply(1);
    }

    public /* synthetic */ BigInt to$default$2() {
        return BigInt$.MODULE$.apply(1);
    }

    public byte[] toByteArray() {
        return this.bigInteger().toByteArray();
    }

    public String toString(int radix) {
        return this.bigInteger().toString(radix);
    }

    public String toString() {
        return this.bigInteger().toString();
    }

    public GenericRange.Inclusive<BigInt> to(BigInt end, BigInt step) {
        return Range$BigInt$.MODULE$.inclusive(this, end, step);
    }

    public GenericRange.Exclusive<BigInt> until(BigInt end, BigInt step) {
        return Range$BigInt$.MODULE$.apply(this, end, step);
    }

    @Override
    public double doubleValue() {
        return this.bigInteger().doubleValue();
    }

    @Override
    public float floatValue() {
        return this.bigInteger().floatValue();
    }

    @Override
    public long longValue() {
        return this.bigInteger().longValue();
    }

    @Override
    public int intValue() {
        return this.bigInteger().intValue();
    }

    public char charValue() {
        return (char)this.intValue();
    }

    @Override
    public short shortValue() {
        return (short)this.intValue();
    }

    @Override
    public byte byteValue() {
        return (byte)this.intValue();
    }

    public boolean isProbablePrime(int certainty) {
        return this.bigInteger().isProbablePrime(certainty);
    }

    public int bitCount() {
        return this.bigInteger().bitCount();
    }

    public int bitLength() {
        return this.bigInteger().bitLength();
    }

    public int lowestSetBit() {
        return this.bigInteger().getLowestSetBit();
    }

    public BigInt flipBit(int n) {
        return new BigInt(this.bigInteger().flipBit(n));
    }

    public BigInt clearBit(int n) {
        return new BigInt(this.bigInteger().clearBit(n));
    }

    public BigInt setBit(int n) {
        return new BigInt(this.bigInteger().setBit(n));
    }

    public boolean testBit(int n) {
        return this.bigInteger().testBit(n);
    }

    public BigInt $tilde() {
        return new BigInt(this.bigInteger().not());
    }

    public int signum() {
        return this.bigInteger().signum();
    }

    public BigInt abs() {
        return new BigInt(this.bigInteger().abs());
    }

    public BigInt unary_$minus() {
        return new BigInt(this.bigInteger().negate());
    }

    public BigInt modInverse(BigInt m) {
        return new BigInt(this.bigInteger().modInverse(m.bigInteger()));
    }

    public BigInt modPow(BigInt exp, BigInt m) {
        return new BigInt(this.bigInteger().modPow(exp.bigInteger(), m.bigInteger()));
    }

    public BigInt pow(int exp) {
        return new BigInt(this.bigInteger().pow(exp));
    }

    public BigInt max(BigInt that) {
        return new BigInt(this.bigInteger().max(that.bigInteger()));
    }

    public BigInt min(BigInt that) {
        return new BigInt(this.bigInteger().min(that.bigInteger()));
    }

    public BigInt mod(BigInt that) {
        return new BigInt(this.bigInteger().mod(that.bigInteger()));
    }

    public BigInt gcd(BigInt that) {
        return new BigInt(this.bigInteger().gcd(that.bigInteger()));
    }

    public BigInt $amp$tilde(BigInt that) {
        return new BigInt(this.bigInteger().andNot(that.bigInteger()));
    }

    public BigInt $up(BigInt that) {
        return new BigInt(this.bigInteger().xor(that.bigInteger()));
    }

    public BigInt $bar(BigInt that) {
        return new BigInt(this.bigInteger().or(that.bigInteger()));
    }

    public BigInt $amp(BigInt that) {
        return new BigInt(this.bigInteger().and(that.bigInteger()));
    }

    public BigInt $greater$greater(int n) {
        return new BigInt(this.bigInteger().shiftRight(n));
    }

    public BigInt $less$less(int n) {
        return new BigInt(this.bigInteger().shiftLeft(n));
    }

    public Tuple2<BigInt, BigInt> $div$percent(BigInt that) {
        BigInteger[] dr = this.bigInteger().divideAndRemainder(that.bigInteger());
        return new Tuple2<BigInt, BigInt>(new BigInt(dr[0]), new BigInt(dr[1]));
    }

    public BigInt $percent(BigInt that) {
        return new BigInt(this.bigInteger().remainder(that.bigInteger()));
    }

    public BigInt $div(BigInt that) {
        return new BigInt(this.bigInteger().divide(that.bigInteger()));
    }

    public BigInt $times(BigInt that) {
        return new BigInt(this.bigInteger().multiply(that.bigInteger()));
    }

    public BigInt $minus(BigInt that) {
        return new BigInt(this.bigInteger().subtract(that.bigInteger()));
    }

    public BigInt $plus(BigInt that) {
        return new BigInt(this.bigInteger().add(that.bigInteger()));
    }

    public boolean $greater(BigInt that) {
        return this.compare(that) > 0;
    }

    public boolean $less(BigInt that) {
        return this.compare(that) < 0;
    }

    public boolean $greater$eq(BigInt that) {
        return this.compare(that) >= 0;
    }

    public boolean $less$eq(BigInt that) {
        return this.compare(that) <= 0;
    }

    public int compare(BigInt that) {
        return this.bigInteger().compareTo(that.bigInteger());
    }

    public boolean equals(BigInt that) {
        return this.compare(that) == 0;
    }

    public boolean equals(Object that) {
        boolean bl;
        Object temp1 = that;
        if (temp1 instanceof BigInt) {
            BigInt temp2 = (BigInt)temp1;
            bl = this.equals(temp2);
        } else if (temp1 instanceof BigInteger) {
            BigInteger temp3 = (BigInteger)temp1;
            bl = this.equals(new BigInt(temp3));
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.bigInteger().hashCode();
    }

    public BigInteger bigInteger() {
        return this.bigInteger;
    }
}

