/*
 * Decompiled with CFR 0.152.
 */
package scala;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import scala.Option;
import scala.ScalaObject;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UniquenessCache<K, V>
implements ScalaObject {
    private final WeakHashMap<K, WeakReference<V>> map;
    private final ReentrantReadWriteLock.WriteLock wlock;
    private final ReentrantReadWriteLock.ReadLock rlock;
    private final ReentrantReadWriteLock rwl;
    private final ReferenceQueue<V> queue = new ReferenceQueue();

    public UniquenessCache() {
        this.rwl = new ReentrantReadWriteLock();
        this.rlock = this.rwl().readLock();
        this.wlock = this.rwl().writeLock();
        this.map = new WeakHashMap();
    }

    private final Object updateCache$1(Object object) {
        this.wlock().lock();
        Object exceptionResult2 = null;
        try {
            Object object2;
            Object res = this.cached$1(object);
            if (BoxesRunTime.equals(res, null)) {
                V sym = this.valueFromKey(object);
                this.map().put(object, new WeakReference<V>(sym, this.queue()));
                object2 = sym;
            } else {
                object2 = res;
            }
            exceptionResult2 = object2;
            this.wlock().unlock();
            return exceptionResult2;
        }
        catch (Throwable throwable) {
            this.wlock().unlock();
            throw throwable;
        }
    }

    private final Object cached$1(Object object) {
        this.rlock().lock();
        Object exceptionResult1 = null;
        try {
            WeakReference<V> reference;
            WeakReference<V> weakReference = reference = this.map().get(object);
            exceptionResult1 = weakReference == null || weakReference.equals(null) ? null : reference.get();
            this.rlock().unlock();
            return exceptionResult1;
        }
        catch (Throwable throwable) {
            this.rlock().unlock();
            throw throwable;
        }
    }

    public Option<K> unapply(V other) {
        return this.keyFromValue(other);
    }

    public V apply(K name$1) {
        Object res = this.cached$1(name$1);
        return (V)(BoxesRunTime.equals(res, null) ? this.updateCache$1(name$1) : res);
    }

    public abstract Option<K> keyFromValue(V var1);

    public abstract V valueFromKey(K var1);

    private WeakHashMap<K, WeakReference<V>> map() {
        return this.map;
    }

    private ReentrantReadWriteLock.WriteLock wlock() {
        return this.wlock;
    }

    private ReentrantReadWriteLock.ReadLock rlock() {
        return this.rlock;
    }

    private ReentrantReadWriteLock rwl() {
        return this.rwl;
    }

    private ReferenceQueue<V> queue() {
        return this.queue;
    }
}

