/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.forkjoin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import scala.actors.forkjoin.ForkJoinPool;
import scala.actors.forkjoin.ForkJoinWorkerThread;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ForkJoinTask<V>
implements Future<V>,
Serializable {
    volatile int status;
    static final int COMPLETION_MASK = -536870912;
    static final int NORMAL = -536870912;
    static final int CANCELLED = -1073741824;
    static final int EXCEPTIONAL = -1610612736;
    static final int SIGNAL_MASK = 65535;
    static final int INTERNAL_SIGNAL_MASK = Short.MAX_VALUE;
    static final int EXTERNAL_SIGNAL = 32768;
    static final Map<ForkJoinTask<?>, Throwable> exceptionMap = Collections.synchronizedMap(new WeakHashMap());
    private static final long serialVersionUID = -7721805057305804111L;
    static final Unsafe _unsafe;
    static final long statusOffset;

    static ForkJoinWorkerThread getWorker() {
        Thread thread = Thread.currentThread();
        return thread instanceof ForkJoinWorkerThread ? (ForkJoinWorkerThread)thread : null;
    }

    final boolean casStatus(int n, int n2) {
        return _unsafe.compareAndSwapInt(this, statusOffset, n, n2);
    }

    static void rethrowException(Throwable throwable) {
        if (throwable != null) {
            _unsafe.throwException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCompletion(int n) {
        ForkJoinPool forkJoinPool = ForkJoinTask.getPool();
        if (forkJoinPool != null) {
            int n2;
            while ((n2 = this.status) >= 0 && !this.casStatus(n2, n)) {
            }
            if ((n2 & 0xFFFF) != 0) {
                if ((n2 &= Short.MAX_VALUE) != 0) {
                    forkJoinPool.updateRunningCount(n2);
                }
                ForkJoinTask forkJoinTask = this;
                synchronized (forkJoinTask) {
                    this.notifyAll();
                }
            }
        } else {
            this.externallySetCompletion(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void externallySetCompletion(int n) {
        int n2;
        while ((n2 = this.status) >= 0 && !this.casStatus(n2, n2 & 0xFFFF | n)) {
        }
        ForkJoinTask forkJoinTask = this;
        synchronized (forkJoinTask) {
            this.notifyAll();
        }
    }

    final void setNormalCompletion() {
        if (!_unsafe.compareAndSwapInt(this, statusOffset, 0, -536870912)) {
            this.setCompletion(-536870912);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doAwaitDone() {
        try {
            while (this.status >= 0) {
                ForkJoinTask forkJoinTask = this;
                synchronized (forkJoinTask) {
                    if (this.status >= 0) {
                        this.wait();
                    }
                }
            }
            return;
        }
        catch (InterruptedException interruptedException) {
            this.onInterruptedWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAwaitDone(long l, long l2) {
        ForkJoinTask forkJoinTask = this;
        synchronized (forkJoinTask) {
            try {
                long l3;
                while (this.status >= 0 && (l3 = l2 - System.nanoTime() - l) > 0L) {
                    this.wait(l3 / 1000000L, (int)(l3 % 1000000L));
                }
            }
            catch (InterruptedException interruptedException) {
                this.onInterruptedWait();
            }
        }
    }

    private int awaitDone(ForkJoinWorkerThread forkJoinWorkerThread, boolean bl) {
        int n;
        ForkJoinPool forkJoinPool;
        ForkJoinPool forkJoinPool2 = forkJoinPool = forkJoinWorkerThread == null ? null : forkJoinWorkerThread.pool;
        while ((n = this.status) >= 0) {
            if (!this.casStatus(n, forkJoinPool == null ? n | 0x8000 : n + 1)) continue;
            if (forkJoinPool == null || !forkJoinPool.preJoin(this, bl)) {
                this.doAwaitDone();
            }
            if (((n = this.status) & Short.MAX_VALUE) == 0) break;
            this.adjustPoolCountsOnUnblock(forkJoinPool);
            break;
        }
        return n;
    }

    private int awaitDone(ForkJoinWorkerThread forkJoinWorkerThread, long l) {
        int n;
        ForkJoinPool forkJoinPool;
        ForkJoinPool forkJoinPool2 = forkJoinPool = forkJoinWorkerThread == null ? null : forkJoinWorkerThread.pool;
        while ((n = this.status) >= 0) {
            if (!this.casStatus(n, forkJoinPool == null ? n | 0x8000 : n + 1)) continue;
            long l2 = System.nanoTime();
            if (forkJoinPool == null || !forkJoinPool.preJoin(this, false)) {
                this.doAwaitDone(l2, l);
            }
            if ((n = this.status) >= 0) {
                this.adjustPoolCountsOnCancelledWait(forkJoinPool);
                n = this.status;
            }
            if (n >= 0 || (n & Short.MAX_VALUE) == 0) break;
            this.adjustPoolCountsOnUnblock(forkJoinPool);
            break;
        }
        return n;
    }

    private void adjustPoolCountsOnUnblock(ForkJoinPool forkJoinPool) {
        int n;
        while ((n = this.status) < 0 && !this.casStatus(n, n & 0xE0000000)) {
        }
        if (forkJoinPool != null && (n &= Short.MAX_VALUE) != 0) {
            forkJoinPool.updateRunningCount(n);
        }
    }

    private void adjustPoolCountsOnCancelledWait(ForkJoinPool forkJoinPool) {
        if (forkJoinPool != null) {
            int n;
            while ((n = this.status) >= 0 && (n & Short.MAX_VALUE) != 0) {
                if (!this.casStatus(n, n - 1)) continue;
                forkJoinPool.updateRunningCount(1);
                break;
            }
        }
    }

    private void onInterruptedWait() {
        ForkJoinWorkerThread forkJoinWorkerThread = ForkJoinTask.getWorker();
        if (forkJoinWorkerThread == null) {
            Thread.currentThread().interrupt();
        } else if (forkJoinWorkerThread.isTerminating()) {
            this.cancelIgnoringExceptions();
        }
    }

    private void setDoneExceptionally(Throwable throwable) {
        exceptionMap.put(this, throwable);
        this.setCompletion(-1610612736);
    }

    private void reportException(int n) {
        if ((n &= 0xE0000000) < -536870912) {
            if (n == -1073741824) {
                throw new CancellationException();
            }
            ForkJoinTask.rethrowException(exceptionMap.get(this));
        }
    }

    private V reportFutureResult() throws ExecutionException, InterruptedException {
        int n = this.status & 0xE0000000;
        if (n < -536870912) {
            Throwable throwable;
            if (n == -1073741824) {
                throw new CancellationException();
            }
            if (n == -1610612736 && (throwable = exceptionMap.get(this)) != null) {
                throw new ExecutionException(throwable);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
        return this.getRawResult();
    }

    private V reportTimedFutureResult() throws InterruptedException, ExecutionException, TimeoutException {
        Throwable throwable;
        int n = this.status & 0xE0000000;
        if (n == -536870912) {
            return this.getRawResult();
        }
        if (n == -1073741824) {
            throw new CancellationException();
        }
        if (n == -1610612736 && (throwable = exceptionMap.get(this)) != null) {
            throw new ExecutionException(throwable);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        throw new TimeoutException();
    }

    private boolean tryExec() {
        try {
            if (!this.exec()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            this.setDoneExceptionally(throwable);
            ForkJoinTask.rethrowException(throwable);
            return false;
        }
        this.setNormalCompletion();
        return true;
    }

    final void quietlyExec() {
        if (this.status >= 0) {
            try {
                if (!this.exec()) {
                    return;
                }
            }
            catch (Throwable throwable) {
                this.setDoneExceptionally(throwable);
                return;
            }
            this.setNormalCompletion();
        }
    }

    private boolean tryQuietlyInvoke() {
        try {
            if (!this.exec()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            this.setDoneExceptionally(throwable);
            return false;
        }
        this.setNormalCompletion();
        return true;
    }

    final void cancelIgnoringExceptions() {
        try {
            this.cancel(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int busyJoin(ForkJoinWorkerThread forkJoinWorkerThread) {
        ForkJoinTask<?> forkJoinTask;
        int n;
        while ((n = this.status) >= 0 && (forkJoinTask = forkJoinWorkerThread.scanWhileJoining(this)) != null) {
            forkJoinTask.quietlyExec();
        }
        return n >= 0 ? this.awaitDone(forkJoinWorkerThread, false) : n;
    }

    public final void fork() {
        ((ForkJoinWorkerThread)Thread.currentThread()).pushTask(this);
    }

    public final V join() {
        ForkJoinWorkerThread forkJoinWorkerThread = ForkJoinTask.getWorker();
        if (forkJoinWorkerThread == null || this.status < 0 || !forkJoinWorkerThread.unpushTask(this) || !this.tryExec()) {
            this.reportException(this.awaitDone(forkJoinWorkerThread, true));
        }
        return this.getRawResult();
    }

    public final V invoke() {
        if (this.status >= 0 && this.tryExec()) {
            return this.getRawResult();
        }
        return this.join();
    }

    public static void invokeAll(ForkJoinTask<?> forkJoinTask, ForkJoinTask<?> forkJoinTask2) {
        forkJoinTask2.fork();
        forkJoinTask.invoke();
        forkJoinTask2.join();
    }

    public static void invokeAll(ForkJoinTask<?> ... forkJoinTaskArray) {
        ForkJoinTask<?> forkJoinTask;
        int n;
        int n2;
        Throwable throwable = null;
        for (n2 = n = forkJoinTaskArray.length - 1; n2 >= 0; --n2) {
            forkJoinTask = forkJoinTaskArray[n2];
            if (forkJoinTask == null) {
                if (throwable != null) continue;
                throwable = new NullPointerException();
                continue;
            }
            if (n2 != 0) {
                forkJoinTask.fork();
                continue;
            }
            forkJoinTask.quietlyInvoke();
            if (throwable != null) continue;
            throwable = forkJoinTask.getException();
        }
        for (n2 = 1; n2 <= n; ++n2) {
            forkJoinTask = forkJoinTaskArray[n2];
            if (forkJoinTask == null) continue;
            if (throwable != null) {
                forkJoinTask.cancel(false);
                continue;
            }
            forkJoinTask.quietlyJoin();
            if (throwable != null) continue;
            throwable = forkJoinTask.getException();
        }
        if (throwable != null) {
            ForkJoinTask.rethrowException(throwable);
        }
    }

    public static void invokeAll(Collection<? extends ForkJoinTask<?>> collection) {
        ForkJoinTask forkJoinTask;
        int n;
        int n2;
        if (!(collection instanceof List)) {
            ForkJoinTask.invokeAll(collection.toArray(new ForkJoinTask[collection.size()]));
            return;
        }
        List list2 = (List)collection;
        Throwable throwable = null;
        for (n2 = n = list2.size() - 1; n2 >= 0; --n2) {
            forkJoinTask = (ForkJoinTask)list2.get(n2);
            if (forkJoinTask == null) {
                if (throwable != null) continue;
                throwable = new NullPointerException();
                continue;
            }
            if (n2 != 0) {
                forkJoinTask.fork();
                continue;
            }
            forkJoinTask.quietlyInvoke();
            if (throwable != null) continue;
            throwable = forkJoinTask.getException();
        }
        for (n2 = 1; n2 <= n; ++n2) {
            forkJoinTask = (ForkJoinTask)list2.get(n2);
            if (forkJoinTask == null) continue;
            if (throwable != null) {
                forkJoinTask.cancel(false);
                continue;
            }
            forkJoinTask.quietlyJoin();
            if (throwable != null) continue;
            throwable = forkJoinTask.getException();
        }
        if (throwable != null) {
            ForkJoinTask.rethrowException(throwable);
        }
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return (this.status & 0xE0000000) == -1073741824;
    }

    @Override
    public boolean cancel(boolean bl) {
        this.setCompletion(-1073741824);
        return (this.status & 0xE0000000) == -1073741824;
    }

    public final boolean isCompletedAbnormally() {
        return (this.status & 0xE0000000) < -536870912;
    }

    public final Throwable getException() {
        int n = this.status & 0xE0000000;
        if (n >= -536870912) {
            return null;
        }
        if (n == -1073741824) {
            return new CancellationException();
        }
        return exceptionMap.get(this);
    }

    public void completeExceptionally(Throwable throwable) {
        this.setDoneExceptionally(throwable instanceof RuntimeException || throwable instanceof Error ? throwable : new RuntimeException(throwable));
    }

    public void complete(V v) {
        try {
            this.setRawResult(v);
        }
        catch (Throwable throwable) {
            this.setDoneExceptionally(throwable);
            return;
        }
        this.setNormalCompletion();
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        ForkJoinWorkerThread forkJoinWorkerThread = ForkJoinTask.getWorker();
        if (forkJoinWorkerThread == null || this.status < 0 || !forkJoinWorkerThread.unpushTask(this) || !this.tryQuietlyInvoke()) {
            this.awaitDone(forkJoinWorkerThread, true);
        }
        return this.reportFutureResult();
    }

    @Override
    public final V get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        ForkJoinWorkerThread forkJoinWorkerThread = ForkJoinTask.getWorker();
        if (forkJoinWorkerThread == null || this.status < 0 || !forkJoinWorkerThread.unpushTask(this) || !this.tryQuietlyInvoke()) {
            this.awaitDone(forkJoinWorkerThread, timeUnit.toNanos(l));
        }
        return this.reportTimedFutureResult();
    }

    public final V helpJoin() {
        ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)Thread.currentThread();
        if (this.status < 0 || !forkJoinWorkerThread.unpushTask(this) || !this.tryExec()) {
            this.reportException(this.busyJoin(forkJoinWorkerThread));
        }
        return this.getRawResult();
    }

    public final void quietlyHelpJoin() {
        ForkJoinWorkerThread forkJoinWorkerThread;
        if (!(this.status < 0 || (forkJoinWorkerThread = (ForkJoinWorkerThread)Thread.currentThread()).unpushTask(this) && this.tryQuietlyInvoke())) {
            this.busyJoin(forkJoinWorkerThread);
        }
    }

    public final void quietlyJoin() {
        ForkJoinWorkerThread forkJoinWorkerThread;
        if (!(this.status < 0 || (forkJoinWorkerThread = ForkJoinTask.getWorker()) != null && forkJoinWorkerThread.unpushTask(this) && this.tryQuietlyInvoke())) {
            this.awaitDone(forkJoinWorkerThread, true);
        }
    }

    public final void quietlyInvoke() {
        if (this.status >= 0 && !this.tryQuietlyInvoke()) {
            this.quietlyJoin();
        }
    }

    public static void helpQuiesce() {
        ((ForkJoinWorkerThread)Thread.currentThread()).helpQuiescePool();
    }

    public void reinitialize() {
        if ((this.status & 0xE0000000) == -1610612736) {
            exceptionMap.remove(this);
        }
        this.status = 0;
    }

    public static ForkJoinPool getPool() {
        Thread thread = Thread.currentThread();
        return thread instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)thread).pool : null;
    }

    public boolean tryUnfork() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).unpushTask(this);
    }

    public static int getQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getQueueSize();
    }

    public static int getSurplusQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getEstimatedSurplusTaskCount();
    }

    public abstract V getRawResult();

    protected abstract void setRawResult(V var1);

    protected abstract boolean exec();

    protected static ForkJoinTask<?> peekNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).peekTask();
    }

    protected static ForkJoinTask<?> pollNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollLocalTask();
    }

    protected static ForkJoinTask<?> pollTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollTask();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getException());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.status &= Short.MIN_VALUE;
        this.status |= 0x8000;
        Object object = objectInputStream.readObject();
        if (object != null) {
            this.setDoneExceptionally((Throwable)object);
        }
    }

    private static Unsafe getUnsafe() throws Throwable {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        return ForkJoinTask.getUnsafePrivileged();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getCause();
            }
        }
    }

    private static Unsafe getUnsafePrivileged() throws NoSuchFieldException, IllegalAccessException {
        Field field = Unsafe.class.getDeclaredField("theUnsafe");
        field.setAccessible(true);
        return (Unsafe)field.get(null);
    }

    private static long fieldOffset(String string2) throws NoSuchFieldException {
        return _unsafe.objectFieldOffset(ForkJoinTask.class.getDeclaredField(string2));
    }

    static {
        try {
            _unsafe = ForkJoinTask.getUnsafe();
            statusOffset = ForkJoinTask.fieldOffset("status");
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could not initialize intrinsics", throwable);
        }
    }
}

