/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.forkjoin;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.concurrent.RejectedExecutionException;
import scala.actors.forkjoin.ForkJoinPool;
import scala.actors.forkjoin.ForkJoinTask;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForkJoinWorkerThread
extends Thread {
    private static final int INITIAL_QUEUE_CAPACITY = 8192;
    private static final int MAXIMUM_QUEUE_CAPACITY = 0x10000000;
    final ForkJoinPool pool;
    private ForkJoinTask<?>[] queue;
    private volatile int sp;
    private volatile int base;
    private boolean active;
    private volatile int runState;
    private int seed;
    private int stealCount;
    int poolIndex;
    long lastEventCount;
    private boolean locallyFifo;
    private static final int RUNNING = 0;
    private static final int SHUTDOWN = 1;
    private static final int TERMINATING = 2;
    private static final int TERMINATED = 3;
    static final Unsafe _unsafe;
    static final long baseOffset;
    static final long spOffset;
    static final long runStateOffset;
    static final long qBase;
    static final int qShift;

    protected ForkJoinWorkerThread(ForkJoinPool forkJoinPool) {
        if (forkJoinPool == null) {
            throw new NullPointerException();
        }
        this.pool = forkJoinPool;
    }

    public ForkJoinPool getPool() {
        return this.pool;
    }

    public int getPoolIndex() {
        return this.poolIndex;
    }

    void setAsyncMode(boolean bl) {
        this.locallyFifo = bl;
    }

    final boolean isShutdown() {
        return this.runState >= 1;
    }

    final boolean isTerminating() {
        return this.runState >= 2;
    }

    final boolean isTerminated() {
        return this.runState == 3;
    }

    final boolean shutdown() {
        return this.transitionRunStateTo(1);
    }

    final boolean shutdownNow() {
        return this.transitionRunStateTo(2);
    }

    private boolean transitionRunStateTo(int n) {
        int n2;
        do {
            if ((n2 = this.runState) < n) continue;
            return false;
        } while (!_unsafe.compareAndSwapInt(this, runStateOffset, n2, n));
        return true;
    }

    private boolean tryActivate() {
        if (!this.active) {
            if (!this.pool.tryIncrementActiveCount()) {
                return false;
            }
            this.active = true;
        }
        return true;
    }

    private boolean tryInactivate() {
        if (this.active) {
            if (!this.pool.tryDecrementActiveCount()) {
                return false;
            }
            this.active = false;
        }
        return true;
    }

    private static int xorShift(int n) {
        n ^= n << 1;
        n ^= n >>> 3;
        n ^= n << 10;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable throwable = null;
        try {
            this.onStart();
            this.pool.sync(this);
            this.mainLoop();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        finally {
            this.onTermination(throwable);
        }
    }

    private void mainLoop() {
        while (!this.isShutdown()) {
            ForkJoinTask<?> forkJoinTask = this.pollTask();
            if (forkJoinTask != null || (forkJoinTask = this.pollSubmission()) != null) {
                forkJoinTask.quietlyExec();
                continue;
            }
            if (!this.tryInactivate()) continue;
            this.pool.sync(this);
        }
    }

    protected void onStart() {
        this.queue = new ForkJoinTask[8192];
        int n = this.poolIndex + 1;
        this.seed = n + (n << 8) + (n << 16) + (n << 24);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onTermination(Throwable throwable) {
        while (throwable == null && !this.pool.isTerminating() && this.base != this.sp) {
            try {
                ForkJoinTask<?> forkJoinTask = this.popTask();
                if (forkJoinTask == null) continue;
                forkJoinTask.quietlyExec();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
        }
        try {
            while (!this.tryInactivate()) {
            }
            this.cancelTasks();
            this.runState = 3;
            this.pool.workerTerminated(this);
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            }
        }
        finally {
            if (throwable != null) {
                ForkJoinTask.rethrowException(throwable);
            }
        }
    }

    private static void setSlot(ForkJoinTask<?>[] forkJoinTaskArray, int n, ForkJoinTask<?> forkJoinTask) {
        _unsafe.putObjectVolatile(forkJoinTaskArray, (long)(n << qShift) + qBase, forkJoinTask);
    }

    private static boolean casSlotNull(ForkJoinTask<?>[] forkJoinTaskArray, int n, ForkJoinTask<?> forkJoinTask) {
        return _unsafe.compareAndSwapObject(forkJoinTaskArray, (long)(n << qShift) + qBase, forkJoinTask, null);
    }

    private void storeSp(int n) {
        _unsafe.putIntVolatile(this, spOffset, n);
    }

    final void pushTask(ForkJoinTask<?> forkJoinTask) {
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        int n = forkJoinTaskArray.length - 1;
        int n2 = this.sp;
        ForkJoinWorkerThread.setSlot(forkJoinTaskArray, n2 & n, forkJoinTask);
        this.storeSp(++n2);
        if ((n2 -= this.base) == 1) {
            this.pool.signalWork();
        } else if (n2 >= n) {
            this.growQueue();
        }
    }

    final ForkJoinTask<?> deqTask() {
        int n = this.base;
        if (this.sp != n) {
            int n2;
            ForkJoinTask<?> forkJoinTask;
            ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
            if (this.queue != null && (forkJoinTask = forkJoinTaskArray[n2 = forkJoinTaskArray.length - 1 & n]) != null && ForkJoinWorkerThread.casSlotNull(forkJoinTaskArray, n2, forkJoinTask)) {
                this.base = n + 1;
                return forkJoinTask;
            }
        }
        return null;
    }

    final ForkJoinTask<?> popTask() {
        int n = this.sp;
        while (n != this.base) {
            if (!this.tryActivate()) continue;
            ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
            int n2 = forkJoinTaskArray.length - 1;
            int n3 = n - 1 & n2;
            ForkJoinTask<?> forkJoinTask = forkJoinTaskArray[n3];
            if (forkJoinTask == null || !ForkJoinWorkerThread.casSlotNull(forkJoinTaskArray, n3, forkJoinTask)) break;
            this.storeSp(n - 1);
            return forkJoinTask;
        }
        return null;
    }

    final boolean unpushTask(ForkJoinTask<?> forkJoinTask) {
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        int n = this.sp - 1;
        int n2 = forkJoinTaskArray.length - 1;
        if (ForkJoinWorkerThread.casSlotNull(forkJoinTaskArray, n & n2, forkJoinTask)) {
            this.storeSp(n);
            return true;
        }
        return false;
    }

    final ForkJoinTask<?> peekTask() {
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        if (forkJoinTaskArray == null) {
            return null;
        }
        int n = forkJoinTaskArray.length - 1;
        int n2 = this.locallyFifo ? this.base : this.sp - 1;
        return forkJoinTaskArray[n2 & n];
    }

    private void growQueue() {
        ForkJoinTask<?>[] forkJoinTaskArray = this.queue;
        int n = forkJoinTaskArray.length;
        int n2 = n << 1;
        if (n2 > 0x10000000) {
            throw new RejectedExecutionException("Queue capacity exceeded");
        }
        this.queue = new ForkJoinTask[n2];
        ForkJoinTask[] forkJoinTaskArray2 = this.queue;
        int n3 = this.base;
        int n4 = n3 + n;
        int n5 = n - 1;
        int n6 = n2 - 1;
        do {
            int n7;
            ForkJoinTask<?> forkJoinTask;
            if ((forkJoinTask = forkJoinTaskArray[n7 = n3 & n5]) != null && !ForkJoinWorkerThread.casSlotNull(forkJoinTaskArray, n7, forkJoinTask)) {
                forkJoinTask = null;
            }
            ForkJoinWorkerThread.setSlot(forkJoinTaskArray2, n3 & n6, forkJoinTask);
        } while (++n3 != n4);
        this.pool.signalWork();
    }

    private ForkJoinTask<?> scan() {
        ForkJoinTask<?> forkJoinTask = null;
        int n = this.seed;
        block0: do {
            ForkJoinWorkerThread forkJoinWorkerThread;
            int n2;
            ForkJoinWorkerThread[] forkJoinWorkerThreadArray = this.pool.workers;
            if (this.pool.workers == null || (n2 = forkJoinWorkerThreadArray.length - 1) <= 0) continue;
            int n3 = n;
            int n4 = ~n2;
            while (true) {
                n = ForkJoinWorkerThread.xorShift(n);
                forkJoinWorkerThread = forkJoinWorkerThreadArray[n2 & n3];
                if (forkJoinWorkerThread != null && forkJoinWorkerThread.sp != forkJoinWorkerThread.base) break;
                if (n4 > n2) continue block0;
                n3 = n4++ < 0 ? n : n3 + 1;
            }
            if (this.tryActivate() && (forkJoinTask = forkJoinWorkerThread.deqTask()) != null) break;
        } while (this.pool.hasNewSyncEvent(this));
        this.seed = n;
        return forkJoinTask;
    }

    final ForkJoinTask<?> pollTask() {
        ForkJoinTask<?> forkJoinTask;
        ForkJoinTask<?> forkJoinTask2 = forkJoinTask = this.locallyFifo ? this.deqTask() : this.popTask();
        if (forkJoinTask == null && (forkJoinTask = this.scan()) != null) {
            ++this.stealCount;
        }
        return forkJoinTask;
    }

    final ForkJoinTask<?> pollLocalTask() {
        return this.locallyFifo ? this.deqTask() : this.popTask();
    }

    private ForkJoinTask<?> pollSubmission() {
        ForkJoinPool forkJoinPool = this.pool;
        while (forkJoinPool.hasQueuedSubmissions()) {
            ForkJoinTask<?> forkJoinTask;
            if (!this.tryActivate() || (forkJoinTask = forkJoinPool.pollSubmission()) == null) continue;
            return forkJoinTask;
        }
        return null;
    }

    final void cancelTasks() {
        ForkJoinTask<?> forkJoinTask;
        while (this.base != this.sp && (forkJoinTask = this.deqTask()) != null) {
            forkJoinTask.cancelIgnoringExceptions();
        }
    }

    final int drainTasksTo(Collection<ForkJoinTask<?>> collection) {
        ForkJoinTask<?> forkJoinTask;
        int n = 0;
        while (this.base != this.sp && (forkJoinTask = this.deqTask()) != null) {
            collection.add(forkJoinTask);
            ++n;
        }
        return n;
    }

    final int getAndClearStealCount() {
        int n = this.stealCount;
        this.stealCount = 0;
        return n;
    }

    static boolean hasQueuedTasks(ForkJoinWorkerThread[] forkJoinWorkerThreadArray) {
        if (forkJoinWorkerThreadArray != null) {
            int n = forkJoinWorkerThreadArray.length;
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < n; ++j) {
                    ForkJoinWorkerThread forkJoinWorkerThread = forkJoinWorkerThreadArray[j];
                    if (forkJoinWorkerThread == null || forkJoinWorkerThread.sp == forkJoinWorkerThread.base) continue;
                    return true;
                }
            }
        }
        return false;
    }

    final int getQueueSize() {
        int n = this.sp - this.base;
        return n < 0 ? 0 : n;
    }

    final int getEstimatedSurplusTaskCount() {
        return this.sp - this.base - (this.pool.getIdleThreadCount() >>> 1);
    }

    final ForkJoinTask<?> scanWhileJoining(ForkJoinTask<?> forkJoinTask) {
        ForkJoinTask<?> forkJoinTask2 = this.pollTask();
        if (forkJoinTask2 != null && forkJoinTask.status < 0 && this.sp == this.base) {
            this.pushTask(forkJoinTask2);
            forkJoinTask2 = null;
        }
        return forkJoinTask2;
    }

    final void helpQuiescePool() {
        while (true) {
            ForkJoinTask<?> forkJoinTask;
            if ((forkJoinTask = this.pollTask()) != null) {
                forkJoinTask.quietlyExec();
                continue;
            }
            if (this.tryInactivate() && this.pool.isQuiescent()) break;
        }
        while (!this.tryActivate()) {
        }
    }

    private static Unsafe getUnsafe() throws Throwable {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        return ForkJoinWorkerThread.getUnsafePrivileged();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getCause();
            }
        }
    }

    private static Unsafe getUnsafePrivileged() throws NoSuchFieldException, IllegalAccessException {
        Field field = Unsafe.class.getDeclaredField("theUnsafe");
        field.setAccessible(true);
        return (Unsafe)field.get(null);
    }

    private static long fieldOffset(String string2) throws NoSuchFieldException {
        return _unsafe.objectFieldOffset(ForkJoinWorkerThread.class.getDeclaredField(string2));
    }

    static {
        try {
            _unsafe = ForkJoinWorkerThread.getUnsafe();
            baseOffset = ForkJoinWorkerThread.fieldOffset("base");
            spOffset = ForkJoinWorkerThread.fieldOffset("sp");
            runStateOffset = ForkJoinWorkerThread.fieldOffset("runState");
            qBase = _unsafe.arrayBaseOffset(ForkJoinTask[].class);
            int n = _unsafe.arrayIndexScale(ForkJoinTask[].class);
            if ((n & n - 1) != 0) {
                throw new Error("data type scale not a power of two");
            }
            qShift = 31 - Integer.numberOfLeadingZeros(n);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could not initialize intrinsics", throwable);
        }
    }
}

