/*
 * Decompiled with CFR 0.152.
 */
package scala.actors.forkjoin;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.concurrent.locks.LockSupport;
import scala.actors.forkjoin.TransferQueue;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedTransferQueue<E>
extends AbstractQueue<E>
implements TransferQueue<E>,
Serializable {
    private static final long serialVersionUID = -3223113410248163686L;
    static final int NOWAIT = 0;
    static final int TIMEOUT = 1;
    static final int WAIT = 2;
    static final int NCPUS = Runtime.getRuntime().availableProcessors();
    static final int maxTimedSpins = NCPUS < 2 ? 0 : 32;
    static final int maxUntimedSpins = maxTimedSpins * 16;
    static final long spinForTimeoutThreshold = 1000L;
    private final transient PaddedAtomicReference<QNode> head;
    private final transient PaddedAtomicReference<QNode> tail;
    private final transient PaddedAtomicReference<QNode> cleanMe;
    private static final Unsafe _unsafe;
    private static final long headOffset;
    private static final long tailOffset;
    private static final long cleanMeOffset;

    private boolean advanceHead(QNode qNode, QNode qNode2) {
        if (qNode == this.head.get() && this.head.compareAndSet(qNode, qNode2)) {
            qNode.clearNext();
            return true;
        }
        return false;
    }

    private Object xfer(Object object, int n, long l) {
        Object v;
        QNode qNode;
        boolean bl = object != null;
        QNode qNode2 = null;
        PaddedAtomicReference<QNode> paddedAtomicReference = this.head;
        PaddedAtomicReference<QNode> paddedAtomicReference2 = this.tail;
        while (true) {
            QNode qNode3 = (QNode)paddedAtomicReference2.get();
            QNode qNode4 = (QNode)paddedAtomicReference.get();
            if (qNode3 != null && (qNode3 == qNode4 || qNode3.isData == bl)) {
                if (qNode2 == null) {
                    qNode2 = new QNode(object, bl);
                }
                if ((qNode = qNode3.next) != null) {
                    if (qNode3 != paddedAtomicReference2.get()) continue;
                    paddedAtomicReference2.compareAndSet(qNode3, qNode);
                    continue;
                }
                if (!qNode3.casNext(null, qNode2)) continue;
                paddedAtomicReference2.compareAndSet(qNode3, qNode2);
                return this.awaitFulfill(qNode3, qNode2, object, n, l);
            }
            if (qNode4 == null) continue;
            qNode = qNode4.next;
            if (qNode3 == paddedAtomicReference2.get() && qNode != null && this.advanceHead(qNode4, qNode) && (v = qNode.get()) != qNode && qNode.compareAndSet(v, object)) break;
        }
        LockSupport.unpark(qNode.waiter);
        return bl ? object : v;
    }

    private Object fulfill(Object object) {
        Object v;
        QNode qNode;
        boolean bl = object != null;
        PaddedAtomicReference<QNode> paddedAtomicReference = this.head;
        PaddedAtomicReference<QNode> paddedAtomicReference2 = this.tail;
        while (true) {
            QNode qNode2 = (QNode)paddedAtomicReference2.get();
            QNode qNode3 = (QNode)paddedAtomicReference.get();
            if (qNode2 != null && (qNode2 == qNode3 || qNode2.isData == bl)) {
                qNode = qNode2.next;
                if (qNode2 != paddedAtomicReference2.get()) continue;
                if (qNode != null) {
                    paddedAtomicReference2.compareAndSet(qNode2, qNode);
                    continue;
                }
                return null;
            }
            if (qNode3 == null) continue;
            qNode = qNode3.next;
            if (qNode2 == paddedAtomicReference2.get() && qNode != null && this.advanceHead(qNode3, qNode) && (v = qNode.get()) != qNode && qNode.compareAndSet(v, object)) break;
        }
        LockSupport.unpark(qNode.waiter);
        return bl ? object : v;
    }

    private Object awaitFulfill(QNode qNode, QNode qNode2, Object object, int n, long l) {
        if (n == 0) {
            return null;
        }
        long l2 = n == 1 ? System.nanoTime() : 0L;
        Thread thread = Thread.currentThread();
        int n2 = -1;
        while (true) {
            long l3;
            Object v;
            if (thread.isInterrupted()) {
                qNode2.compareAndSet(object, qNode2);
            }
            if ((v = qNode2.get()) != object) {
                this.advanceHead(qNode, qNode2);
                if (v == qNode2) {
                    this.clean(qNode, qNode2);
                    return null;
                }
                if (v != null) {
                    qNode2.set(qNode2);
                    return v;
                }
                return object;
            }
            if (n == 1 && (l -= (l3 = System.nanoTime()) - (l2 = l3)) <= 0L) {
                qNode2.compareAndSet(object, qNode2);
                continue;
            }
            if (n2 < 0) {
                QNode qNode3 = (QNode)this.head.get();
                int n3 = qNode3 != null && qNode3.next == qNode2 ? (n == 1 ? maxTimedSpins : maxUntimedSpins) : (n2 = 0);
            }
            if (n2 > 0) {
                --n2;
                continue;
            }
            if (qNode2.waiter == null) {
                qNode2.waiter = thread;
                continue;
            }
            if (n != 1) {
                LockSupport.park();
                qNode2.waiter = null;
                n2 = -1;
                continue;
            }
            if (l <= 1000L) continue;
            LockSupport.parkNanos(l);
            qNode2.waiter = null;
            n2 = -1;
        }
    }

    private QNode getValidatedTail() {
        QNode qNode;
        while (true) {
            QNode qNode2 = (QNode)this.head.get();
            QNode qNode3 = qNode2.next;
            if (qNode3 != null && qNode3.next == qNode3) {
                this.advanceHead(qNode2, qNode3);
                continue;
            }
            qNode = (QNode)this.tail.get();
            QNode qNode4 = qNode.next;
            if (qNode != this.tail.get()) continue;
            if (qNode4 == null) break;
            this.tail.compareAndSet(qNode, qNode4);
        }
        return qNode;
    }

    private void clean(QNode qNode, QNode qNode2) {
        Thread thread = qNode2.waiter;
        if (thread != null) {
            qNode2.waiter = null;
            if (thread != Thread.currentThread()) {
                LockSupport.unpark(thread);
            }
        }
        if (qNode == null) {
            return;
        }
        while (qNode.next == qNode2) {
            QNode qNode3;
            QNode qNode4 = this.reclean();
            QNode qNode5 = this.getValidatedTail();
            if (!(qNode2 != qNode5 ? (qNode3 = qNode2.next) == qNode2 || qNode.casNext(qNode2, qNode3) : qNode4 == qNode || qNode4 == null && this.cleanMe.compareAndSet(null, qNode))) continue;
            break;
        }
    }

    private QNode reclean() {
        QNode qNode;
        QNode qNode2;
        QNode qNode3;
        while ((qNode3 = (QNode)this.cleanMe.get()) != null && (qNode2 = qNode3.next) != (qNode = this.getValidatedTail())) {
            QNode qNode4;
            if (qNode2 != null && qNode2 != qNode3 && qNode2.get() == qNode2 && (qNode4 = qNode2.next) != qNode2 && !qNode3.casNext(qNode2, qNode4)) continue;
            this.cleanMe.compareAndSet(qNode3, null);
        }
        return qNode3;
    }

    public LinkedTransferQueue() {
        QNode qNode = new QNode(null, false);
        this.head = new PaddedAtomicReference<QNode>(qNode);
        this.tail = new PaddedAtomicReference<QNode>(qNode);
        this.cleanMe = new PaddedAtomicReference<Object>(null);
    }

    public LinkedTransferQueue(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    @Override
    public void put(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.xfer(e, 0, 0L);
    }

    @Override
    public boolean offer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        this.xfer(e, 0, 0L);
        return true;
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.xfer(e, 0, 0L);
        return true;
    }

    @Override
    public boolean add(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        this.xfer(e, 0, 0L);
        return true;
    }

    @Override
    public void transfer(E e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.xfer(e, 2, 0L) == null) {
            Thread.interrupted();
            throw new InterruptedException();
        }
    }

    @Override
    public boolean tryTransfer(E e, long l, TimeUnit timeUnit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        if (this.xfer(e, 1, timeUnit.toNanos(l)) != null) {
            return true;
        }
        if (!Thread.interrupted()) {
            return false;
        }
        throw new InterruptedException();
    }

    @Override
    public boolean tryTransfer(E e) {
        if (e == null) {
            throw new NullPointerException();
        }
        return this.fulfill(e) != null;
    }

    @Override
    public E take() throws InterruptedException {
        Object object = this.xfer(null, 2, 0L);
        if (object != null) {
            return (E)object;
        }
        Thread.interrupted();
        throw new InterruptedException();
    }

    @Override
    public E poll(long l, TimeUnit timeUnit) throws InterruptedException {
        Object object = this.xfer(null, 1, timeUnit.toNanos(l));
        if (object != null || !Thread.interrupted()) {
            return (E)object;
        }
        throw new InterruptedException();
    }

    @Override
    public E poll() {
        return (E)this.fulfill(null);
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        E e;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while ((e = this.poll()) != null) {
            collection.add(e);
            ++n;
        }
        return n;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int n) {
        E e;
        int n2;
        if (collection == null) {
            throw new NullPointerException();
        }
        if (collection == this) {
            throw new IllegalArgumentException();
        }
        for (n2 = 0; n2 < n && (e = this.poll()) != null; ++n2) {
            collection.add(e);
        }
        return n2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private QNode traversalHead() {
        while (true) {
            QNode qNode = (QNode)this.tail.get();
            QNode qNode2 = (QNode)this.head.get();
            if (qNode2 != null && qNode != null) {
                QNode qNode3 = qNode.next;
                QNode qNode4 = qNode2.next;
                if (qNode == this.tail.get()) {
                    if (qNode3 != null) {
                        this.tail.compareAndSet(qNode, qNode3);
                    } else {
                        if (qNode4 == null) return qNode2;
                        Object v = qNode4.get();
                        if (v != qNode4) return qNode2;
                        this.advanceHead(qNode2, qNode4);
                    }
                }
            }
            this.reclean();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public E peek() {
        Object v;
        while (true) {
            QNode qNode = this.traversalHead();
            QNode qNode2 = qNode.next;
            if (qNode2 == null) {
                return null;
            }
            v = qNode2.get();
            if (qNode2 == v) continue;
            if (!qNode2.isData) {
                return null;
            }
            if (v != null) break;
        }
        return (E)v;
    }

    @Override
    public boolean isEmpty() {
        while (true) {
            QNode qNode = this.traversalHead();
            QNode qNode2 = qNode.next;
            if (qNode2 == null) {
                return true;
            }
            Object v = qNode2.get();
            if (qNode2 == v) continue;
            if (!qNode2.isData) {
                return true;
            }
            if (v != null) break;
        }
        return false;
    }

    @Override
    public boolean hasWaitingConsumer() {
        Object v;
        QNode qNode;
        do {
            QNode qNode2 = this.traversalHead();
            qNode = qNode2.next;
            if (qNode != null) continue;
            return false;
        } while (qNode == (v = qNode.get()));
        return !qNode.isData;
    }

    @Override
    public int size() {
        Object v;
        int n = 0;
        QNode qNode = this.traversalHead();
        QNode qNode2 = qNode.next;
        while (qNode2 != null && qNode2.isData && ((v = qNode2.get()) == null || v == qNode2 || ++n != Integer.MAX_VALUE)) {
            qNode2 = qNode2.next;
        }
        return n;
    }

    @Override
    public int getWaitingConsumerCount() {
        int n = 0;
        QNode qNode = this.traversalHead();
        QNode qNode2 = qNode.next;
        while (!(qNode2 == null || qNode2.isData || qNode2.get() == null && ++n == Integer.MAX_VALUE)) {
            qNode2 = qNode2.next;
        }
        return n;
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            return false;
        }
        block0: while (true) {
            QNode qNode = this.traversalHead();
            while (true) {
                QNode qNode2;
                if ((qNode2 = qNode.next) == null || !qNode2.isData) {
                    return false;
                }
                if (qNode2 == qNode) continue block0;
                Object v = qNode2.get();
                if (v != null && v != qNode2 && object.equals(v) && qNode2.compareAndSet(v, qNode2)) {
                    this.clean(qNode, qNode2);
                    return true;
                }
                qNode = qNode2;
            }
            break;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (E e : this) {
            objectOutputStream.writeObject(e);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        this.resetHeadAndTail();
        while ((object = objectInputStream.readObject()) != null) {
            this.offer(object);
        }
    }

    private void resetHeadAndTail() {
        QNode qNode = new QNode(null, false);
        _unsafe.putObjectVolatile(this, headOffset, new PaddedAtomicReference<QNode>(qNode));
        _unsafe.putObjectVolatile(this, tailOffset, new PaddedAtomicReference<QNode>(qNode));
        _unsafe.putObjectVolatile(this, cleanMeOffset, new PaddedAtomicReference<Object>(null));
    }

    private static Unsafe getUnsafe() throws Throwable {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException securityException) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        return LinkedTransferQueue.getUnsafePrivileged();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getCause();
            }
        }
    }

    private static Unsafe getUnsafePrivileged() throws NoSuchFieldException, IllegalAccessException {
        Field field = Unsafe.class.getDeclaredField("theUnsafe");
        field.setAccessible(true);
        return (Unsafe)field.get(null);
    }

    private static long fieldOffset(String string2) throws NoSuchFieldException {
        return _unsafe.objectFieldOffset(LinkedTransferQueue.class.getDeclaredField(string2));
    }

    static {
        try {
            _unsafe = LinkedTransferQueue.getUnsafe();
            headOffset = LinkedTransferQueue.fieldOffset("head");
            tailOffset = LinkedTransferQueue.fieldOffset("tail");
            cleanMeOffset = LinkedTransferQueue.fieldOffset("cleanMe");
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Could not initialize intrinsics", throwable);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Itr
    implements Iterator<E> {
        QNode next;
        QNode pnext;
        QNode snext;
        QNode curr;
        QNode pcurr;
        E nextItem;

        Itr() {
            this.findNext();
        }

        void findNext() {
            while (true) {
                QNode qNode = this.pnext;
                QNode qNode2 = this.next;
                if (qNode == null || qNode == qNode2) {
                    qNode = LinkedTransferQueue.this.traversalHead();
                    qNode2 = qNode.next;
                }
                if (qNode2 == null || !qNode2.isData) {
                    this.next = null;
                    return;
                }
                Object v = qNode2.get();
                QNode qNode3 = qNode2.next;
                if (v != null && qNode2 != v && qNode2 != qNode3) {
                    this.nextItem = v;
                    this.snext = qNode3;
                    this.pnext = qNode;
                    this.next = qNode2;
                    return;
                }
                this.pnext = qNode2;
                this.next = qNode3;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.pcurr = this.pnext;
            this.curr = this.next;
            this.pnext = this.next;
            this.next = this.snext;
            Object e = this.nextItem;
            this.findNext();
            return e;
        }

        @Override
        public void remove() {
            QNode qNode = this.curr;
            if (qNode == null) {
                throw new IllegalStateException();
            }
            Object v = qNode.get();
            if (v != null && v != qNode && qNode.compareAndSet(v, qNode)) {
                LinkedTransferQueue.this.clean(this.pcurr, qNode);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PaddedAtomicReference<T>
    extends AtomicReference<T> {
        Object p0;
        Object p1;
        Object p2;
        Object p3;
        Object p4;
        Object p5;
        Object p6;
        Object p7;
        Object p8;
        Object p9;
        Object pa;
        Object pb;
        Object pc;
        Object pd;
        Object pe;

        PaddedAtomicReference(T t) {
            super(t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class QNode
    extends AtomicReference<Object> {
        volatile QNode next;
        volatile Thread waiter;
        final boolean isData;
        static final AtomicReferenceFieldUpdater<QNode, QNode> nextUpdater = AtomicReferenceFieldUpdater.newUpdater(QNode.class, QNode.class, "next");

        QNode(Object object, boolean bl) {
            super(object);
            this.isData = bl;
        }

        final boolean casNext(QNode qNode, QNode qNode2) {
            return nextUpdater.compareAndSet(this, qNode, qNode2);
        }

        final void clearNext() {
            nextUpdater.set(this, this);
        }
    }
}

