/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.generic;

import java.util.Arrays;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Range;
import scala.Some;
import scala.Tuple2;
import scala.Unhashable;
import scala.collection.Iterator;
import scala.collection.Sequence;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.generic.Builder;
import scala.collection.generic.BuilderFactory;
import scala.collection.generic.IterableTemplate;
import scala.collection.generic.SequenceTemplate;
import scala.collection.generic.SequenceTemplate$;
import scala.collection.generic.SequenceView;
import scala.collection.generic.TraversableTemplate$class;
import scala.collection.generic.TraversableViewTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.runtime.BoxedArray;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SequenceTemplate$class {
    public static void $init$(SequenceTemplate $this) {
    }

    private static final int mi$1(SequenceTemplate $this, IntRef intRef, IntRef intRef2) {
        return intRef.elem + intRef2.elem;
    }

    public static Object projection(SequenceTemplate $this) {
        return $this.view();
    }

    public static boolean containsSlice(SequenceTemplate $this, Sequence that) {
        return $this.indexOfSeq(that) != -1;
    }

    public static boolean equalsWith(SequenceTemplate $this, Sequence that, Function2 f) {
        Iterator i = $this.iterator();
        Iterator j = that.iterator();
        while (i.hasNext() && j.hasNext()) {
            if (BoxesRunTime.unboxToBoolean(f.apply(i.next(), j.next()))) continue;
            return false;
        }
        return !i.hasNext() && !j.hasNext();
    }

    public static Sequence slice(SequenceTemplate $this, int from2) {
        return (Sequence)$this.slice(from2, $this.length());
    }

    public static int findLastIndexOf(SequenceTemplate $this, Function1 p) {
        return $this.lastIndexWhere(p);
    }

    public static IterableTemplate sortWith(SequenceTemplate $this, Function2 lt$1) {
        BoxedArray arr = $this.toArray();
        Object object = ScalaRunTime$.MODULE$.arrayValue(arr, Object.class);
        Arrays.sort((Object[])(object instanceof BoxedArray ? ScalaRunTime$.MODULE$.arrayValue((BoxedArray)object, Object.class) : object), new SequenceTemplate$.anon.4($this, lt$1));
        Builder b$6 = $this.newBuilder();
        arr.foreach(new SequenceTemplate$.anonfun.sortWith.1($this, b$6));
        Object This2 = b$6.result();
        return (IterableTemplate)(This2 instanceof IterableTemplate ? This2 : ScalaRunTime$.MODULE$.boxArray(This2));
    }

    public static String toString(SequenceTemplate $this) {
        return TraversableTemplate$class.toString($this);
    }

    public static boolean equals(SequenceTemplate $this, Object that) {
        boolean bl;
        BoxedArray<?> temp13 = that;
        BoxedArray<?> boxedArray = temp13;
        if (boxedArray instanceof Sequence || ScalaRunTime$.MODULE$.isArray(boxedArray)) {
            BoxedArray<?> boxedArray2 = temp13;
            Sequence temp14 = boxedArray2 instanceof Sequence ? boxedArray2 : ScalaRunTime$.MODULE$.boxArray(boxedArray2);
            bl = $this.sameElements(temp14);
        } else {
            bl = false;
        }
        return bl;
    }

    private static <B> int lastIndexOf_KMP(SequenceTemplate $this, Sequence<B> source, int sourceOffset, int sourceCount, Sequence<B> target, int targetOffset, int targetCount, int fromIndex) {
        Option<Integer> temp9;
        block4: {
            int n;
            block3: {
                Sequence tgt;
                Sequence src;
                block2: {
                    src = (Sequence)((SequenceTemplate)source.slice(sourceOffset, sourceCount).take(fromIndex)).reverse();
                    tgt = (Sequence)((SequenceTemplate)target.slice(targetOffset, targetCount)).reverse();
                    temp9 = SequenceTemplate$class.KMP($this, src, tgt);
                    None$ none$ = None$.MODULE$;
                    Option<Integer> option = temp9;
                    if ((none$ != null ? !none$.equals(option) : option != null) || !(temp9 instanceof None$)) break block2;
                    n = -1;
                    break block3;
                }
                if (!(temp9 instanceof Some)) break block4;
                Some temp11 = (Some)temp9;
                int temp12 = BoxesRunTime.unboxToInt(temp11.x());
                n = src.length() - tgt.length() - temp12 + sourceOffset;
            }
            return n;
        }
        throw new MatchError(temp9.toString());
    }

    private static <B> int indexOf_KMP(SequenceTemplate $this, Sequence<B> source, int sourceOffset, int sourceCount, Sequence<B> target, int targetOffset, int targetCount, int fromIndex) {
        Option<Integer> temp5;
        block4: {
            int n;
            block3: {
                block2: {
                    temp5 = SequenceTemplate$class.KMP($this, (Sequence)source.slice(sourceOffset, sourceCount).drop(fromIndex), (Sequence)target.slice(targetOffset, targetCount));
                    None$ none$ = None$.MODULE$;
                    Option<Integer> option = temp5;
                    if ((none$ != null ? !none$.equals(option) : option != null) || !(temp5 instanceof None$)) break block2;
                    n = -1;
                    break block3;
                }
                if (!(temp5 instanceof Some)) break block4;
                Some temp7 = (Some)temp5;
                int temp8 = BoxesRunTime.unboxToInt(temp7.x());
                n = temp8 + fromIndex;
            }
            return n;
        }
        throw new MatchError(temp5.toString());
    }

    private static <B> Option<Integer> KMP(SequenceTemplate $this, Sequence<B> S, Sequence<B> W) {
        if (W.isEmpty()) {
            return new Some<Integer>(BoxesRunTime.boxToInteger(0));
        }
        if (((IterableTemplate)W.drop(1)).isEmpty()) {
            int temp4 = S.indexOf(W.apply(0));
            return BoxesRunTime.equals(BoxesRunTime.boxToInteger(temp4), BoxesRunTime.boxToInteger(-1)) ? None$.MODULE$ : new Some<Integer>(BoxesRunTime.boxToInteger(temp4));
        }
        int[] arr = new int[W.length()];
        int pos = 2;
        int cnd = 0;
        arr[0] = -1;
        arr[1] = 0;
        while (pos < W.length()) {
            if (BoxesRunTime.equals(W.apply(pos - 1), W.apply(cnd))) {
                arr[pos] = cnd + 1;
                ++pos;
                ++cnd;
                continue;
            }
            if (cnd > 0) {
                cnd = arr[cnd];
                continue;
            }
            arr[pos] = 0;
            ++pos;
        }
        int[] T = arr;
        IntRef m$1 = new IntRef(0);
        IntRef i$5 = new IntRef(0);
        while (SequenceTemplate$class.mi$1($this, m$1, i$5) < S.length()) {
            if (BoxesRunTime.equals(W.apply(i$5.elem), S.apply(SequenceTemplate$class.mi$1($this, m$1, i$5)))) {
                ++i$5.elem;
                if (i$5.elem != W.length()) continue;
                return new Some<Integer>(BoxesRunTime.boxToInteger(m$1.elem));
            }
            m$1.elem = SequenceTemplate$class.mi$1($this, m$1, i$5) - T[i$5.elem];
            if (i$5.elem <= 0) continue;
            i$5.elem = T[i$5.elem];
        }
        return None$.MODULE$;
    }

    public static SequenceView view(SequenceTemplate $this, int from2, int until2) {
        return (SequenceView)((TraversableViewTemplate)$this.view()).slice(from2, until2);
    }

    public static Object view(SequenceTemplate $this) {
        return new SequenceTemplate$.anon.3($this);
    }

    public static Range indices(SequenceTemplate $this) {
        return Predef$.MODULE$.intWrapper(0).until($this.length());
    }

    public static Sequence toSequence(SequenceTemplate $this) {
        return (Sequence)$this.thisCollection();
    }

    public static Object padTo(SequenceTemplate $this, int len, Object elem2, BuilderFactory bf) {
        Builder b = bf.apply($this.thisCollection());
        b.$plus$plus$eq((Traversable)$this.thisCollection());
        for (int diff2 = len - $this.length(); diff2 > 0; --diff2) {
            b.$plus$eq(elem2);
        }
        return b.result();
    }

    public static Object patch(SequenceTemplate $this, int from2, Sequence patch, int replaced, BuilderFactory bf) {
        Builder b = bf.apply($this.thisCollection());
        Tuple2 temp1 = $this.splitAt(from2);
        if (temp1 != null) {
            IterableTemplate temp3;
            Object This2 = temp1._1();
            IterableTemplate temp2 = (IterableTemplate)(This2 instanceof IterableTemplate ? This2 : ScalaRunTime$.MODULE$.boxArray(This2));
            Object This3 = temp1._2();
            IterableTemplate rest = temp3 = (IterableTemplate)(This3 instanceof IterableTemplate ? This3 : ScalaRunTime$.MODULE$.boxArray(This3));
            Tuple2<IterableTemplate, IterableTemplate> tuple2 = new Tuple2<IterableTemplate, IterableTemplate>(temp2, rest);
            BoxedArray<?> prefix = tuple2._1() instanceof IterableTemplate ? tuple2._1() : ScalaRunTime$.MODULE$.boxArray(tuple2._1());
            BoxedArray<?> rest2 = tuple2._2() instanceof IterableTemplate ? tuple2._2() : ScalaRunTime$.MODULE$.boxArray(tuple2._2());
            b.$plus$plus$eq(prefix);
            b.$plus$plus$eq(patch);
            b.$plus$plus$eq((Traversable)rest2.drop(replaced));
            return b.result();
        }
        throw new MatchError(temp1.toString());
    }

    public static IterableTemplate removeDuplicates(SequenceTemplate $this) {
        Builder b$5 = $this.newBuilder();
        ObjectRef seen$1 = new ObjectRef((Set)Set$.MODULE$.apply(ScalaRunTime$.MODULE$.boxArray(new Object[0])));
        $this.foreach(new SequenceTemplate$.anonfun.removeDuplicates.1($this, b$5, seen$1));
        Object This2 = b$5.result();
        return (IterableTemplate)(This2 instanceof IterableTemplate ? This2 : ScalaRunTime$.MODULE$.boxArray(This2));
    }

    /*
     * WARNING - void declaration
     */
    private static <B> Map<B, Integer> occCounts(SequenceTemplate $this, Sequence<B> seq2) {
        void var2_2;
        Map occ$3 = seq2.isEmpty() || seq2.head() instanceof Unhashable ? new SequenceTemplate$.anon.2($this) : new SequenceTemplate$.anon.1($this);
        seq2.foreach(new SequenceTemplate$.anonfun.occCounts.1($this, occ$3));
        return var2_2;
    }

    public static IterableTemplate intersect(SequenceTemplate $this, Sequence that) {
        Map occ$2 = SequenceTemplate$class.occCounts($this, that);
        Builder b$4 = $this.newBuilder();
        $this.foreach(new SequenceTemplate$.anonfun.intersect.1($this, occ$2, b$4));
        Object This2 = b$4.result();
        return (IterableTemplate)(This2 instanceof IterableTemplate ? This2 : ScalaRunTime$.MODULE$.boxArray(This2));
    }

    public static IterableTemplate diff(SequenceTemplate $this, Sequence that) {
        Map occ$1 = SequenceTemplate$class.occCounts($this, that);
        Builder b$3 = $this.newBuilder();
        $this.foreach(new SequenceTemplate$.anonfun.diff.1($this, occ$1, b$3));
        Object This2 = b$3.result();
        return (IterableTemplate)(This2 instanceof IterableTemplate ? This2 : ScalaRunTime$.MODULE$.boxArray(This2));
    }

    public static Object union(SequenceTemplate $this, Sequence that, BuilderFactory bf) {
        return $this.thisCollection().$plus$plus(that, bf);
    }

    public static boolean contains(SequenceTemplate $this, Object elem$1) {
        return $this.exists(new SequenceTemplate$.anonfun.contains.1($this, elem$1));
    }

    public static int lastIndexOfSeq(SequenceTemplate $this, Sequence that, int fromIndex) {
        return SequenceTemplate$class.lastIndexOf_KMP($this, (Sequence)$this.thisCollection(), 0, $this.length(), that, 0, that.length(), fromIndex);
    }

    public static int lastIndexOfSeq(SequenceTemplate $this, Sequence that) {
        return $this.lastIndexOfSeq(that, that.length());
    }

    /*
     * Enabled aggressive block sorting
     */
    public static int indexOfSeq(SequenceTemplate $this, Sequence that, int fromIndex) {
        if ($this.thisCollection().hasDefiniteSize() && that.hasDefiniteSize()) {
            int n = SequenceTemplate$class.indexOf_KMP($this, (Sequence)$this.thisCollection(), 0, $this.length(), that, 0, that.length(), fromIndex);
            return n;
        }
        int i = fromIndex;
        Sequence s = (Sequence)$this.thisCollection().drop(i);
        while (!s.isEmpty()) {
            if (s.startsWith(that)) {
                return i;
            }
            ++i;
            s = (Sequence)s.tail();
        }
        return -1;
    }

    public static int indexOfSeq(SequenceTemplate $this, Sequence that) {
        return $this.indexOfSeq(that, 0);
    }

    public static boolean endsWith(SequenceTemplate $this, Sequence that) {
        Iterator i = $this.iterator().drop($this.length() - that.length());
        Iterator j = that.iterator();
        while (i.hasNext() && j.hasNext()) {
            if (BoxesRunTime.equals(i.next(), j.next())) continue;
            return false;
        }
        return !j.hasNext();
    }

    public static boolean startsWith(SequenceTemplate $this, Sequence that) {
        return $this.startsWith(that, 0);
    }

    public static boolean startsWith(SequenceTemplate $this, Sequence that, int offset) {
        Iterator i = $this.iterator().drop(offset);
        Iterator j = that.iterator();
        while (j.hasNext() && i.hasNext()) {
            if (BoxesRunTime.equals(i.next(), j.next())) continue;
            return false;
        }
        return !j.hasNext();
    }

    public static Iterator reversedElements(SequenceTemplate $this) {
        return $this.reverseIterator();
    }

    public static Iterator reverseIterator(SequenceTemplate $this) {
        return $this.reverse().iterator();
    }

    public static IterableTemplate reverse(SequenceTemplate $this) {
        ObjectRef xs$1 = new ObjectRef(Nil$.MODULE$);
        $this.foreach(new SequenceTemplate$.anonfun.reverse.1($this, xs$1));
        Builder b$2 = $this.newBuilder();
        ((List)xs$1.elem).foreach(new SequenceTemplate$.anonfun.reverse.2($this, b$2));
        Object This2 = b$2.result();
        return (IterableTemplate)(This2 instanceof IterableTemplate ? This2 : ScalaRunTime$.MODULE$.boxArray(This2));
    }

    /*
     * WARNING - void declaration
     */
    public static int lastIndexWhere(SequenceTemplate $this, Function1 p, int end) {
        void var3_3;
        int i = $this.length() - 1;
        Iterator it = $this.reverseIterator();
        while (it.hasNext()) {
            Object elem2 = it.next();
            if (!(i > end || !BoxesRunTime.unboxToBoolean(p.apply(elem2)))) break;
            --i;
        }
        return (int)var3_3;
    }

    public static int lastIndexWhere(SequenceTemplate $this, Function1 p) {
        return $this.lastIndexWhere(p, $this.length() - 1);
    }

    public static int lastIndexOf(SequenceTemplate $this, Object elem$3, int end) {
        return $this.lastIndexWhere(new SequenceTemplate$.anonfun.lastIndexOf.2($this, elem$3), end);
    }

    public static int lastIndexOf(SequenceTemplate $this, Object elem$4) {
        return $this.lastIndexWhere(new SequenceTemplate$.anonfun.lastIndexOf.1($this, elem$4));
    }

    public static int indexOf(SequenceTemplate $this, Object elem$2, int from2) {
        return $this.indexWhere(new SequenceTemplate$.anonfun.indexOf.1($this, elem$2), from2);
    }

    public static int indexOf(SequenceTemplate $this, Object elem2) {
        return $this.indexOf(elem2, 0);
    }

    public static int findIndexOf(SequenceTemplate $this, Function1 p) {
        return $this.indexWhere(p);
    }

    public static int indexWhere(SequenceTemplate $this, Function1 p$2, int from$2) {
        IntRef result$2 = new IntRef(-1);
        IntRef i$4 = new IntRef(from$2);
        Traversable$.MODULE$.breaks().breakable(new SequenceTemplate$.anonfun.indexWhere.1($this, p$2, from$2, result$2, i$4));
        return result$2.elem;
    }

    public static int indexWhere(SequenceTemplate $this, Function1 p) {
        return $this.indexWhere(p, 0);
    }

    public static int prefixLength(SequenceTemplate $this, Function1 p) {
        return $this.segmentLength(p, 0);
    }

    public static int segmentLength(SequenceTemplate $this, Function1 p$1, int from$1) {
        IntRef result$1 = new IntRef(0);
        IntRef i$3 = new IntRef(0);
        Traversable$.MODULE$.breaks().breakable(new SequenceTemplate$.anonfun.segmentLength.1($this, p$1, from$1, result$1, i$3));
        return result$1.elem;
    }

    public static Object zipWithIndex(SequenceTemplate $this, BuilderFactory bf) {
        Builder b$1 = bf.apply($this.thisCollection());
        IntRef i$2 = new IntRef(0);
        $this.foreach(new SequenceTemplate$.anonfun.zipWithIndex.1($this, b$1, i$2));
        return b$1.result();
    }

    public static Object zipAll(SequenceTemplate $this, Sequence that, Object thisElem, Object thatElem, BuilderFactory bf) {
        Builder b = bf.apply($this.thisCollection());
        Iterator these = $this.iterator();
        Iterator those = that.iterator();
        while (these.hasNext() && those.hasNext()) {
            b.$plus$eq(new Tuple2(these.next(), those.next()));
        }
        while (these.hasNext()) {
            b.$plus$eq(new Tuple2(these.next(), thatElem));
        }
        while (those.hasNext()) {
            b.$plus$eq(new Tuple2(thisElem, those.next()));
        }
        return b.result();
    }

    public static Object zip(SequenceTemplate $this, Sequence that, BuilderFactory bf) {
        Builder b = bf.apply($this.thisCollection());
        Iterator these = $this.iterator();
        Iterator those = that.iterator();
        while (these.hasNext() && those.hasNext()) {
            b.$plus$eq(new Tuple2(these.next(), those.next()));
        }
        return b.result();
    }

    public static boolean isDefinedAt(SequenceTemplate $this, int x) {
        return x >= 0 && x < $this.length();
    }

    public static int size(SequenceTemplate $this) {
        return $this.length();
    }

    public static int lengthCompare(SequenceTemplate $this, int len$1) {
        IntRef i$1 = new IntRef(0);
        Traversable$.MODULE$.breaks().breakable(new SequenceTemplate$.anonfun.lengthCompare.1($this, len$1, i$1));
        return i$1.elem - len$1;
    }
}

