/*
 * Decompiled with CFR 0.152.
 */
package scala.testing;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.Product$class;
import scala.ScalaObject;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Sequence;
import scala.collection.Sequence$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.testing.SUnit$Assert$class;
import scala.testing.SUnit$TestResult$;
import scala.testing.SUnit$TestSuite$;

public final class SUnit {

    public static interface Test {
        public void run(TestResult var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Assert
    extends ScalaObject {
        public <A> void fail(String var1, A var2, A var3);

        public void fail(String var1);

        public void assertTrue(boolean var1);

        public void assertTrue(String var1, boolean var2);

        public void assertEq(Object var1, Object var2);

        public void assertEq(String var1, Object var2, Object var3);

        public void assertNull(Object var1);

        public void assertNull(String var1, Object var2);

        public void assertNotEq(Object var1, Object var2);

        public void assertNotEq(String var1, Object var2, Object var3);

        public void assertNotNull(Object var1);

        public void assertNotNull(String var1, Object var2);

        public void assertFalse(boolean var1);

        public void assertFalse(String var1, boolean var2);

        public <A> void assertEquals(A var1, A var2);

        public <A> void assertEquals(String var1, A var2, A var3);

        public <A> void assertSameElements(Sequence<A> var1, Sequence<A> var2);

        public boolean enableStackTrace();
    }

    public static abstract class TestCase
    implements Test,
    Assert,
    ScalaObject {
        private final String name;

        public TestCase(String name) {
            this.name = name;
            SUnit$Assert$class.$init$(this);
        }

        public String toString() {
            return this.name();
        }

        public void tearDown() {
        }

        public void setUp() {
        }

        public void run(TestResult r) {
            try {
                this.runTest();
            }
            catch (Throwable throwable) {
                r.addFailure(this, throwable);
            }
        }

        public abstract void runTest();

        public String name() {
            return this.name;
        }

        public void fail(String msg, Object expected, Object actual) {
            SUnit$Assert$class.fail(this, msg, expected, actual);
        }

        public void fail(String msg) {
            SUnit$Assert$class.fail(this, msg);
        }

        public void assertTrue(boolean actual) {
            SUnit$Assert$class.assertTrue(this, actual);
        }

        public void assertTrue(String msg, boolean actual) {
            SUnit$Assert$class.assertTrue(this, msg, actual);
        }

        public void assertEq(Object expected, Object actual) {
            SUnit$Assert$class.assertEq(this, expected, actual);
        }

        public void assertEq(String msg, Object expected, Object actual) {
            SUnit$Assert$class.assertEq(this, msg, expected, actual);
        }

        public void assertNull(Object actual) {
            SUnit$Assert$class.assertNull(this, actual);
        }

        public void assertNull(String msg, Object actual) {
            SUnit$Assert$class.assertNull(this, msg, actual);
        }

        public void assertNotEq(Object expected, Object actual) {
            SUnit$Assert$class.assertNotEq(this, expected, actual);
        }

        public void assertNotEq(String msg, Object expected, Object actual) {
            SUnit$Assert$class.assertNotEq(this, msg, expected, actual);
        }

        public void assertNotNull(Object actual) {
            SUnit$Assert$class.assertNotNull(this, actual);
        }

        public void assertNotNull(String msg, Object actual) {
            SUnit$Assert$class.assertNotNull(this, msg, actual);
        }

        public void assertFalse(boolean actual) {
            SUnit$Assert$class.assertFalse(this, actual);
        }

        public void assertFalse(String msg, boolean actual) {
            SUnit$Assert$class.assertFalse(this, msg, actual);
        }

        public void assertEquals(Object expected, Object actual) {
            SUnit$Assert$class.assertEquals(this, expected, actual);
        }

        public void assertEquals(String msg, Object expected, Object actual) {
            SUnit$Assert$class.assertEquals(this, msg, expected, actual);
        }

        public void assertSameElements(Sequence actual, Sequence expected) {
            SUnit$Assert$class.assertSameElements(this, actual, expected);
        }

        public boolean enableStackTrace() {
            return SUnit$Assert$class.enableStackTrace(this);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestSuite
    implements Test,
    ScalaObject {
        private final ArrayBuffer<Test> buf;

        public TestSuite(Sequence<Test> tests) {
            this.buf = new ArrayBuffer();
            this.buf().$plus$plus$eq(tests);
        }

        @Override
        public void run(TestResult r$1) {
            this.buf().foreach(new TestSuite$$anonfun$run$1(this, r$1));
        }

        public void addTest(Test t) {
            this.buf().$plus$eq((Object)t);
        }

        public ArrayBuffer<Test> buf() {
            return this.buf;
        }

        public TestSuite(Sequence<String> names, Function1<String, Test> constr) {
            Sequence<Test> sequence2 = names.map(constr, Sequence$.MODULE$.builderFactory());
            this(sequence2 instanceof Sequence ? sequence2 : ScalaRunTime$.MODULE$.boxArray(sequence2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestResult
    implements ScalaObject {
        private final ArrayBuffer<Tuple2<Test, Throwable>> buf = new ArrayBuffer();

        public Iterator<TestFailure> failures() {
            return this.buf().iterator().map(new TestResult$$anonfun$failures$1(this));
        }

        public int failureCount() {
            return this.buf().length();
        }

        public void addFailure(Test test2, Throwable t) {
            this.buf().$plus$eq((Object)new Tuple2<Test, Throwable>(test2, t));
        }

        public ArrayBuffer<Tuple2<Test, Throwable>> buf() {
            return this.buf;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TestFailure
    implements ScalaObject {
        private final Throwable thrownException;
        private final Test failedTest;

        public TestFailure(Test failedTest, Throwable thrownException) {
            this.failedTest = failedTest;
            this.thrownException = thrownException;
        }

        public String trace() {
            return Predef$.MODULE$.exceptionWrapper(this.thrownException()).getStackTraceString();
        }

        public String toString() {
            return new StringBuilder().append((Object)this.failedTest().toString()).append((Object)" failed due to ").append((Object)this.thrownException().toString()).toString();
        }

        public TestFailure(Tuple2<Test, Throwable> p) {
            this(p._1(), p._2());
        }

        public Throwable thrownException() {
            return this.thrownException;
        }

        public Test failedTest() {
            return this.failedTest;
        }
    }

    public static class AssertFailed
    extends RuntimeException
    implements ScalaObject,
    Product,
    Serializable {
        private final String msg0;
        private final boolean stackTrace;
        private final String msg;

        public AssertFailed(String msg, boolean stackTrace) {
            String string2;
            this.msg = msg;
            this.stackTrace = stackTrace;
            Product$class.$init$(this);
            if (stackTrace) {
                StringWriter wrt = new StringWriter();
                this.printStackTrace(new PrintWriter(wrt));
                string2 = wrt.toString();
            } else {
                string2 = msg;
            }
            this.msg0 = string2;
        }

        private final /* synthetic */ boolean gd1$1(boolean bl, String string2) {
            String string3 = string2;
            String string4 = this.msg();
            return !(string3 != null ? !string3.equals(string4) : string4 != null) && bl == this.stackTrace();
        }

        public boolean canEqual(Object object) {
            return object instanceof AssertFailed;
        }

        public Object productElement(int n) {
            Object object;
            int temp5 = n;
            switch (temp5) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(n)).toString());
                }
                case 1: {
                    object = BoxesRunTime.boxToBoolean(this.stackTrace());
                    break;
                }
                case 0: {
                    object = this.msg();
                }
            }
            return object;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AssertFailed";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            String msg$1;
            if (this == object) return true;
            Object temp1 = object;
            if (!(temp1 instanceof AssertFailed)) return false;
            AssertFailed temp2 = (AssertFailed)temp1;
            String temp3 = temp2.msg();
            boolean temp4 = temp2.stackTrace();
            boolean stackTrace$1 = temp4;
            if (!this.gd1$1(stackTrace$1, msg$1 = temp3)) return false;
            stackTrace$1 = temp4;
            boolean bl = ((AssertFailed)object).canEqual(this);
            if (!bl) return false;
            return true;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        public /* synthetic */ String copy$default$1() {
            return this.msg();
        }

        public /* synthetic */ boolean copy$default$2() {
            return this.stackTrace();
        }

        public /* synthetic */ AssertFailed copy(String msg, boolean stackTrace) {
            return new AssertFailed(msg, stackTrace);
        }

        public String toString() {
            return this.msg0() == null ? new StringBuilder().append((Object)"failed assertion: ").append((Object)this.msg()).toString() : this.msg0();
        }

        private String msg0() {
            return this.msg0;
        }

        public boolean stackTrace() {
            return this.stackTrace;
        }

        public String msg() {
            return this.msg;
        }

        public Iterator productElements() {
            return Product$class.productElements(this);
        }

        public Iterator productIterator() {
            return Product$class.productIterator(this);
        }
    }

    public static interface TestConsoleMain
    extends ScalaObject {
        public void main(String[] var1);

        public TestSuite suite();
    }
}

