/*
 * Decompiled with CFR 0.152.
 */
package scala.xml.parsing;

import java.io.File;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Sequence;
import scala.collection.generic.LinearSequenceTemplate;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Stack;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.Null$;
import scala.xml.ProcInstr;
import scala.xml.Text;
import scala.xml.factory.XMLLoader;
import scala.xml.factory.XMLLoader$class;
import scala.xml.parsing.FactoryAdapter$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FactoryAdapter
extends DefaultHandler
implements XMLLoader<Node>,
ScalaObject {
    private final boolean normalizeWhitespace;
    private boolean capture;
    private String curTag;
    private Stack<NamespaceBinding> scopeStack;
    private final Stack<String> tagStack;
    private final Stack<Node> hStack;
    private final Stack<MetaData> attribStack;
    private final StringBuilder buffer;
    private Node rootElem;

    public FactoryAdapter() {
        XMLLoader$class.$init$(this);
        this.rootElem = null;
        this.buffer = new StringBuilder();
        this.attribStack = new Stack();
        this.hStack = new Stack();
        this.tagStack = new Stack();
        this.scopeStack = new Stack();
        this.curTag = null;
        this.capture = false;
        this.normalizeWhitespace = false;
    }

    @Override
    public void processingInstruction(String target, String data2) {
        this.createProcInstr(target, data2).foreach(new $anonfun$processingInstruction$1(this));
    }

    @Override
    public void endElement(String uri, String _localName, String qname) {
        this.captureText();
        MetaData metaData = this.attribStack().pop();
        List v = Nil$.MODULE$;
        Node child = this.hStack().pop();
        while (child != null) {
            Node node = child;
            v = v.$colon$colon(node);
            child = this.hStack().pop();
        }
        int colon2 = qname.indexOf(58);
        String localName = -1 == colon2 ? qname : qname.substring(colon2 + 1, qname.length());
        NamespaceBinding scp = this.scopeStack().pop();
        String pre = -1 == colon2 ? null : qname.substring(0, colon2);
        this.rootElem_$eq(this.createNode(pre, localName, metaData, scp, v));
        this.hStack().push(this.rootElem());
        this.curTag_$eq(this.tagStack().pop());
        this.capture_$eq(this.curTag() != null ? this.nodeContainsText(this.curTag()) : false);
    }

    public void captureText() {
        String text2;
        Object object = this.capture() ? ((text2 = this.buffer().toString()).length() > 0 ? this.hStack().push(this.createText(text2)) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
        this.buffer().setLength(0);
    }

    @Override
    public void startElement(String uri, String _localName, String qname, Attributes attributes$1) {
        this.captureText();
        this.tagStack().push(this.curTag());
        this.curTag_$eq(qname);
        int colon2 = qname.indexOf(58);
        String localName = -1 == colon2 ? qname : qname.substring(colon2 + 1, qname.length());
        this.capture_$eq(this.nodeContainsText(localName));
        this.hStack().push(null);
        ObjectRef m$1 = new ObjectRef(Null$.MODULE$);
        ObjectRef scpe$1 = new ObjectRef(this.scopeStack().top());
        ((LinearSequenceTemplate)List$.MODULE$.range(0, attributes$1.getLength())).foreach(new $anonfun$startElement$1(this, attributes$1, m$1, scpe$1));
        this.scopeStack().push((NamespaceBinding)scpe$1.elem);
        this.attribStack().push((MetaData)m$1.elem);
    }

    @Override
    public void characters(char[] ch, int offset, int length) {
        if (this.capture()) {
            if (this.normalizeWhitespace()) {
                int i = offset;
                while (i < offset + length) {
                    char c = Predef$.MODULE$.charWrapper(ch[i]).isWhitespace() ? (char)' ' : ch[i];
                    this.buffer().append(c);
                    ++i;
                    if (c != 32) continue;
                    while (Predef$.MODULE$.charWrapper(ch[i]).isWhitespace()) {
                        ++i;
                    }
                }
                return;
            }
            this.buffer().appendAll(ch, offset, length);
            return;
        }
    }

    public boolean normalizeWhitespace() {
        return this.normalizeWhitespace;
    }

    public abstract Sequence<ProcInstr> createProcInstr(String var1, String var2);

    public abstract Text createText(String var1);

    public abstract Node createNode(String var1, String var2, MetaData var3, NamespaceBinding var4, List<Node> var5);

    public abstract boolean nodeContainsText(String var1);

    public void capture_$eq(boolean bl) {
        this.capture = bl;
    }

    public boolean capture() {
        return this.capture;
    }

    public void curTag_$eq(String string2) {
        this.curTag = string2;
    }

    public String curTag() {
        return this.curTag;
    }

    public void scopeStack_$eq(Stack<NamespaceBinding> stack) {
        this.scopeStack = stack;
    }

    public Stack<NamespaceBinding> scopeStack() {
        return this.scopeStack;
    }

    public Stack<String> tagStack() {
        return this.tagStack;
    }

    public Stack<Node> hStack() {
        return this.hStack;
    }

    public Stack<MetaData> attribStack() {
        return this.attribStack;
    }

    public StringBuilder buffer() {
        return this.buffer;
    }

    public void rootElem_$eq(Node node) {
        this.rootElem = node;
    }

    public Node rootElem() {
        return this.rootElem;
    }

    @Override
    public Node loadString(String string2) {
        return XMLLoader$class.loadString(this, string2);
    }

    @Override
    public Node load(InputSource source) {
        return XMLLoader$class.load((XMLLoader)this, source);
    }

    @Override
    public Node load(String sysID) {
        return XMLLoader$class.load((XMLLoader)this, sysID);
    }

    @Override
    public Node load(Reader reader) {
        return XMLLoader$class.load((XMLLoader)this, reader);
    }

    @Override
    public Node load(InputStream is) {
        return XMLLoader$class.load((XMLLoader)this, is);
    }

    @Override
    public Node loadFile(String name) {
        return XMLLoader$class.loadFile((XMLLoader)this, name);
    }

    @Override
    public Node loadFile(FileDescriptor fd) {
        return XMLLoader$class.loadFile((XMLLoader)this, fd);
    }

    @Override
    public Node loadFile(File file) {
        return XMLLoader$class.loadFile((XMLLoader)this, file);
    }

    @Override
    public Node loadXML(InputSource source, SAXParser parser) {
        return XMLLoader$class.loadXML(this, source, parser);
    }

    @Override
    public SAXParser parser() {
        return XMLLoader$class.parser(this);
    }

    @Override
    public FactoryAdapter adapter() {
        return XMLLoader$class.adapter(this);
    }
}

