/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent.duration;

import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeqOptimized$class;
import scala.collection.TraversableLike$class;
import scala.collection.TraversableOnce;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Duration$
implements ScalaObject,
Serializable {
    public static final Duration$ MODULE$;
    private final double maxPreciseDouble;
    private final List<Tuple2<TimeUnit, String>> timeUnitLabels;
    private final Map<TimeUnit, String> timeUnitName;
    private final Map<String, TimeUnit> timeUnit;
    private final long \u00b5s_per_ns;
    private final long ms_per_ns;
    private final long s_per_ns;
    private final long min_per_ns;
    private final long h_per_ns;
    private final long d_per_ns;
    private final FiniteDuration Zero;
    private final Duration.Infinite Undefined;
    private final Duration.Infinite Inf;
    private final Duration.Infinite MinusInf;

    static {
        new Duration$();
    }

    public Duration apply(double length, TimeUnit unit) {
        return this.fromNanos((double)unit.toNanos(1L) * length);
    }

    public FiniteDuration apply(long length, TimeUnit unit) {
        return new FiniteDuration(length, unit);
    }

    public FiniteDuration apply(long length, String unit) {
        return new FiniteDuration(length, (TimeUnit)((Object)this.timeUnit().apply(unit)));
    }

    public Duration apply(String s) {
        block10: {
            Duration duration;
            block7: {
                TimeUnit timeUnit;
                String s1;
                block9: {
                    block8: {
                        String string2;
                        block6: {
                            block5: {
                                String string3 = s;
                                String string4 = string2 = (s1 = (String)TraversableLike$class.filterNot(new StringOps(string3), (Function1)((Object)new Serializable(){
                                    public static final long serialVersionUID;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final boolean apply(char c) {
                                        return Predef$.MODULE$.charWrapper(c).isWhitespace();
                                    }
                                })));
                                if (!(string4 == null ? "Inf" != null : !string4.equals("Inf"))) break block5;
                                String string5 = string2;
                                if (!(string5 == null ? "PlusInf" != null : !string5.equals("PlusInf"))) break block5;
                                String string6 = string2;
                                if (string6 != null ? !string6.equals("+Inf") : "+Inf" != null) break block6;
                            }
                            duration = this.Inf;
                            break block7;
                        }
                        String string7 = string2;
                        if (!(string7 == null ? "MinusInf" != null : !string7.equals("MinusInf"))) break block8;
                        String string8 = string2;
                        if (string8 != null ? !string8.equals("-Inf") : "-Inf" != null) break block9;
                    }
                    duration = this.MinusInf;
                    break block7;
                }
                String string9 = s1;
                String unitName = (String)IndexedSeqOptimized$class.reverse(Predef$.MODULE$.augmentString((String)IndexedSeqOptimized$class.takeWhile(Predef$.MODULE$.augmentString((String)IndexedSeqOptimized$class.reverse(new StringOps(string9))), (Function1)((Object)new Serializable(){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(char c) {
                        return Predef$.MODULE$.charWrapper(c).isLetter();
                    }
                }))));
                Option option = this.timeUnit.get(unitName);
                if (!(option instanceof Some)) break block10;
                Some some = (Some)option;
                TimeUnit unit = timeUnit = (TimeUnit)((Object)some.x);
                String string10 = s1;
                String valueStr = (String)IndexedSeqOptimized$class.dropRight(new StringOps(string10), unitName.length());
                double valueD = Double.parseDouble(valueStr);
                if (valueD >= -9.007199254740992E15 && valueD <= 9.007199254740992E15) {
                    TimeUnit timeUnit2 = unit;
                    double d = valueD;
                    duration = this.fromNanos((double)timeUnit2.toNanos(1L) * d);
                } else {
                    TimeUnit timeUnit3 = unit;
                    long l = Long.parseLong(valueStr);
                    duration = new FiniteDuration(l, timeUnit3);
                }
            }
            return duration;
        }
        throw new NumberFormatException(new StringBuilder().append((Object)"format error ").append((Object)s).toString());
    }

    public final List<String> scala$concurrent$duration$Duration$$words(String s) {
        return Predef$.MODULE$.refArrayOps((Object[])s.trim().split("\\s+")).toList();
    }

    public final List<String> scala$concurrent$duration$Duration$$expandLabels(String labels) {
        List<String> list2 = this.scala$concurrent$duration$Duration$$words(labels);
        if (list2 instanceof $colon$colon) {
            $colon$colon $colon$colon = ($colon$colon)list2;
            Tuple2<Object, List> tuple2 = new Tuple2<Object, List>($colon$colon.hd$1(), $colon$colon.tl$1());
            String hd = (String)tuple2._1();
            List rest = tuple2._2();
            String string2 = hd;
            return rest.flatMap(new Serializable(){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final List<String> apply(String s) {
                    return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{s, new StringBuilder().append((Object)s).append((Object)"s").toString()}));
                }
            }, List$.MODULE$.canBuildFrom()).$colon$colon(string2);
        }
        throw new MatchError(list2);
    }

    public Map<TimeUnit, String> timeUnitName() {
        return this.timeUnitName;
    }

    public Map<String, TimeUnit> timeUnit() {
        return this.timeUnit;
    }

    /*
     * WARNING - void declaration
     */
    public Option<Tuple2<Object, TimeUnit>> unapply(String s$1) {
        Option option;
        Option option2 = this.liftedTree1$1(s$1);
        if (option2.isEmpty()) {
            option = None$.MODULE$;
        } else {
            void $inlThis1;
            Duration duration = (Duration)$inlThis1.get();
            option = MODULE$.unapply(duration);
        }
        return option;
    }

    public Option<Tuple2<Object, TimeUnit>> unapply(Duration d) {
        return d.isFinite() ? new Some<Tuple2<Long, TimeUnit>>(new Tuple2<Long, TimeUnit>(BoxesRunTime.boxToLong(d.length()), d.unit())) : None$.MODULE$;
    }

    public Duration fromNanos(double nanos) {
        Duration duration;
        if (Predef$.MODULE$.double2Double(nanos).isInfinite()) {
            duration = nanos > 0.0 ? this.Inf() : this.MinusInf();
        } else if (Predef$.MODULE$.double2Double(nanos).isNaN()) {
            duration = this.Undefined();
        } else {
            if (nanos > (double)Long.MAX_VALUE || nanos < (double)Long.MIN_VALUE) {
                throw new IllegalArgumentException(new StringBuilder().append((Object)"trying to construct too large duration with ").append(BoxesRunTime.boxToDouble(nanos)).append((Object)"ns").toString());
            }
            duration = this.fromNanos((long)(nanos + 0.5));
        }
        return duration;
    }

    public FiniteDuration fromNanos(long nanos) {
        return nanos % 86400000000000L == 0L ? this.apply(nanos / 86400000000000L, TimeUnit.DAYS) : (nanos % 3600000000000L == 0L ? this.apply(nanos / 3600000000000L, TimeUnit.HOURS) : (nanos % 60000000000L == 0L ? this.apply(nanos / 60000000000L, TimeUnit.MINUTES) : (nanos % 1000000000L == 0L ? this.apply(nanos / 1000000000L, TimeUnit.SECONDS) : (nanos % 1000000L == 0L ? this.apply(nanos / 1000000L, TimeUnit.MILLISECONDS) : (nanos % 1000L == 0L ? this.apply(nanos / 1000L, TimeUnit.MICROSECONDS) : this.apply(nanos, TimeUnit.NANOSECONDS))))));
    }

    public FiniteDuration Zero() {
        return this.Zero;
    }

    public Duration.Infinite Undefined() {
        return this.Undefined;
    }

    public Duration.Infinite Inf() {
        return this.Inf;
    }

    public Duration.Infinite MinusInf() {
        return this.MinusInf;
    }

    public FiniteDuration create(long length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public Duration create(double length, TimeUnit unit) {
        return this.apply(length, unit);
    }

    public FiniteDuration create(long length, String unit) {
        return this.apply(length, unit);
    }

    public Duration create(String s) {
        return this.apply(s);
    }

    public Object readResolve() {
        return MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private final Option liftedTree1$1(String string2) {
        void var2_2;
        Option exceptionResult1;
        try {
            exceptionResult1 = new Some<Duration>(this.apply(string2));
        }
        catch (RuntimeException runtimeException) {
            exceptionResult1 = None$.MODULE$;
        }
        return var2_2;
    }

    private Duration$() {
        MODULE$ = this;
        this.timeUnitLabels = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$.MODULE$.any2ArrowAssoc(TimeUnit.DAYS).$minus$greater("d day"), Predef$.MODULE$.any2ArrowAssoc(TimeUnit.HOURS).$minus$greater("h hour"), Predef$.MODULE$.any2ArrowAssoc(TimeUnit.MINUTES).$minus$greater("min minute"), Predef$.MODULE$.any2ArrowAssoc(TimeUnit.SECONDS).$minus$greater("s sec second"), Predef$.MODULE$.any2ArrowAssoc(TimeUnit.MILLISECONDS).$minus$greater("ms milli millisecond"), Predef$.MODULE$.any2ArrowAssoc(TimeUnit.MICROSECONDS).$minus$greater("\u00b5s micro microsecond"), Predef$.MODULE$.any2ArrowAssoc(TimeUnit.NANOSECONDS).$minus$greater("ns nano nanosecond")}));
        this.timeUnitName = this.timeUnitLabels.toMap(Predef$.MODULE$.conforms()).mapValues(new anonfun.3()).toMap(Predef$.MODULE$.conforms());
        this.timeUnit = ((TraversableOnce)this.timeUnitLabels.flatMap(new anonfun.4(), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.Zero = new FiniteDuration(0L, TimeUnit.DAYS);
        this.Undefined = new anon.1();
        this.Inf = new anon.2();
        this.MinusInf = new anon.3();
    }
}

