/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven.dependency;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.scala_tools.maven.VersionNumber;
import org.scala_tools.maven.dependency.ScalaConstants;

public class CheckScalaVersionVisitor
implements DependencyNodeVisitor {
    private VersionNumber version;
    private boolean failed = false;
    private Log log;

    public boolean endVisit(DependencyNode node) {
        return !this.failed;
    }

    public CheckScalaVersionVisitor(String projectVerison, Log log) {
        this.version = new VersionNumber(projectVerison);
        this.log = log;
    }

    public boolean isScalaDistroArtifact(Artifact artifact) {
        return "org.scala-lang".equalsIgnoreCase(artifact.getGroupId()) && ScalaConstants.SCALA_DISTRO_ARTIFACTS.contains(artifact.getArtifactId());
    }

    public boolean visit(DependencyNode node) {
        VersionNumber originalVersion;
        Artifact artifact = node.getArtifact();
        this.log.debug((CharSequence)("checking [" + artifact + "] for scala version"));
        if (this.isScalaDistroArtifact(artifact) && artifact.getVersion() != null && (originalVersion = new VersionNumber(artifact.getVersion())).compareTo(this.version) != 0) {
            this.failed = true;
        }
        return !this.failed;
    }

    public boolean isFailed() {
        return this.failed;
    }
}

