/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven.executions;

import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.StringUtils;
import org.scala_tools.maven.executions.AbstractJavaMainCaller;

public class ReflectionJavaMainCaller
extends AbstractJavaMainCaller {
    private ClassLoader cl = null;

    public ReflectionJavaMainCaller(AbstractMojo requester, String mainClassName, String classpath, String[] jvmArgs, String[] args) throws Exception {
        super(requester, mainClassName, "", jvmArgs, args);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath.split(File.pathSeparator)) {
            try {
                urls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                requester.getLog().error((Throwable)e);
            }
        }
        this.cl = new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }

    public void addJvmArgs(String ... args) {
    }

    public void run(boolean displayCmd, boolean throwFailure) throws Exception {
        block2: {
            try {
                this.runInternal(displayCmd);
            }
            catch (Exception e) {
                if (!throwFailure) break block2;
                throw e;
            }
        }
    }

    public void spawn(final boolean displayCmd) throws Exception {
        Thread t = new Thread(){

            public void run() {
                try {
                    ReflectionJavaMainCaller.this.runInternal(displayCmd);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    private void runInternal(boolean displayCmd) throws Exception {
        if (this.cl == null) {
            throw new IllegalStateException("No valid classloader defined for scala compiler!");
        }
        Class<?> mainClass = this.cl.loadClass(this.mainClassName);
        Method mainMethod = mainClass.getMethod("main", String[].class);
        int mods = mainMethod.getModifiers();
        if (mainMethod.getReturnType() != Void.TYPE || !Modifier.isStatic(mods) || !Modifier.isPublic(mods)) {
            throw new NoSuchMethodException("main");
        }
        Object[] argArray = this.args.toArray(new String[this.args.size()]);
        if (displayCmd) {
            this.requester.getLog().info((CharSequence)("cmd : " + mainClass + "(" + StringUtils.join((Object[])argArray, (String)",") + ")"));
        }
        mainMethod.invoke(null, new Object[]{argArray});
    }
}

