/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;
import org.scala_tools.maven.ConsolePiper;
import org.scala_tools.maven.StreamLogger;
import org.scala_tools.maven.StreamPiper;
import org.scala_tools.maven.executions.JavaMainCaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaCommand
implements JavaMainCaller {
    private AbstractMojo requester_;
    private List<String> env_;
    private List<String> jvmArgs_;
    private List<String> args_;
    private String javaExec_;
    private String mainClassName_;
    private boolean logOnly_ = true;

    public static String toMultiPath(List<String> paths) {
        return StringUtils.join(paths.iterator(), (String)File.pathSeparator);
    }

    public static String toMultiPath(String[] paths) {
        return StringUtils.join((Object[])paths, (String)File.pathSeparator);
    }

    public static String[] findFiles(File dir, String pattern) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(dir);
        scanner.setIncludes(new String[]{pattern});
        scanner.addDefaultExcludes();
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    public static String toClasspathString(ClassLoader cl) throws Exception {
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        StringBuilder back = new StringBuilder();
        while (cl != null) {
            if (cl instanceof URLClassLoader) {
                URL[] urls;
                URLClassLoader ucl = (URLClassLoader)cl;
                for (URL url : urls = ucl.getURLs()) {
                    if (back.length() != 0) {
                        back.append(File.pathSeparatorChar);
                    }
                    back.append(url.getFile());
                }
            }
            cl = cl.getParent();
        }
        return back.toString();
    }

    public JavaCommand(AbstractMojo requester, String mainClassName, String classpath, String[] jvmArgs, String[] args) throws Exception {
        this.requester_ = requester;
        this.env_ = new ArrayList<String>();
        for (String key : System.getenv().keySet()) {
            this.env_.add(key + "=" + System.getenv(key));
        }
        this.javaExec_ = System.getProperty("java.home");
        if (this.javaExec_ == null) {
            this.javaExec_ = System.getenv("JAVA_HOME");
            if (this.javaExec_ == null) {
                throw new IllegalStateException("Couldn't locate java, try setting JAVA_HOME environment variable.");
            }
        }
        this.javaExec_ = this.javaExec_ + File.separator + "bin" + File.separator + "java";
        this.mainClassName_ = mainClassName;
        this.jvmArgs_ = new ArrayList<String>();
        this.args_ = new ArrayList<String>();
        this.addJvmArgs("-classpath", classpath);
        this.addJvmArgs(jvmArgs);
        this.addArgs(args);
    }

    @Override
    public void addEnvVar(String key, String value) {
        this.env_.add(key + "=" + value);
    }

    @Override
    public void addJvmArgs(String ... args) {
        if (args == null) {
            return;
        }
        for (String arg : args) {
            this.jvmArgs_.add(arg);
        }
    }

    @Override
    public void addArgs(String ... args) {
        if (args == null) {
            return;
        }
        for (String arg : args) {
            this.args_.add(arg);
        }
    }

    @Override
    public void addOption(String key, String value) {
        if (value == null || key == null) {
            return;
        }
        this.args_.add(key);
        this.args_.add(value);
    }

    @Override
    public void addOption(String key, File value) {
        if (value == null || key == null) {
            return;
        }
        this.args_.add(key);
        this.args_.add(value.getAbsolutePath());
    }

    @Override
    public void addOption(String key, boolean value) {
        if (!value || key == null) {
            return;
        }
        this.args_.add(key);
    }

    @Override
    public void setLogOnly(boolean v) {
        this.logOnly_ = v;
    }

    private String[] buildCommand() {
        ArrayList<String> back = new ArrayList<String>(2 + this.jvmArgs_.size() + this.args_.size());
        back.add(this.javaExec_);
        back.addAll(this.jvmArgs_);
        back.add(this.mainClassName_);
        back.addAll(this.args_);
        return back.toArray(new String[back.size()]);
    }

    @Override
    public void run(boolean displayCmd) throws Exception {
        this.run(displayCmd, true);
    }

    @Override
    public void run(boolean displayCmd, boolean throwFailure) throws Exception {
        Object[] cmd = this.buildCommand();
        if (displayCmd) {
            this.requester_.getLog().info((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        } else if (this.requester_.getLog().isDebugEnabled()) {
            this.requester_.getLog().debug((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        }
        ProcessBuilder pb = new ProcessBuilder((String[])cmd);
        if (!this.logOnly_) {
            pb = pb.redirectErrorStream(true);
        }
        Process p = pb.start();
        if (this.logOnly_) {
            new StreamLogger(p.getErrorStream(), this.requester_.getLog(), true).start();
            new StreamLogger(p.getInputStream(), this.requester_.getLog(), false).start();
        } else {
            new StreamPiper(p.getInputStream(), System.out).start();
            new ConsolePiper(p).start();
        }
        int retVal = p.waitFor();
        if (throwFailure && retVal != 0) {
            throw new MojoFailureException("command line returned non-zero value:" + retVal);
        }
    }

    @Override
    public void spawn(boolean displayCmd) throws Exception {
        Object[] cmd = this.buildCommand();
        if (displayCmd) {
            this.requester_.getLog().info((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        } else if (this.requester_.getLog().isDebugEnabled()) {
            this.requester_.getLog().debug((CharSequence)("cmd:  " + StringUtils.join((Object[])cmd, (String)" ")));
        }
        ProcessBuilder pb = new ProcessBuilder((String[])cmd);
        pb.start();
    }
}

