/*
 * Decompiled with CFR 0.152.
 */
package org.scala_tools.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.FileUtils;
import org.scala_tools.maven.JavaCommand;
import org.scala_tools.maven.ScalaMojoSupport;
import org.scala_tools.maven.executions.JavaMainCaller;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScalaCompilerSupport
extends ScalaMojoSupport {
    protected long loopSleep = 2500L;
    protected boolean sendJavaToScalac = true;

    protected abstract File getOutputDir() throws Exception;

    protected abstract List<String> getClasspathElements() throws Exception;

    protected abstract List<String> getSourceDirectories() throws Exception;

    @Override
    protected void doExecute() throws Exception {
        File outputDir = this.normalize(this.getOutputDir());
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (this.getLog().isDebugEnabled()) {
            for (String directory : this.getSourceDirectories()) {
                this.getLog().debug((CharSequence)directory);
            }
        }
        int nbFiles = this.compile(this.getSourceDirectories(), outputDir, this.getClasspathElements(), false);
        switch (nbFiles) {
            case -1: {
                this.getLog().warn((CharSequence)"No source files found.");
                break;
            }
            case 0: {
                this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date");
                break;
            }
        }
    }

    protected File normalize(File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException exc) {
            f = f.getAbsoluteFile();
        }
        return f;
    }

    protected int compile(File sourceDir, File outputDir, List<String> classpathElements, boolean compileInLoop) throws Exception, InterruptedException {
        return this.compile(Arrays.asList(sourceDir.getAbsolutePath()), outputDir, classpathElements, compileInLoop);
    }

    protected int compile(List<String> sourceRootDirs, File outputDir, List<String> classpathElements, boolean compileInLoop) throws Exception, InterruptedException {
        List<String> scalaSourceFiles = this.findSource(sourceRootDirs, "scala");
        if (scalaSourceFiles.size() == 0) {
            return -1;
        }
        File lastCompileAtFile = new File(outputDir + ".timestamp");
        long lastCompileAt = -1L;
        if (lastCompileAtFile.exists() && outputDir.exists() && outputDir.list().length > 0) {
            lastCompileAt = lastCompileAtFile.lastModified();
        }
        ArrayList<File> files = new ArrayList<File>(scalaSourceFiles.size());
        for (String x : scalaSourceFiles) {
            File f = new File(x);
            if (f.lastModified() < lastCompileAt) continue;
            files.add(f);
        }
        if (files.size() == 0) {
            return 0;
        }
        if (!compileInLoop && this.sendJavaToScalac && this.isJavaSupportedByCompiler()) {
            List<String> javaSourceFiles = this.findSource(sourceRootDirs, "java");
            for (String javaSourceFile : javaSourceFiles) {
                files.add(new File(javaSourceFile));
            }
        }
        if (!compileInLoop) {
            this.getLog().info((CharSequence)String.format("Compiling %d source files to %s", files.size(), outputDir.getAbsolutePath()));
        }
        long now = System.currentTimeMillis();
        JavaMainCaller jcmd = this.getScalaCommand();
        jcmd.addArgs("-classpath", JavaCommand.toMultiPath(classpathElements));
        jcmd.addArgs("-d", outputDir.getAbsolutePath());
        for (File f : files) {
            jcmd.addArgs(f.getAbsolutePath());
            if (!compileInLoop) continue;
            this.getLog().info((CharSequence)String.format("%tR compiling %s", now, f.getName()));
        }
        jcmd.run(this.displayCmd, !compileInLoop);
        if (lastCompileAtFile.exists()) {
            lastCompileAtFile.setLastModified(now);
        } else {
            FileUtils.fileWrite((String)lastCompileAtFile.getAbsolutePath(), (String)".");
        }
        return files.size();
    }

    private List<String> findSource(List<String> sourceRootDirs, String extension) {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        for (String rootSourceDir : this.normalizeSourceRoots(sourceRootDirs)) {
            String[] tmpFiles;
            File dir = this.normalize(new File(rootSourceDir));
            for (String tmpLocalFile : tmpFiles = JavaCommand.findFiles(dir, "**/*." + extension)) {
                File tmpAbsFile = this.normalize(new File(dir, tmpLocalFile));
                sourceFiles.add(tmpAbsFile.getAbsolutePath());
            }
        }
        return sourceFiles;
    }

    private List<String> normalizeSourceRoots(List<String> compileSourceRootsList) {
        ArrayList<String> newCompileSourceRootsList = new ArrayList<String>();
        if (compileSourceRootsList != null) {
            for (String srcDir : compileSourceRootsList) {
                File srcDirFile = this.normalize(new File(srcDir));
                if (newCompileSourceRootsList.contains(srcDirFile.getAbsolutePath()) || !srcDirFile.exists()) continue;
                newCompileSourceRootsList.add(srcDirFile.getAbsolutePath());
            }
        }
        return newCompileSourceRootsList;
    }
}

