/*
 * Decompiled with CFR 0.152.
 */
package org_scala_tools_maven_executions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.StringUtils;
import org_scala_tools_maven_executions.JavaMainCallerSupport;
import org_scala_tools_maven_executions.MainHelper;

public class JavaMainCallerInProcess
extends JavaMainCallerSupport {
    private ClassLoader _cl = null;

    public JavaMainCallerInProcess(AbstractMojo requester, String mainClassName, String classpath, String[] jvmArgs, String[] args) throws Exception {
        super(requester, mainClassName, "", jvmArgs, args);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath.split(File.pathSeparator)) {
            try {
                urls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                requester.getLog().error((Throwable)e);
            }
        }
        this._cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), (ClassLoader)null);
    }

    public void addJvmArgs(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.requester.getLog().warn((CharSequence)("jvmArgs are ignored when run in process :" + arg));
            }
        }
    }

    public boolean run(boolean displayCmd, boolean throwFailure) throws Exception {
        try {
            this.runInternal(displayCmd);
            return true;
        }
        catch (Exception e) {
            if (throwFailure) {
                throw e;
            }
            return false;
        }
    }

    public void spawn(final boolean displayCmd) throws Exception {
        Thread t = new Thread(){

            public void run() {
                try {
                    JavaMainCallerInProcess.this.runInternal(displayCmd);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        t.start();
    }

    private void runInternal(boolean displayCmd) throws Exception {
        Object[] argArray = this.args.toArray(new String[this.args.size()]);
        if (displayCmd) {
            this.requester.getLog().info((CharSequence)("cmd : " + this.mainClassName + "(" + StringUtils.join((Object[])argArray, (String)",") + ")"));
        }
        MainHelper.runMain(this.mainClassName, this.args, this._cl);
    }

    public void redirectToLog() {
        this.requester.getLog().warn((CharSequence)"redirection to log is not supported for 'inProcess' mode");
    }
}

