/*
 * Decompiled with CFR 0.152.
 */
package scala.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.FileUtils;
import scala.maven.JavaCommand;
import scala.maven.ScalaMojoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScalaCompilerSupport
extends ScalaMojoSupport {
    protected long loopSleep = 2500L;

    protected abstract File getOutputDir() throws Exception;

    protected abstract File getSourceDir() throws Exception;

    protected abstract List<String> getClasspathElements() throws Exception;

    @Override
    protected void doExecute() throws Exception {
        File sourceDir;
        File outputDir = this.normalize(this.getOutputDir());
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if (!(sourceDir = this.normalize(this.getSourceDir())).exists()) {
            return;
        }
        int nbFiles = this.compile(sourceDir, outputDir, this.getClasspathElements(), false);
        switch (nbFiles) {
            case -1: {
                this.getLog().warn((CharSequence)"No source files found.");
                break;
            }
            case 0: {
                this.getLog().info((CharSequence)"Nothing to compile - all classes are up to date");
                break;
            }
        }
    }

    protected File normalize(File f) {
        try {
            f = f.getCanonicalFile();
        }
        catch (IOException exc) {
            f = f.getAbsoluteFile();
        }
        return f;
    }

    protected int compile(File sourceDir, File outputDir, List<String> classpathElements, boolean compileInLoop) throws Exception, InterruptedException {
        String[] sourceFiles = JavaCommand.findFiles(sourceDir, "**/*.scala");
        if (sourceFiles.length == 0) {
            return -1;
        }
        int sourceDirPathLength = sourceDir.getAbsolutePath().length();
        File lastCompileAtFile = new File(outputDir + ".timestamp");
        long lastCompileAt = lastCompileAtFile.lastModified();
        ArrayList<File> files = new ArrayList<File>(sourceFiles.length);
        for (String x : sourceFiles) {
            File f = new File(sourceDir, x);
            if (f.lastModified() < lastCompileAt) continue;
            files.add(f);
        }
        if (files.size() == 0) {
            return 0;
        }
        if (!compileInLoop) {
            this.getLog().info((CharSequence)String.format("Compiling %d source files to %s", files.size(), outputDir.getAbsolutePath()));
        }
        long now = System.currentTimeMillis();
        JavaCommand jcmd = this.getScalaCommand();
        jcmd.addArgs("-classpath", JavaCommand.toMultiPath(classpathElements));
        jcmd.addArgs("-d", outputDir.getAbsolutePath());
        jcmd.addArgs("-sourcepath", sourceDir.getAbsolutePath());
        for (File f : files) {
            jcmd.addArgs(f.getAbsolutePath());
            if (!compileInLoop) continue;
            this.getLog().info((CharSequence)String.format("%tR compiling %s", now, f.getAbsolutePath().substring(sourceDirPathLength + 1)));
        }
        jcmd.run(this.displayCmd, !compileInLoop);
        if (lastCompileAtFile.exists()) {
            lastCompileAtFile.setLastModified(now);
        } else {
            FileUtils.fileWrite((String)lastCompileAtFile.getAbsolutePath(), (String)".");
        }
        return files.size();
    }
}

